-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Versi server:                 10.1.31-MariaDB - mariadb.org binary distribution
-- OS Server:                    Win32
-- HeidiSQL Versi:               11.3.0.6295
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Membuang struktur basisdata untuk warehouse
CREATE DATABASE IF NOT EXISTS `warehouse` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `warehouse`;

-- membuang struktur untuk table warehouse.add_coa
CREATE TABLE IF NOT EXISTS `add_coa` (
  `AddCoaID` int(11) NOT NULL AUTO_INCREMENT,
  `COA_ID` int(11) NOT NULL,
  `AddStdID` int(11) NOT NULL,
  `Nilai` float DEFAULT NULL,
  PRIMARY KEY (`AddCoaID`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.add_coa: ~7 rows (lebih kurang)
/*!40000 ALTER TABLE `add_coa` DISABLE KEYS */;
REPLACE INTO `add_coa` (`AddCoaID`, `COA_ID`, `AddStdID`, `Nilai`) VALUES
	(1, 1, 25, 0.036),
	(2, 1, 26, 0.79),
	(3, 1, 27, 3),
	(4, 1, 28, 2),
	(5, 1, 29, 3),
	(6, 1, 30, 1),
	(7, 1, 31, 1);
/*!40000 ALTER TABLE `add_coa` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.add_std
CREATE TABLE IF NOT EXISTS `add_std` (
  `AddStdID` int(11) NOT NULL AUTO_INCREMENT,
  `SpecID` int(11) NOT NULL,
  `ProductID` int(11) NOT NULL,
  `Type_Cek` varchar(10) NOT NULL,
  `CL` float DEFAULT NULL,
  `Allowance` float DEFAULT NULL,
  PRIMARY KEY (`AddStdID`),
  KEY `SpecID` (`SpecID`),
  KEY `ProductID` (`ProductID`),
  CONSTRAINT `add_std_ibfk_1` FOREIGN KEY (`SpecID`) REFERENCES `spec` (`SpecID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `add_std_ibfk_2` FOREIGN KEY (`ProductID`) REFERENCES `product` (`ProductID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.add_std: ~55 rows (lebih kurang)
/*!40000 ALTER TABLE `add_std` DISABLE KEYS */;
REPLACE INTO `add_std` (`AddStdID`, `SpecID`, `ProductID`, `Type_Cek`, `CL`, `Allowance`) VALUES
	(9, 17, 4, 'RANGE', 0.79, 0.02),
	(10, 18, 4, 'MAXIMUM', 6, 0),
	(11, 19, 4, 'MAXIMUM', 3, 0),
	(12, 20, 4, 'MAXIMUM', 5, 0),
	(13, 21, 4, 'BOOLEAN', 0, 0),
	(15, 16, 6, 'RANGE', 0.035, 0.005),
	(16, 17, 6, 'RANGE', 0.79, 0.02),
	(17, 18, 6, 'MAXIMUM', 6, 0),
	(18, 19, 6, 'MAXIMUM', 3, 0),
	(19, 20, 6, 'MAXIMUM', 5, 0),
	(20, 21, 6, 'BOOLEAN', 0, 0),
	(21, 22, 6, 'BOOLEAN', 0, 0),
	(22, 16, 18, 'RANGE', 0.035, 0.005),
	(23, 17, 18, 'RANGE', 0.79, 0.02),
	(24, 18, 18, 'MAXIMUM', 6, 0),
	(25, 16, 7, 'RANGE', 0.035, 0.005),
	(26, 17, 7, 'RANGE', 0.79, 0.02),
	(27, 18, 7, 'MAXIMUM', 4.5, 0),
	(28, 19, 7, 'MAXIMUM', 3, 0),
	(29, 20, 7, 'MAXIMUM', 5, 0),
	(30, 21, 7, 'BOOLEAN', 0, 0),
	(31, 22, 7, 'BOOLEAN', 0, 0),
	(32, 16, 11, 'RANGE', 0.035, 0.005),
	(33, 17, 11, 'RANGE', 0.79, 0.02),
	(34, 18, 11, 'MAXIMUM', 6, 0),
	(35, 19, 11, 'MAXIMUM', 3, 0),
	(36, 20, 11, 'MAXIMUM', 5, 0),
	(37, 21, 11, 'BOOLEAN', 0, 0),
	(38, 22, 11, 'BOOLEAN', 0, 0),
	(39, 16, 10, 'RANGE', 0.035, 0.005),
	(40, 17, 10, 'RANGE', 0.79, 0.02),
	(41, 18, 10, 'MAXIMUM', 6, 0),
	(42, 19, 10, 'MAXIMUM', 3, 0),
	(43, 20, 10, 'MAXIMUM', 5, 0),
	(44, 21, 10, 'BOOLEAN', 0, 0),
	(45, 22, 10, 'BOOLEAN', 0, 0),
	(46, 17, 5, 'RANGE', 0.79, 0.02),
	(47, 18, 5, 'MAXIMUM', 4.5, 0),
	(48, 19, 5, 'MAXIMUM', 3, 0),
	(49, 20, 5, 'MAXIMUM', 5, 0),
	(50, 21, 5, 'BOOLEAN', 0, 0),
	(51, 17, 12, 'RANGE', 0.79, 0.02),
	(52, 18, 12, 'MAXIMUM', 6, 0),
	(53, 19, 12, 'MAXIMUM', 3, 0),
	(54, 20, 12, 'MAXIMUM', 5, 0),
	(55, 21, 12, 'BOOLEAN', 0, 0),
	(56, 16, 13, 'RANGE', 0.035, 0.005),
	(57, 17, 13, 'RANGE', 0.79, 0.02),
	(58, 18, 13, 'MAXIMUM', 6, 0),
	(59, 16, 14, 'RANGE', 0.035, 0.005),
	(60, 17, 14, 'RANGE', 0.79, 0.02),
	(61, 18, 14, 'MAXIMUM', 6, 0),
	(62, 16, 15, 'RANGE', 0.035, 0.005),
	(63, 17, 15, 'RANGE', 0.79, 0.02),
	(64, 18, 15, 'MAXIMUM', 6, 0);
/*!40000 ALTER TABLE `add_std` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.bot_dimensi
CREATE TABLE IF NOT EXISTS `bot_dimensi` (
  `DMS_ID` int(255) NOT NULL AUTO_INCREMENT,
  `COA_ID` int(11) NOT NULL,
  `StdID` int(11) NOT NULL,
  `Sample` int(11) NOT NULL,
  `Fill` int(11) NOT NULL,
  `Nilai` float NOT NULL,
  PRIMARY KEY (`DMS_ID`),
  KEY `COA_ID` (`COA_ID`),
  KEY `StdID` (`StdID`),
  CONSTRAINT `bot_dimensi_ibfk_1` FOREIGN KEY (`COA_ID`) REFERENCES `coa` (`COA_ID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `bot_dimensi_ibfk_2` FOREIGN KEY (`StdID`) REFERENCES `standard` (`StdID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.bot_dimensi: ~0 rows (lebih kurang)
/*!40000 ALTER TABLE `bot_dimensi` DISABLE KEYS */;
/*!40000 ALTER TABLE `bot_dimensi` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.bot_wall
CREATE TABLE IF NOT EXISTS `bot_wall` (
  `Wall_ID` int(250) NOT NULL AUTO_INCREMENT,
  `COA_ID` int(11) NOT NULL,
  `Sample` int(11) NOT NULL,
  `Cavity` int(11) NOT NULL,
  `t1` float NOT NULL,
  `t2` float NOT NULL,
  `t3` float NOT NULL,
  PRIMARY KEY (`Wall_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.bot_wall: ~0 rows (lebih kurang)
/*!40000 ALTER TABLE `bot_wall` DISABLE KEYS */;
/*!40000 ALTER TABLE `bot_wall` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.coa
CREATE TABLE IF NOT EXISTS `coa` (
  `COA_ID` int(255) NOT NULL AUTO_INCREMENT,
  `Date_COA` date NOT NULL,
  `Lot_COA` varchar(15) NOT NULL,
  `Shift` int(1) NOT NULL,
  `PlanID` int(11) NOT NULL,
  `Material` varchar(120) DEFAULT NULL,
  `Colorant` varchar(120) DEFAULT NULL,
  `QC1` int(2) DEFAULT NULL,
  `QC2` int(2) DEFAULT NULL,
  `Jml_Sample` int(2) DEFAULT NULL,
  PRIMARY KEY (`COA_ID`),
  KEY `PlanID` (`PlanID`),
  CONSTRAINT `coa_ibfk_1` FOREIGN KEY (`PlanID`) REFERENCES `plan` (`PlanID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.coa: ~7 rows (lebih kurang)
/*!40000 ALTER TABLE `coa` DISABLE KEYS */;
REPLACE INTO `coa` (`COA_ID`, `Date_COA`, `Lot_COA`, `Shift`, `PlanID`, `Material`, `Colorant`, `QC1`, `QC2`, `Jml_Sample`) VALUES
	(4, '2023-01-02', '0002', 2, 204, 'DSR TLE-105', 'COLOR MATRIX 575.10488.7 DAN BLUE 7', 9, 6, 24),
	(5, '2023-01-02', '0005', 1, 206, 'DSR TLE-105', 'COLOR MATRIX 575.10488.7 DAN BLUE 7', 6, 8, 24),
	(6, '2022-12-23', '0125', 1, 182, 'EASTLON CB602', 'COLOR MATRIX 575.10488.7 DAN BLUE 7', 18, 9, 24),
	(7, '2022-12-15', '0095', 1, 161, 'RAMAPET N2', '', 9, 18, 24),
	(8, '2022-12-31', '0012', 2, 203, 'EASTLON CB602', 'COLOR MATRIX 575.10488.7 DAN BLUE 7', 6, 9, 24),
	(9, '2022-12-23', '0126', 2, 182, 'DSR TLE-105', 'COLOR MATRIX 575.10488.7 DAN BLUE 7', 6, 8, 24),
	(10, '2023-01-02', '0001', 1, 204, 'DSR TLE-105', 'COLOR MATRIX 575.10488.7 DAN BLUE 7', 18, 8, 24);
/*!40000 ALTER TABLE `coa` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.coa_bb
CREATE TABLE IF NOT EXISTS `coa_bb` (
  `CoabbID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `MaterialID` int(11) NOT NULL,
  `Lot` varchar(25) COLLATE armscii8_bin NOT NULL,
  `File` varchar(100) COLLATE armscii8_bin NOT NULL,
  KEY `CoabbID` (`CoabbID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=armscii8 COLLATE=armscii8_bin;

-- Membuang data untuk tabel warehouse.coa_bb: ~2 rows (lebih kurang)
/*!40000 ALTER TABLE `coa_bb` DISABLE KEYS */;
REPLACE INTO `coa_bb` (`CoabbID`, `MaterialID`, `Lot`, `File`) VALUES
	(1, 13, '709849007', 'coa ramapet.jpeg'),
	(2, 16, '22IA06', 'coa ramapet.jpeg');
/*!40000 ALTER TABLE `coa_bb` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.cost
CREATE TABLE IF NOT EXISTS `cost` (
  `CostID` int(11) NOT NULL AUTO_INCREMENT,
  `EkspedisiID` int(11) NOT NULL,
  `CustomerID` int(11) NOT NULL,
  `Del_Cost` int(15) NOT NULL,
  `Ret_Cost` int(15) NOT NULL,
  PRIMARY KEY (`CostID`),
  KEY `EkspedisiID` (`EkspedisiID`),
  KEY `CustomerID` (`CustomerID`),
  CONSTRAINT `cost_ibfk_1` FOREIGN KEY (`EkspedisiID`) REFERENCES `ekspedisi` (`EkspedisiID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `cost_ibfk_2` FOREIGN KEY (`CustomerID`) REFERENCES `customer` (`CustomerID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.cost: ~0 rows (lebih kurang)
/*!40000 ALTER TABLE `cost` DISABLE KEYS */;
REPLACE INTO `cost` (`CostID`, `EkspedisiID`, `CustomerID`, `Del_Cost`, `Ret_Cost`) VALUES
	(1, 1, 2, 1600000, 5000);
/*!40000 ALTER TABLE `cost` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.customer
CREATE TABLE IF NOT EXISTS `customer` (
  `CustomerID` int(3) NOT NULL AUTO_INCREMENT,
  `CustomerName` tinytext,
  `Alamat` varchar(255) DEFAULT NULL,
  `CustomerNo` tinytext,
  `Sales` tinytext,
  `TOD` tinytext,
  `Kota` tinytext,
  `HO_ID` int(11) DEFAULT NULL,
  PRIMARY KEY (`CustomerID`),
  KEY `FK_customer_ho_tbl` (`HO_ID`),
  CONSTRAINT `FK_customer_ho_tbl` FOREIGN KEY (`HO_ID`) REFERENCES `ho_tbl` (`HO_ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1 COMMENT='Daftar Customer';

-- Membuang data untuk tabel warehouse.customer: ~14 rows (lebih kurang)
/*!40000 ALTER TABLE `customer` DISABLE KEYS */;
REPLACE INTO `customer` (`CustomerID`, `CustomerName`, `Alamat`, `CustomerNo`, `Sales`, `TOD`, `Kota`, `HO_ID`) VALUES
	(1, 'PT. BANDANGAN TIRTA AGUNG', 'Jl. Ahmad Yani KM. 9 Banjarmasin<br>\r\nKalimantan Banjar<br>\r\nIndonesia<br>\r\nTel : 0511-4281570', '1185987', '00042700', 'EXW Ex works', 'SURABAYA', 3),
	(2, 'PT. Sinar Sosro, Gresik', 'Jl. Raya Cangkir Km.21 RT 10 RW 06 Cangkir, Driyorejo<br>\r\nGresik, Jawa Timur<br>\r\nâ€ƒ61177<br>\r\nIndonesia<br>\r\nTel : 0317507124', '1186726', '00042700', 'FLD Free Delivery to site', 'JAWA BARAT', 4),
	(3, 'PT. TIRTA INVESTAMA - Klaten', 'JL. COKRO DELANGGU Ds WANGEN<br>\r\nRT 01 RW 04 POLANHARJO<br>\r\nKLATEN JAWA TENGAH<br>\r\n&emsp;57474<br>\r\nIndonesia<br>\r\nTel : 0272557435', '1186719', '00042699', 'FLD Free Delivery to site', 'DKI Jakarta', 1),
	(4, 'PT. Sinar Sosro, Mojokerto', 'RIGHROAD IR SUTAMI AWANG-AWANG MOJOSARI<br>\r\nKAB MOJOKERTO, JAWA TIMUR<br>\r\nIndonesia<br>\r\nTel : 0321590330', '1186732', '00042700', 'FLD Free Delivery to site', 'JAWA BARAT', 4),
	(5, 'PT. SARIGUNA PRIMATIRTA, Tbk - PANDAAN', 'JL. SURABAYA-MALANG KM 52,<br>\r\nNGADIMULYO, SUKOREJO, PASURUAN<br>\r\nPANDAAN<br>\r\nIndonesia', '1190099', '00042700', 'FLD', 'SURABAYA', 5),
	(6, 'AWI SENGON', 'Jl. Raya Surabaya-Malang Km. 59<br>\r\nDs. Sengonagung Kec. Purwosari<br>\r\nKab Pasuruan - Jawa Timur<br>\r\n&emsp;67162<br>\r\nIndonesia<br>\r\nTel : 0343611077<br>', '1186605', '00042699', 'FLD Free Delivery to site', 'DKI Jakarta', 6),
	(7, 'PT. MULTI PLASINDO PERKASA BOYOLALI', 'BULUREJO RT. 004 / RW. 003<br>\r\nRANDUSARI TERAS KAB. BOYOLALI<br>\r\nJAWA TENGAH<br>\r\nIndonesia<br>\r\nTel : 0', '1186072', '00042700', 'DDP Delivery duty paid', 'SOLO', 7),
	(8, 'CV. HOKINDO JAYA ABADI', 'Dsn. Tanjung Indah RT/RW : 002/000<br>\r\nDesa Tanjung Niaga Kec. Nanga Pinoh<br>', '1186032', '00042700', 'FLD', 'JAWA BARAT', 8),
	(9, 'PT. TIRTA INVESTAMA - Pandaan', 'Jl. Raya Surabaya-Malang Km. 48.5<br>\r\nKarang Jati, Pandaan, Pasuruan<br>\r\nJawa Timur<br>\r\nâ€ƒ67156<br>\r\nIndonesia<br>\r\nTel: 0343633022', '1186720', '00042699', 'FLD Free Delivery to site', 'DKI Jakarta', 1),
	(10, 'PT. BROMO TIRTA LESTARI', 'JL. RAYA BANJARSARI KM.7  SUMBER\r\nASIH KB. PROBOLINGG0\r\nIndonesia\r\nTel : 0335-432166', '1185991', '00042805', 'DDP Delivery duty paid', 'PASURUAN', 9),
	(11, 'PT. CS2 Pola Sehat - Plant Pandaan', 'DUSUN KECELING RT 001 RW 006\r\nKEMIRISEWU PANDAAN\r\nPASURUAN 67156\r\nIndonesia', '1191753', '00042699', 'FLD Free Delivery to site', 'Banten', 10),
	(12, 'PT. AIR GANGGA DEWATA ALAMI', 'JL. PERMATA PERING\r\nDS. PERING, BLABATUH, GIANYAR\r\nBALI\r\nIndonesia', '1189109', '00042700', 'FLD Free Delivery to site', 'GEMPOL', 11),
	(13, 'DALIMANG', 'GRIYA SANGIANG MAS BLOK KA 3 NO 7\r\nRT 004 RW 011 GEBANG RAYA. PERIUK\r\nKOTA TANGERANG\r\nIndonesia', '1191813', '00042700', 'EXW Ex works', 'KOTA TANGERANG', 12),
	(14, 'PT. KIEWELL PLASTIC PACKAGING', 'Jl. Cempaka RT 01/RW 03, Grogol<br>\r\nSukoharjo, Jawa Tengah<br>\r\nIndonesia<br>\r\nTel: 0', '1186047', '00042699', 'DDP Delivery duty paid', 'Solo', 2);
/*!40000 ALTER TABLE `customer` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.defect
CREATE TABLE IF NOT EXISTS `defect` (
  `Defect_ID` int(11) NOT NULL AUTO_INCREMENT,
  `Prod` int(11) NOT NULL,
  `Kode` varchar(5) NOT NULL,
  `Defect` varchar(75) NOT NULL,
  PRIMARY KEY (`Defect_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.defect: ~83 rows (lebih kurang)
/*!40000 ALTER TABLE `defect` DISABLE KEYS */;
REPLACE INTO `defect` (`Defect_ID`, `Prod`, `Kode`, `Defect`) VALUES
	(1, 1, 'A', 'Short Shot'),
	(2, 1, 'B', 'Lip Gelombang'),
	(3, 1, 'C', 'Lip Miring'),
	(4, 1, 'D', 'Mold Mismatch'),
	(5, 1, 'E', 'Neck Crystalizer not Full'),
	(6, 1, 'F', 'Lip Oval'),
	(8, 1, 'G', 'Neck Broken'),
	(9, 1, 'H', 'Preform Buckling'),
	(10, 1, 'I', 'Flowmark Bottom'),
	(11, 1, 'J', 'Ulir Rusak'),
	(12, 1, 'K', 'Gate Crystallization'),
	(13, 1, 'L', 'Gate Pin Hole'),
	(14, 1, 'M', 'Preform Menempel Satu Dengan yang Lain'),
	(15, 1, 'N', 'Contamination Grease / Oli'),
	(16, 1, 'O', 'Preform Bercampur Tidak Satu Ukuran'),
	(17, 1, 'P', 'Bintik Logam'),
	(18, 1, 'Q', 'Dirty / Dust / Foreign Material'),
	(19, 1, 'R', 'Flash Di Ulir'),
	(20, 1, 'S', 'Flash Lip'),
	(21, 1, 'T', 'Parting Line'),
	(22, 1, 'U', 'Long Gate / Gate Panjang'),
	(23, 1, 'V', 'Gate Nonjol'),
	(24, 1, 'W', 'Gate Lancip'),
	(25, 1, 'X', 'Gate Stringging/Serabut Panjang'),
	(26, 1, 'Y', 'Hazy Preform'),
	(27, 1, 'Z', 'Bum Mark/Gosong'),
	(28, 1, 'Ba', 'Neck Kembung'),
	(29, 1, 'Aa', 'Water Mark'),
	(30, 1, 'Ab', 'Flowmark Body'),
	(31, 1, 'Ac', 'Un-Melted Polymer'),
	(32, 1, 'Ad', 'Bubble Ulir'),
	(33, 1, 'Ae', 'Bubble Body'),
	(34, 1, 'Af', 'Gate Void / Bubble Bottom'),
	(35, 1, 'Ag', 'Bintik Putih /  Kerak'),
	(36, 1, 'Ah', 'Bintik Hitam / Bintik Coklat'),
	(37, 1, 'Ai', 'Bintik Merah'),
	(38, 1, 'Aj', 'Warna Tidak Standar'),
	(39, 1, 'Ak', 'Warna Tidak Merata'),
	(40, 1, 'Al', 'Preform Tercampur beda material'),
	(41, 1, 'Am', 'Dimensi & Berat Kurang atau Lebih dari Standard'),
	(42, 1, 'An', 'Deliminasi (Kulit Preorm Terkelupas)'),
	(43, 1, 'Ao', 'Stratches / Cacat'),
	(44, 1, 'Ap', 'Gores Bottom / Gate Peeling'),
	(45, 1, 'Aq', 'Silver Bottom'),
	(46, 1, 'Ar', 'Yellowish / Preform Kuning'),
	(47, 1, 'As', 'Flowmark Ulir'),
	(48, 1, 'At', 'Odor / Berbau'),
	(49, 1, 'Au', 'Ovalitas Neck / Neck Oval'),
	(50, 1, 'Av', 'Splay Mark / Bercak Minyak'),
	(51, 1, 'Aw', 'Neck Kematengan'),
	(52, 1, 'Ax', 'Gores EOAT'),
	(53, 1, 'Ay', 'Gate Flaking'),
	(54, 1, 'Az', 'Lip Cacat / Ulir Cacat'),
	(55, 1, 'Bb', 'Silver Melingkar dibottom'),
	(56, 1, 'QC', 'Sample QC'),
	(57, 2, 'A', 'Short_Shot'),
	(58, 2, 'B', 'Mold Mismatch'),
	(59, 2, 'C', 'Neck Crystallizer not full'),
	(60, 2, 'D', 'Ovalitas Neck/Lip'),
	(61, 2, 'E', 'Flash On Threads'),
	(62, 2, 'F', 'Perpendicularity'),
	(63, 2, 'G', 'Srangled Neck'),
	(64, 2, 'H', 'Damaged threads finish'),
	(65, 2, 'I', 'Knit Lines'),
	(66, 2, 'J', 'Damaged On the Neck'),
	(67, 2, 'K', 'Base Shrink back/Deformed base'),
	(68, 2, 'L', 'Poor material distribution'),
	(69, 2, 'M', 'Hole in the gate'),
	(70, 2, 'N', 'Bubble'),
	(71, 2, 'O', 'Odor'),
	(72, 2, 'P', 'Contamination Grease, Oil, etc'),
	(73, 2, 'Q', 'Crused or Denied Bottle'),
	(74, 2, 'R', 'Color out Speck'),
	(75, 2, 'S', 'Weight/Dimensi out of Standard'),
	(76, 2, 'T', 'Off Center gate'),
	(77, 2, 'U', 'Water mark/Rings'),
	(78, 2, 'V', 'Parting line Flash'),
	(79, 2, 'W', 'Crystalinity'),
	(80, 2, 'X', 'Scratches'),
	(81, 2, 'Y', 'Dirty / Dust'),
	(82, 2, 'Z', 'Permukaan Botol bram bergelombang/Kasar'),
	(83, 2, 'AA', 'Black Spot/ White'),
	(86, 2, 'QC', 'QC Sample');
/*!40000 ALTER TABLE `defect` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.deliverytbl
CREATE TABLE IF NOT EXISTS `deliverytbl` (
  `Del_ID` int(11) NOT NULL AUTO_INCREMENT,
  `DateKirim` date NOT NULL,
  `Week` int(5) DEFAULT NULL,
  `DetailPO_ID` int(10) DEFAULT NULL,
  `DetailEkspedisi_ID` int(10) DEFAULT NULL,
  `Expedisi` varchar(255) DEFAULT NULL,
  `Cont` varchar(255) DEFAULT NULL,
  `Seal` varchar(255) DEFAULT NULL,
  `Arrival_Time` time NOT NULL,
  `SO_No` int(25) DEFAULT NULL,
  `DateDoc` date DEFAULT NULL,
  `NoDN` varchar(20) DEFAULT NULL,
  `QtyKirim` int(10) DEFAULT NULL,
  `Sample` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`Del_ID`),
  KEY `DetailPO_ID` (`DetailPO_ID`),
  KEY `DetailEkspedisi_ID` (`DetailEkspedisi_ID`),
  CONSTRAINT `deliverytbl_ibfk_1` FOREIGN KEY (`DetailEkspedisi_ID`) REFERENCES `detailekspedisi` (`DetailEkspedisi_ID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `deliverytbl_ibfk_2` FOREIGN KEY (`DetailPO_ID`) REFERENCES `detail_po` (`DetailPO_ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.deliverytbl: ~118 rows (lebih kurang)
/*!40000 ALTER TABLE `deliverytbl` DISABLE KEYS */;
REPLACE INTO `deliverytbl` (`Del_ID`, `DateKirim`, `Week`, `DetailPO_ID`, `DetailEkspedisi_ID`, `Expedisi`, `Cont`, `Seal`, `Arrival_Time`, `SO_No`, `DateDoc`, `NoDN`, `QtyKirim`, `Sample`) VALUES
	(5, '2022-12-06', 49, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34608521', 16, NULL),
	(6, '2022-12-06', 49, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34608523', 16, NULL),
	(7, '2022-12-06', 49, 16, 3, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34608914', 40, NULL),
	(9, '2022-12-06', 49, 17, 7, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34608916', 40, NULL),
	(10, '2022-12-06', 49, 8, 6, 'MAHAMERU', '34606938', 'E22.345888', '00:00:00', NULL, NULL, '34608765', 300, NULL),
	(11, '2022-12-06', 49, 18, 7, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34606938', 42, NULL),
	(12, '2022-12-07', 49, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34609649', 16, NULL),
	(13, '2022-12-07', 49, 11, 5, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34609650', 16, NULL),
	(14, '2022-12-07', 49, 11, 7, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34609651', 16, NULL),
	(15, '2022-12-07', 49, 17, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34610138', 40, NULL),
	(16, '2022-12-07', 49, 8, 6, 'MAHAMERU', 'MRTU 219100-9', 'H 033371', '00:00:00', NULL, NULL, '34608766', 300, NULL),
	(17, '2022-12-07', 49, 7, 6, 'MAHAMERU', 'MRTU 222491-0', 'H 047869', '00:00:00', NULL, NULL, '34610131', 300, NULL),
	(18, '2022-12-07', 49, 7, 6, 'MAHAMERU', 'MRTU 216123-6', 'H 047870', '00:00:00', NULL, NULL, '34610133', 300, NULL),
	(19, '2022-12-08', 49, 11, 9, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34610492', 16, NULL),
	(20, '2022-12-08', 49, 11, 9, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34610493', 16, NULL),
	(21, '2022-12-08', 49, 17, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34610139', 40, NULL),
	(22, '2022-12-08', 49, 7, 6, 'MAHAMERU', 'MRTU 226815-8', 'H 033373', '00:00:00', NULL, NULL, '34610456', 300, NULL),
	(23, '2022-12-08', 49, 7, 6, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34610457', 300, NULL),
	(24, '2022-12-09', 49, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34611397', 16, NULL),
	(25, '2022-12-09', 49, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34611399', 16, NULL),
	(26, '2022-12-09', 49, 17, 3, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34610140', 40, NULL),
	(27, '2022-12-09', 49, 12, 9, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34611406', 42, NULL),
	(28, '2022-12-09', 49, 7, 6, 'MAHAMERU', 'MRTU-225974-7', 'H-033378', '00:00:00', NULL, NULL, '34611420', 300, NULL),
	(29, '2022-12-09', 49, 7, 6, 'MAHAMERU', 'MRTU 2180724', 'H 033379', '00:00:00', NULL, NULL, '34611425', 300, NULL),
	(30, '2022-12-09', 49, 7, 6, 'MAHAMERU', 'MRTU 2221612', 'H 033380', '00:00:00', NULL, NULL, '34611428', 300, NULL),
	(31, '2022-12-10', 49, 11, 10, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34611401', 16, NULL),
	(32, '2022-12-10', 49, 11, 10, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34611402', 16, NULL),
	(33, '2022-12-10', 49, 17, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34610141', 40, NULL),
	(34, '2022-12-10', 49, 7, 6, 'MAHAMERU', 'MRTU 223054-8', 'H 033384', '00:00:00', NULL, NULL, '34611429', 300, NULL),
	(35, '2022-12-10', 49, 7, 6, 'MAHAMERU', 'MRTU 225312-1', 'H 033385', '00:00:00', NULL, NULL, '34611430', 300, NULL),
	(36, '2022-12-10', 49, 7, 6, 'MAHAMERU', 'MRTU 223299-9', 'H 033386', '00:00:00', NULL, NULL, '34611431', 300, NULL),
	(37, '2022-12-10', 49, 20, 11, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34611247', 470, NULL),
	(38, '2022-12-13', 50, 10, 10, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34612177', 115, NULL),
	(39, '2022-12-13', 50, 12, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34612401', 42, NULL),
	(42, '2022-12-14', 50, 16, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34613414', 40, NULL),
	(43, '2022-12-14', 50, 17, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34613416', 40, NULL),
	(44, '2022-12-15', 50, 7, 6, 'MAHAMERU', 'MRTU-2198132', 'H-038160', '00:00:00', NULL, NULL, '34613309', 300, NULL),
	(45, '2022-12-15', 50, 16, 4, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34613790', 40, NULL),
	(46, '2022-12-15', 50, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34614175', 16, NULL),
	(47, '2022-12-16', 50, 15, 2, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34607918', 42, NULL),
	(48, '2022-12-16', 50, 16, 4, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34613791', 40, NULL),
	(49, '2022-12-16', 50, 12, 9, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34614952', 2, NULL),
	(50, '2022-12-16', 50, 13, 9, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34614952', 40, NULL),
	(51, '2022-12-16', 50, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34614176', 16, NULL),
	(52, '2022-12-16', 50, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34614177', 16, NULL),
	(53, '2022-12-16', 50, 7, 6, 'MAHAMERU', 'MRTU 225038-0', 'H 038161', '00:00:00', NULL, NULL, '34613311', 300, NULL),
	(54, '2022-12-16', 50, 8, 6, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34614395', 300, NULL),
	(55, '2022-12-17', 50, 11, 12, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34614178', 16, NULL),
	(56, '2022-12-17', 50, 11, 9, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34614180', 16, NULL),
	(57, '2022-12-17', 50, 16, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34614601', 40, NULL),
	(58, '2022-12-17', 50, 7, 6, 'MAHAMERU', '34613313', 'H 038170', '00:00:00', NULL, NULL, '34613313', 300, NULL),
	(59, '2022-12-17', 50, 8, 6, 'MAHAMERU', 'MRTU 226221-0', 'H 038169', '00:00:00', NULL, NULL, '34614396', 300, NULL),
	(60, '2022-12-19', 51, 16, 3, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34615631', 40, NULL),
	(61, '2022-12-19', 51, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34615643', 16, NULL),
	(62, '2022-12-20', 51, 16, 4, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34615632', 40, NULL),
	(63, '2022-12-20', 51, 17, 10, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34615633', 40, NULL),
	(64, '2022-12-20', 51, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34615644', 16, NULL),
	(65, '2022-12-20', 51, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34615645', 16, NULL),
	(67, '2022-12-20', 51, 15, 3, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34617222', 42, NULL),
	(68, '2022-12-20', 51, 15, 2, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34617220', 41, NULL),
	(69, '2022-12-20', 51, 19, 2, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34617218', 1, NULL),
	(71, '2022-12-20', 51, 21, 6, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34616334', 460, NULL),
	(72, '2022-12-21', 51, 16, 13, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34617092', 40, NULL),
	(73, '2022-12-21', 51, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34615646', 16, NULL),
	(74, '2022-12-21', 51, 11, 5, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34615647', 16, NULL),
	(75, '2022-12-21', 51, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34615648', 16, NULL),
	(78, '2022-12-21', 51, 13, 13, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34617862', 42, NULL),
	(80, '2022-12-22', 51, 24, 7, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34617093', 40, NULL),
	(81, '2022-12-22', 51, 8, 6, 'MAHAMERU', 'MRTU 226245-8', 'H 040420', '00:00:00', NULL, NULL, '34617526', 300, NULL),
	(82, '2022-12-22', 51, 25, 6, 'MAHAMERU', 'MRTU 224177-4', 'H 040409', '00:00:00', NULL, NULL, '34617528', 300, NULL),
	(83, '2022-12-23', 51, 28, 6, 'MAHAMERU', 'MRTU-2122986', 'G 602173', '00:00:00', NULL, NULL, '34617529', 300, NULL),
	(84, '2022-12-23', 51, 28, 6, 'MAHAMERU', 'MRTU 214831-6', 'G 602174', '00:00:00', NULL, NULL, '34617531', 300, NULL),
	(85, '2022-12-24', 51, 28, 6, 'MAHAMERU', 'MRTU-2278367', 'G-602176', '00:00:00', NULL, NULL, '34617532', 300, NULL),
	(86, '2022-12-26', 52, 14, 2, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34618393', 42, NULL),
	(87, '2022-12-26', 52, 14, 10, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34618394', 42, NULL),
	(88, '2022-12-23', 51, 22, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34618445', 40, NULL),
	(89, '2022-12-24', 51, 22, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34618446', 40, NULL),
	(90, '2022-12-23', 51, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34618943', 16, NULL),
	(91, '2022-12-23', 51, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34618944', 16, NULL),
	(92, '2022-12-23', 51, 22, 12, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34618773', 40, NULL),
	(93, '2022-12-24', 51, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34618948', 16, NULL),
	(94, '2022-12-24', 51, 11, 10, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34618949', 16, NULL),
	(95, '2022-12-24', 51, 31, 6, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34618894', 520, NULL),
	(96, '2022-12-27', 52, 22, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34618774', 40, NULL),
	(97, '2022-12-27', 52, 14, 3, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619611', 42, NULL),
	(98, '2022-12-27', 52, 14, 9, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619609', 42, NULL),
	(99, '2022-12-28', 52, 13, 10, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619558', 42, NULL),
	(100, '2022-12-28', 52, 14, 2, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619613', 42, NULL),
	(101, '2022-12-28', 52, 14, 5, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619612', 29, NULL),
	(102, '2022-12-28', 52, 30, 5, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619612', 13, NULL),
	(103, '2022-12-26', 52, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619413', 16, NULL),
	(104, '2022-12-27', 52, 11, 1, NULL, NULL, NULL, '00:00:00', 14304232, '2022-12-26', '34619415', 16, NULL),
	(105, '2022-12-27', 52, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619416', 16, NULL),
	(106, '2022-12-28', 52, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619760', 16, NULL),
	(107, '2022-12-28', 52, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619761', 16, NULL),
	(108, '2022-12-28', 52, 19, 9, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34620462', 42, NULL),
	(109, '2022-12-28', 52, 19, 12, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34620493', 42, NULL),
	(110, '2022-12-28', 52, 19, 14, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34620495', 42, NULL),
	(111, '2022-12-28', 52, 19, 15, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34620504', 42, NULL),
	(112, '2022-12-29', 52, 19, 3, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34620691', 42, NULL),
	(113, '2022-12-29', 52, 19, 7, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34620693', 42, NULL),
	(114, '2022-12-29', 52, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619762', 16, NULL),
	(115, '2022-12-29', 52, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619763', 16, NULL),
	(116, '2022-12-29', 52, 22, 4, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619602', 40, NULL),
	(117, '2022-12-29', 52, 30, 5, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619615', 42, NULL),
	(118, '2022-12-30', 52, 22, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619607', 40, NULL),
	(119, '2022-12-30', 52, 11, 13, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619765', 16, NULL),
	(120, '2022-12-30', 52, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34619767', 16, NULL),
	(121, '2023-01-03', 1, 13, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34621352', 42, NULL),
	(122, '2023-01-04', 1, 13, 4, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34621364', 42, NULL),
	(123, '2023-01-04', 1, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34621800', 16, NULL),
	(124, '2023-01-04', 1, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34621802', 16, NULL),
	(125, '2023-01-04', 1, 36, 4, 'USAHA BERSAMA', 'B 9003 UEW', 'ARIPIN-081214600913', '00:00:00', NULL, NULL, '34621324', 40, NULL),
	(126, '2023-01-05', 1, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34621803', 16, NULL),
	(127, '2023-01-05', 1, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '34621805', 16, NULL),
	(128, '2023-01-06', 1, 11, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '', 16, NULL),
	(129, '2023-01-06', 1, 41, 1, NULL, NULL, NULL, '00:00:00', NULL, NULL, '', 16, NULL),
	(130, '2023-01-29', 4, 37, 4, NULL, NULL, NULL, '00:00:00', NULL, NULL, '0123', 42, NULL);
/*!40000 ALTER TABLE `deliverytbl` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.detailekspedisi
CREATE TABLE IF NOT EXISTS `detailekspedisi` (
  `DetailEkspedisi_ID` int(11) NOT NULL AUTO_INCREMENT,
  `EkspedisiID` int(11) NOT NULL,
  `Sopir` char(20) NOT NULL,
  `NoPolisi` varchar(20) NOT NULL,
  `NoHP` char(20) NOT NULL,
  PRIMARY KEY (`DetailEkspedisi_ID`),
  KEY `FK_detailekspedisi_ekspedisi` (`EkspedisiID`),
  CONSTRAINT `FK_detailekspedisi_ekspedisi` FOREIGN KEY (`EkspedisiID`) REFERENCES `ekspedisi` (`EkspedisiID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.detailekspedisi: ~14 rows (lebih kurang)
/*!40000 ALTER TABLE `detailekspedisi` DISABLE KEYS */;
REPLACE INTO `detailekspedisi` (`DetailEkspedisi_ID`, `EkspedisiID`, `Sopir`, `NoPolisi`, `NoHP`) VALUES
	(1, 1, 'ARI PRIJAMBODO', 'L 9377 BC', '082143497771'),
	(2, 1, 'KARSONO', 'B 9003 UEW', '082244823225'),
	(3, 1, 'ISMAIL', 'B 9004 UEW', '081281411297'),
	(4, 1, 'ARIPIN', '', '081214600913'),
	(5, 2, 'JANJI MULYONO', 'L 8087 UR', '081252088355'),
	(6, 4, '', '', ''),
	(7, 2, 'UMAR', 'DK 9588 DQ', '081270737701'),
	(9, 2, 'M.SOLIHIN', 'L 8357 UR', '085648618612'),
	(10, 2, 'SUTRISNO', 'L 9574 UY', '082332333180'),
	(11, 5, '', '', ''),
	(12, 2, 'JUMADI', 'L 9390 UT', '085732933036'),
	(13, 6, 'M.RIFAI', 'N 8978 UV', '081217279367'),
	(14, 1, 'ZAINI', 'L 9743 UK', '085335924708'),
	(15, 1, 'ADAM', 'L 9798 UF', '081333348998');
/*!40000 ALTER TABLE `detailekspedisi` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.detail_po
CREATE TABLE IF NOT EXISTS `detail_po` (
  `DetailPO_ID` int(11) NOT NULL AUTO_INCREMENT,
  `PO_ID` int(11) DEFAULT NULL,
  `ProductID` int(11) DEFAULT NULL,
  `QtyPO` int(11) DEFAULT NULL,
  `BalancePO` int(5) DEFAULT NULL,
  PRIMARY KEY (`DetailPO_ID`),
  KEY `FK_detail_po_po_tbl` (`PO_ID`),
  KEY `FK_detail_po_product` (`ProductID`),
  CONSTRAINT `FK_detail_po_product` FOREIGN KEY (`ProductID`) REFERENCES `product` (`ProductID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `detail_po_ibfk_1` FOREIGN KEY (`PO_ID`) REFERENCES `po_tbl` (`PO_ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.detail_po: ~30 rows (lebih kurang)
/*!40000 ALTER TABLE `detail_po` DISABLE KEYS */;
REPLACE INTO `detail_po` (`DetailPO_ID`, `PO_ID`, `ProductID`, `QtyPO`, `BalancePO`) VALUES
	(7, 5, 4, 4212000, 0),
	(8, 5, 12, 864000, 0),
	(9, 6, 19, 315000, 257),
	(10, 7, 15, 100000, 0),
	(11, 8, 8, 3104640, 0),
	(12, 9, 18, 718272, 0),
	(13, 10, 18, 1737216, 0),
	(14, 11, 7, 2635136, 0),
	(15, 12, 11, 761520, 0),
	(16, 13, 7, 3525120, 0),
	(17, 14, 11, 1693440, 0),
	(18, 15, 16, 529200, 0),
	(19, 16, 11, 4116000, 427),
	(20, 17, 12, 270720, 0),
	(21, 18, 12, 264960, 0),
	(22, 19, 7, 4406400, 160),
	(24, 13, 7, 440640, 0),
	(25, 5, 12, 172800, 0),
	(28, 20, 4, 5508000, 4200),
	(29, 20, 12, 1382400, 2400),
	(30, 11, 7, 3238704, 0),
	(31, 21, 12, 300000, 0),
	(32, 22, 10, 172800, 300),
	(33, 23, 6, 216000, 200),
	(36, 24, 7, 25997760, 2320),
	(37, 25, 7, 2500000, 184),
	(38, 26, 11, 2004000, 331),
	(39, 27, 9, 875520, 256),
	(40, 28, 8, 1707552, 352),
	(41, 8, 8, 310464, 48);
/*!40000 ALTER TABLE `detail_po` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.dimensi
CREATE TABLE IF NOT EXISTS `dimensi` (
  `DMS_ID` int(255) NOT NULL AUTO_INCREMENT,
  `COA_ID` int(100) NOT NULL,
  `StdID` int(100) NOT NULL,
  `Sample` int(2) NOT NULL,
  `Cavity` int(3) NOT NULL,
  `Nilai` float NOT NULL,
  PRIMARY KEY (`DMS_ID`),
  KEY `COA_ID` (`COA_ID`),
  KEY `StdID` (`StdID`),
  CONSTRAINT `dimensi_ibfk_1` FOREIGN KEY (`COA_ID`) REFERENCES `coa` (`COA_ID`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `dimensi_ibfk_2` FOREIGN KEY (`StdID`) REFERENCES `standard` (`StdID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7425 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.dimensi: ~2.688 rows (lebih kurang)
/*!40000 ALTER TABLE `dimensi` DISABLE KEYS */;
REPLACE INTO `dimensi` (`DMS_ID`, `COA_ID`, `StdID`, `Sample`, `Cavity`, `Nilai`) VALUES
	(1281, 4, 78, 1, 25, 14.32),
	(1282, 4, 79, 1, 25, 33.945),
	(1283, 4, 80, 1, 25, 30.16),
	(1284, 4, 81, 1, 25, 29.98),
	(1285, 4, 82, 1, 25, 27.99),
	(1286, 4, 83, 1, 25, 28.01),
	(1287, 4, 84, 1, 25, 25.265),
	(1288, 4, 85, 1, 25, 27.99),
	(1289, 4, 86, 1, 25, 27.98),
	(1290, 4, 87, 1, 25, 18.81),
	(1291, 4, 88, 1, 25, 13.235),
	(1292, 4, 89, 1, 25, 18.55),
	(1293, 4, 90, 1, 25, 86.03),
	(1294, 4, 91, 1, 25, 1.458),
	(1295, 4, 92, 1, 25, 2.265),
	(1296, 4, 93, 1, 25, 2.245),
	(1297, 4, 78, 2, 26, 14.3),
	(1298, 4, 79, 2, 26, 33.93),
	(1299, 4, 80, 2, 26, 30.165),
	(1300, 4, 81, 2, 26, 29.98),
	(1301, 4, 82, 2, 26, 27.97),
	(1302, 4, 83, 2, 26, 27.99),
	(1303, 4, 84, 2, 26, 25.28),
	(1304, 4, 85, 2, 26, 27.97),
	(1305, 4, 86, 2, 26, 28),
	(1306, 4, 87, 2, 26, 18.84),
	(1307, 4, 88, 2, 26, 13.26),
	(1308, 4, 89, 2, 26, 18.535),
	(1309, 4, 90, 2, 26, 86.05),
	(1310, 4, 91, 2, 26, 1.472),
	(1311, 4, 92, 2, 26, 2.265),
	(1312, 4, 93, 2, 26, 2.24),
	(1313, 4, 78, 3, 27, 14.33),
	(1314, 4, 79, 3, 27, 33.985),
	(1315, 4, 80, 3, 27, 30.175),
	(1316, 4, 81, 3, 27, 29.99),
	(1317, 4, 82, 3, 27, 28),
	(1318, 4, 83, 3, 27, 28.02),
	(1319, 4, 84, 3, 27, 25.315),
	(1320, 4, 85, 3, 27, 27.995),
	(1321, 4, 86, 3, 27, 28.01),
	(1322, 4, 87, 3, 27, 18.815),
	(1323, 4, 88, 3, 27, 13.225),
	(1324, 4, 89, 3, 27, 18.545),
	(1325, 4, 90, 3, 27, 86.055),
	(1326, 4, 91, 3, 27, 1.468),
	(1327, 4, 92, 3, 27, 2.255),
	(1328, 4, 93, 3, 27, 2.255),
	(1329, 4, 78, 4, 28, 14.34),
	(1330, 4, 79, 4, 28, 33.955),
	(1331, 4, 80, 4, 28, 30.175),
	(1332, 4, 81, 4, 28, 30.01),
	(1333, 4, 82, 4, 28, 28.01),
	(1334, 4, 83, 4, 28, 28.02),
	(1335, 4, 84, 4, 28, 25.325),
	(1336, 4, 85, 4, 28, 27.985),
	(1337, 4, 86, 4, 28, 27.985),
	(1338, 4, 87, 4, 28, 18.835),
	(1339, 4, 88, 4, 28, 13.255),
	(1340, 4, 89, 4, 28, 18.515),
	(1341, 4, 90, 4, 28, 86.09),
	(1342, 4, 91, 4, 28, 1.47),
	(1343, 4, 92, 4, 28, 2.25),
	(1344, 4, 93, 4, 28, 2.25),
	(1345, 4, 78, 5, 29, 14.3),
	(1346, 4, 79, 5, 29, 33.935),
	(1347, 4, 80, 5, 29, 30.16),
	(1348, 4, 81, 5, 29, 29.995),
	(1349, 4, 82, 5, 29, 27.98),
	(1350, 4, 83, 5, 29, 27.99),
	(1351, 4, 84, 5, 29, 25.32),
	(1352, 4, 85, 5, 29, 27.96),
	(1353, 4, 86, 5, 29, 27.975),
	(1354, 4, 87, 5, 29, 18.835),
	(1355, 4, 88, 5, 29, 13.24),
	(1356, 4, 89, 5, 29, 18.55),
	(1357, 4, 90, 5, 29, 86.06),
	(1358, 4, 91, 5, 29, 1.468),
	(1359, 4, 92, 5, 29, 2.265),
	(1360, 4, 93, 5, 29, 2.255),
	(1361, 4, 78, 6, 30, 14.3),
	(1362, 4, 79, 6, 30, 33.93),
	(1363, 4, 80, 6, 30, 30.175),
	(1364, 4, 81, 6, 30, 30.03),
	(1365, 4, 82, 6, 30, 28),
	(1366, 4, 83, 6, 30, 28.02),
	(1367, 4, 84, 6, 30, 25.29),
	(1368, 4, 85, 6, 30, 27.99),
	(1369, 4, 86, 6, 30, 28.005),
	(1370, 4, 87, 6, 30, 18.815),
	(1371, 4, 88, 6, 30, 13.23),
	(1372, 4, 89, 6, 30, 18.55),
	(1373, 4, 90, 6, 30, 86.09),
	(1374, 4, 91, 6, 30, 1.472),
	(1375, 4, 92, 6, 30, 2.26),
	(1376, 4, 93, 6, 30, 2.26),
	(1377, 4, 78, 7, 31, 14.32),
	(1378, 4, 79, 7, 31, 33.95),
	(1379, 4, 80, 7, 31, 30.15),
	(1380, 4, 81, 7, 31, 29.995),
	(1381, 4, 82, 7, 31, 27.98),
	(1382, 4, 83, 7, 31, 28),
	(1383, 4, 84, 7, 31, 25.325),
	(1384, 4, 85, 7, 31, 27.99),
	(1385, 4, 86, 7, 31, 28),
	(1386, 4, 87, 7, 31, 18.82),
	(1387, 4, 88, 7, 31, 13.26),
	(1388, 4, 89, 7, 31, 18.53),
	(1389, 4, 90, 7, 31, 86.085),
	(1390, 4, 91, 7, 31, 1.456),
	(1391, 4, 92, 7, 31, 2.255),
	(1392, 4, 93, 7, 31, 2.25),
	(1393, 4, 78, 8, 32, 14.32),
	(1394, 4, 79, 8, 32, 33.99),
	(1395, 4, 80, 8, 32, 30.18),
	(1396, 4, 81, 8, 32, 29.97),
	(1397, 4, 82, 8, 32, 28),
	(1398, 4, 83, 8, 32, 28.02),
	(1399, 4, 84, 8, 32, 25.32),
	(1400, 4, 85, 8, 32, 27.975),
	(1401, 4, 86, 8, 32, 27.98),
	(1402, 4, 87, 8, 32, 18.825),
	(1403, 4, 88, 8, 32, 13.26),
	(1404, 4, 89, 8, 32, 18.535),
	(1405, 4, 90, 8, 32, 86.035),
	(1406, 4, 91, 8, 32, 1.47),
	(1407, 4, 92, 8, 32, 2.26),
	(1408, 4, 93, 8, 32, 2.265),
	(1409, 4, 78, 9, 33, 14.29),
	(1410, 4, 79, 9, 33, 33.94),
	(1411, 4, 80, 9, 33, 30.135),
	(1412, 4, 81, 9, 33, 30.025),
	(1413, 4, 82, 9, 33, 27.98),
	(1414, 4, 83, 9, 33, 28),
	(1415, 4, 84, 9, 33, 25.31),
	(1416, 4, 85, 9, 33, 27.985),
	(1417, 4, 86, 9, 33, 27.98),
	(1418, 4, 87, 9, 33, 18.825),
	(1419, 4, 88, 9, 33, 13.24),
	(1420, 4, 89, 9, 33, 18.55),
	(1421, 4, 90, 9, 33, 86.01),
	(1422, 4, 91, 9, 33, 1.468),
	(1423, 4, 92, 9, 33, 2.255),
	(1424, 4, 93, 9, 33, 2.25),
	(1425, 4, 78, 10, 34, 14.34),
	(1426, 4, 79, 10, 34, 34.015),
	(1427, 4, 80, 10, 34, 30.15),
	(1428, 4, 81, 10, 34, 30.015),
	(1429, 4, 82, 10, 34, 27.99),
	(1430, 4, 83, 10, 34, 28),
	(1431, 4, 84, 10, 34, 25.315),
	(1432, 4, 85, 10, 34, 27.99),
	(1433, 4, 86, 10, 34, 27.995),
	(1434, 4, 87, 10, 34, 18.85),
	(1435, 4, 88, 10, 34, 13.225),
	(1436, 4, 89, 10, 34, 18.56),
	(1437, 4, 90, 10, 34, 86.055),
	(1438, 4, 91, 10, 34, 1.472),
	(1439, 4, 92, 10, 34, 2.25),
	(1440, 4, 93, 10, 34, 2.265),
	(1441, 4, 78, 11, 35, 14.31),
	(1442, 4, 79, 11, 35, 33.96),
	(1443, 4, 80, 11, 35, 30.15),
	(1444, 4, 81, 11, 35, 29.98),
	(1445, 4, 82, 11, 35, 27.98),
	(1446, 4, 83, 11, 35, 28),
	(1447, 4, 84, 11, 35, 25.3),
	(1448, 4, 85, 11, 35, 27.985),
	(1449, 4, 86, 11, 35, 27.975),
	(1450, 4, 87, 11, 35, 18.825),
	(1451, 4, 88, 11, 35, 13.24),
	(1452, 4, 89, 11, 35, 18.555),
	(1453, 4, 90, 11, 35, 86.07),
	(1454, 4, 91, 11, 35, 1.47),
	(1455, 4, 92, 11, 35, 2.255),
	(1456, 4, 93, 11, 35, 2.26),
	(1457, 4, 78, 12, 36, 14.31),
	(1458, 4, 79, 12, 36, 33.94),
	(1459, 4, 80, 12, 36, 30.155),
	(1460, 4, 81, 12, 36, 30.01),
	(1461, 4, 82, 12, 36, 27.98),
	(1462, 4, 83, 12, 36, 28.01),
	(1463, 4, 84, 12, 36, 25.315),
	(1464, 4, 85, 12, 36, 27.99),
	(1465, 4, 86, 12, 36, 27.995),
	(1466, 4, 87, 12, 36, 18.85),
	(1467, 4, 88, 12, 36, 13.225),
	(1468, 4, 89, 12, 36, 18.56),
	(1469, 4, 90, 12, 36, 86.05),
	(1470, 4, 91, 12, 36, 1.468),
	(1471, 4, 92, 12, 36, 2.265),
	(1472, 4, 93, 12, 36, 2.255),
	(1473, 4, 78, 13, 37, 14.32),
	(1474, 4, 79, 13, 37, 33.95),
	(1475, 4, 80, 13, 37, 30.135),
	(1476, 4, 81, 13, 37, 29.975),
	(1477, 4, 82, 13, 37, 27.98),
	(1478, 4, 83, 13, 37, 27.99),
	(1479, 4, 84, 13, 37, 25.31),
	(1480, 4, 85, 13, 37, 27.99),
	(1481, 4, 86, 13, 37, 27.965),
	(1482, 4, 87, 13, 37, 18.825),
	(1483, 4, 88, 13, 37, 13.24),
	(1484, 4, 89, 13, 37, 18.55),
	(1485, 4, 90, 13, 37, 86.01),
	(1486, 4, 91, 13, 37, 1.464),
	(1487, 4, 92, 13, 37, 2.26),
	(1488, 4, 93, 13, 37, 2.25),
	(1489, 4, 78, 14, 38, 14.32),
	(1490, 4, 79, 14, 38, 33.97),
	(1491, 4, 80, 14, 38, 30.145),
	(1492, 4, 81, 14, 38, 29.995),
	(1493, 4, 82, 14, 38, 28),
	(1494, 4, 83, 14, 38, 28.01),
	(1495, 4, 84, 14, 38, 25.31),
	(1496, 4, 85, 14, 38, 27.955),
	(1497, 4, 86, 14, 38, 27.995),
	(1498, 4, 87, 14, 38, 18.83),
	(1499, 4, 88, 14, 38, 13.225),
	(1500, 4, 89, 14, 38, 18.56),
	(1501, 4, 90, 14, 38, 86.05),
	(1502, 4, 91, 14, 38, 1.47),
	(1503, 4, 92, 14, 38, 2.255),
	(1504, 4, 93, 14, 38, 2.255),
	(1505, 4, 78, 15, 39, 14.32),
	(1506, 4, 79, 15, 39, 33.96),
	(1507, 4, 80, 15, 39, 30.155),
	(1508, 4, 81, 15, 39, 29.995),
	(1509, 4, 82, 15, 39, 27.99),
	(1510, 4, 83, 15, 39, 28.02),
	(1511, 4, 84, 15, 39, 25.305),
	(1512, 4, 85, 15, 39, 27.97),
	(1513, 4, 86, 15, 39, 27.985),
	(1514, 4, 87, 15, 39, 18.815),
	(1515, 4, 88, 15, 39, 13.245),
	(1516, 4, 89, 15, 39, 18.55),
	(1517, 4, 90, 15, 39, 86.01),
	(1518, 4, 91, 15, 39, 1.468),
	(1519, 4, 92, 15, 39, 2.25),
	(1520, 4, 93, 15, 39, 2.245),
	(1521, 4, 78, 16, 40, 14.31),
	(1522, 4, 79, 16, 40, 33.925),
	(1523, 4, 80, 16, 40, 30.17),
	(1524, 4, 81, 16, 40, 29.98),
	(1525, 4, 82, 16, 40, 27.97),
	(1526, 4, 83, 16, 40, 27.99),
	(1527, 4, 84, 16, 40, 25.27),
	(1528, 4, 85, 16, 40, 27.965),
	(1529, 4, 86, 16, 40, 27.985),
	(1530, 4, 87, 16, 40, 18.82),
	(1531, 4, 88, 16, 40, 13.235),
	(1532, 4, 89, 16, 40, 18.54),
	(1533, 4, 90, 16, 40, 86.07),
	(1534, 4, 91, 16, 40, 1.464),
	(1535, 4, 92, 16, 40, 2.265),
	(1536, 4, 93, 16, 40, 2.26),
	(1537, 4, 78, 17, 41, 14.32),
	(1538, 4, 79, 17, 41, 33.985),
	(1539, 4, 80, 17, 41, 30.175),
	(1540, 4, 81, 17, 41, 30.02),
	(1541, 4, 82, 17, 41, 27.98),
	(1542, 4, 83, 17, 41, 27.99),
	(1543, 4, 84, 17, 41, 25.32),
	(1544, 4, 85, 17, 41, 27.99),
	(1545, 4, 86, 17, 41, 28.005),
	(1546, 4, 87, 17, 41, 18.815),
	(1547, 4, 88, 17, 41, 13.23),
	(1548, 4, 89, 17, 41, 18.55),
	(1549, 4, 90, 17, 41, 86.09),
	(1550, 4, 91, 17, 41, 1.458),
	(1551, 4, 92, 17, 41, 2.26),
	(1552, 4, 93, 17, 41, 2.265),
	(1553, 4, 78, 18, 42, 14.29),
	(1554, 4, 79, 18, 42, 33.95),
	(1555, 4, 80, 18, 42, 30.15),
	(1556, 4, 81, 18, 42, 30),
	(1557, 4, 82, 18, 42, 27.97),
	(1558, 4, 83, 18, 42, 28),
	(1559, 4, 84, 18, 42, 25.31),
	(1560, 4, 85, 18, 42, 27.985),
	(1561, 4, 86, 18, 42, 27.975),
	(1562, 4, 87, 18, 42, 18.825),
	(1563, 4, 88, 18, 42, 13.24),
	(1564, 4, 89, 18, 42, 18.55),
	(1565, 4, 90, 18, 42, 86.01),
	(1566, 4, 91, 18, 42, 1.464),
	(1567, 4, 92, 18, 42, 2.265),
	(1568, 4, 93, 18, 42, 2.255),
	(1569, 4, 78, 19, 43, 14.32),
	(1570, 4, 79, 19, 43, 33.985),
	(1571, 4, 80, 19, 43, 30.165),
	(1572, 4, 81, 19, 43, 29.985),
	(1573, 4, 82, 19, 43, 27.98),
	(1574, 4, 83, 19, 43, 27.99),
	(1575, 4, 84, 19, 43, 25.3),
	(1576, 4, 85, 19, 43, 27.96),
	(1577, 4, 86, 19, 43, 28),
	(1578, 4, 87, 19, 43, 18.805),
	(1579, 4, 88, 19, 43, 13.26),
	(1580, 4, 89, 19, 43, 18.525),
	(1581, 4, 90, 19, 43, 86.075),
	(1582, 4, 91, 19, 43, 1.468),
	(1583, 4, 92, 19, 43, 2.26),
	(1584, 4, 93, 19, 43, 2.25),
	(1585, 4, 78, 20, 44, 14.31),
	(1586, 4, 79, 20, 44, 33.96),
	(1587, 4, 80, 20, 44, 30.15),
	(1588, 4, 81, 20, 44, 30.02),
	(1589, 4, 82, 20, 44, 27.98),
	(1590, 4, 83, 20, 44, 28.01),
	(1591, 4, 84, 20, 44, 25.325),
	(1592, 4, 85, 20, 44, 27.975),
	(1593, 4, 86, 20, 44, 27.985),
	(1594, 4, 87, 20, 44, 18.835),
	(1595, 4, 88, 20, 44, 13.24),
	(1596, 4, 89, 20, 44, 18.545),
	(1597, 4, 90, 20, 44, 86.055),
	(1598, 4, 91, 20, 44, 1.472),
	(1599, 4, 92, 20, 44, 2.265),
	(1600, 4, 93, 20, 44, 2.25),
	(1601, 4, 78, 21, 45, 14.33),
	(1602, 4, 79, 21, 45, 34),
	(1603, 4, 80, 21, 45, 30.185),
	(1604, 4, 81, 21, 45, 29.99),
	(1605, 4, 82, 21, 45, 27.98),
	(1606, 4, 83, 21, 45, 27.99),
	(1607, 4, 84, 21, 45, 25.305),
	(1608, 4, 85, 21, 45, 27.985),
	(1609, 4, 86, 21, 45, 27.99),
	(1610, 4, 87, 21, 45, 18.81),
	(1611, 4, 88, 21, 45, 13.235),
	(1612, 4, 89, 21, 45, 18.54),
	(1613, 4, 90, 21, 45, 86.03),
	(1614, 4, 91, 21, 45, 1.468),
	(1615, 4, 92, 21, 45, 2.27),
	(1616, 4, 93, 21, 45, 2.245),
	(1617, 4, 78, 22, 46, 14.31),
	(1618, 4, 79, 22, 46, 33.96),
	(1619, 4, 80, 22, 46, 30.155),
	(1620, 4, 81, 22, 46, 29.98),
	(1621, 4, 82, 22, 46, 27.99),
	(1622, 4, 83, 22, 46, 28.01),
	(1623, 4, 84, 22, 46, 25.315),
	(1624, 4, 85, 22, 46, 27.97),
	(1625, 4, 86, 22, 46, 27.98),
	(1626, 4, 87, 22, 46, 18.815),
	(1627, 4, 88, 22, 46, 13.255),
	(1628, 4, 89, 22, 46, 18.53),
	(1629, 4, 90, 22, 46, 86.08),
	(1630, 4, 91, 22, 46, 1.472),
	(1631, 4, 92, 22, 46, 2.26),
	(1632, 4, 93, 22, 46, 2.255),
	(1633, 4, 78, 23, 47, 14.28),
	(1634, 4, 79, 23, 47, 33.96),
	(1635, 4, 80, 23, 47, 30.16),
	(1636, 4, 81, 23, 47, 29.98),
	(1637, 4, 82, 23, 47, 27.97),
	(1638, 4, 83, 23, 47, 27.99),
	(1639, 4, 84, 23, 47, 25.31),
	(1640, 4, 85, 23, 47, 27.955),
	(1641, 4, 86, 23, 47, 27.995),
	(1642, 4, 87, 23, 47, 18.83),
	(1643, 4, 88, 23, 47, 13.225),
	(1644, 4, 89, 23, 47, 18.56),
	(1645, 4, 90, 23, 47, 86.045),
	(1646, 4, 91, 23, 47, 1.468),
	(1647, 4, 92, 23, 47, 2.265),
	(1648, 4, 93, 23, 47, 2.255),
	(1649, 4, 78, 24, 48, 14.31),
	(1650, 4, 79, 24, 48, 33.985),
	(1651, 4, 80, 24, 48, 30.165),
	(1652, 4, 81, 24, 48, 29.995),
	(1653, 4, 82, 24, 48, 27.98),
	(1654, 4, 83, 24, 48, 27.99),
	(1655, 4, 84, 24, 48, 25.33),
	(1656, 4, 85, 24, 48, 27.98),
	(1657, 4, 86, 24, 48, 27.965),
	(1658, 4, 87, 24, 48, 18.82),
	(1659, 4, 88, 24, 48, 13.26),
	(1660, 4, 89, 24, 48, 18.54),
	(1661, 4, 90, 24, 48, 86.01),
	(1662, 4, 91, 24, 48, 1.47),
	(1663, 4, 92, 24, 48, 2.26),
	(1664, 4, 93, 24, 48, 2.25),
	(3201, 6, 9, 1, 1, 14.23),
	(3202, 6, 10, 1, 1, 33.935),
	(3203, 6, 11, 1, 1, 30.14),
	(3204, 6, 12, 1, 1, 29.975),
	(3205, 6, 13, 1, 1, 28.01),
	(3206, 6, 14, 1, 1, 28.02),
	(3207, 6, 15, 1, 1, 25.3),
	(3208, 6, 16, 1, 1, 27.965),
	(3209, 6, 17, 1, 1, 27.995),
	(3210, 6, 18, 1, 1, 18.835),
	(3211, 6, 19, 1, 1, 13.255),
	(3212, 6, 20, 1, 1, 18.555),
	(3213, 6, 21, 1, 1, 86.025),
	(3214, 6, 22, 1, 1, 1.468),
	(3215, 6, 23, 1, 1, 2.25),
	(3216, 6, 42, 1, 1, 2.26),
	(3217, 6, 9, 2, 2, 14.22),
	(3218, 6, 10, 2, 2, 33.92),
	(3219, 6, 11, 2, 2, 30.125),
	(3220, 6, 12, 2, 2, 29.985),
	(3221, 6, 13, 2, 2, 27.98),
	(3222, 6, 14, 2, 2, 28),
	(3223, 6, 15, 2, 2, 25.285),
	(3224, 6, 16, 2, 2, 27.955),
	(3225, 6, 17, 2, 2, 27.975),
	(3226, 6, 18, 2, 2, 18.835),
	(3227, 6, 19, 2, 2, 13.205),
	(3228, 6, 20, 2, 2, 18.55),
	(3229, 6, 21, 2, 2, 86.055),
	(3230, 6, 22, 2, 2, 1.46),
	(3231, 6, 23, 2, 2, 2.245),
	(3232, 6, 42, 2, 2, 2.25),
	(3233, 6, 9, 3, 3, 14.27),
	(3234, 6, 10, 3, 3, 33.95),
	(3235, 6, 11, 3, 3, 30.155),
	(3236, 6, 12, 3, 3, 30),
	(3237, 6, 13, 3, 3, 28.01),
	(3238, 6, 14, 3, 3, 28.02),
	(3239, 6, 15, 3, 3, 25.295),
	(3240, 6, 16, 3, 3, 27.98),
	(3241, 6, 17, 3, 3, 28),
	(3242, 6, 18, 3, 3, 18.825),
	(3243, 6, 19, 3, 3, 13.255),
	(3244, 6, 20, 3, 3, 18.565),
	(3245, 6, 21, 3, 3, 86.015),
	(3246, 6, 22, 3, 3, 1.46),
	(3247, 6, 23, 3, 3, 2.25),
	(3248, 6, 42, 3, 3, 2.255),
	(3249, 6, 9, 4, 4, 14.22),
	(3250, 6, 10, 4, 4, 33.945),
	(3251, 6, 11, 4, 4, 30.145),
	(3252, 6, 12, 4, 4, 29.965),
	(3253, 6, 13, 4, 4, 27.99),
	(3254, 6, 14, 4, 4, 28.02),
	(3255, 6, 15, 4, 4, 25.285),
	(3256, 6, 16, 4, 4, 27.96),
	(3257, 6, 17, 4, 4, 27.99),
	(3258, 6, 18, 4, 4, 18.845),
	(3259, 6, 19, 4, 4, 13.25),
	(3260, 6, 20, 4, 4, 18.555),
	(3261, 6, 21, 4, 4, 86.065),
	(3262, 6, 22, 4, 4, 1.458),
	(3263, 6, 23, 4, 4, 2.255),
	(3264, 6, 42, 4, 4, 2.25),
	(3265, 6, 9, 5, 5, 14.26),
	(3266, 6, 10, 5, 5, 33.955),
	(3267, 6, 11, 5, 5, 30.145),
	(3268, 6, 12, 5, 5, 30.01),
	(3269, 6, 13, 5, 5, 27.98),
	(3270, 6, 14, 5, 5, 28.01),
	(3271, 6, 15, 5, 5, 25.305),
	(3272, 6, 16, 5, 5, 27.985),
	(3273, 6, 17, 5, 5, 28.01),
	(3274, 6, 18, 5, 5, 18.82),
	(3275, 6, 19, 5, 5, 13.225),
	(3276, 6, 20, 5, 5, 18.55),
	(3277, 6, 21, 5, 5, 86.01),
	(3278, 6, 22, 5, 5, 1.47),
	(3279, 6, 23, 5, 5, 2.265),
	(3280, 6, 42, 5, 5, 2.26),
	(3281, 6, 9, 6, 6, 14.26),
	(3282, 6, 10, 6, 6, 33.955),
	(3283, 6, 11, 6, 6, 30.14),
	(3284, 6, 12, 6, 6, 29.99),
	(3285, 6, 13, 6, 6, 27.97),
	(3286, 6, 14, 6, 6, 27.99),
	(3287, 6, 15, 6, 6, 25.31),
	(3288, 6, 16, 6, 6, 27.985),
	(3289, 6, 17, 6, 6, 27.97),
	(3290, 6, 18, 6, 6, 18.815),
	(3291, 6, 19, 6, 6, 13.26),
	(3292, 6, 20, 6, 6, 18.515),
	(3293, 6, 21, 6, 6, 86.03),
	(3294, 6, 22, 6, 6, 1.458),
	(3295, 6, 23, 6, 6, 2.255),
	(3296, 6, 42, 6, 6, 2.245),
	(3297, 6, 9, 7, 7, 14.26),
	(3298, 6, 10, 7, 7, 33.915),
	(3299, 6, 11, 7, 7, 30.125),
	(3300, 6, 12, 7, 7, 29.97),
	(3301, 6, 13, 7, 7, 28.01),
	(3302, 6, 14, 7, 7, 28.02),
	(3303, 6, 15, 7, 7, 25.285),
	(3304, 6, 16, 7, 7, 27.96),
	(3305, 6, 17, 7, 7, 27.995),
	(3306, 6, 18, 7, 7, 18.805),
	(3307, 6, 19, 7, 7, 13.215),
	(3308, 6, 20, 7, 7, 18.535),
	(3309, 6, 21, 7, 7, 86.005),
	(3310, 6, 22, 7, 7, 1.46),
	(3311, 6, 23, 7, 7, 2.265),
	(3312, 6, 42, 7, 7, 2.255),
	(3313, 6, 9, 8, 8, 14.28),
	(3314, 6, 10, 8, 8, 33.92),
	(3315, 6, 11, 8, 8, 30.145),
	(3316, 6, 12, 8, 8, 30.005),
	(3317, 6, 13, 8, 8, 27.97),
	(3318, 6, 14, 8, 8, 27.98),
	(3319, 6, 15, 8, 8, 25.295),
	(3320, 6, 16, 8, 8, 27.955),
	(3321, 6, 17, 8, 8, 27.985),
	(3322, 6, 18, 8, 8, 18.855),
	(3323, 6, 19, 8, 8, 13.235),
	(3324, 6, 20, 8, 8, 18.56),
	(3325, 6, 21, 8, 8, 86.035),
	(3326, 6, 22, 8, 8, 1.462),
	(3327, 6, 23, 8, 8, 2.25),
	(3328, 6, 42, 8, 8, 2.265),
	(3329, 6, 9, 9, 9, 14.24),
	(3330, 6, 10, 9, 9, 33.945),
	(3331, 6, 11, 9, 9, 30.135),
	(3332, 6, 12, 9, 9, 29.985),
	(3333, 6, 13, 9, 9, 27.97),
	(3334, 6, 14, 9, 9, 27.99),
	(3335, 6, 15, 9, 9, 25.315),
	(3336, 6, 16, 9, 9, 27.97),
	(3337, 6, 17, 9, 9, 27.965),
	(3338, 6, 18, 9, 9, 18.825),
	(3339, 6, 19, 9, 9, 13.205),
	(3340, 6, 20, 9, 9, 18.505),
	(3341, 6, 21, 9, 9, 86.02),
	(3342, 6, 22, 9, 9, 1.464),
	(3343, 6, 23, 9, 9, 2.245),
	(3344, 6, 42, 9, 9, 2.25),
	(3345, 6, 9, 10, 10, 14.23),
	(3346, 6, 10, 10, 10, 33.93),
	(3347, 6, 11, 10, 10, 30.145),
	(3348, 6, 12, 10, 10, 29.995),
	(3349, 6, 13, 10, 10, 27.97),
	(3350, 6, 14, 10, 10, 28),
	(3351, 6, 15, 10, 10, 25.295),
	(3352, 6, 16, 10, 10, 27.975),
	(3353, 6, 17, 10, 10, 27.995),
	(3354, 6, 18, 10, 10, 18.84),
	(3355, 6, 19, 10, 10, 13.255),
	(3356, 6, 20, 10, 10, 18.505),
	(3357, 6, 21, 10, 10, 86.025),
	(3358, 6, 22, 10, 10, 1.46),
	(3359, 6, 23, 10, 10, 2.265),
	(3360, 6, 42, 10, 10, 2.245),
	(3361, 6, 9, 11, 11, 14.23),
	(3362, 6, 10, 11, 11, 33.925),
	(3363, 6, 11, 11, 11, 30.125),
	(3364, 6, 12, 11, 11, 29.975),
	(3365, 6, 13, 11, 11, 28),
	(3366, 6, 14, 11, 11, 28.01),
	(3367, 6, 15, 11, 11, 25.29),
	(3368, 6, 16, 11, 11, 27.955),
	(3369, 6, 17, 11, 11, 27.98),
	(3370, 6, 18, 11, 11, 18.805),
	(3371, 6, 19, 11, 11, 13.245),
	(3372, 6, 20, 11, 11, 18.555),
	(3373, 6, 21, 11, 11, 86.015),
	(3374, 6, 22, 11, 11, 1.466),
	(3375, 6, 23, 11, 11, 2.265),
	(3376, 6, 42, 11, 11, 2.265),
	(3377, 6, 9, 12, 12, 14.28),
	(3378, 6, 10, 12, 12, 33.915),
	(3379, 6, 11, 12, 12, 30.125),
	(3380, 6, 12, 12, 12, 29.975),
	(3381, 6, 13, 12, 12, 27.97),
	(3382, 6, 14, 12, 12, 27.98),
	(3383, 6, 15, 12, 12, 25.285),
	(3384, 6, 16, 12, 12, 27.985),
	(3385, 6, 17, 12, 12, 27.965),
	(3386, 6, 18, 12, 12, 18.845),
	(3387, 6, 19, 12, 12, 13.215),
	(3388, 6, 20, 12, 12, 18.545),
	(3389, 6, 21, 12, 12, 86.065),
	(3390, 6, 22, 12, 12, 1.458),
	(3391, 6, 23, 12, 12, 2.25),
	(3392, 6, 42, 12, 12, 2.25),
	(3393, 6, 9, 13, 13, 14.21),
	(3394, 6, 10, 13, 13, 33.955),
	(3395, 6, 11, 13, 13, 30.125),
	(3396, 6, 12, 13, 13, 29.99),
	(3397, 6, 13, 13, 13, 27.97),
	(3398, 6, 14, 13, 13, 28),
	(3399, 6, 15, 13, 13, 25.325),
	(3400, 6, 16, 13, 13, 27.99),
	(3401, 6, 17, 13, 13, 27.985),
	(3402, 6, 18, 13, 13, 18.85),
	(3403, 6, 19, 13, 13, 13.205),
	(3404, 6, 20, 13, 13, 18.51),
	(3405, 6, 21, 13, 13, 86.015),
	(3406, 6, 22, 13, 13, 1.468),
	(3407, 6, 23, 13, 13, 2.26),
	(3408, 6, 42, 13, 13, 2.255),
	(3409, 6, 9, 14, 14, 14.23),
	(3410, 6, 10, 14, 14, 33.915),
	(3411, 6, 11, 14, 14, 30.15),
	(3412, 6, 12, 14, 14, 29.995),
	(3413, 6, 13, 14, 14, 27.98),
	(3414, 6, 14, 14, 14, 28),
	(3415, 6, 15, 14, 14, 25.285),
	(3416, 6, 16, 14, 14, 27.97),
	(3417, 6, 17, 14, 14, 27.975),
	(3418, 6, 18, 14, 14, 18.805),
	(3419, 6, 19, 14, 14, 13.21),
	(3420, 6, 20, 14, 14, 18.55),
	(3421, 6, 21, 14, 14, 86.005),
	(3422, 6, 22, 14, 14, 1.46),
	(3423, 6, 23, 14, 14, 2.245),
	(3424, 6, 42, 14, 14, 2.26),
	(3425, 6, 9, 15, 15, 14.21),
	(3426, 6, 10, 15, 15, 33.92),
	(3427, 6, 11, 15, 15, 30.135),
	(3428, 6, 12, 15, 15, 29.985),
	(3429, 6, 13, 15, 15, 27.99),
	(3430, 6, 14, 15, 15, 28.02),
	(3431, 6, 15, 15, 15, 25.29),
	(3432, 6, 16, 15, 15, 27.965),
	(3433, 6, 17, 15, 15, 27.965),
	(3434, 6, 18, 15, 15, 18.825),
	(3435, 6, 19, 15, 15, 13.215),
	(3436, 6, 20, 15, 15, 18.52),
	(3437, 6, 21, 15, 15, 86.055),
	(3438, 6, 22, 15, 15, 1.462),
	(3439, 6, 23, 15, 15, 2.25),
	(3440, 6, 42, 15, 15, 2.265),
	(3441, 6, 9, 16, 16, 14.26),
	(3442, 6, 10, 16, 16, 33.935),
	(3443, 6, 11, 16, 16, 30.13),
	(3444, 6, 12, 16, 16, 29.975),
	(3445, 6, 13, 16, 16, 27.98),
	(3446, 6, 14, 16, 16, 27.99),
	(3447, 6, 15, 16, 16, 25.295),
	(3448, 6, 16, 16, 16, 27.99),
	(3449, 6, 17, 16, 16, 28),
	(3450, 6, 18, 16, 16, 18.82),
	(3451, 6, 19, 16, 16, 13.225),
	(3452, 6, 20, 16, 16, 18.555),
	(3453, 6, 21, 16, 16, 86.035),
	(3454, 6, 22, 16, 16, 1.464),
	(3455, 6, 23, 16, 16, 2.255),
	(3456, 6, 42, 16, 16, 2.26),
	(3457, 6, 9, 17, 17, 14.22),
	(3458, 6, 10, 17, 17, 33.93),
	(3459, 6, 11, 17, 17, 30.15),
	(3460, 6, 12, 17, 17, 29.96),
	(3461, 6, 13, 17, 17, 27.97),
	(3462, 6, 14, 17, 17, 27.98),
	(3463, 6, 15, 17, 17, 25.295),
	(3464, 6, 16, 17, 17, 27.955),
	(3465, 6, 17, 17, 17, 28.005),
	(3466, 6, 18, 17, 17, 18.83),
	(3467, 6, 19, 17, 17, 13.26),
	(3468, 6, 20, 17, 17, 18.505),
	(3469, 6, 21, 17, 17, 86.07),
	(3470, 6, 22, 17, 17, 1.458),
	(3471, 6, 23, 17, 17, 2.25),
	(3472, 6, 42, 17, 17, 2.265),
	(3473, 6, 9, 18, 18, 14.24),
	(3474, 6, 10, 18, 18, 33.915),
	(3475, 6, 11, 18, 18, 30.125),
	(3476, 6, 12, 18, 18, 29.99),
	(3477, 6, 13, 18, 18, 27.98),
	(3478, 6, 14, 18, 18, 28),
	(3479, 6, 15, 18, 18, 25.285),
	(3480, 6, 16, 18, 18, 27.975),
	(3481, 6, 17, 18, 18, 28.01),
	(3482, 6, 18, 18, 18, 18.86),
	(3483, 6, 19, 18, 18, 13.225),
	(3484, 6, 20, 18, 18, 18.51),
	(3485, 6, 21, 18, 18, 86.005),
	(3486, 6, 22, 18, 18, 1.46),
	(3487, 6, 23, 18, 18, 2.245),
	(3488, 6, 42, 18, 18, 2.255),
	(3489, 6, 9, 19, 19, 14.23),
	(3490, 6, 10, 19, 19, 33.96),
	(3491, 6, 11, 19, 19, 30.135),
	(3492, 6, 12, 19, 19, 29.975),
	(3493, 6, 13, 19, 19, 28),
	(3494, 6, 14, 19, 19, 28.01),
	(3495, 6, 15, 19, 19, 25.31),
	(3496, 6, 16, 19, 19, 27.995),
	(3497, 6, 17, 19, 19, 27.985),
	(3498, 6, 18, 19, 19, 18.815),
	(3499, 6, 19, 19, 19, 13.205),
	(3500, 6, 20, 19, 19, 18.515),
	(3501, 6, 21, 19, 19, 86.02),
	(3502, 6, 22, 19, 19, 1.462),
	(3503, 6, 23, 19, 19, 2.255),
	(3504, 6, 42, 19, 19, 2.245),
	(3505, 6, 9, 20, 20, 14.2),
	(3506, 6, 10, 20, 20, 33.945),
	(3507, 6, 11, 20, 20, 30.13),
	(3508, 6, 12, 20, 20, 29.98),
	(3509, 6, 13, 20, 20, 28),
	(3510, 6, 14, 20, 20, 28.02),
	(3511, 6, 15, 20, 20, 25.305),
	(3512, 6, 16, 20, 20, 27.985),
	(3513, 6, 17, 20, 20, 27.995),
	(3514, 6, 18, 20, 20, 18.835),
	(3515, 6, 19, 20, 20, 13.21),
	(3516, 6, 20, 20, 20, 18.525),
	(3517, 6, 21, 20, 20, 86.03),
	(3518, 6, 22, 20, 20, 1.464),
	(3519, 6, 23, 20, 20, 2.245),
	(3520, 6, 42, 20, 20, 2.255),
	(3521, 6, 9, 21, 21, 14.27),
	(3522, 6, 10, 21, 21, 33.93),
	(3523, 6, 11, 21, 21, 30.14),
	(3524, 6, 12, 21, 21, 29.985),
	(3525, 6, 13, 21, 21, 27.98),
	(3526, 6, 14, 21, 21, 27.99),
	(3527, 6, 15, 21, 21, 25.285),
	(3528, 6, 16, 21, 21, 27.975),
	(3529, 6, 17, 21, 21, 27.99),
	(3530, 6, 18, 21, 21, 18.815),
	(3531, 6, 19, 21, 21, 13.235),
	(3532, 6, 20, 21, 21, 18.535),
	(3533, 6, 21, 21, 21, 86.025),
	(3534, 6, 22, 21, 21, 1.47),
	(3535, 6, 23, 21, 21, 2.25),
	(3536, 6, 42, 21, 21, 2.265),
	(3537, 6, 9, 22, 22, 14.25),
	(3538, 6, 10, 22, 22, 33.94),
	(3539, 6, 11, 22, 22, 30.15),
	(3540, 6, 12, 22, 22, 29.96),
	(3541, 6, 13, 22, 22, 27.97),
	(3542, 6, 14, 22, 22, 27.98),
	(3543, 6, 15, 22, 22, 25.315),
	(3544, 6, 16, 22, 22, 27.965),
	(3545, 6, 17, 22, 22, 27.975),
	(3546, 6, 18, 22, 22, 18.86),
	(3547, 6, 19, 22, 22, 13.265),
	(3548, 6, 20, 22, 22, 18.53),
	(3549, 6, 21, 22, 22, 86.04),
	(3550, 6, 22, 22, 22, 1.458),
	(3551, 6, 23, 22, 22, 2.25),
	(3552, 6, 42, 22, 22, 2.265),
	(3553, 6, 9, 23, 23, 14.23),
	(3554, 6, 10, 23, 23, 33.945),
	(3555, 6, 11, 23, 23, 30.125),
	(3556, 6, 12, 23, 23, 29.955),
	(3557, 6, 13, 23, 23, 27.97),
	(3558, 6, 14, 23, 23, 27.98),
	(3559, 6, 15, 23, 23, 25.285),
	(3560, 6, 16, 23, 23, 27.96),
	(3561, 6, 17, 23, 23, 27.965),
	(3562, 6, 18, 23, 23, 18.815),
	(3563, 6, 19, 23, 23, 13.215),
	(3564, 6, 20, 23, 23, 18.535),
	(3565, 6, 21, 23, 23, 86.005),
	(3566, 6, 22, 23, 23, 1.468),
	(3567, 6, 23, 23, 23, 2.26),
	(3568, 6, 42, 23, 23, 2.25),
	(3569, 6, 9, 24, 24, 14.28),
	(3570, 6, 10, 24, 24, 33.935),
	(3571, 6, 11, 24, 24, 30.135),
	(3572, 6, 12, 24, 24, 29.985),
	(3573, 6, 13, 24, 24, 27.97),
	(3574, 6, 14, 24, 24, 27.98),
	(3575, 6, 15, 24, 24, 25.295),
	(3576, 6, 16, 24, 24, 27.975),
	(3577, 6, 17, 24, 24, 27.975),
	(3578, 6, 18, 24, 24, 18.81),
	(3579, 6, 19, 24, 24, 13.23),
	(3580, 6, 20, 24, 24, 18.545),
	(3581, 6, 21, 24, 24, 86.045),
	(3582, 6, 22, 24, 24, 1.462),
	(3583, 6, 23, 24, 24, 2.245),
	(3584, 6, 42, 24, 24, 2.255),
	(4353, 7, 142, 1, 1, 27.52),
	(4354, 7, 143, 1, 1, 33.965),
	(4355, 7, 144, 1, 1, 30.145),
	(4356, 7, 145, 1, 1, 29.965),
	(4357, 7, 146, 1, 1, 27.97),
	(4358, 7, 147, 1, 1, 27.99),
	(4359, 7, 148, 1, 1, 25.29),
	(4360, 7, 149, 1, 1, 27.975),
	(4361, 7, 150, 1, 1, 27.975),
	(4362, 7, 151, 1, 1, 25.69),
	(4363, 7, 152, 1, 1, 13.226),
	(4364, 7, 153, 1, 1, 18.53),
	(4365, 7, 154, 1, 1, 119.055),
	(4366, 7, 155, 1, 1, 1.53),
	(4367, 7, 156, 1, 1, 2.53),
	(4368, 7, 157, 1, 1, 2.545),
	(4369, 7, 142, 2, 2, 27.56),
	(4370, 7, 143, 2, 2, 33.925),
	(4371, 7, 144, 2, 2, 30.13),
	(4372, 7, 145, 2, 2, 29.97),
	(4373, 7, 146, 2, 2, 27.97),
	(4374, 7, 147, 2, 2, 27.98),
	(4375, 7, 148, 2, 2, 25.31),
	(4376, 7, 149, 2, 2, 27.985),
	(4377, 7, 150, 2, 2, 27.99),
	(4378, 7, 151, 2, 2, 25.675),
	(4379, 7, 152, 2, 2, 13.24),
	(4380, 7, 153, 2, 2, 18.557),
	(4381, 7, 154, 2, 2, 119.035),
	(4382, 7, 155, 2, 2, 1.525),
	(4383, 7, 156, 2, 2, 2.535),
	(4384, 7, 157, 2, 2, 2.525),
	(4385, 7, 142, 3, 3, 27.54),
	(4386, 7, 143, 3, 3, 33.94),
	(4387, 7, 144, 3, 3, 30.14),
	(4388, 7, 145, 3, 3, 29.98),
	(4389, 7, 146, 3, 3, 27.97),
	(4390, 7, 147, 3, 3, 27.99),
	(4391, 7, 148, 3, 3, 25.285),
	(4392, 7, 149, 3, 3, 27.965),
	(4393, 7, 150, 3, 3, 27.975),
	(4394, 7, 151, 3, 3, 25.69),
	(4395, 7, 152, 3, 3, 13.235),
	(4396, 7, 153, 3, 3, 18.53),
	(4397, 7, 154, 3, 3, 119.06),
	(4398, 7, 155, 3, 3, 1.53),
	(4399, 7, 156, 3, 3, 2.545),
	(4400, 7, 157, 3, 3, 2.53),
	(4401, 7, 142, 4, 4, 27.52),
	(4402, 7, 143, 4, 4, 33.94),
	(4403, 7, 144, 4, 4, 30.125),
	(4404, 7, 145, 4, 4, 29.97),
	(4405, 7, 146, 4, 4, 27.97),
	(4406, 7, 147, 4, 4, 27.98),
	(4407, 7, 148, 4, 4, 25.31),
	(4408, 7, 149, 4, 4, 27.975),
	(4409, 7, 150, 4, 4, 27.98),
	(4410, 7, 151, 4, 4, 25.675),
	(4411, 7, 152, 4, 4, 13.255),
	(4412, 7, 153, 4, 4, 18.57),
	(4413, 7, 154, 4, 4, 119.065),
	(4414, 7, 155, 4, 4, 1.52),
	(4415, 7, 156, 4, 4, 2.53),
	(4416, 7, 157, 4, 4, 2.535),
	(4417, 7, 142, 5, 5, 27.51),
	(4418, 7, 143, 5, 5, 33.955),
	(4419, 7, 144, 5, 5, 30.13),
	(4420, 7, 145, 5, 5, 29.97),
	(4421, 7, 146, 5, 5, 27.97),
	(4422, 7, 147, 5, 5, 27.99),
	(4423, 7, 148, 5, 5, 25.315),
	(4424, 7, 149, 5, 5, 27.975),
	(4425, 7, 150, 5, 5, 27.975),
	(4426, 7, 151, 5, 5, 25.69),
	(4427, 7, 152, 5, 5, 13.24),
	(4428, 7, 153, 5, 5, 18.55),
	(4429, 7, 154, 5, 5, 119.055),
	(4430, 7, 155, 5, 5, 1.53),
	(4431, 7, 156, 5, 5, 2.525),
	(4432, 7, 157, 5, 5, 2.53),
	(4433, 7, 142, 6, 6, 27.54),
	(4434, 7, 143, 6, 6, 33.94),
	(4435, 7, 144, 6, 6, 30.14),
	(4436, 7, 145, 6, 6, 29.975),
	(4437, 7, 146, 6, 6, 27.98),
	(4438, 7, 147, 6, 6, 28),
	(4439, 7, 148, 6, 6, 25.31),
	(4440, 7, 149, 6, 6, 27.99),
	(4441, 7, 150, 6, 6, 27.98),
	(4442, 7, 151, 6, 6, 25.71),
	(4443, 7, 152, 6, 6, 13.225),
	(4444, 7, 153, 6, 6, 18.52),
	(4445, 7, 154, 6, 6, 119.055),
	(4446, 7, 155, 6, 6, 1.525),
	(4447, 7, 156, 6, 6, 2.53),
	(4448, 7, 157, 6, 6, 2.535),
	(4449, 7, 142, 7, 7, 27.51),
	(4450, 7, 143, 7, 7, 33.93),
	(4451, 7, 144, 7, 7, 30.121),
	(4452, 7, 145, 7, 7, 29.96),
	(4453, 7, 146, 7, 7, 27.96),
	(4454, 7, 147, 7, 7, 27.98),
	(4455, 7, 148, 7, 7, 25.29),
	(4456, 7, 149, 7, 7, 27.97),
	(4457, 7, 150, 7, 7, 27.99),
	(4458, 7, 151, 7, 7, 25.705),
	(4459, 7, 152, 7, 7, 13.235),
	(4460, 7, 153, 7, 7, 18.56),
	(4461, 7, 154, 7, 7, 119.025),
	(4462, 7, 155, 7, 7, 1.53),
	(4463, 7, 156, 7, 7, 2.525),
	(4464, 7, 157, 7, 7, 2.53),
	(4465, 7, 142, 8, 8, 27.54),
	(4466, 7, 143, 8, 8, 33.94),
	(4467, 7, 144, 8, 8, 30.14),
	(4468, 7, 145, 8, 8, 29.97),
	(4469, 7, 146, 8, 8, 27.98),
	(4470, 7, 147, 8, 8, 27.99),
	(4471, 7, 148, 8, 8, 25.29),
	(4472, 7, 149, 8, 8, 27.99),
	(4473, 7, 150, 8, 8, 27.97),
	(4474, 7, 151, 8, 8, 25.695),
	(4475, 7, 152, 8, 8, 13.25),
	(4476, 7, 153, 8, 8, 18.515),
	(4477, 7, 154, 8, 8, 119.05),
	(4478, 7, 155, 8, 8, 1.525),
	(4479, 7, 156, 8, 8, 2.53),
	(4480, 7, 157, 8, 8, 2.535),
	(4481, 7, 142, 9, 9, 27.51),
	(4482, 7, 143, 9, 9, 33.935),
	(4483, 7, 144, 9, 9, 30.125),
	(4484, 7, 145, 9, 9, 29.98),
	(4485, 7, 146, 9, 9, 27.97),
	(4486, 7, 147, 9, 9, 27.98),
	(4487, 7, 148, 9, 9, 25.305),
	(4488, 7, 149, 9, 9, 27.97),
	(4489, 7, 150, 9, 9, 27.98),
	(4490, 7, 151, 9, 9, 25.685),
	(4491, 7, 152, 9, 9, 13.23),
	(4492, 7, 153, 9, 9, 18.525),
	(4493, 7, 154, 9, 9, 119.055),
	(4494, 7, 155, 9, 9, 1.53),
	(4495, 7, 156, 9, 9, 2.525),
	(4496, 7, 157, 9, 9, 2.53),
	(4497, 7, 142, 10, 10, 27.53),
	(4498, 7, 143, 10, 10, 33.935),
	(4499, 7, 144, 10, 10, 30.16),
	(4500, 7, 145, 10, 10, 29.99),
	(4501, 7, 146, 10, 10, 27.98),
	(4502, 7, 147, 10, 10, 28),
	(4503, 7, 148, 10, 10, 25.31),
	(4504, 7, 149, 10, 10, 27.99),
	(4505, 7, 150, 10, 10, 28.005),
	(4506, 7, 151, 10, 10, 25.705),
	(4507, 7, 152, 10, 10, 13.255),
	(4508, 7, 153, 10, 10, 18.56),
	(4509, 7, 154, 10, 10, 119.025),
	(4510, 7, 155, 10, 10, 1.525),
	(4511, 7, 156, 10, 10, 2.52),
	(4512, 7, 157, 10, 10, 2.535),
	(4513, 7, 142, 11, 11, 27.53),
	(4514, 7, 143, 11, 11, 33.95),
	(4515, 7, 144, 11, 11, 30.135),
	(4516, 7, 145, 11, 11, 29.985),
	(4517, 7, 146, 11, 11, 27.97),
	(4518, 7, 147, 11, 11, 28),
	(4519, 7, 148, 11, 11, 25.285),
	(4520, 7, 149, 11, 11, 28),
	(4521, 7, 150, 11, 11, 27.99),
	(4522, 7, 151, 11, 11, 25.69),
	(4523, 7, 152, 11, 11, 13.235),
	(4524, 7, 153, 11, 11, 18.56),
	(4525, 7, 154, 11, 11, 119.06),
	(4526, 7, 155, 11, 11, 1.53),
	(4527, 7, 156, 11, 11, 2.525),
	(4528, 7, 157, 11, 11, 2.525),
	(4529, 7, 142, 12, 12, 27.52),
	(4530, 7, 143, 12, 12, 33.975),
	(4531, 7, 144, 12, 12, 30.16),
	(4532, 7, 145, 12, 12, 29.975),
	(4533, 7, 146, 12, 12, 27.98),
	(4534, 7, 147, 12, 12, 27.99),
	(4535, 7, 148, 12, 12, 25.29),
	(4536, 7, 149, 12, 12, 27.985),
	(4537, 7, 150, 12, 12, 27.995),
	(4538, 7, 151, 12, 12, 25.675),
	(4539, 7, 152, 12, 12, 13.245),
	(4540, 7, 153, 12, 12, 18.525),
	(4541, 7, 154, 12, 12, 119.075),
	(4542, 7, 155, 12, 12, 1.535),
	(4543, 7, 156, 12, 12, 2.52),
	(4544, 7, 157, 12, 12, 2.53),
	(4545, 7, 142, 13, 13, 27.52),
	(4546, 7, 143, 13, 13, 33.945),
	(4547, 7, 144, 13, 13, 30.135),
	(4548, 7, 145, 13, 13, 30),
	(4549, 7, 146, 13, 13, 27.96),
	(4550, 7, 147, 13, 13, 27.98),
	(4551, 7, 148, 13, 13, 25.275),
	(4552, 7, 149, 13, 13, 27.99),
	(4553, 7, 150, 13, 13, 27.985),
	(4554, 7, 151, 13, 13, 25.675),
	(4555, 7, 152, 13, 13, 13.24),
	(4556, 7, 153, 13, 13, 18.555),
	(4557, 7, 154, 13, 13, 119.045),
	(4558, 7, 155, 13, 13, 1.53),
	(4559, 7, 156, 13, 13, 2.53),
	(4560, 7, 157, 13, 13, 2.535),
	(4561, 7, 142, 14, 14, 27.56),
	(4562, 7, 143, 14, 14, 33.975),
	(4563, 7, 144, 14, 14, 30.145),
	(4564, 7, 145, 14, 14, 29.985),
	(4565, 7, 146, 14, 14, 27.97),
	(4566, 7, 147, 14, 14, 27.98),
	(4567, 7, 148, 14, 14, 25.285),
	(4568, 7, 149, 14, 14, 27.985),
	(4569, 7, 150, 14, 14, 27.99),
	(4570, 7, 151, 14, 14, 25.685),
	(4571, 7, 152, 14, 14, 13.235),
	(4572, 7, 153, 14, 14, 18.555),
	(4573, 7, 154, 14, 14, 119.085),
	(4574, 7, 155, 14, 14, 1.525),
	(4575, 7, 156, 14, 14, 2.525),
	(4576, 7, 157, 14, 14, 2.53),
	(4577, 7, 142, 15, 15, 27.5),
	(4578, 7, 143, 15, 15, 33.955),
	(4579, 7, 144, 15, 15, 30.13),
	(4580, 7, 145, 15, 15, 29.975),
	(4581, 7, 146, 15, 15, 27.96),
	(4582, 7, 147, 15, 15, 27.97),
	(4583, 7, 148, 15, 15, 25.265),
	(4584, 7, 149, 15, 15, 27.965),
	(4585, 7, 150, 15, 15, 27.97),
	(4586, 7, 151, 15, 15, 25.665),
	(4587, 7, 152, 15, 15, 13.245),
	(4588, 7, 153, 15, 15, 18.525),
	(4589, 7, 154, 15, 15, 119.065),
	(4590, 7, 155, 15, 15, 1.53),
	(4591, 7, 156, 15, 15, 2.545),
	(4592, 7, 157, 15, 15, 2.54),
	(4593, 7, 142, 16, 16, 27.5),
	(4594, 7, 143, 16, 16, 33.925),
	(4595, 7, 144, 16, 16, 30.14),
	(4596, 7, 145, 16, 16, 29.98),
	(4597, 7, 146, 16, 16, 27.96),
	(4598, 7, 147, 16, 16, 27.98),
	(4599, 7, 148, 16, 16, 25.29),
	(4600, 7, 149, 16, 16, 27.975),
	(4601, 7, 150, 16, 16, 27.99),
	(4602, 7, 151, 16, 16, 25.705),
	(4603, 7, 152, 16, 16, 13.265),
	(4604, 7, 153, 16, 16, 18.515),
	(4605, 7, 154, 16, 16, 119.055),
	(4606, 7, 155, 16, 16, 1.525),
	(4607, 7, 156, 16, 16, 2.53),
	(4608, 7, 157, 16, 16, 2.53),
	(4609, 7, 142, 17, 17, 27.53),
	(4610, 7, 143, 17, 17, 33.94),
	(4611, 7, 144, 17, 17, 30.155),
	(4612, 7, 145, 17, 17, 29.97),
	(4613, 7, 146, 17, 17, 27.96),
	(4614, 7, 147, 17, 17, 27.98),
	(4615, 7, 148, 17, 17, 25.27),
	(4616, 7, 149, 17, 17, 28.01),
	(4617, 7, 150, 17, 17, 27.975),
	(4618, 7, 151, 17, 17, 25.73),
	(4619, 7, 152, 17, 17, 13.24),
	(4620, 7, 153, 17, 17, 18.545),
	(4621, 7, 154, 17, 17, 119.04),
	(4622, 7, 155, 17, 17, 1.53),
	(4623, 7, 156, 17, 17, 2.535),
	(4624, 7, 157, 17, 17, 2.545),
	(4625, 7, 142, 18, 18, 27.52),
	(4626, 7, 143, 18, 18, 33.94),
	(4627, 7, 144, 18, 18, 30.13),
	(4628, 7, 145, 18, 18, 29.97),
	(4629, 7, 146, 18, 18, 27.98),
	(4630, 7, 147, 18, 18, 28),
	(4631, 7, 148, 18, 18, 25.29),
	(4632, 7, 149, 18, 18, 27.99),
	(4633, 7, 150, 18, 18, 27.985),
	(4634, 7, 151, 18, 18, 25.72),
	(4635, 7, 152, 18, 18, 13.2165),
	(4636, 7, 153, 18, 18, 18.55),
	(4637, 7, 154, 18, 18, 119.04),
	(4638, 7, 155, 18, 18, 1.53),
	(4639, 7, 156, 18, 18, 2.53),
	(4640, 7, 157, 18, 18, 2.525),
	(4641, 7, 142, 19, 19, 27.52),
	(4642, 7, 143, 19, 19, 33.955),
	(4643, 7, 144, 19, 19, 30.125),
	(4644, 7, 145, 19, 19, 29.99),
	(4645, 7, 146, 19, 19, 27.98),
	(4646, 7, 147, 19, 19, 27.99),
	(4647, 7, 148, 19, 19, 25.285),
	(4648, 7, 149, 19, 19, 27.98),
	(4649, 7, 150, 19, 19, 27.995),
	(4650, 7, 151, 19, 19, 25.71),
	(4651, 7, 152, 19, 19, 13.24),
	(4652, 7, 153, 19, 19, 18.53),
	(4653, 7, 154, 19, 19, 119.065),
	(4654, 7, 155, 19, 19, 1.53),
	(4655, 7, 156, 19, 19, 2.535),
	(4656, 7, 157, 19, 19, 2.53),
	(4657, 7, 142, 20, 20, 27.5),
	(4658, 7, 143, 20, 20, 33.925),
	(4659, 7, 144, 20, 20, 30.14),
	(4660, 7, 145, 20, 20, 29.98),
	(4661, 7, 146, 20, 20, 27.98),
	(4662, 7, 147, 20, 20, 28),
	(4663, 7, 148, 20, 20, 25.28),
	(4664, 7, 149, 20, 20, 27.97),
	(4665, 7, 150, 20, 20, 27.99),
	(4666, 7, 151, 20, 20, 25.71),
	(4667, 7, 152, 20, 20, 13.22),
	(4668, 7, 153, 20, 20, 18.55),
	(4669, 7, 154, 20, 20, 119.055),
	(4670, 7, 155, 20, 20, 1.525),
	(4671, 7, 156, 20, 20, 2.525),
	(4672, 7, 157, 20, 20, 2.52),
	(4673, 7, 142, 21, 21, 27.52),
	(4674, 7, 143, 21, 21, 33.915),
	(4675, 7, 144, 21, 21, 30.13),
	(4676, 7, 145, 21, 21, 29.975),
	(4677, 7, 146, 21, 21, 27.98),
	(4678, 7, 147, 21, 21, 28),
	(4679, 7, 148, 21, 21, 25.285),
	(4680, 7, 149, 21, 21, 27.975),
	(4681, 7, 150, 21, 21, 27.98),
	(4682, 7, 151, 21, 21, 25.72),
	(4683, 7, 152, 21, 21, 13.245),
	(4684, 7, 153, 21, 21, 18.525),
	(4685, 7, 154, 21, 21, 119.015),
	(4686, 7, 155, 21, 21, 1.53),
	(4687, 7, 156, 21, 21, 2.54),
	(4688, 7, 157, 21, 21, 2.53),
	(4689, 7, 142, 22, 22, 27.53),
	(4690, 7, 143, 22, 22, 33.93),
	(4691, 7, 144, 22, 22, 30.12),
	(4692, 7, 145, 22, 22, 29.97),
	(4693, 7, 146, 22, 22, 27.96),
	(4694, 7, 147, 22, 22, 27.98),
	(4695, 7, 148, 22, 22, 25.31),
	(4696, 7, 149, 22, 22, 27.995),
	(4697, 7, 150, 22, 22, 27.975),
	(4698, 7, 151, 22, 22, 25.685),
	(4699, 7, 152, 22, 22, 13.24),
	(4700, 7, 153, 22, 22, 18.515),
	(4701, 7, 154, 22, 22, 119.05),
	(4702, 7, 155, 22, 22, 1.525),
	(4703, 7, 156, 22, 22, 2.52),
	(4704, 7, 157, 22, 22, 2.525),
	(4705, 7, 142, 23, 23, 27.51),
	(4706, 7, 143, 23, 23, 33.94),
	(4707, 7, 144, 23, 23, 30.115),
	(4708, 7, 145, 23, 23, 29.97),
	(4709, 7, 146, 23, 23, 27.98),
	(4710, 7, 147, 23, 23, 27.99),
	(4711, 7, 148, 23, 23, 25.29),
	(4712, 7, 149, 23, 23, 27.98),
	(4713, 7, 150, 23, 23, 27.985),
	(4714, 7, 151, 23, 23, 25.675),
	(4715, 7, 152, 23, 23, 13.245),
	(4716, 7, 153, 23, 23, 18.52),
	(4717, 7, 154, 23, 23, 119.025),
	(4718, 7, 155, 23, 23, 1.53),
	(4719, 7, 156, 23, 23, 2.53),
	(4720, 7, 157, 23, 23, 2.53),
	(4721, 7, 142, 24, 24, 27.52),
	(4722, 7, 143, 24, 24, 33.925),
	(4723, 7, 144, 24, 24, 30.125),
	(4724, 7, 145, 24, 24, 29.98),
	(4725, 7, 146, 24, 24, 27.96),
	(4726, 7, 147, 24, 24, 27.98),
	(4727, 7, 148, 24, 24, 25.31),
	(4728, 7, 149, 24, 24, 27.985),
	(4729, 7, 150, 24, 24, 27.984),
	(4730, 7, 151, 24, 24, 25.71),
	(4731, 7, 152, 24, 24, 13.225),
	(4732, 7, 153, 24, 24, 18.53),
	(4733, 7, 154, 24, 24, 119.06),
	(4734, 7, 155, 24, 24, 1.535),
	(4735, 7, 156, 24, 24, 2.52),
	(4736, 7, 157, 24, 24, 2.525),
	(4737, 9, 9, 1, 25, 14.23),
	(4738, 9, 10, 1, 25, 0),
	(4739, 9, 11, 1, 25, 30.14),
	(4740, 9, 12, 1, 25, 29.975),
	(4741, 9, 13, 1, 25, 28.01),
	(4742, 9, 14, 1, 25, 28.02),
	(4743, 9, 15, 1, 25, 25.3),
	(4744, 9, 16, 1, 25, 27.965),
	(4745, 9, 17, 1, 25, 27.995),
	(4746, 9, 18, 1, 25, 18.835),
	(4747, 9, 19, 1, 25, 13.255),
	(4748, 9, 20, 1, 25, 18.555),
	(4749, 9, 21, 1, 25, 86.025),
	(4750, 9, 22, 1, 25, 1.468),
	(4751, 9, 23, 1, 25, 2.25),
	(4752, 9, 42, 1, 25, 2.26),
	(4753, 9, 9, 2, 26, 14.22),
	(4754, 9, 10, 2, 26, 0),
	(4755, 9, 11, 2, 26, 30.125),
	(4756, 9, 12, 2, 26, 29.985),
	(4757, 9, 13, 2, 26, 27.98),
	(4758, 9, 14, 2, 26, 28),
	(4759, 9, 15, 2, 26, 25.285),
	(4760, 9, 16, 2, 26, 27.955),
	(4761, 9, 17, 2, 26, 27.975),
	(4762, 9, 18, 2, 26, 18.835),
	(4763, 9, 19, 2, 26, 13.205),
	(4764, 9, 20, 2, 26, 18.55),
	(4765, 9, 21, 2, 26, 86.055),
	(4766, 9, 22, 2, 26, 1.46),
	(4767, 9, 23, 2, 26, 2.245),
	(4768, 9, 42, 2, 26, 2.25),
	(4769, 9, 9, 3, 27, 14.27),
	(4770, 9, 10, 3, 27, 0),
	(4771, 9, 11, 3, 27, 30.155),
	(4772, 9, 12, 3, 27, 30),
	(4773, 9, 13, 3, 27, 28.01),
	(4774, 9, 14, 3, 27, 28.02),
	(4775, 9, 15, 3, 27, 25.295),
	(4776, 9, 16, 3, 27, 27.98),
	(4777, 9, 17, 3, 27, 28),
	(4778, 9, 18, 3, 27, 18.825),
	(4779, 9, 19, 3, 27, 13.255),
	(4780, 9, 20, 3, 27, 18.565),
	(4781, 9, 21, 3, 27, 86.015),
	(4782, 9, 22, 3, 27, 1.46),
	(4783, 9, 23, 3, 27, 2.25),
	(4784, 9, 42, 3, 27, 2.255),
	(4785, 9, 9, 4, 28, 14.22),
	(4786, 9, 10, 4, 28, 0),
	(4787, 9, 11, 4, 28, 30.145),
	(4788, 9, 12, 4, 28, 29.965),
	(4789, 9, 13, 4, 28, 27.99),
	(4790, 9, 14, 4, 28, 28.02),
	(4791, 9, 15, 4, 28, 25.285),
	(4792, 9, 16, 4, 28, 27.96),
	(4793, 9, 17, 4, 28, 27.99),
	(4794, 9, 18, 4, 28, 18.845),
	(4795, 9, 19, 4, 28, 13.25),
	(4796, 9, 20, 4, 28, 18.555),
	(4797, 9, 21, 4, 28, 86.065),
	(4798, 9, 22, 4, 28, 1.458),
	(4799, 9, 23, 4, 28, 2.255),
	(4800, 9, 42, 4, 28, 2.25),
	(4801, 9, 9, 5, 29, 14.26),
	(4802, 9, 10, 5, 29, 0),
	(4803, 9, 11, 5, 29, 30.145),
	(4804, 9, 12, 5, 29, 30.01),
	(4805, 9, 13, 5, 29, 27.98),
	(4806, 9, 14, 5, 29, 28.01),
	(4807, 9, 15, 5, 29, 25.305),
	(4808, 9, 16, 5, 29, 27.985),
	(4809, 9, 17, 5, 29, 28.01),
	(4810, 9, 18, 5, 29, 18.82),
	(4811, 9, 19, 5, 29, 13.225),
	(4812, 9, 20, 5, 29, 18.55),
	(4813, 9, 21, 5, 29, 86.01),
	(4814, 9, 22, 5, 29, 1.47),
	(4815, 9, 23, 5, 29, 2.265),
	(4816, 9, 42, 5, 29, 2.26),
	(4817, 9, 9, 6, 30, 14.26),
	(4818, 9, 10, 6, 30, 0),
	(4819, 9, 11, 6, 30, 30.14),
	(4820, 9, 12, 6, 30, 29.99),
	(4821, 9, 13, 6, 30, 27.97),
	(4822, 9, 14, 6, 30, 27.99),
	(4823, 9, 15, 6, 30, 25.31),
	(4824, 9, 16, 6, 30, 27.985),
	(4825, 9, 17, 6, 30, 27.97),
	(4826, 9, 18, 6, 30, 18.815),
	(4827, 9, 19, 6, 30, 13.26),
	(4828, 9, 20, 6, 30, 18.515),
	(4829, 9, 21, 6, 30, 86.03),
	(4830, 9, 22, 6, 30, 1.458),
	(4831, 9, 23, 6, 30, 2.255),
	(4832, 9, 42, 6, 30, 2.245),
	(4833, 9, 9, 7, 31, 14.26),
	(4834, 9, 10, 7, 31, 0),
	(4835, 9, 11, 7, 31, 30.125),
	(4836, 9, 12, 7, 31, 29.97),
	(4837, 9, 13, 7, 31, 28.01),
	(4838, 9, 14, 7, 31, 28.02),
	(4839, 9, 15, 7, 31, 25.285),
	(4840, 9, 16, 7, 31, 27.96),
	(4841, 9, 17, 7, 31, 27.995),
	(4842, 9, 18, 7, 31, 18.805),
	(4843, 9, 19, 7, 31, 13.215),
	(4844, 9, 20, 7, 31, 18.535),
	(4845, 9, 21, 7, 31, 86.005),
	(4846, 9, 22, 7, 31, 1.46),
	(4847, 9, 23, 7, 31, 2.265),
	(4848, 9, 42, 7, 31, 2.255),
	(4849, 9, 9, 8, 32, 14.28),
	(4850, 9, 10, 8, 32, 0),
	(4851, 9, 11, 8, 32, 30.145),
	(4852, 9, 12, 8, 32, 30.005),
	(4853, 9, 13, 8, 32, 27.97),
	(4854, 9, 14, 8, 32, 27.98),
	(4855, 9, 15, 8, 32, 25.295),
	(4856, 9, 16, 8, 32, 27.955),
	(4857, 9, 17, 8, 32, 27.985),
	(4858, 9, 18, 8, 32, 18.855),
	(4859, 9, 19, 8, 32, 13.235),
	(4860, 9, 20, 8, 32, 18.56),
	(4861, 9, 21, 8, 32, 86.035),
	(4862, 9, 22, 8, 32, 1.462),
	(4863, 9, 23, 8, 32, 2.25),
	(4864, 9, 42, 8, 32, 2.265),
	(4865, 9, 9, 9, 33, 14.24),
	(4866, 9, 10, 9, 33, 0),
	(4867, 9, 11, 9, 33, 30.135),
	(4868, 9, 12, 9, 33, 29.985),
	(4869, 9, 13, 9, 33, 27.97),
	(4870, 9, 14, 9, 33, 27.99),
	(4871, 9, 15, 9, 33, 25.315),
	(4872, 9, 16, 9, 33, 27.97),
	(4873, 9, 17, 9, 33, 27.965),
	(4874, 9, 18, 9, 33, 18.825),
	(4875, 9, 19, 9, 33, 13.205),
	(4876, 9, 20, 9, 33, 18.505),
	(4877, 9, 21, 9, 33, 86.02),
	(4878, 9, 22, 9, 33, 1.464),
	(4879, 9, 23, 9, 33, 2.245),
	(4880, 9, 42, 9, 33, 2.25),
	(4881, 9, 9, 10, 34, 14.23),
	(4882, 9, 10, 10, 34, 0),
	(4883, 9, 11, 10, 34, 30.145),
	(4884, 9, 12, 10, 34, 29.995),
	(4885, 9, 13, 10, 34, 27.97),
	(4886, 9, 14, 10, 34, 28),
	(4887, 9, 15, 10, 34, 25.295),
	(4888, 9, 16, 10, 34, 27.975),
	(4889, 9, 17, 10, 34, 27.995),
	(4890, 9, 18, 10, 34, 18.84),
	(4891, 9, 19, 10, 34, 13.255),
	(4892, 9, 20, 10, 34, 18.505),
	(4893, 9, 21, 10, 34, 86.025),
	(4894, 9, 22, 10, 34, 1.46),
	(4895, 9, 23, 10, 34, 2.265),
	(4896, 9, 42, 10, 34, 2.245),
	(4897, 9, 9, 11, 35, 14.23),
	(4898, 9, 10, 11, 35, 0),
	(4899, 9, 11, 11, 35, 30.125),
	(4900, 9, 12, 11, 35, 29.975),
	(4901, 9, 13, 11, 35, 28),
	(4902, 9, 14, 11, 35, 28.01),
	(4903, 9, 15, 11, 35, 25.29),
	(4904, 9, 16, 11, 35, 27.955),
	(4905, 9, 17, 11, 35, 27.98),
	(4906, 9, 18, 11, 35, 18.805),
	(4907, 9, 19, 11, 35, 13.245),
	(4908, 9, 20, 11, 35, 18.555),
	(4909, 9, 21, 11, 35, 86.015),
	(4910, 9, 22, 11, 35, 1.466),
	(4911, 9, 23, 11, 35, 2.265),
	(4912, 9, 42, 11, 35, 2.265),
	(4913, 9, 9, 12, 36, 14.28),
	(4914, 9, 10, 12, 36, 0),
	(4915, 9, 11, 12, 36, 30.125),
	(4916, 9, 12, 12, 36, 29.975),
	(4917, 9, 13, 12, 36, 27.97),
	(4918, 9, 14, 12, 36, 27.98),
	(4919, 9, 15, 12, 36, 25.285),
	(4920, 9, 16, 12, 36, 27.985),
	(4921, 9, 17, 12, 36, 27.965),
	(4922, 9, 18, 12, 36, 18.845),
	(4923, 9, 19, 12, 36, 13.215),
	(4924, 9, 20, 12, 36, 18.545),
	(4925, 9, 21, 12, 36, 86.065),
	(4926, 9, 22, 12, 36, 1.458),
	(4927, 9, 23, 12, 36, 2.25),
	(4928, 9, 42, 12, 36, 2.25),
	(4929, 9, 9, 13, 37, 14.21),
	(4930, 9, 10, 13, 37, 0),
	(4931, 9, 11, 13, 37, 30.125),
	(4932, 9, 12, 13, 37, 29.99),
	(4933, 9, 13, 13, 37, 27.97),
	(4934, 9, 14, 13, 37, 28),
	(4935, 9, 15, 13, 37, 25.325),
	(4936, 9, 16, 13, 37, 27.99),
	(4937, 9, 17, 13, 37, 27.985),
	(4938, 9, 18, 13, 37, 18.85),
	(4939, 9, 19, 13, 37, 13.205),
	(4940, 9, 20, 13, 37, 18.51),
	(4941, 9, 21, 13, 37, 86.015),
	(4942, 9, 22, 13, 37, 1.468),
	(4943, 9, 23, 13, 37, 2.26),
	(4944, 9, 42, 13, 37, 2.255),
	(4945, 9, 9, 14, 38, 14.23),
	(4946, 9, 10, 14, 38, 0),
	(4947, 9, 11, 14, 38, 30.15),
	(4948, 9, 12, 14, 38, 29.995),
	(4949, 9, 13, 14, 38, 27.98),
	(4950, 9, 14, 14, 38, 28),
	(4951, 9, 15, 14, 38, 25.285),
	(4952, 9, 16, 14, 38, 27.97),
	(4953, 9, 17, 14, 38, 27.975),
	(4954, 9, 18, 14, 38, 18.805),
	(4955, 9, 19, 14, 38, 13.21),
	(4956, 9, 20, 14, 38, 18.55),
	(4957, 9, 21, 14, 38, 86.005),
	(4958, 9, 22, 14, 38, 1.46),
	(4959, 9, 23, 14, 38, 2.245),
	(4960, 9, 42, 14, 38, 2.26),
	(4961, 9, 9, 15, 39, 14.21),
	(4962, 9, 10, 15, 39, 0),
	(4963, 9, 11, 15, 39, 30.135),
	(4964, 9, 12, 15, 39, 29.985),
	(4965, 9, 13, 15, 39, 27.99),
	(4966, 9, 14, 15, 39, 28.02),
	(4967, 9, 15, 15, 39, 25.29),
	(4968, 9, 16, 15, 39, 27.965),
	(4969, 9, 17, 15, 39, 27.965),
	(4970, 9, 18, 15, 39, 18.825),
	(4971, 9, 19, 15, 39, 13.215),
	(4972, 9, 20, 15, 39, 18.52),
	(4973, 9, 21, 15, 39, 86.055),
	(4974, 9, 22, 15, 39, 1.462),
	(4975, 9, 23, 15, 39, 2.25),
	(4976, 9, 42, 15, 39, 2.265),
	(4977, 9, 9, 16, 40, 14.26),
	(4978, 9, 10, 16, 40, 0),
	(4979, 9, 11, 16, 40, 30.13),
	(4980, 9, 12, 16, 40, 29.975),
	(4981, 9, 13, 16, 40, 27.98),
	(4982, 9, 14, 16, 40, 27.99),
	(4983, 9, 15, 16, 40, 25.295),
	(4984, 9, 16, 16, 40, 27.99),
	(4985, 9, 17, 16, 40, 28),
	(4986, 9, 18, 16, 40, 18.82),
	(4987, 9, 19, 16, 40, 13.225),
	(4988, 9, 20, 16, 40, 18.555),
	(4989, 9, 21, 16, 40, 86.035),
	(4990, 9, 22, 16, 40, 1.464),
	(4991, 9, 23, 16, 40, 2.255),
	(4992, 9, 42, 16, 40, 2.26),
	(4993, 9, 9, 17, 41, 14.22),
	(4994, 9, 10, 17, 41, 0),
	(4995, 9, 11, 17, 41, 30.15),
	(4996, 9, 12, 17, 41, 29.96),
	(4997, 9, 13, 17, 41, 27.97),
	(4998, 9, 14, 17, 41, 27.98),
	(4999, 9, 15, 17, 41, 25.295),
	(5000, 9, 16, 17, 41, 27.955),
	(5001, 9, 17, 17, 41, 28.005),
	(5002, 9, 18, 17, 41, 18.83),
	(5003, 9, 19, 17, 41, 13.26),
	(5004, 9, 20, 17, 41, 18.505),
	(5005, 9, 21, 17, 41, 86.07),
	(5006, 9, 22, 17, 41, 1.458),
	(5007, 9, 23, 17, 41, 2.25),
	(5008, 9, 42, 17, 41, 2.265),
	(5009, 9, 9, 18, 42, 14.24),
	(5010, 9, 10, 18, 42, 0),
	(5011, 9, 11, 18, 42, 30.125),
	(5012, 9, 12, 18, 42, 29.99),
	(5013, 9, 13, 18, 42, 27.98),
	(5014, 9, 14, 18, 42, 28),
	(5015, 9, 15, 18, 42, 25.285),
	(5016, 9, 16, 18, 42, 27.975),
	(5017, 9, 17, 18, 42, 28.01),
	(5018, 9, 18, 18, 42, 18.86),
	(5019, 9, 19, 18, 42, 13.225),
	(5020, 9, 20, 18, 42, 18.51),
	(5021, 9, 21, 18, 42, 86.005),
	(5022, 9, 22, 18, 42, 1.46),
	(5023, 9, 23, 18, 42, 2.245),
	(5024, 9, 42, 18, 42, 2.255),
	(5025, 9, 9, 19, 43, 14.23),
	(5026, 9, 10, 19, 43, 0),
	(5027, 9, 11, 19, 43, 30.135),
	(5028, 9, 12, 19, 43, 29.975),
	(5029, 9, 13, 19, 43, 28),
	(5030, 9, 14, 19, 43, 28.01),
	(5031, 9, 15, 19, 43, 25.31),
	(5032, 9, 16, 19, 43, 27.995),
	(5033, 9, 17, 19, 43, 27.985),
	(5034, 9, 18, 19, 43, 18.815),
	(5035, 9, 19, 19, 43, 13.205),
	(5036, 9, 20, 19, 43, 18.515),
	(5037, 9, 21, 19, 43, 86.02),
	(5038, 9, 22, 19, 43, 1.462),
	(5039, 9, 23, 19, 43, 2.255),
	(5040, 9, 42, 19, 43, 2.245),
	(5041, 9, 9, 20, 44, 14.2),
	(5042, 9, 10, 20, 44, 0),
	(5043, 9, 11, 20, 44, 30.13),
	(5044, 9, 12, 20, 44, 29.98),
	(5045, 9, 13, 20, 44, 28),
	(5046, 9, 14, 20, 44, 28.02),
	(5047, 9, 15, 20, 44, 25.305),
	(5048, 9, 16, 20, 44, 27.985),
	(5049, 9, 17, 20, 44, 27.995),
	(5050, 9, 18, 20, 44, 18.835),
	(5051, 9, 19, 20, 44, 13.21),
	(5052, 9, 20, 20, 44, 18.525),
	(5053, 9, 21, 20, 44, 86.03),
	(5054, 9, 22, 20, 44, 1.464),
	(5055, 9, 23, 20, 44, 2.245),
	(5056, 9, 42, 20, 44, 2.255),
	(5057, 9, 9, 21, 45, 14.27),
	(5058, 9, 10, 21, 45, 0),
	(5059, 9, 11, 21, 45, 30.14),
	(5060, 9, 12, 21, 45, 29.985),
	(5061, 9, 13, 21, 45, 27.98),
	(5062, 9, 14, 21, 45, 27.99),
	(5063, 9, 15, 21, 45, 25.285),
	(5064, 9, 16, 21, 45, 27.975),
	(5065, 9, 17, 21, 45, 27.99),
	(5066, 9, 18, 21, 45, 18.815),
	(5067, 9, 19, 21, 45, 13.235),
	(5068, 9, 20, 21, 45, 18.535),
	(5069, 9, 21, 21, 45, 86.025),
	(5070, 9, 22, 21, 45, 1.47),
	(5071, 9, 23, 21, 45, 2.25),
	(5072, 9, 42, 21, 45, 2.265),
	(5073, 9, 9, 22, 46, 14.25),
	(5074, 9, 10, 22, 46, 0),
	(5075, 9, 11, 22, 46, 30.15),
	(5076, 9, 12, 22, 46, 29.96),
	(5077, 9, 13, 22, 46, 27.97),
	(5078, 9, 14, 22, 46, 27.98),
	(5079, 9, 15, 22, 46, 25.315),
	(5080, 9, 16, 22, 46, 27.965),
	(5081, 9, 17, 22, 46, 27.975),
	(5082, 9, 18, 22, 46, 18.86),
	(5083, 9, 19, 22, 46, 13.265),
	(5084, 9, 20, 22, 46, 18.53),
	(5085, 9, 21, 22, 46, 86.04),
	(5086, 9, 22, 22, 46, 1.458),
	(5087, 9, 23, 22, 46, 2.25),
	(5088, 9, 42, 22, 46, 2.265),
	(5089, 9, 9, 23, 47, 14.23),
	(5090, 9, 10, 23, 47, 0),
	(5091, 9, 11, 23, 47, 30.125),
	(5092, 9, 12, 23, 47, 29.955),
	(5093, 9, 13, 23, 47, 27.97),
	(5094, 9, 14, 23, 47, 27.98),
	(5095, 9, 15, 23, 47, 25.285),
	(5096, 9, 16, 23, 47, 27.96),
	(5097, 9, 17, 23, 47, 27.965),
	(5098, 9, 18, 23, 47, 18.815),
	(5099, 9, 19, 23, 47, 13.215),
	(5100, 9, 20, 23, 47, 18.535),
	(5101, 9, 21, 23, 47, 86.005),
	(5102, 9, 22, 23, 47, 1.468),
	(5103, 9, 23, 23, 47, 2.26),
	(5104, 9, 42, 23, 47, 2.25),
	(5105, 9, 9, 24, 48, 14.28),
	(5106, 9, 10, 24, 48, 0),
	(5107, 9, 11, 24, 48, 30.135),
	(5108, 9, 12, 24, 48, 29.985),
	(5109, 9, 13, 24, 48, 27.97),
	(5110, 9, 14, 24, 48, 27.98),
	(5111, 9, 15, 24, 48, 25.295),
	(5112, 9, 16, 24, 48, 27.975),
	(5113, 9, 17, 24, 48, 27.975),
	(5114, 9, 18, 24, 48, 18.81),
	(5115, 9, 19, 24, 48, 13.23),
	(5116, 9, 20, 24, 48, 18.545),
	(5117, 9, 21, 24, 48, 86.045),
	(5118, 9, 22, 24, 48, 1.462),
	(5119, 9, 23, 24, 48, 2.245),
	(5120, 9, 42, 24, 48, 2.255),
	(6273, 10, 78, 1, 1, 14.32),
	(6274, 10, 79, 1, 1, 33.945),
	(6275, 10, 80, 1, 1, 30.16),
	(6276, 10, 81, 1, 1, 29.98),
	(6277, 10, 82, 1, 1, 27.99),
	(6278, 10, 83, 1, 1, 28.01),
	(6279, 10, 84, 1, 1, 25.265),
	(6280, 10, 85, 1, 1, 27.99),
	(6281, 10, 86, 1, 1, 27.98),
	(6282, 10, 87, 1, 1, 18.81),
	(6283, 10, 88, 1, 1, 13.235),
	(6284, 10, 89, 1, 1, 18.55),
	(6285, 10, 90, 1, 1, 86.03),
	(6286, 10, 91, 1, 1, 1.458),
	(6287, 10, 92, 1, 1, 2.265),
	(6288, 10, 93, 1, 1, 2.245),
	(6289, 10, 78, 2, 2, 14.3),
	(6290, 10, 79, 2, 2, 33.93),
	(6291, 10, 80, 2, 2, 30.165),
	(6292, 10, 81, 2, 2, 29.98),
	(6293, 10, 82, 2, 2, 27.97),
	(6294, 10, 83, 2, 2, 27.99),
	(6295, 10, 84, 2, 2, 25.28),
	(6296, 10, 85, 2, 2, 27.97),
	(6297, 10, 86, 2, 2, 28),
	(6298, 10, 87, 2, 2, 18.84),
	(6299, 10, 88, 2, 2, 13.26),
	(6300, 10, 89, 2, 2, 18.535),
	(6301, 10, 90, 2, 2, 86.05),
	(6302, 10, 91, 2, 2, 1.472),
	(6303, 10, 92, 2, 2, 2.265),
	(6304, 10, 93, 2, 2, 2.24),
	(6305, 10, 78, 3, 3, 14.33),
	(6306, 10, 79, 3, 3, 33.985),
	(6307, 10, 80, 3, 3, 30.175),
	(6308, 10, 81, 3, 3, 29.99),
	(6309, 10, 82, 3, 3, 28),
	(6310, 10, 83, 3, 3, 28.02),
	(6311, 10, 84, 3, 3, 25.315),
	(6312, 10, 85, 3, 3, 27.995),
	(6313, 10, 86, 3, 3, 28.01),
	(6314, 10, 87, 3, 3, 18.815),
	(6315, 10, 88, 3, 3, 13.225),
	(6316, 10, 89, 3, 3, 18.545),
	(6317, 10, 90, 3, 3, 86.055),
	(6318, 10, 91, 3, 3, 1.468),
	(6319, 10, 92, 3, 3, 2.255),
	(6320, 10, 93, 3, 3, 2.255),
	(6321, 10, 78, 4, 4, 14.34),
	(6322, 10, 79, 4, 4, 33.955),
	(6323, 10, 80, 4, 4, 30.175),
	(6324, 10, 81, 4, 4, 30.01),
	(6325, 10, 82, 4, 4, 28.01),
	(6326, 10, 83, 4, 4, 28.02),
	(6327, 10, 84, 4, 4, 25.325),
	(6328, 10, 85, 4, 4, 27.985),
	(6329, 10, 86, 4, 4, 27.985),
	(6330, 10, 87, 4, 4, 18.835),
	(6331, 10, 88, 4, 4, 13.255),
	(6332, 10, 89, 4, 4, 18.515),
	(6333, 10, 90, 4, 4, 86.09),
	(6334, 10, 91, 4, 4, 1.47),
	(6335, 10, 92, 4, 4, 2.25),
	(6336, 10, 93, 4, 4, 2.25),
	(6337, 10, 78, 5, 5, 14.3),
	(6338, 10, 79, 5, 5, 33.935),
	(6339, 10, 80, 5, 5, 30.16),
	(6340, 10, 81, 5, 5, 29.995),
	(6341, 10, 82, 5, 5, 27.98),
	(6342, 10, 83, 5, 5, 27.99),
	(6343, 10, 84, 5, 5, 25.32),
	(6344, 10, 85, 5, 5, 27.96),
	(6345, 10, 86, 5, 5, 27.975),
	(6346, 10, 87, 5, 5, 18.835),
	(6347, 10, 88, 5, 5, 13.24),
	(6348, 10, 89, 5, 5, 18.55),
	(6349, 10, 90, 5, 5, 86.06),
	(6350, 10, 91, 5, 5, 1.468),
	(6351, 10, 92, 5, 5, 2.265),
	(6352, 10, 93, 5, 5, 2.255),
	(6353, 10, 78, 6, 6, 14.3),
	(6354, 10, 79, 6, 6, 33.93),
	(6355, 10, 80, 6, 6, 30.175),
	(6356, 10, 81, 6, 6, 30.03),
	(6357, 10, 82, 6, 6, 28),
	(6358, 10, 83, 6, 6, 28.02),
	(6359, 10, 84, 6, 6, 25.29),
	(6360, 10, 85, 6, 6, 27.99),
	(6361, 10, 86, 6, 6, 28.005),
	(6362, 10, 87, 6, 6, 18.815),
	(6363, 10, 88, 6, 6, 13.23),
	(6364, 10, 89, 6, 6, 18.55),
	(6365, 10, 90, 6, 6, 86.09),
	(6366, 10, 91, 6, 6, 1.472),
	(6367, 10, 92, 6, 6, 2.26),
	(6368, 10, 93, 6, 6, 2.26),
	(6369, 10, 78, 7, 7, 14.32),
	(6370, 10, 79, 7, 7, 33.95),
	(6371, 10, 80, 7, 7, 30.15),
	(6372, 10, 81, 7, 7, 29.995),
	(6373, 10, 82, 7, 7, 27.98),
	(6374, 10, 83, 7, 7, 28),
	(6375, 10, 84, 7, 7, 25.325),
	(6376, 10, 85, 7, 7, 27.99),
	(6377, 10, 86, 7, 7, 28),
	(6378, 10, 87, 7, 7, 18.82),
	(6379, 10, 88, 7, 7, 13.26),
	(6380, 10, 89, 7, 7, 18.53),
	(6381, 10, 90, 7, 7, 86.085),
	(6382, 10, 91, 7, 7, 1.456),
	(6383, 10, 92, 7, 7, 2.255),
	(6384, 10, 93, 7, 7, 2.25),
	(6385, 10, 78, 8, 8, 14.32),
	(6386, 10, 79, 8, 8, 33.99),
	(6387, 10, 80, 8, 8, 30.18),
	(6388, 10, 81, 8, 8, 29.97),
	(6389, 10, 82, 8, 8, 28),
	(6390, 10, 83, 8, 8, 28.02),
	(6391, 10, 84, 8, 8, 25.32),
	(6392, 10, 85, 8, 8, 27.975),
	(6393, 10, 86, 8, 8, 27.98),
	(6394, 10, 87, 8, 8, 18.825),
	(6395, 10, 88, 8, 8, 13.26),
	(6396, 10, 89, 8, 8, 18.535),
	(6397, 10, 90, 8, 8, 86.035),
	(6398, 10, 91, 8, 8, 1.47),
	(6399, 10, 92, 8, 8, 2.26),
	(6400, 10, 93, 8, 8, 2.265),
	(6401, 10, 78, 9, 9, 14.29),
	(6402, 10, 79, 9, 9, 33.94),
	(6403, 10, 80, 9, 9, 30.135),
	(6404, 10, 81, 9, 9, 30.025),
	(6405, 10, 82, 9, 9, 27.98),
	(6406, 10, 83, 9, 9, 28),
	(6407, 10, 84, 9, 9, 25.31),
	(6408, 10, 85, 9, 9, 27.985),
	(6409, 10, 86, 9, 9, 27.98),
	(6410, 10, 87, 9, 9, 18.825),
	(6411, 10, 88, 9, 9, 13.24),
	(6412, 10, 89, 9, 9, 18.55),
	(6413, 10, 90, 9, 9, 86.01),
	(6414, 10, 91, 9, 9, 1.468),
	(6415, 10, 92, 9, 9, 2.255),
	(6416, 10, 93, 9, 9, 2.25),
	(6417, 10, 78, 10, 10, 14.34),
	(6418, 10, 79, 10, 10, 34.015),
	(6419, 10, 80, 10, 10, 30.15),
	(6420, 10, 81, 10, 10, 30.015),
	(6421, 10, 82, 10, 10, 27.99),
	(6422, 10, 83, 10, 10, 28),
	(6423, 10, 84, 10, 10, 25.315),
	(6424, 10, 85, 10, 10, 27.99),
	(6425, 10, 86, 10, 10, 27.995),
	(6426, 10, 87, 10, 10, 18.85),
	(6427, 10, 88, 10, 10, 13.225),
	(6428, 10, 89, 10, 10, 18.56),
	(6429, 10, 90, 10, 10, 86.055),
	(6430, 10, 91, 10, 10, 1.472),
	(6431, 10, 92, 10, 10, 2.25),
	(6432, 10, 93, 10, 10, 2.265),
	(6433, 10, 78, 11, 11, 14.31),
	(6434, 10, 79, 11, 11, 33.96),
	(6435, 10, 80, 11, 11, 30.15),
	(6436, 10, 81, 11, 11, 29.98),
	(6437, 10, 82, 11, 11, 27.98),
	(6438, 10, 83, 11, 11, 28),
	(6439, 10, 84, 11, 11, 25.3),
	(6440, 10, 85, 11, 11, 27.985),
	(6441, 10, 86, 11, 11, 27.975),
	(6442, 10, 87, 11, 11, 18.825),
	(6443, 10, 88, 11, 11, 13.24),
	(6444, 10, 89, 11, 11, 18.555),
	(6445, 10, 90, 11, 11, 86.07),
	(6446, 10, 91, 11, 11, 1.47),
	(6447, 10, 92, 11, 11, 2.255),
	(6448, 10, 93, 11, 11, 2.26),
	(6449, 10, 78, 12, 12, 14.31),
	(6450, 10, 79, 12, 12, 33.94),
	(6451, 10, 80, 12, 12, 30.155),
	(6452, 10, 81, 12, 12, 30.01),
	(6453, 10, 82, 12, 12, 27.98),
	(6454, 10, 83, 12, 12, 28.01),
	(6455, 10, 84, 12, 12, 25.315),
	(6456, 10, 85, 12, 12, 27.99),
	(6457, 10, 86, 12, 12, 27.995),
	(6458, 10, 87, 12, 12, 18.85),
	(6459, 10, 88, 12, 12, 13.225),
	(6460, 10, 89, 12, 12, 18.56),
	(6461, 10, 90, 12, 12, 86.05),
	(6462, 10, 91, 12, 12, 1.468),
	(6463, 10, 92, 12, 12, 2.265),
	(6464, 10, 93, 12, 12, 2.255),
	(6465, 10, 78, 13, 13, 14.32),
	(6466, 10, 79, 13, 13, 33.95),
	(6467, 10, 80, 13, 13, 30.135),
	(6468, 10, 81, 13, 13, 29.975),
	(6469, 10, 82, 13, 13, 27.98),
	(6470, 10, 83, 13, 13, 27.99),
	(6471, 10, 84, 13, 13, 25.31),
	(6472, 10, 85, 13, 13, 27.99),
	(6473, 10, 86, 13, 13, 27.965),
	(6474, 10, 87, 13, 13, 18.825),
	(6475, 10, 88, 13, 13, 13.24),
	(6476, 10, 89, 13, 13, 18.55),
	(6477, 10, 90, 13, 13, 86.01),
	(6478, 10, 91, 13, 13, 1.464),
	(6479, 10, 92, 13, 13, 2.26),
	(6480, 10, 93, 13, 13, 2.25),
	(6481, 10, 78, 14, 14, 14.32),
	(6482, 10, 79, 14, 14, 33.97),
	(6483, 10, 80, 14, 14, 30.145),
	(6484, 10, 81, 14, 14, 29.995),
	(6485, 10, 82, 14, 14, 28),
	(6486, 10, 83, 14, 14, 28.01),
	(6487, 10, 84, 14, 14, 25.31),
	(6488, 10, 85, 14, 14, 27.955),
	(6489, 10, 86, 14, 14, 27.995),
	(6490, 10, 87, 14, 14, 18.83),
	(6491, 10, 88, 14, 14, 13.225),
	(6492, 10, 89, 14, 14, 18.56),
	(6493, 10, 90, 14, 14, 86.05),
	(6494, 10, 91, 14, 14, 1.47),
	(6495, 10, 92, 14, 14, 2.255),
	(6496, 10, 93, 14, 14, 2.255),
	(6497, 10, 78, 15, 15, 14.32),
	(6498, 10, 79, 15, 15, 33.96),
	(6499, 10, 80, 15, 15, 30.155),
	(6500, 10, 81, 15, 15, 29.995),
	(6501, 10, 82, 15, 15, 27.99),
	(6502, 10, 83, 15, 15, 28.02),
	(6503, 10, 84, 15, 15, 25.305),
	(6504, 10, 85, 15, 15, 27.97),
	(6505, 10, 86, 15, 15, 27.985),
	(6506, 10, 87, 15, 15, 18.815),
	(6507, 10, 88, 15, 15, 13.245),
	(6508, 10, 89, 15, 15, 18.55),
	(6509, 10, 90, 15, 15, 86.01),
	(6510, 10, 91, 15, 15, 1.468),
	(6511, 10, 92, 15, 15, 2.25),
	(6512, 10, 93, 15, 15, 2.245),
	(6513, 10, 78, 16, 16, 14.31),
	(6514, 10, 79, 16, 16, 33.925),
	(6515, 10, 80, 16, 16, 30.17),
	(6516, 10, 81, 16, 16, 29.98),
	(6517, 10, 82, 16, 16, 27.97),
	(6518, 10, 83, 16, 16, 27.99),
	(6519, 10, 84, 16, 16, 25.27),
	(6520, 10, 85, 16, 16, 27.965),
	(6521, 10, 86, 16, 16, 27.985),
	(6522, 10, 87, 16, 16, 18.82),
	(6523, 10, 88, 16, 16, 13.235),
	(6524, 10, 89, 16, 16, 18.54),
	(6525, 10, 90, 16, 16, 86.07),
	(6526, 10, 91, 16, 16, 1.464),
	(6527, 10, 92, 16, 16, 2.265),
	(6528, 10, 93, 16, 16, 2.26),
	(6529, 10, 78, 17, 17, 14.32),
	(6530, 10, 79, 17, 17, 33.985),
	(6531, 10, 80, 17, 17, 30.175),
	(6532, 10, 81, 17, 17, 30.02),
	(6533, 10, 82, 17, 17, 27.98),
	(6534, 10, 83, 17, 17, 27.99),
	(6535, 10, 84, 17, 17, 25.32),
	(6536, 10, 85, 17, 17, 27.99),
	(6537, 10, 86, 17, 17, 28.005),
	(6538, 10, 87, 17, 17, 18.815),
	(6539, 10, 88, 17, 17, 13.23),
	(6540, 10, 89, 17, 17, 18.55),
	(6541, 10, 90, 17, 17, 86.09),
	(6542, 10, 91, 17, 17, 1.458),
	(6543, 10, 92, 17, 17, 2.26),
	(6544, 10, 93, 17, 17, 2.265),
	(6545, 10, 78, 18, 18, 14.29),
	(6546, 10, 79, 18, 18, 33.95),
	(6547, 10, 80, 18, 18, 30.15),
	(6548, 10, 81, 18, 18, 30),
	(6549, 10, 82, 18, 18, 27.97),
	(6550, 10, 83, 18, 18, 28),
	(6551, 10, 84, 18, 18, 25.31),
	(6552, 10, 85, 18, 18, 27.985),
	(6553, 10, 86, 18, 18, 27.975),
	(6554, 10, 87, 18, 18, 18.825),
	(6555, 10, 88, 18, 18, 13.24),
	(6556, 10, 89, 18, 18, 18.55),
	(6557, 10, 90, 18, 18, 86.01),
	(6558, 10, 91, 18, 18, 1.464),
	(6559, 10, 92, 18, 18, 2.265),
	(6560, 10, 93, 18, 18, 2.255),
	(6561, 10, 78, 19, 19, 14.32),
	(6562, 10, 79, 19, 19, 33.985),
	(6563, 10, 80, 19, 19, 30.165),
	(6564, 10, 81, 19, 19, 29.985),
	(6565, 10, 82, 19, 19, 27.98),
	(6566, 10, 83, 19, 19, 27.99),
	(6567, 10, 84, 19, 19, 25.3),
	(6568, 10, 85, 19, 19, 27.96),
	(6569, 10, 86, 19, 19, 28),
	(6570, 10, 87, 19, 19, 18.805),
	(6571, 10, 88, 19, 19, 13.26),
	(6572, 10, 89, 19, 19, 18.525),
	(6573, 10, 90, 19, 19, 86.075),
	(6574, 10, 91, 19, 19, 1.468),
	(6575, 10, 92, 19, 19, 2.26),
	(6576, 10, 93, 19, 19, 2.25),
	(6577, 10, 78, 20, 20, 14.31),
	(6578, 10, 79, 20, 20, 33.96),
	(6579, 10, 80, 20, 20, 30.15),
	(6580, 10, 81, 20, 20, 30.02),
	(6581, 10, 82, 20, 20, 27.98),
	(6582, 10, 83, 20, 20, 28.01),
	(6583, 10, 84, 20, 20, 25.325),
	(6584, 10, 85, 20, 20, 27.975),
	(6585, 10, 86, 20, 20, 27.985),
	(6586, 10, 87, 20, 20, 18.835),
	(6587, 10, 88, 20, 20, 13.24),
	(6588, 10, 89, 20, 20, 18.545),
	(6589, 10, 90, 20, 20, 86.055),
	(6590, 10, 91, 20, 20, 1.472),
	(6591, 10, 92, 20, 20, 2.265),
	(6592, 10, 93, 20, 20, 2.25),
	(6593, 10, 78, 21, 21, 14.33),
	(6594, 10, 79, 21, 21, 34),
	(6595, 10, 80, 21, 21, 30.185),
	(6596, 10, 81, 21, 21, 29.99),
	(6597, 10, 82, 21, 21, 27.98),
	(6598, 10, 83, 21, 21, 27.99),
	(6599, 10, 84, 21, 21, 25.305),
	(6600, 10, 85, 21, 21, 27.985),
	(6601, 10, 86, 21, 21, 27.99),
	(6602, 10, 87, 21, 21, 18.81),
	(6603, 10, 88, 21, 21, 13.235),
	(6604, 10, 89, 21, 21, 18.54),
	(6605, 10, 90, 21, 21, 86.03),
	(6606, 10, 91, 21, 21, 1.468),
	(6607, 10, 92, 21, 21, 2.27),
	(6608, 10, 93, 21, 21, 2.245),
	(6609, 10, 78, 22, 22, 14.31),
	(6610, 10, 79, 22, 22, 33.96),
	(6611, 10, 80, 22, 22, 30.155),
	(6612, 10, 81, 22, 22, 29.98),
	(6613, 10, 82, 22, 22, 27.99),
	(6614, 10, 83, 22, 22, 28.01),
	(6615, 10, 84, 22, 22, 25.315),
	(6616, 10, 85, 22, 22, 27.97),
	(6617, 10, 86, 22, 22, 27.98),
	(6618, 10, 87, 22, 22, 18.815),
	(6619, 10, 88, 22, 22, 13.255),
	(6620, 10, 89, 22, 22, 18.53),
	(6621, 10, 90, 22, 22, 86.08),
	(6622, 10, 91, 22, 22, 1.472),
	(6623, 10, 92, 22, 22, 2.26),
	(6624, 10, 93, 22, 22, 2.255),
	(6625, 10, 78, 23, 23, 14.28),
	(6626, 10, 79, 23, 23, 33.96),
	(6627, 10, 80, 23, 23, 30.16),
	(6628, 10, 81, 23, 23, 29.98),
	(6629, 10, 82, 23, 23, 27.97),
	(6630, 10, 83, 23, 23, 27.99),
	(6631, 10, 84, 23, 23, 25.31),
	(6632, 10, 85, 23, 23, 27.955),
	(6633, 10, 86, 23, 23, 27.995),
	(6634, 10, 87, 23, 23, 18.83),
	(6635, 10, 88, 23, 23, 13.225),
	(6636, 10, 89, 23, 23, 18.56),
	(6637, 10, 90, 23, 23, 86.045),
	(6638, 10, 91, 23, 23, 1.468),
	(6639, 10, 92, 23, 23, 2.265),
	(6640, 10, 93, 23, 23, 2.255),
	(6641, 10, 78, 24, 24, 14.31),
	(6642, 10, 79, 24, 24, 33.985),
	(6643, 10, 80, 24, 24, 30.165),
	(6644, 10, 81, 24, 24, 29.995),
	(6645, 10, 82, 24, 24, 27.98),
	(6646, 10, 83, 24, 24, 27.99),
	(6647, 10, 84, 24, 24, 25.33),
	(6648, 10, 85, 24, 24, 27.98),
	(6649, 10, 86, 24, 24, 27.965),
	(6650, 10, 87, 24, 24, 18.82),
	(6651, 10, 88, 24, 24, 13.26),
	(6652, 10, 89, 24, 24, 18.54),
	(6653, 10, 90, 24, 24, 86.01),
	(6654, 10, 91, 24, 24, 1.47),
	(6655, 10, 92, 24, 24, 2.26),
	(6656, 10, 93, 24, 24, 2.25),
	(6657, 8, 59, 1, 25, 27.51),
	(6658, 8, 60, 1, 25, 32.98),
	(6659, 8, 61, 1, 25, 27.95),
	(6660, 8, 62, 1, 25, 27.435),
	(6661, 8, 63, 1, 25, 24.97),
	(6662, 8, 64, 1, 25, 24.99),
	(6663, 8, 65, 1, 25, 25.72),
	(6664, 8, 66, 1, 25, 21.715),
	(6665, 8, 67, 1, 25, 22.48),
	(6666, 8, 68, 1, 25, 25.75),
	(6667, 8, 69, 1, 25, 14.135),
	(6668, 8, 70, 1, 25, 21.13),
	(6669, 8, 71, 1, 25, 100.075),
	(6670, 8, 72, 1, 25, 2.045),
	(6671, 8, 73, 1, 25, 3.91),
	(6672, 8, 74, 1, 25, 3.93),
	(6673, 8, 59, 2, 26, 27.5),
	(6674, 8, 60, 2, 26, 32.945),
	(6675, 8, 61, 2, 26, 27.97),
	(6676, 8, 62, 2, 26, 27.455),
	(6677, 8, 63, 2, 26, 24.95),
	(6678, 8, 64, 2, 26, 24.96),
	(6679, 8, 65, 2, 26, 25.72),
	(6680, 8, 66, 2, 26, 21.705),
	(6681, 8, 67, 2, 26, 22.53),
	(6682, 8, 68, 2, 26, 25.73),
	(6683, 8, 69, 2, 26, 14.155),
	(6684, 8, 70, 2, 26, 21.14),
	(6685, 8, 71, 2, 26, 100.06),
	(6686, 8, 72, 2, 26, 2.045),
	(6687, 8, 73, 2, 26, 3.93),
	(6688, 8, 74, 2, 26, 3.91),
	(6689, 8, 59, 3, 27, 27.52),
	(6690, 8, 60, 3, 27, 33),
	(6691, 8, 61, 3, 27, 27.965),
	(6692, 8, 62, 3, 27, 27.435),
	(6693, 8, 63, 3, 27, 24.96),
	(6694, 8, 64, 3, 27, 24.98),
	(6695, 8, 65, 3, 27, 25.725),
	(6696, 8, 66, 3, 27, 21.705),
	(6697, 8, 67, 3, 27, 22.49),
	(6698, 8, 68, 3, 27, 25.72),
	(6699, 8, 69, 3, 27, 14.125),
	(6700, 8, 70, 3, 27, 21.15),
	(6701, 8, 71, 3, 27, 100.025),
	(6702, 8, 72, 3, 27, 2.035),
	(6703, 8, 73, 3, 27, 3.92),
	(6704, 8, 74, 3, 27, 3.93),
	(6705, 8, 59, 4, 28, 27.53),
	(6706, 8, 60, 4, 28, 32.96),
	(6707, 8, 61, 4, 28, 27.97),
	(6708, 8, 62, 4, 28, 27.42),
	(6709, 8, 63, 4, 28, 24.92),
	(6710, 8, 64, 4, 28, 24.93),
	(6711, 8, 65, 4, 28, 25.695),
	(6712, 8, 66, 4, 28, 21.73),
	(6713, 8, 67, 4, 28, 22.49),
	(6714, 8, 68, 4, 28, 25.73),
	(6715, 8, 69, 4, 28, 14.16),
	(6716, 8, 70, 4, 28, 21.155),
	(6717, 8, 71, 4, 28, 100.035),
	(6718, 8, 72, 4, 28, 2.03),
	(6719, 8, 73, 4, 28, 3.93),
	(6720, 8, 74, 4, 28, 3.9),
	(6721, 8, 59, 5, 29, 27.53),
	(6722, 8, 60, 5, 29, 32.985),
	(6723, 8, 61, 5, 29, 27.955),
	(6724, 8, 62, 5, 29, 27.415),
	(6725, 8, 63, 5, 29, 24.93),
	(6726, 8, 64, 5, 29, 24.95),
	(6727, 8, 65, 5, 29, 25.685),
	(6728, 8, 66, 5, 29, 21.71),
	(6729, 8, 67, 5, 29, 22.515),
	(6730, 8, 68, 5, 29, 25.705),
	(6731, 8, 69, 5, 29, 14.125),
	(6732, 8, 70, 5, 29, 21.135),
	(6733, 8, 71, 5, 29, 100.04),
	(6734, 8, 72, 5, 29, 2.045),
	(6735, 8, 73, 5, 29, 3.89),
	(6736, 8, 74, 5, 29, 3.91),
	(6737, 8, 59, 6, 30, 27.55),
	(6738, 8, 60, 6, 30, 32.97),
	(6739, 8, 61, 6, 30, 27.965),
	(6740, 8, 62, 6, 30, 27.44),
	(6741, 8, 63, 6, 30, 24.96),
	(6742, 8, 64, 6, 30, 24.98),
	(6743, 8, 65, 6, 30, 25.705),
	(6744, 8, 66, 6, 30, 21.73),
	(6745, 8, 67, 6, 30, 22.51),
	(6746, 8, 68, 6, 30, 25.69),
	(6747, 8, 69, 6, 30, 14.14),
	(6748, 8, 70, 6, 30, 21.125),
	(6749, 8, 71, 6, 30, 100.07),
	(6750, 8, 72, 6, 30, 2.05),
	(6751, 8, 73, 6, 30, 3.91),
	(6752, 8, 74, 6, 30, 3.93),
	(6753, 8, 59, 7, 31, 27.53),
	(6754, 8, 60, 7, 31, 32.975),
	(6755, 8, 61, 7, 31, 27.97),
	(6756, 8, 62, 7, 31, 27.39),
	(6757, 8, 63, 7, 31, 24.98),
	(6758, 8, 64, 7, 31, 24.99),
	(6759, 8, 65, 7, 31, 25.735),
	(6760, 8, 66, 7, 31, 21.73),
	(6761, 8, 67, 7, 31, 22.48),
	(6762, 8, 68, 7, 31, 25.725),
	(6763, 8, 69, 7, 31, 14.125),
	(6764, 8, 70, 7, 31, 21.15),
	(6765, 8, 71, 7, 31, 100.015),
	(6766, 8, 72, 7, 31, 2.04),
	(6767, 8, 73, 7, 31, 3.92),
	(6768, 8, 74, 7, 31, 3.9),
	(6769, 8, 59, 8, 32, 27.53),
	(6770, 8, 60, 8, 32, 32.955),
	(6771, 8, 61, 8, 32, 27.97),
	(6772, 8, 62, 8, 32, 27.415),
	(6773, 8, 63, 8, 32, 24.93),
	(6774, 8, 64, 8, 32, 24.95),
	(6775, 8, 65, 8, 32, 25.695),
	(6776, 8, 66, 8, 32, 21.71),
	(6777, 8, 67, 8, 32, 22.5),
	(6778, 8, 68, 8, 32, 25.71),
	(6779, 8, 69, 8, 32, 14.155),
	(6780, 8, 70, 8, 32, 21.14),
	(6781, 8, 71, 8, 32, 100.04),
	(6782, 8, 72, 8, 32, 2.045),
	(6783, 8, 73, 8, 32, 3.91),
	(6784, 8, 74, 8, 32, 3.92),
	(6785, 8, 59, 9, 33, 27.53),
	(6786, 8, 60, 9, 33, 32.97),
	(6787, 8, 61, 9, 33, 27.96),
	(6788, 8, 62, 9, 33, 27.405),
	(6789, 8, 63, 9, 33, 24.97),
	(6790, 8, 64, 9, 33, 24.99),
	(6791, 8, 65, 9, 33, 25.745),
	(6792, 8, 66, 9, 33, 21.74),
	(6793, 8, 67, 9, 33, 22.525),
	(6794, 8, 68, 9, 33, 25.75),
	(6795, 8, 69, 9, 33, 14.125),
	(6796, 8, 70, 9, 33, 21.17),
	(6797, 8, 71, 9, 33, 100.05),
	(6798, 8, 72, 9, 33, 2.05),
	(6799, 8, 73, 9, 33, 3.93),
	(6800, 8, 74, 9, 33, 3.91),
	(6801, 8, 59, 10, 34, 27.52),
	(6802, 8, 60, 10, 34, 32.945),
	(6803, 8, 61, 10, 34, 27.965),
	(6804, 8, 62, 10, 34, 27.41),
	(6805, 8, 63, 10, 34, 24.96),
	(6806, 8, 64, 10, 34, 24.98),
	(6807, 8, 65, 10, 34, 25.71),
	(6808, 8, 66, 10, 34, 21.73),
	(6809, 8, 67, 10, 34, 22.53),
	(6810, 8, 68, 10, 34, 25.71),
	(6811, 8, 69, 10, 34, 14.115),
	(6812, 8, 70, 10, 34, 21.125),
	(6813, 8, 71, 10, 34, 100.06),
	(6814, 8, 72, 10, 34, 2.035),
	(6815, 8, 73, 10, 34, 3.93),
	(6816, 8, 74, 10, 34, 3.9),
	(6817, 8, 59, 11, 35, 27.55),
	(6818, 8, 60, 11, 35, 32.94),
	(6819, 8, 61, 11, 35, 27.95),
	(6820, 8, 62, 11, 35, 27.42),
	(6821, 8, 63, 11, 35, 24.95),
	(6822, 8, 64, 11, 35, 24.96),
	(6823, 8, 65, 11, 35, 25.69),
	(6824, 8, 66, 11, 35, 21.69),
	(6825, 8, 67, 11, 35, 22.52),
	(6826, 8, 68, 11, 35, 25.73),
	(6827, 8, 69, 11, 35, 14.12),
	(6828, 8, 70, 11, 35, 21.14),
	(6829, 8, 71, 11, 35, 100.06),
	(6830, 8, 72, 11, 35, 2.04),
	(6831, 8, 73, 11, 35, 3.93),
	(6832, 8, 74, 11, 35, 3.93),
	(6833, 8, 59, 12, 36, 27.54),
	(6834, 8, 60, 12, 36, 32.96),
	(6835, 8, 61, 12, 36, 27.96),
	(6836, 8, 62, 12, 36, 27.44),
	(6837, 8, 63, 12, 36, 24.93),
	(6838, 8, 64, 12, 36, 24.96),
	(6839, 8, 65, 12, 36, 25.69),
	(6840, 8, 66, 12, 36, 21.69),
	(6841, 8, 67, 12, 36, 22.49),
	(6842, 8, 68, 12, 36, 25.73),
	(6843, 8, 69, 12, 36, 14.16),
	(6844, 8, 70, 12, 36, 21.12),
	(6845, 8, 71, 12, 36, 100.04),
	(6846, 8, 72, 12, 36, 2.05),
	(6847, 8, 73, 12, 36, 3.92),
	(6848, 8, 74, 12, 36, 3.92),
	(6849, 8, 59, 13, 37, 27.54),
	(6850, 8, 60, 13, 37, 32.97),
	(6851, 8, 61, 13, 37, 27.965),
	(6852, 8, 62, 13, 37, 27.405),
	(6853, 8, 63, 13, 37, 24.97),
	(6854, 8, 64, 13, 37, 24.99),
	(6855, 8, 65, 13, 37, 25.695),
	(6856, 8, 66, 13, 37, 21.715),
	(6857, 8, 67, 13, 37, 22.48),
	(6858, 8, 68, 13, 37, 25.75),
	(6859, 8, 69, 13, 37, 14.135),
	(6860, 8, 70, 13, 37, 21.13),
	(6861, 8, 71, 13, 37, 100.075),
	(6862, 8, 72, 13, 37, 2.055),
	(6863, 8, 73, 13, 37, 3.91),
	(6864, 8, 74, 13, 37, 3.91),
	(6865, 8, 59, 14, 38, 27.57),
	(6866, 8, 60, 14, 38, 32.97),
	(6867, 8, 61, 14, 38, 27.97),
	(6868, 8, 62, 14, 38, 27.425),
	(6869, 8, 63, 14, 38, 24.96),
	(6870, 8, 64, 14, 38, 24.97),
	(6871, 8, 65, 14, 38, 25.74),
	(6872, 8, 66, 14, 38, 21.735),
	(6873, 8, 67, 14, 38, 22.525),
	(6874, 8, 68, 14, 38, 25.725),
	(6875, 8, 69, 14, 38, 14.125),
	(6876, 8, 70, 14, 38, 21.13),
	(6877, 8, 71, 14, 38, 100.055),
	(6878, 8, 72, 14, 38, 2.04),
	(6879, 8, 73, 14, 38, 3.93),
	(6880, 8, 74, 14, 38, 3.92),
	(6881, 8, 59, 15, 39, 27.53),
	(6882, 8, 60, 15, 39, 32.97),
	(6883, 8, 61, 15, 39, 27.965),
	(6884, 8, 62, 15, 39, 27.415),
	(6885, 8, 63, 15, 39, 24.97),
	(6886, 8, 64, 15, 39, 24.99),
	(6887, 8, 65, 15, 39, 25.715),
	(6888, 8, 66, 15, 39, 21.71),
	(6889, 8, 67, 15, 39, 22.475),
	(6890, 8, 68, 15, 39, 25.74),
	(6891, 8, 69, 15, 39, 14.125),
	(6892, 8, 70, 15, 39, 21.15),
	(6893, 8, 71, 15, 39, 100.045),
	(6894, 8, 72, 15, 39, 2.045),
	(6895, 8, 73, 15, 39, 3.92),
	(6896, 8, 74, 15, 39, 3.91),
	(6897, 8, 59, 16, 40, 27.54),
	(6898, 8, 60, 16, 40, 32.975),
	(6899, 8, 61, 16, 40, 27.96),
	(6900, 8, 62, 16, 40, 27.42),
	(6901, 8, 63, 16, 40, 24.98),
	(6902, 8, 64, 16, 40, 24.99),
	(6903, 8, 65, 16, 40, 25.715),
	(6904, 8, 66, 16, 40, 21.71),
	(6905, 8, 67, 16, 40, 22.475),
	(6906, 8, 68, 16, 40, 25.74),
	(6907, 8, 69, 16, 40, 14.125),
	(6908, 8, 70, 16, 40, 21.15),
	(6909, 8, 71, 16, 40, 100.045),
	(6910, 8, 72, 16, 40, 2.04),
	(6911, 8, 73, 16, 40, 3.93),
	(6912, 8, 74, 16, 40, 3.92),
	(6913, 8, 59, 17, 41, 27.52),
	(6914, 8, 60, 17, 41, 32.975),
	(6915, 8, 61, 17, 41, 27.975),
	(6916, 8, 62, 17, 41, 27.41),
	(6917, 8, 63, 17, 41, 24.96),
	(6918, 8, 64, 17, 41, 24.98),
	(6919, 8, 65, 17, 41, 25.725),
	(6920, 8, 66, 17, 41, 21.725),
	(6921, 8, 67, 17, 41, 22.53),
	(6922, 8, 68, 17, 41, 25.73),
	(6923, 8, 69, 17, 41, 14.135),
	(6924, 8, 70, 17, 41, 21.15),
	(6925, 8, 71, 17, 41, 100.035),
	(6926, 8, 72, 17, 41, 2.035),
	(6927, 8, 73, 17, 41, 3.92),
	(6928, 8, 74, 17, 41, 3.91),
	(6929, 8, 59, 18, 42, 27.51),
	(6930, 8, 60, 18, 42, 32.955),
	(6931, 8, 61, 18, 42, 27.95),
	(6932, 8, 62, 18, 42, 27.405),
	(6933, 8, 63, 18, 42, 24.95),
	(6934, 8, 64, 18, 42, 24.96),
	(6935, 8, 65, 18, 42, 25.71),
	(6936, 8, 66, 18, 42, 21.73),
	(6937, 8, 67, 18, 42, 22.535),
	(6938, 8, 68, 18, 42, 25.705),
	(6939, 8, 69, 18, 42, 14.105),
	(6940, 8, 70, 18, 42, 21.14),
	(6941, 8, 71, 18, 42, 100.075),
	(6942, 8, 72, 18, 42, 2.03),
	(6943, 8, 73, 18, 42, 3.91),
	(6944, 8, 74, 18, 42, 3.92),
	(6945, 8, 59, 19, 43, 27.53),
	(6946, 8, 60, 19, 43, 32.94),
	(6947, 8, 61, 19, 43, 27.945),
	(6948, 8, 62, 19, 43, 27.42),
	(6949, 8, 63, 19, 43, 24.93),
	(6950, 8, 64, 19, 43, 24.95),
	(6951, 8, 65, 19, 43, 25.695),
	(6952, 8, 66, 19, 43, 21.71),
	(6953, 8, 67, 19, 43, 22.52),
	(6954, 8, 68, 19, 43, 25.695),
	(6955, 8, 69, 19, 43, 14.14),
	(6956, 8, 70, 19, 43, 21.155),
	(6957, 8, 71, 19, 43, 100.055),
	(6958, 8, 72, 19, 43, 2.035),
	(6959, 8, 73, 19, 43, 3.9),
	(6960, 8, 74, 19, 43, 3.89),
	(6961, 8, 59, 20, 44, 27.52),
	(6962, 8, 60, 20, 44, 32.945),
	(6963, 8, 61, 20, 44, 27.95),
	(6964, 8, 62, 20, 44, 27.44),
	(6965, 8, 63, 20, 44, 24.95),
	(6966, 8, 64, 20, 44, 24.98),
	(6967, 8, 65, 20, 44, 25.72),
	(6968, 8, 66, 20, 44, 21.725),
	(6969, 8, 67, 20, 44, 22.51),
	(6970, 8, 68, 20, 44, 25.71),
	(6971, 8, 69, 20, 44, 14.13),
	(6972, 8, 70, 20, 44, 21.17),
	(6973, 8, 71, 20, 44, 100.04),
	(6974, 8, 72, 20, 44, 2.03),
	(6975, 8, 73, 20, 44, 3.93),
	(6976, 8, 74, 20, 44, 3.91),
	(6977, 8, 59, 21, 45, 27.54),
	(6978, 8, 60, 21, 45, 32.965),
	(6979, 8, 61, 21, 45, 27.955),
	(6980, 8, 62, 21, 45, 27.41),
	(6981, 8, 63, 21, 45, 24.97),
	(6982, 8, 64, 21, 45, 24.99),
	(6983, 8, 65, 21, 45, 25.745),
	(6984, 8, 66, 21, 45, 21.74),
	(6985, 8, 67, 21, 45, 22.525),
	(6986, 8, 68, 21, 45, 25.75),
	(6987, 8, 69, 21, 45, 14.125),
	(6988, 8, 70, 21, 45, 21.17),
	(6989, 8, 71, 21, 45, 100.05),
	(6990, 8, 72, 21, 45, 2.045),
	(6991, 8, 73, 21, 45, 3.92),
	(6992, 8, 74, 21, 45, 3.93),
	(6993, 8, 59, 22, 46, 27.52),
	(6994, 8, 60, 22, 46, 32.965),
	(6995, 8, 61, 22, 46, 27.96),
	(6996, 8, 62, 22, 46, 27.405),
	(6997, 8, 63, 22, 46, 24.96),
	(6998, 8, 64, 22, 46, 24.99),
	(6999, 8, 65, 22, 46, 25.71),
	(7000, 8, 66, 22, 46, 21.74),
	(7001, 8, 67, 22, 46, 22.525),
	(7002, 8, 68, 22, 46, 25.75),
	(7003, 8, 69, 22, 46, 14.125),
	(7004, 8, 70, 22, 46, 21.17),
	(7005, 8, 71, 22, 46, 100.05),
	(7006, 8, 72, 22, 46, 2.045),
	(7007, 8, 73, 22, 46, 3.93),
	(7008, 8, 74, 22, 46, 3.91),
	(7009, 8, 59, 23, 47, 27.49),
	(7010, 8, 60, 23, 47, 32.97),
	(7011, 8, 61, 23, 47, 27.95),
	(7012, 8, 62, 23, 47, 27.43),
	(7013, 8, 63, 23, 47, 24.94),
	(7014, 8, 64, 23, 47, 24.97),
	(7015, 8, 65, 23, 47, 25.675),
	(7016, 8, 66, 23, 47, 21.73),
	(7017, 8, 67, 23, 47, 22.485),
	(7018, 8, 68, 23, 47, 25.74),
	(7019, 8, 69, 23, 47, 14.135),
	(7020, 8, 70, 23, 47, 21.15),
	(7021, 8, 71, 23, 47, 100.04),
	(7022, 8, 72, 23, 47, 2.035),
	(7023, 8, 73, 23, 47, 3.91),
	(7024, 8, 74, 23, 47, 3.89),
	(7025, 8, 59, 24, 48, 27.54),
	(7026, 8, 60, 24, 48, 32.98),
	(7027, 8, 61, 24, 48, 27.95),
	(7028, 8, 62, 24, 48, 27.405),
	(7029, 8, 63, 24, 48, 24.95),
	(7030, 8, 64, 24, 48, 24.98),
	(7031, 8, 65, 24, 48, 25.735),
	(7032, 8, 66, 24, 48, 21.705),
	(7033, 8, 67, 24, 48, 22.51),
	(7034, 8, 68, 24, 48, 25.71),
	(7035, 8, 69, 24, 48, 14.13),
	(7036, 8, 70, 24, 48, 21.17),
	(7037, 8, 71, 24, 48, 100.04),
	(7038, 8, 72, 24, 48, 2.03),
	(7039, 8, 73, 24, 48, 3.94),
	(7040, 8, 74, 24, 48, 3.91),
	(7041, 5, 94, 1, 1, 27.52),
	(7042, 5, 95, 1, 1, 33.965),
	(7043, 5, 96, 1, 1, 30.145),
	(7044, 5, 97, 1, 1, 29.965),
	(7045, 5, 98, 1, 1, 27.97),
	(7046, 5, 99, 1, 1, 27.99),
	(7047, 5, 100, 1, 1, 25.29),
	(7048, 5, 101, 1, 1, 27.975),
	(7049, 5, 102, 1, 1, 27.975),
	(7050, 5, 103, 1, 1, 25.69),
	(7051, 5, 104, 1, 1, 13.226),
	(7052, 5, 105, 1, 1, 18.53),
	(7053, 5, 106, 1, 1, 119.055),
	(7054, 5, 107, 1, 1, 1.53),
	(7055, 5, 108, 1, 1, 2.53),
	(7056, 5, 109, 1, 1, 2.545),
	(7057, 5, 94, 2, 2, 27.56),
	(7058, 5, 95, 2, 2, 33.925),
	(7059, 5, 96, 2, 2, 30.13),
	(7060, 5, 97, 2, 2, 29.97),
	(7061, 5, 98, 2, 2, 27.97),
	(7062, 5, 99, 2, 2, 27.98),
	(7063, 5, 100, 2, 2, 25.31),
	(7064, 5, 101, 2, 2, 27.985),
	(7065, 5, 102, 2, 2, 27.99),
	(7066, 5, 103, 2, 2, 25.675),
	(7067, 5, 104, 2, 2, 13.24),
	(7068, 5, 105, 2, 2, 18.557),
	(7069, 5, 106, 2, 2, 119.035),
	(7070, 5, 107, 2, 2, 1.525),
	(7071, 5, 108, 2, 2, 2.535),
	(7072, 5, 109, 2, 2, 2.525),
	(7073, 5, 94, 3, 3, 27.54),
	(7074, 5, 95, 3, 3, 33.94),
	(7075, 5, 96, 3, 3, 30.14),
	(7076, 5, 97, 3, 3, 29.98),
	(7077, 5, 98, 3, 3, 27.97),
	(7078, 5, 99, 3, 3, 27.99),
	(7079, 5, 100, 3, 3, 25.285),
	(7080, 5, 101, 3, 3, 27.965),
	(7081, 5, 102, 3, 3, 27.975),
	(7082, 5, 103, 3, 3, 25.69),
	(7083, 5, 104, 3, 3, 13.235),
	(7084, 5, 105, 3, 3, 18.53),
	(7085, 5, 106, 3, 3, 119.06),
	(7086, 5, 107, 3, 3, 1.53),
	(7087, 5, 108, 3, 3, 2.545),
	(7088, 5, 109, 3, 3, 2.53),
	(7089, 5, 94, 4, 4, 27.52),
	(7090, 5, 95, 4, 4, 33.94),
	(7091, 5, 96, 4, 4, 30.125),
	(7092, 5, 97, 4, 4, 29.97),
	(7093, 5, 98, 4, 4, 27.97),
	(7094, 5, 99, 4, 4, 27.98),
	(7095, 5, 100, 4, 4, 25.31),
	(7096, 5, 101, 4, 4, 27.975),
	(7097, 5, 102, 4, 4, 27.98),
	(7098, 5, 103, 4, 4, 25.675),
	(7099, 5, 104, 4, 4, 13.255),
	(7100, 5, 105, 4, 4, 18.57),
	(7101, 5, 106, 4, 4, 119.065),
	(7102, 5, 107, 4, 4, 1.52),
	(7103, 5, 108, 4, 4, 2.53),
	(7104, 5, 109, 4, 4, 2.535),
	(7105, 5, 94, 5, 5, 27.51),
	(7106, 5, 95, 5, 5, 33.955),
	(7107, 5, 96, 5, 5, 30.13),
	(7108, 5, 97, 5, 5, 29.97),
	(7109, 5, 98, 5, 5, 27.97),
	(7110, 5, 99, 5, 5, 27.99),
	(7111, 5, 100, 5, 5, 25.315),
	(7112, 5, 101, 5, 5, 27.975),
	(7113, 5, 102, 5, 5, 27.975),
	(7114, 5, 103, 5, 5, 25.69),
	(7115, 5, 104, 5, 5, 13.24),
	(7116, 5, 105, 5, 5, 18.55),
	(7117, 5, 106, 5, 5, 119.055),
	(7118, 5, 107, 5, 5, 1.53),
	(7119, 5, 108, 5, 5, 2.525),
	(7120, 5, 109, 5, 5, 2.53),
	(7121, 5, 94, 6, 6, 27.54),
	(7122, 5, 95, 6, 6, 33.94),
	(7123, 5, 96, 6, 6, 30.14),
	(7124, 5, 97, 6, 6, 29.975),
	(7125, 5, 98, 6, 6, 27.98),
	(7126, 5, 99, 6, 6, 28),
	(7127, 5, 100, 6, 6, 25.31),
	(7128, 5, 101, 6, 6, 27.99),
	(7129, 5, 102, 6, 6, 27.98),
	(7130, 5, 103, 6, 6, 25.71),
	(7131, 5, 104, 6, 6, 13.225),
	(7132, 5, 105, 6, 6, 18.52),
	(7133, 5, 106, 6, 6, 119.055),
	(7134, 5, 107, 6, 6, 1.525),
	(7135, 5, 108, 6, 6, 2.53),
	(7136, 5, 109, 6, 6, 2.535),
	(7137, 5, 94, 7, 7, 27.51),
	(7138, 5, 95, 7, 7, 33.93),
	(7139, 5, 96, 7, 7, 30.121),
	(7140, 5, 97, 7, 7, 29.96),
	(7141, 5, 98, 7, 7, 27.96),
	(7142, 5, 99, 7, 7, 27.98),
	(7143, 5, 100, 7, 7, 25.29),
	(7144, 5, 101, 7, 7, 27.97),
	(7145, 5, 102, 7, 7, 27.99),
	(7146, 5, 103, 7, 7, 25.705),
	(7147, 5, 104, 7, 7, 13.235),
	(7148, 5, 105, 7, 7, 18.56),
	(7149, 5, 106, 7, 7, 119.025),
	(7150, 5, 107, 7, 7, 1.53),
	(7151, 5, 108, 7, 7, 2.525),
	(7152, 5, 109, 7, 7, 2.53),
	(7153, 5, 94, 8, 8, 27.54),
	(7154, 5, 95, 8, 8, 33.94),
	(7155, 5, 96, 8, 8, 30.14),
	(7156, 5, 97, 8, 8, 29.97),
	(7157, 5, 98, 8, 8, 27.98),
	(7158, 5, 99, 8, 8, 27.99),
	(7159, 5, 100, 8, 8, 25.29),
	(7160, 5, 101, 8, 8, 27.99),
	(7161, 5, 102, 8, 8, 27.97),
	(7162, 5, 103, 8, 8, 25.695),
	(7163, 5, 104, 8, 8, 13.25),
	(7164, 5, 105, 8, 8, 18.515),
	(7165, 5, 106, 8, 8, 119.05),
	(7166, 5, 107, 8, 8, 1.525),
	(7167, 5, 108, 8, 8, 2.53),
	(7168, 5, 109, 8, 8, 2.535),
	(7169, 5, 94, 9, 9, 27.51),
	(7170, 5, 95, 9, 9, 33.935),
	(7171, 5, 96, 9, 9, 30.125),
	(7172, 5, 97, 9, 9, 29.98),
	(7173, 5, 98, 9, 9, 27.97),
	(7174, 5, 99, 9, 9, 27.98),
	(7175, 5, 100, 9, 9, 25.305),
	(7176, 5, 101, 9, 9, 27.97),
	(7177, 5, 102, 9, 9, 27.98),
	(7178, 5, 103, 9, 9, 25.685),
	(7179, 5, 104, 9, 9, 13.23),
	(7180, 5, 105, 9, 9, 18.525),
	(7181, 5, 106, 9, 9, 119.055),
	(7182, 5, 107, 9, 9, 1.53),
	(7183, 5, 108, 9, 9, 2.525),
	(7184, 5, 109, 9, 9, 2.53),
	(7185, 5, 94, 10, 10, 27.53),
	(7186, 5, 95, 10, 10, 33.935),
	(7187, 5, 96, 10, 10, 30.16),
	(7188, 5, 97, 10, 10, 29.99),
	(7189, 5, 98, 10, 10, 27.98),
	(7190, 5, 99, 10, 10, 28),
	(7191, 5, 100, 10, 10, 25.31),
	(7192, 5, 101, 10, 10, 27.99),
	(7193, 5, 102, 10, 10, 28.005),
	(7194, 5, 103, 10, 10, 25.705),
	(7195, 5, 104, 10, 10, 13.255),
	(7196, 5, 105, 10, 10, 18.56),
	(7197, 5, 106, 10, 10, 119.025),
	(7198, 5, 107, 10, 10, 1.525),
	(7199, 5, 108, 10, 10, 2.52),
	(7200, 5, 109, 10, 10, 2.535),
	(7201, 5, 94, 11, 11, 27.53),
	(7202, 5, 95, 11, 11, 33.95),
	(7203, 5, 96, 11, 11, 30.135),
	(7204, 5, 97, 11, 11, 29.985),
	(7205, 5, 98, 11, 11, 27.97),
	(7206, 5, 99, 11, 11, 28),
	(7207, 5, 100, 11, 11, 25.285),
	(7208, 5, 101, 11, 11, 28),
	(7209, 5, 102, 11, 11, 27.99),
	(7210, 5, 103, 11, 11, 25.69),
	(7211, 5, 104, 11, 11, 13.235),
	(7212, 5, 105, 11, 11, 18.56),
	(7213, 5, 106, 11, 11, 119.06),
	(7214, 5, 107, 11, 11, 1.53),
	(7215, 5, 108, 11, 11, 2.525),
	(7216, 5, 109, 11, 11, 2.525),
	(7217, 5, 94, 12, 12, 27.52),
	(7218, 5, 95, 12, 12, 33.975),
	(7219, 5, 96, 12, 12, 30.16),
	(7220, 5, 97, 12, 12, 29.975),
	(7221, 5, 98, 12, 12, 27.98),
	(7222, 5, 99, 12, 12, 27.99),
	(7223, 5, 100, 12, 12, 25.29),
	(7224, 5, 101, 12, 12, 27.985),
	(7225, 5, 102, 12, 12, 27.995),
	(7226, 5, 103, 12, 12, 25.675),
	(7227, 5, 104, 12, 12, 13.245),
	(7228, 5, 105, 12, 12, 18.525),
	(7229, 5, 106, 12, 12, 119.075),
	(7230, 5, 107, 12, 12, 1.535),
	(7231, 5, 108, 12, 12, 2.52),
	(7232, 5, 109, 12, 12, 2.53),
	(7233, 5, 94, 13, 13, 27.52),
	(7234, 5, 95, 13, 13, 33.945),
	(7235, 5, 96, 13, 13, 30.135),
	(7236, 5, 97, 13, 13, 30),
	(7237, 5, 98, 13, 13, 27.96),
	(7238, 5, 99, 13, 13, 27.98),
	(7239, 5, 100, 13, 13, 25.275),
	(7240, 5, 101, 13, 13, 27.99),
	(7241, 5, 102, 13, 13, 27.985),
	(7242, 5, 103, 13, 13, 25.675),
	(7243, 5, 104, 13, 13, 13.24),
	(7244, 5, 105, 13, 13, 18.555),
	(7245, 5, 106, 13, 13, 119.045),
	(7246, 5, 107, 13, 13, 1.53),
	(7247, 5, 108, 13, 13, 2.53),
	(7248, 5, 109, 13, 13, 2.535),
	(7249, 5, 94, 14, 14, 27.56),
	(7250, 5, 95, 14, 14, 33.975),
	(7251, 5, 96, 14, 14, 30.145),
	(7252, 5, 97, 14, 14, 29.985),
	(7253, 5, 98, 14, 14, 27.97),
	(7254, 5, 99, 14, 14, 27.98),
	(7255, 5, 100, 14, 14, 25.285),
	(7256, 5, 101, 14, 14, 27.985),
	(7257, 5, 102, 14, 14, 27.99),
	(7258, 5, 103, 14, 14, 25.685),
	(7259, 5, 104, 14, 14, 13.235),
	(7260, 5, 105, 14, 14, 18.555),
	(7261, 5, 106, 14, 14, 119.085),
	(7262, 5, 107, 14, 14, 1.525),
	(7263, 5, 108, 14, 14, 2.525),
	(7264, 5, 109, 14, 14, 2.53),
	(7265, 5, 94, 15, 15, 27.5),
	(7266, 5, 95, 15, 15, 33.955),
	(7267, 5, 96, 15, 15, 30.13),
	(7268, 5, 97, 15, 15, 29.975),
	(7269, 5, 98, 15, 15, 27.96),
	(7270, 5, 99, 15, 15, 27.97),
	(7271, 5, 100, 15, 15, 25.265),
	(7272, 5, 101, 15, 15, 27.965),
	(7273, 5, 102, 15, 15, 27.97),
	(7274, 5, 103, 15, 15, 25.665),
	(7275, 5, 104, 15, 15, 13.245),
	(7276, 5, 105, 15, 15, 18.525),
	(7277, 5, 106, 15, 15, 119.065),
	(7278, 5, 107, 15, 15, 1.53),
	(7279, 5, 108, 15, 15, 2.545),
	(7280, 5, 109, 15, 15, 2.54),
	(7281, 5, 94, 16, 16, 27.5),
	(7282, 5, 95, 16, 16, 33.925),
	(7283, 5, 96, 16, 16, 30.14),
	(7284, 5, 97, 16, 16, 29.98),
	(7285, 5, 98, 16, 16, 27.96),
	(7286, 5, 99, 16, 16, 27.98),
	(7287, 5, 100, 16, 16, 25.29),
	(7288, 5, 101, 16, 16, 27.975),
	(7289, 5, 102, 16, 16, 27.99),
	(7290, 5, 103, 16, 16, 25.705),
	(7291, 5, 104, 16, 16, 13.265),
	(7292, 5, 105, 16, 16, 18.515),
	(7293, 5, 106, 16, 16, 119.055),
	(7294, 5, 107, 16, 16, 1.525),
	(7295, 5, 108, 16, 16, 2.53),
	(7296, 5, 109, 16, 16, 2.53),
	(7297, 5, 94, 17, 17, 27.53),
	(7298, 5, 95, 17, 17, 33.94),
	(7299, 5, 96, 17, 17, 30.155),
	(7300, 5, 97, 17, 17, 29.97),
	(7301, 5, 98, 17, 17, 27.96),
	(7302, 5, 99, 17, 17, 27.98),
	(7303, 5, 100, 17, 17, 25.27),
	(7304, 5, 101, 17, 17, 28.01),
	(7305, 5, 102, 17, 17, 27.975),
	(7306, 5, 103, 17, 17, 25.73),
	(7307, 5, 104, 17, 17, 13.24),
	(7308, 5, 105, 17, 17, 18.545),
	(7309, 5, 106, 17, 17, 119.04),
	(7310, 5, 107, 17, 17, 1.53),
	(7311, 5, 108, 17, 17, 2.535),
	(7312, 5, 109, 17, 17, 2.545),
	(7313, 5, 94, 18, 18, 27.52),
	(7314, 5, 95, 18, 18, 33.94),
	(7315, 5, 96, 18, 18, 30.13),
	(7316, 5, 97, 18, 18, 29.97),
	(7317, 5, 98, 18, 18, 27.98),
	(7318, 5, 99, 18, 18, 28),
	(7319, 5, 100, 18, 18, 25.29),
	(7320, 5, 101, 18, 18, 27.99),
	(7321, 5, 102, 18, 18, 27.985),
	(7322, 5, 103, 18, 18, 25.72),
	(7323, 5, 104, 18, 18, 13.2165),
	(7324, 5, 105, 18, 18, 18.55),
	(7325, 5, 106, 18, 18, 119.04),
	(7326, 5, 107, 18, 18, 1.53),
	(7327, 5, 108, 18, 18, 2.53),
	(7328, 5, 109, 18, 18, 2.525),
	(7329, 5, 94, 19, 19, 27.52),
	(7330, 5, 95, 19, 19, 33.955),
	(7331, 5, 96, 19, 19, 30.125),
	(7332, 5, 97, 19, 19, 29.99),
	(7333, 5, 98, 19, 19, 27.98),
	(7334, 5, 99, 19, 19, 27.99),
	(7335, 5, 100, 19, 19, 25.285),
	(7336, 5, 101, 19, 19, 27.98),
	(7337, 5, 102, 19, 19, 27.995),
	(7338, 5, 103, 19, 19, 25.71),
	(7339, 5, 104, 19, 19, 13.24),
	(7340, 5, 105, 19, 19, 18.53),
	(7341, 5, 106, 19, 19, 119.065),
	(7342, 5, 107, 19, 19, 1.53),
	(7343, 5, 108, 19, 19, 2.535),
	(7344, 5, 109, 19, 19, 2.53),
	(7345, 5, 94, 20, 20, 27.5),
	(7346, 5, 95, 20, 20, 33.925),
	(7347, 5, 96, 20, 20, 30.14),
	(7348, 5, 97, 20, 20, 29.98),
	(7349, 5, 98, 20, 20, 27.98),
	(7350, 5, 99, 20, 20, 28),
	(7351, 5, 100, 20, 20, 25.28),
	(7352, 5, 101, 20, 20, 27.97),
	(7353, 5, 102, 20, 20, 27.99),
	(7354, 5, 103, 20, 20, 25.71),
	(7355, 5, 104, 20, 20, 13.22),
	(7356, 5, 105, 20, 20, 18.55),
	(7357, 5, 106, 20, 20, 119.055),
	(7358, 5, 107, 20, 20, 1.525),
	(7359, 5, 108, 20, 20, 2.525),
	(7360, 5, 109, 20, 20, 2.52),
	(7361, 5, 94, 21, 21, 27.52),
	(7362, 5, 95, 21, 21, 33.915),
	(7363, 5, 96, 21, 21, 30.13),
	(7364, 5, 97, 21, 21, 29.975),
	(7365, 5, 98, 21, 21, 27.98),
	(7366, 5, 99, 21, 21, 28),
	(7367, 5, 100, 21, 21, 25.285),
	(7368, 5, 101, 21, 21, 27.975),
	(7369, 5, 102, 21, 21, 27.98),
	(7370, 5, 103, 21, 21, 25.72),
	(7371, 5, 104, 21, 21, 13.245),
	(7372, 5, 105, 21, 21, 18.525),
	(7373, 5, 106, 21, 21, 119.015),
	(7374, 5, 107, 21, 21, 1.53),
	(7375, 5, 108, 21, 21, 2.54),
	(7376, 5, 109, 21, 21, 2.53),
	(7377, 5, 94, 22, 22, 27.53),
	(7378, 5, 95, 22, 22, 33.93),
	(7379, 5, 96, 22, 22, 30.12),
	(7380, 5, 97, 22, 22, 29.97),
	(7381, 5, 98, 22, 22, 27.96),
	(7382, 5, 99, 22, 22, 27.98),
	(7383, 5, 100, 22, 22, 25.31),
	(7384, 5, 101, 22, 22, 27.995),
	(7385, 5, 102, 22, 22, 27.975),
	(7386, 5, 103, 22, 22, 25.685),
	(7387, 5, 104, 22, 22, 13.24),
	(7388, 5, 105, 22, 22, 18.515),
	(7389, 5, 106, 22, 22, 119.05),
	(7390, 5, 107, 22, 22, 1.525),
	(7391, 5, 108, 22, 22, 2.52),
	(7392, 5, 109, 22, 22, 2.525),
	(7393, 5, 94, 23, 23, 27.51),
	(7394, 5, 95, 23, 23, 33.94),
	(7395, 5, 96, 23, 23, 30.115),
	(7396, 5, 97, 23, 23, 29.97),
	(7397, 5, 98, 23, 23, 27.98),
	(7398, 5, 99, 23, 23, 27.99),
	(7399, 5, 100, 23, 23, 25.29),
	(7400, 5, 101, 23, 23, 27.98),
	(7401, 5, 102, 23, 23, 27.985),
	(7402, 5, 103, 23, 23, 25.675),
	(7403, 5, 104, 23, 23, 13.245),
	(7404, 5, 105, 23, 23, 18.52),
	(7405, 5, 106, 23, 23, 119.025),
	(7406, 5, 107, 23, 23, 1.53),
	(7407, 5, 108, 23, 23, 2.53),
	(7408, 5, 109, 23, 23, 2.53),
	(7409, 5, 94, 24, 24, 27.52),
	(7410, 5, 95, 24, 24, 33.925),
	(7411, 5, 96, 24, 24, 30.125),
	(7412, 5, 97, 24, 24, 29.98),
	(7413, 5, 98, 24, 24, 27.96),
	(7414, 5, 99, 24, 24, 27.98),
	(7415, 5, 100, 24, 24, 25.31),
	(7416, 5, 101, 24, 24, 27.985),
	(7417, 5, 102, 24, 24, 27.984),
	(7418, 5, 103, 24, 24, 25.71),
	(7419, 5, 104, 24, 24, 13.225),
	(7420, 5, 105, 24, 24, 18.53),
	(7421, 5, 106, 24, 24, 119.06),
	(7422, 5, 107, 24, 24, 1.535),
	(7423, 5, 108, 24, 24, 2.52),
	(7424, 5, 109, 24, 24, 2.525);
/*!40000 ALTER TABLE `dimensi` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.downtime
CREATE TABLE IF NOT EXISTS `downtime` (
  `DT_ID` int(11) NOT NULL AUTO_INCREMENT,
  `PlanID` int(11) NOT NULL,
  `Shift` int(11) NOT NULL,
  `Jenis` int(11) NOT NULL,
  `Jam` time NOT NULL,
  `Reason` varchar(100) NOT NULL,
  `Hour` float NOT NULL,
  `Eksekusi` varchar(100) NOT NULL,
  PRIMARY KEY (`DT_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.downtime: ~3 rows (lebih kurang)
/*!40000 ALTER TABLE `downtime` DISABLE KEYS */;
REPLACE INTO `downtime` (`DT_ID`, `PlanID`, `Shift`, `Jenis`, `Jam`, `Reason`, `Hour`, `Eksekusi`) VALUES
	(1, 207, 1, 3, '09:50:00', 'Listrik Tip', 0.14, 'Menunggu'),
	(2, 205, 1, 1, '07:30:00', 'Piovan', 0.25, 'Menunggu'),
	(3, 204, 1, 3, '08:44:00', 'piovan', 0.37, 'Berdoa');
/*!40000 ALTER TABLE `downtime` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.dt_patrol
CREATE TABLE IF NOT EXISTS `dt_patrol` (
  `DT_PatrolID` int(11) NOT NULL AUTO_INCREMENT,
  `PlanID` int(11) NOT NULL,
  `Shift` int(11) NOT NULL,
  `Jam` time NOT NULL,
  `Hour` float NOT NULL,
  `Actual` int(10) DEFAULT NULL,
  PRIMARY KEY (`DT_PatrolID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.dt_patrol: ~0 rows (lebih kurang)
/*!40000 ALTER TABLE `dt_patrol` DISABLE KEYS */;
/*!40000 ALTER TABLE `dt_patrol` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.ekspedisi
CREATE TABLE IF NOT EXISTS `ekspedisi` (
  `EkspedisiID` int(11) NOT NULL AUTO_INCREMENT,
  `Ekspedisi` tinytext NOT NULL,
  `Alamat` varchar(255) NOT NULL,
  `PIC` tinytext NOT NULL,
  `HP` varchar(20) NOT NULL,
  PRIMARY KEY (`EkspedisiID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.ekspedisi: ~6 rows (lebih kurang)
/*!40000 ALTER TABLE `ekspedisi` DISABLE KEYS */;
REPLACE INTO `ekspedisi` (`EkspedisiID`, `Ekspedisi`, `Alamat`, `PIC`, `HP`) VALUES
	(1, 'USAHA BERSAMA', 'Kenjeran\r\nSurabaya', 'Jimmy S', '0811379376'),
	(2, 'ANN JAYA', 'Krian\r\nSidoarjo', 'Khoiri', '081233311147'),
	(3, 'MULTINDO', 'Krian\r\nSidoarjo\r\n', 'Eddy', '082231439149'),
	(4, 'CONTAINER', 'EXTERNAL', '-', '-'),
	(5, 'Ambil Sendiri', '-', '-', '-'),
	(6, 'RESTU MULIA', '-', '-', '-');
/*!40000 ALTER TABLE `ekspedisi` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.ho_tbl
CREATE TABLE IF NOT EXISTS `ho_tbl` (
  `HO_ID` int(11) NOT NULL AUTO_INCREMENT,
  `HO_Customer` tinytext,
  `No_HO` tinytext,
  `Alamat_HO` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`HO_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.ho_tbl: ~12 rows (lebih kurang)
/*!40000 ALTER TABLE `ho_tbl` DISABLE KEYS */;
REPLACE INTO `ho_tbl` (`HO_ID`, `HO_Customer`, `No_HO`, `Alamat_HO`) VALUES
	(1, 'PT. TIRTA INVESTAMA', '1050360', 'GEDUNG RDTX PLACE LT 5-9 JL PROF<br>\r\nDR.SATRIO KAV 3, KARET KUNINGAN,<br>\r\nSETIABUDI, KOTA ADM. JAKARTA SELATAN<br>\r\nDKI JAKARTA 12940<br>\r\nIndonesia'),
	(2, 'PT. KIEWELL PLASTIC PACKAGING', '1186047', 'Jl. Cempaka RT 01 / RW 03, Grogol<br>\r\nSukoharjo, Jawa Tengah<br>\r\nIndonesia<br>\r\nTel: 0'),
	(3, 'PT. BANDANGAN TIRTA AGUNG', '1185987', 'Jl, Ahmad Yani KM.9 Banjarmasin<br>\r\nKalimantan Banjar<br>\r\nIndonesia<br>\r\nTel : 0511-4281570'),
	(4, 'PT. SINAR SOSRO', '1186597', 'Jl. Raya Sultan Agung KM 28<br>\r\nMedan Satria<br>\r\nJawa Barat 17132<br>\r\nIndonesia<br>\r\nTel : 0218840855'),
	(5, 'PT. SARIGUNA PRIMATIRTA, Tbk - PANDAAN', '1190099', 'JL. SURABAYA-MALANG KM 52,<br>\r\nNGADIMULYO, SUKOREJO, PASURUAN<br>\r\nPANDAAN<br>\r\nIndonesia'),
	(6, 'PT. AKASHA WIRA INTERNATONAL TBK.', '1186596', 'Gedung Perkantoran Hijau Arkadia Tower C Lt.15<br>\r\nJl. TB. Simatupang Kav. 88, Kel Kebagusan<br>\r\nPasar Minggu 12520<br>\r\nIndonesia'),
	(7, 'PT. MULTI PLASINDO PERKASA BOYOLALI', '1186072', 'BULUREJO RT. 004 / RW. 003<br>\r\nRANDUSARI TERAS KAB. BOYOLALI<br>\r\nJAWA TENGAH<br>\r\nIndonesia<br>\r\nTel : 0'),
	(8, 'CV. HOKINDO JAYA ABADI', '1186032', 'Dsn. Tanjung Indah RT/RW : 002/000<br>\r\nDesa Tanjung Niaga Kec. Nanga Pinoh<br>'),
	(9, 'PT. BROMO TIRTA LESTARI', '1185991', 'JL. RAYA BANJARSARI KM.7  SUMBER\r\nASIH KB. PROBOLINGG0\r\nIndonesia\r\nTel : 0335-432166'),
	(10, 'PT. CS2 POLA SEHAT', '1186621', 'Jl. Yos Sudarso, No 143\r\nKebon Besar, Batu Ceper\r\nTangerang\r\nIndonesia'),
	(11, 'PT. AIR GANGGA DEWATA ALAMI', '1189109', 'JL. PERMATA PERING\r\nDS. PERING, BLABATUH, GIANYAR\r\nBALI\r\nIndonesia'),
	(12, 'DALIMANG', '1191813', 'GRIYA SANGIANG MAS BLOK KA 3 NO 7\r\nRT 004 RW 011 GEBANG RAYA. PERIUK\r\nKOTA TANGERANG\r\nIndonesia');
/*!40000 ALTER TABLE `ho_tbl` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.incoming
CREATE TABLE IF NOT EXISTS `incoming` (
  `IncomingID` int(25) NOT NULL AUTO_INCREMENT,
  `Date_Inc` date NOT NULL,
  `MaterialID` int(25) NOT NULL,
  `Supplier` varchar(30) NOT NULL,
  `Qty_Inc` int(10) NOT NULL,
  `No_SJ` varchar(35) NOT NULL,
  `Desc` varchar(40) NOT NULL,
  PRIMARY KEY (`IncomingID`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.incoming: ~63 rows (lebih kurang)
/*!40000 ALTER TABLE `incoming` DISABLE KEYS */;
REPLACE INTO `incoming` (`IncomingID`, `Date_Inc`, `MaterialID`, `Supplier`, `Qty_Inc`, `No_SJ`, `Desc`) VALUES
	(4, '2022-11-19', 16, 'PT. INDO RAMA SYNTHETICS TBK', 23000, '412204169', '20JB @1150KG'),
	(5, '2022-10-31', 16, 'PT. INDO RAMA SYNTHETICS TBK', 12650, '412203940', '11JB @1150KG'),
	(6, '2022-11-19', 16, 'PT. INDO RAMA SYNTHETICS TBK', 23000, '412204171', '20JB @1150KG'),
	(8, '2022-10-24', 22, 'PT. PETNESIA RESINDO', 16500, 'S2210160-2', '15JB @1100KG'),
	(9, '2022-10-24', 22, 'PT. PETNESIA RESINDO', 17600, 'S2210160-3', '16JB @1100KG'),
	(10, '2022-10-25', 22, 'PT. PETNESIA RESINDO', 16800, 'S2210166-1', '16JB @1050KG'),
	(11, '2022-10-25', 22, 'PT. PETNESIA RESINDO', 16800, 'S2210166-2', '16JB @1050KG'),
	(12, '2022-10-25', 22, 'PT. PETNESIA RESINDO', 16800, 'S2210167-1', '16JB @1050KG'),
	(13, '2022-10-25', 22, 'PT. PETNESIA RESINDO', 16800, 'S2210167-2', '16JB @1050KG'),
	(14, '2022-11-21', 1, 'ITA TANGERANG', 90288, '00401', 'BATCH 2211 5JB @15048PCS'),
	(15, '2022-11-26', 1, 'ITA TANGERANG', 481536, '00404', 'BATCH 2211 32JB@15048PCS '),
	(16, '2022-11-28', 1, 'ITA TANGERANG', 481536, '00410', 'BATCH 2211 32JB@15048PCS'),
	(17, '2022-12-02', 1, 'ITA TANGERANG', 481536, '00413', 'BATCH 2212 32JB@15048PCS'),
	(18, '2022-11-26', 13, 'ITA TANGERANG', 40, '127665', '2PAIL @20KG'),
	(19, '2022-12-01', 17, 'PT. TIRTA INVESTAMA (KLATEN)', 14300, '5048593353', '13JB @1100KG'),
	(20, '2022-12-02', 17, 'PT. TIRTA INVESTAMA (KLATEN)', 17600, '5048605699', '16JB @1100KG'),
	(21, '2022-12-02', 17, 'PT. TIRTA INVESTAMA (KLATEN)', 17600, '5048601384', '16JB @1100KG'),
	(22, '2022-11-30', 17, 'PT. TIRTA INVESTAMA (KLATEN)', 1100, '5048578125', '1JB @1100KG'),
	(23, '2022-12-05', 18, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048652607', '16JB @1100KG'),
	(24, '2022-12-06', 23, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048669444', '16JB @1100KG'),
	(26, '2022-12-03', 17, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048619227', '16JB @1100KG'),
	(27, '2022-12-05', 17, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048651958', '16JB @1100KG'),
	(28, '2022-11-02', 2, 'ITA TANGERANG', 90288, '0381', '6JB @15048PCS'),
	(29, '2022-12-10', 1, 'ITA TANGERANG', 481536, '00416', 'BATCH 2211 32JB@15048PCS'),
	(30, '2022-12-12', 13, 'ITA TANGERANG', 40, '', '2 PAIL @20KG'),
	(31, '2022-12-13', 17, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048784436', '16JB @1100KG'),
	(32, '2022-12-02', 17, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048606879', '16JB @1100KG'),
	(33, '2022-12-14', 17, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048800767', '16JB @1100KG'),
	(34, '2022-12-14', 17, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048808482', '16JB @1100KG'),
	(35, '2022-12-15', 16, 'PT. INDO RAMA SYNTHETICS TBK', 23000, '412204551', '20JB @1150KG'),
	(36, '2022-12-15', 1, 'ITA TANGERANG', 481536, '0418', 'BATCH 2211 32JB@15048PCS'),
	(37, '2022-12-19', 22, 'PT. PETNESIA RESINDO', 16800, 'S2212119-1', '16JB @1050KG'),
	(38, '2022-12-19', 22, 'PT. PETNESIA RESINDO', 16800, 'S2212119-2', '16JB @1050KG'),
	(39, '2022-12-19', 22, 'PT. PETNESIA RESINDO', 16800, 'S2212119-3', '16JB @1050KG'),
	(40, '2022-12-19', 22, 'PT. PETNESIA RESINDO', 16800, 'S2212119-6', '16JB @1050KG'),
	(41, '2022-12-19', 17, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048872389', '16JB @1100KG'),
	(42, '2022-12-19', 17, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048882466', '16JB @1100KG'),
	(43, '2022-12-19', 17, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048882537', '16JB @1100KG'),
	(44, '2022-12-20', 22, 'PT. PETNESIA RESINDO', 16800, 'S2212119-4', '16JB @1050KG'),
	(45, '2022-12-20', 22, 'PT. PETNESIA RESINDO', 16800, 'S2212124-1', '16JB @1050KG'),
	(46, '2022-12-20', 22, 'PT. PETNESIA RESINDO', 16800, 'S2212124-3', '16JB @1050KG'),
	(47, '2022-12-20', 22, 'PT. PETNESIA RESINDO', 16800, 'S2212124-4', '16JB @1050KG'),
	(48, '2022-12-16', 17, 'PT. TIRTA INVESTAMA (PANDAAN)', 17600, '5048833654', '16JB @1100KG'),
	(49, '2022-12-21', 22, 'PT. PETNESIA RESINDO', 16800, 'S2212124-5', '16JB @1050KG'),
	(50, '2022-12-21', 22, 'PT. PETNESIA RESINDO', 16800, 'S2212124-6', '16JB @1050KG'),
	(51, '2022-12-22', 23, 'FAR EASTERN INDUSTRIES LTD', 22000, '', '20JB @1100KG'),
	(52, '2022-12-22', 23, 'FAR EASTERN INDUSTRIES LTD', 22000, '', '20JB @1100KG'),
	(53, '2022-12-22', 23, 'FAR EASTERN INDUSTRIES LTD', 22000, 'CSLU1585021', '20JB @1100KG'),
	(54, '2022-12-22', 23, 'FAR EASTERN INDUSTRIES LTD', 22000, 'CSNU1657319', '20JB @1100KG'),
	(55, '2022-12-22', 23, 'FAR EASTERN INDUSTRIES LTD', 22000, 'FCIU5960555', '20JB @1100KG'),
	(56, '2022-12-23', 23, 'FAR EASTERN INDUSTRIES LTD', 22000, 'OOLU0541553', '20JB @1100KG'),
	(57, '2022-12-23', 23, 'FAR EASTERN INDUSTRIES LTD', 22000, 'THRU1680771', '20JB @1100KG'),
	(58, '2022-12-23', 23, 'FAR EASTERN INDUSTRIES LTD', 22000, '', '20JB @1100KG'),
	(59, '2022-12-23', 23, 'FAR EASTERN INDUSTRIES LTD', 22000, 'TEMU27948899', '20JB @1100KG'),
	(60, '2022-12-23', 23, 'FAR EASTERN INDUSTRIES LTD', 22000, 'TEMU3448566', '20JB @1100KG'),
	(61, '2022-12-24', 1, 'ITA TANGERANG', 481536, '00428', 'BATCH 2211 8JB | BATCH 2212 24JB @15048P'),
	(62, '2022-12-26', 17, 'PT. TIRTA INVESTAMA (KLATEN)', 17600, '5048982980', '16JB @1100KG'),
	(63, '2022-12-27', 17, 'PT. TIRTA INVESTAMA (KLATEN)', 17600, '5049003046', '16JB @1100KG'),
	(64, '2022-12-27', 17, 'PT. TIRTA INVESTAMA (KLATEN)', 17600, '5048997340', '16JB @1100KG'),
	(65, '2022-12-28', 17, 'PT. TIRTA INVESTAMA (KLATEN)', 17600, '5049010248', '16JB @1100KG'),
	(66, '2022-12-28', 17, 'PT. TIRTA INVESTAMA (KLATEN)', 17600, '5049014637', '16JB @1100KG'),
	(67, '2022-12-29', 17, 'PT. TIRTA INVESTAMA (KLATEN)', 17600, '5049042603', '16JB @1100KG'),
	(68, '2022-12-29', 17, 'PT. TIRTA INVESTAMA (KLATEN)', 17600, '5049033303', '16JB @1100KG');
/*!40000 ALTER TABLE `incoming` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.lap_prod
CREATE TABLE IF NOT EXISTS `lap_prod` (
  `LapProdID` int(255) NOT NULL AUTO_INCREMENT,
  `PlanID` int(11) NOT NULL,
  `Shift` int(11) NOT NULL,
  `ProdOK` int(11) NOT NULL,
  `Awal` int(11) NOT NULL,
  `Tambahan` int(11) NOT NULL,
  `Sisa` int(11) NOT NULL,
  `SetupTime` float NOT NULL,
  `Start` time NOT NULL,
  `Finish` time NOT NULL,
  `UpTime` float NOT NULL,
  `Speed` float NOT NULL,
  `Cav` int(3) NOT NULL,
  `Berat` float NOT NULL,
  `Mesin_Off` tinyint(1) NOT NULL,
  `Catat` varchar(300) NOT NULL,
  `Operator` varchar(25) NOT NULL,
  `QC_Conf` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`LapProdID`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.lap_prod: ~15 rows (lebih kurang)
/*!40000 ALTER TABLE `lap_prod` DISABLE KEYS */;
REPLACE INTO `lap_prod` (`LapProdID`, `PlanID`, `Shift`, `ProdOK`, `Awal`, `Tambahan`, `Sisa`, `SetupTime`, `Start`, `Finish`, `UpTime`, `Speed`, `Cav`, `Berat`, `Mesin_Off`, `Catat`, `Operator`, `QC_Conf`) VALUES
	(1, 190, 1, 230259, 3917, 0, 2840, 0, '07:00:00', '15:00:00', 8, 8.18, 72, 14.24, 0, '', 'Sukardi', NULL),
	(2, 190, 2, 230352, 2840, 0, 1856, 0, '15:00:00', '23:00:00', 8, 9, 72, 0, 0, '', 'Alen', NULL),
	(3, 190, 3, 230352, 1856, 0, 872, 0, '23:00:00', '07:00:00', 8, 9, 72, 0, 0, '', 'Herman', NULL),
	(4, 194, 1, 230352, 872, 0, 10904, 0, '07:00:00', '15:00:00', 8, 9, 72, 0, 0, '', 'Alen', NULL),
	(5, 194, 2, 230354, 10904, 0, 9922, 0, '15:00:00', '23:00:00', 8, 9, 72, 0, 0, '', 'Seftian', NULL),
	(6, 194, 3, 230353, 9922, 0, 8939, 0, '23:00:00', '07:00:00', 8, 9, 72, 0, 0, '', 'Seftian', NULL),
	(7, 200, 1, 0, 0, 0, -66096, 0, '00:00:00', '00:00:00', 0, 9, 72, 0, 0, '', '', NULL),
	(8, 202, 1, 0, 0, 0, 0, 0, '00:00:00', '00:00:00', 0, 9, 72, 0, 0, '', '', NULL),
	(9, 204, 1, 80000, 0, 0, 2888, 0, '07:00:00', '15:00:00', 7.63, 8.18, 72, 14.31, 0, '', 'Sukardi', NULL),
	(10, 204, 2, 90000, 2888, 0, -6256, 0, '15:00:00', '23:00:00', 8, 8.18, 72, 14.31, 0, '', 'Herman', NULL),
	(11, 204, 3, 80000, -6256, 3500, 132, 0, '23:00:00', '07:00:00', 8, 8.18, 72, 14.23, 1, 'tambahan dari sisa produksi tanggal 29/12/2022', 'Seftian', NULL),
	(12, 207, 1, 80000, 0, 0, 2384, 0.5, '07:00:00', '15:00:00', 7.36, 16800, 0, 0, 0, '', 'AHMAD', NULL),
	(13, 207, 2, 79000, 2384, 0, 3768, 0.5, '15:00:00', '23:00:00', 7.5, 16800, 0, 0, 0, '', 'NASIR', NULL),
	(14, 205, 1, 70000, 0, 0, 9520, 0, '07:00:00', '15:00:00', 7.75, 10.3, 72, 27.57, 0, '', 'Alen', NULL),
	(15, 205, 2, 65000, 9520, 0, 14040, 0, '15:00:00', '23:00:00', 8, 10.3, 72, 27.54, 1, '', 'Seftian', NULL);
/*!40000 ALTER TABLE `lap_prod` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.material
CREATE TABLE IF NOT EXISTS `material` (
  `MaterialID` int(2) NOT NULL AUTO_INCREMENT,
  `RawMat` varchar(50) DEFAULT NULL,
  `Material` varchar(15) DEFAULT NULL,
  `NoMat` char(6) DEFAULT NULL,
  `Qty` int(5) DEFAULT NULL,
  PRIMARY KEY (`MaterialID`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1 COMMENT='Bahan Baku Resin dan Preform NC';

-- Membuang data untuk tabel warehouse.material: ~16 rows (lebih kurang)
/*!40000 ALTER TABLE `material` DISABLE KEYS */;
REPLACE INTO `material` (`MaterialID`, `RawMat`, `Material`, `NoMat`, `Qty`) VALUES
	(1, 'PREFORM HF-NC 21.99G Clear', NULL, '567875', 15048),
	(2, 'PREFORM HF-NC 25.70G Clear', NULL, '567876', 15048),
	(11, 'PET Resin DSR TLE10 ITA', 'DSR', '567937', 1100),
	(12, 'RPET RESIN VEOLIA PTVSI_RPET AQUA', 'RPET VEOLIA', '580604', 1000),
	(13, 'Colourmatrix Dan Blue-7 575-10488-7', 'BLUISH', '567982', 20),
	(14, 'Holcopet Blue 263.6667', 'BLUE', '567991', 20),
	(15, 'Holcopet Orange 268-30-26623', 'ORANGE', '581882', 20),
	(16, 'PET Resin Ramapet N2 IRS ITA', 'RAMAPET', '596809', 1150),
	(17, 'PET Resin DSR TLE105 AQUA', 'DSR', '567938', 1100),
	(18, 'PET Resin Eastlon CB602 AQUA', 'EASTLON', '568068', 1100),
	(19, 'PET Resin Ramapet N2 AQUA', 'RAMAPET', '567957', 1150),
	(20, 'PET Resin Jade CZ302 AQUA', 'JADE', '567945', 1100),
	(21, 'PET Resin Ramapet N2 ITA', 'RAMAPET', '567955', 1150),
	(22, 'PET Resin PNR SA135  ITA', 'PNR', '567948', 1050),
	(23, 'PET Resin Eastlon CB602  ITA', 'EASTLON', '567939', 1100),
	(24, 'PET Resin Jade CZ302 ITA', 'JADE', '567943', 1100);
/*!40000 ALTER TABLE `material` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.mesin
CREATE TABLE IF NOT EXISTS `mesin` (
  `MesinID` int(1) NOT NULL AUTO_INCREMENT,
  `Mesin` varchar(7) NOT NULL,
  `NameMesin` varchar(15) NOT NULL,
  `Type` varchar(50) NOT NULL,
  `Tanggal` date NOT NULL,
  `Cav` int(11) NOT NULL,
  PRIMARY KEY (`MesinID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.mesin: ~3 rows (lebih kurang)
/*!40000 ALTER TABLE `mesin` DISABLE KEYS */;
REPLACE INTO `mesin` (`MesinID`, `Mesin`, `NameMesin`, `Type`, `Tanggal`, `Cav`) VALUES
	(1, 'CA1PH01', 'Husky-1', '', '0000-00-00', 72),
	(2, 'CA1PH02', 'Husky-2', '', '2021-06-29', 72),
	(3, 'CA1BK01', 'Krones', '', '2023-06-29', 14);
/*!40000 ALTER TABLE `mesin` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.military
CREATE TABLE IF NOT EXISTS `military` (
  `MilitaryID` int(11) NOT NULL AUTO_INCREMENT,
  `Bawah` int(10) NOT NULL,
  `Atas` int(10) NOT NULL,
  `Sample` int(5) NOT NULL,
  PRIMARY KEY (`MilitaryID`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.military: ~16 rows (lebih kurang)
/*!40000 ALTER TABLE `military` DISABLE KEYS */;
REPLACE INTO `military` (`MilitaryID`, `Bawah`, `Atas`, `Sample`) VALUES
	(1, 2, 8, 2),
	(2, 9, 15, 3),
	(3, 16, 25, 5),
	(4, 26, 50, 8),
	(5, 51, 90, 13),
	(6, 91, 150, 20),
	(7, 151, 280, 32),
	(8, 281, 500, 50),
	(9, 501, 1200, 80),
	(10, 1201, 3200, 125),
	(11, 3201, 10000, 200),
	(12, 10001, 35000, 315),
	(13, 35001, 150000, 500),
	(14, 150001, 500000, 800),
	(15, 500001, 1000000, 1250),
	(16, 0, 1, 0);
/*!40000 ALTER TABLE `military` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.no_pbb
CREATE TABLE IF NOT EXISTS `no_pbb` (
  `NoPBB_ID` int(150) NOT NULL AUTO_INCREMENT,
  `No_PBB` varchar(25) NOT NULL,
  PRIMARY KEY (`NoPBB_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.no_pbb: ~69 rows (lebih kurang)
/*!40000 ALTER TABLE `no_pbb` DISABLE KEYS */;
REPLACE INTO `no_pbb` (`NoPBB_ID`, `No_PBB`) VALUES
	(1, '013/MT-GPL/12/22'),
	(2, '016/MT-GPL/12/22'),
	(3, '000/MT-GPL/12/22'),
	(4, '014/MT-GPL/12/22'),
	(5, '012/MT-GPL/12/22'),
	(6, '016/MT-GPL/12/22'),
	(7, '017/MT-GPL/12/22'),
	(8, '015/MT-GPL/12/22'),
	(9, '019/MT-GPL/12/22'),
	(10, '020/MT-GPL/12/22'),
	(11, '018/MT-GPL/12/22'),
	(12, '021/MT-GPL/12/22'),
	(13, '022/MT-GPL/12/22'),
	(14, '023/MT-GPL/12/22'),
	(15, '024/MT-GPL/12/22'),
	(16, '025/MT-GPL/12/22'),
	(17, '026/MT-GPL/12/22'),
	(18, '028/MT-GPL/12/22'),
	(19, '029/MT-GPL/12/22'),
	(20, '031/MT-GPL/12/22'),
	(21, '032/MT-GPL/12/22'),
	(22, '034/MT-GPL/12/22'),
	(23, '035/MT-GPL/12/22'),
	(24, '033/MT-GPL/12/22'),
	(25, '037/MT-GPL/12/22'),
	(26, '040/MT-GPL/12/22'),
	(27, '039/MT-GPL/12/22'),
	(28, '036/MT-GPL/12/22'),
	(29, '027/MT-GPL/12/22'),
	(30, '043/MT-GPL/12/22'),
	(31, '041/MT-GPL/12/22'),
	(32, '042/MT-GPL/12/22'),
	(33, '044/MT-GPL/12/22'),
	(34, '045/MT-GPL/12/22'),
	(35, '046/MT-GPL/12/22'),
	(36, '047/MT-GPL/12/22'),
	(37, '048/MT-GPL/12/22'),
	(38, '049/MT-GPL/12/22'),
	(39, '050/MT-GPL/12/22'),
	(40, '051/MT-GPL/12/22'),
	(41, '052/MT-GPL/12/22'),
	(42, '053/MT-GPL/12/22'),
	(43, '054/MT-GPL/12/22'),
	(44, '055/MT-GPL/12/22'),
	(45, '056/MT-GPL/12/22'),
	(46, '057/MT-GPL/12/22'),
	(47, '059/MT-GPL/12/22'),
	(48, '060/MT-GPL/12/22'),
	(49, '061/MT-GPL/12/22'),
	(50, '062/MT-GPL/12/22'),
	(51, '063/MT-GPL/12/22'),
	(52, '064/MT-GPL/12/22'),
	(53, '065/MT-GPL/12/22'),
	(54, '066/MT-GPL/12/22'),
	(55, '067/MT-GPL/12/22'),
	(56, '069/MT-GPL/12/22'),
	(57, '070/MT-GPL/12/22'),
	(58, '071/MT-GPL/12/22'),
	(59, '072/MT-GPL/12/22'),
	(60, '073/MT-GPL/12/22'),
	(61, '074/MT-GPL/12/22'),
	(62, '075/MT-GPL/12/22'),
	(63, '076/MT-GPL/12/22'),
	(64, '077/MT-GPL/12/22'),
	(65, '001/MT-GPL/01/23'),
	(66, '002/MT-GPL/01/23'),
	(67, '003/MT-GPL/01/23'),
	(68, '015/MT-GPL/01/23'),
	(69, '099/MT-GPL/01/23');
/*!40000 ALTER TABLE `no_pbb` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.pbb
CREATE TABLE IF NOT EXISTS `pbb` (
  `PBB_ID` int(255) NOT NULL AUTO_INCREMENT,
  `IncomingID` int(25) NOT NULL,
  `NoPBB_ID` int(25) DEFAULT NULL,
  `POOR` int(25) DEFAULT NULL,
  `PlanID` int(25) DEFAULT NULL,
  `Shift` int(11) DEFAULT NULL,
  `Lot` varchar(25) NOT NULL,
  `Bag` varchar(25) NOT NULL,
  `Batch` int(5) DEFAULT NULL,
  `Material` varchar(10) DEFAULT NULL,
  `Habis` int(11) DEFAULT NULL,
  PRIMARY KEY (`PBB_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1145 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.pbb: ~1.115 rows (lebih kurang)
/*!40000 ALTER TABLE `pbb` DISABLE KEYS */;
REPLACE INTO `pbb` (`PBB_ID`, `IncomingID`, `NoPBB_ID`, `POOR`, `PlanID`, `Shift`, `Lot`, `Bag`, `Batch`, `Material`, `Habis`) VALUES
	(1, 1, NULL, NULL, NULL, NULL, '22IA06', '424', NULL, NULL, NULL),
	(2, 1, NULL, NULL, NULL, NULL, '22IA06', '426', NULL, NULL, NULL),
	(3, 1, NULL, NULL, NULL, NULL, '22IA06', '427', NULL, NULL, NULL),
	(4, 1, NULL, NULL, NULL, NULL, '22IA06', '441', NULL, NULL, NULL),
	(5, 1, NULL, NULL, NULL, NULL, '22IA06', '422', NULL, NULL, NULL),
	(6, 1, NULL, NULL, NULL, NULL, '22IA06', '440', NULL, NULL, NULL),
	(7, 1, NULL, NULL, NULL, NULL, '22IA06', '675', NULL, NULL, NULL),
	(8, 1, NULL, NULL, NULL, NULL, '22IA06', '677', NULL, NULL, NULL),
	(9, 1, NULL, NULL, NULL, NULL, '22IA06', '679', NULL, NULL, NULL),
	(10, 1, NULL, NULL, NULL, NULL, '22IA06', '680', NULL, NULL, NULL),
	(11, 1, NULL, NULL, NULL, NULL, '22IA06', '682', NULL, NULL, NULL),
	(12, 2, NULL, NULL, NULL, NULL, '22JA00', '694', NULL, NULL, NULL),
	(13, 2, NULL, NULL, NULL, NULL, '22JA00', '735', NULL, NULL, NULL),
	(14, 2, NULL, NULL, NULL, NULL, '22JA00', '712', NULL, NULL, NULL),
	(15, 2, NULL, NULL, NULL, NULL, '22JA00', '714', NULL, NULL, NULL),
	(16, 2, NULL, NULL, NULL, NULL, '22JA00', '715', NULL, NULL, NULL),
	(17, 2, NULL, NULL, NULL, NULL, '22JA00', '716', NULL, NULL, NULL),
	(18, 2, NULL, NULL, NULL, NULL, '22JA00', '717', NULL, NULL, NULL),
	(19, 2, NULL, NULL, NULL, NULL, '22JA00', '719', NULL, NULL, NULL),
	(20, 2, NULL, NULL, NULL, NULL, '22JA00', '720', NULL, NULL, NULL),
	(21, 2, NULL, NULL, NULL, NULL, '22JA00', '721', NULL, NULL, NULL),
	(22, 2, NULL, NULL, NULL, NULL, '22JA00', '722', NULL, NULL, NULL),
	(23, 2, NULL, NULL, NULL, NULL, '22JA00', '723', NULL, NULL, NULL),
	(24, 2, NULL, NULL, NULL, NULL, '22JA00', '724', NULL, NULL, NULL),
	(25, 2, NULL, NULL, NULL, NULL, '22JA00', '725', NULL, NULL, NULL),
	(26, 2, NULL, NULL, NULL, NULL, '22JA00', '726', NULL, NULL, NULL),
	(27, 2, NULL, NULL, NULL, NULL, '22JA00', '727', NULL, NULL, NULL),
	(28, 2, NULL, NULL, NULL, NULL, '22JA00', '728', NULL, NULL, NULL),
	(29, 2, NULL, NULL, NULL, NULL, '22JA00', '729', NULL, NULL, NULL),
	(30, 2, NULL, NULL, NULL, NULL, '22JA00', '730', NULL, NULL, NULL),
	(31, 2, NULL, NULL, NULL, NULL, '22JA00', '711', NULL, NULL, NULL),
	(32, 4, 6, 10583921, NULL, NULL, '22JA00', '694', NULL, NULL, NULL),
	(33, 4, 1, 10583921, NULL, NULL, '22JA00', '735', NULL, NULL, NULL),
	(34, 4, 9, 10583921, NULL, NULL, '22JA00', '712', NULL, NULL, NULL),
	(35, 4, 1, 10583921, NULL, NULL, '22JA00', '714', NULL, NULL, NULL),
	(36, 4, 9, 10583921, NULL, NULL, '22JA00', '715', NULL, NULL, NULL),
	(37, 4, 6, 10583921, NULL, NULL, '22JA00', '716', NULL, NULL, NULL),
	(38, 4, 6, 10583921, NULL, NULL, '22JA00', '717', NULL, NULL, NULL),
	(39, 4, 6, 10583921, NULL, NULL, '22JA00', '719', NULL, NULL, NULL),
	(40, 4, 6, 10583921, NULL, NULL, '22JA00', '720', NULL, NULL, NULL),
	(41, 4, 9, 10583921, NULL, NULL, '22JA00', '721', NULL, NULL, NULL),
	(42, 4, 6, 10583921, NULL, NULL, '22JA00', '722', NULL, NULL, NULL),
	(43, 4, 9, 10583921, NULL, NULL, '22JA00', '723', NULL, NULL, NULL),
	(44, 4, 6, 10583921, NULL, NULL, '22JA00', '724', NULL, NULL, NULL),
	(45, 4, 6, 10583921, NULL, NULL, '22JA00', '725', NULL, NULL, NULL),
	(46, 4, 9, 10583921, NULL, NULL, '22JA00', '726', NULL, NULL, NULL),
	(47, 4, 6, 10583921, NULL, NULL, '22JA00', '727', NULL, NULL, NULL),
	(48, 4, 6, 10583921, NULL, NULL, '22JA00', '728', NULL, NULL, NULL),
	(49, 4, 6, 10583921, NULL, NULL, '22JA00', '729', NULL, NULL, NULL),
	(50, 4, 9, 10583921, NULL, NULL, '22JA00', '730', NULL, NULL, NULL),
	(51, 4, 1, 10583921, NULL, NULL, '22JA00', '711', NULL, NULL, NULL),
	(52, 5, 1, 10583921, NULL, NULL, '22IA06', '422', NULL, NULL, NULL),
	(53, 5, 1, 10583921, NULL, NULL, '22IA06', '424', NULL, NULL, NULL),
	(54, 5, 1, 10583921, NULL, NULL, '22IA06', '426', NULL, NULL, NULL),
	(55, 5, 1, 10583921, NULL, NULL, '22IA06', '427', NULL, NULL, NULL),
	(56, 5, 1, 10583921, NULL, NULL, '22IA06', '440', NULL, NULL, NULL),
	(57, 5, 1, 10583921, NULL, NULL, '22IA06', '441', NULL, NULL, NULL),
	(58, 5, 1, 10583921, NULL, NULL, '22IA06', '675', NULL, NULL, NULL),
	(59, 5, 1, 10583921, NULL, NULL, '22IA06', '677', NULL, NULL, NULL),
	(60, 5, 1, 10583921, NULL, NULL, '22IA06', '679', NULL, NULL, NULL),
	(61, 5, 1, 10583921, NULL, NULL, '22IA06', '680', NULL, NULL, NULL),
	(62, 5, 1, 10583921, NULL, NULL, '22IA06', '682', NULL, NULL, NULL),
	(63, 6, 16, 10583921, NULL, NULL, '22JA00', '706', NULL, NULL, NULL),
	(64, 6, 13, 10583921, NULL, NULL, '22JA00', '705', NULL, NULL, NULL),
	(65, 6, 16, 10583921, NULL, NULL, '22JA00', '708', NULL, NULL, NULL),
	(66, 6, 16, 10583921, NULL, NULL, '22JA00', '709', NULL, NULL, NULL),
	(67, 6, 16, 10583921, NULL, NULL, '22JA00', '710', NULL, NULL, NULL),
	(68, 6, 13, 10583921, NULL, NULL, '22JA00', '713', NULL, NULL, NULL),
	(69, 6, 9, 10583921, NULL, NULL, '22JA00', '718', NULL, NULL, NULL),
	(70, 6, 16, 10583921, NULL, NULL, '22JA00', '692', NULL, NULL, NULL),
	(71, 6, 16, 10583921, NULL, NULL, '22JA00', '693', NULL, NULL, NULL),
	(72, 6, 13, 10583921, NULL, NULL, '22JA00', '695', NULL, NULL, NULL),
	(73, 6, 13, 10583921, NULL, NULL, '22JA00', '696', NULL, NULL, NULL),
	(74, 6, 13, 10583921, NULL, NULL, '22JA00', '697', NULL, NULL, NULL),
	(75, 6, 13, 10583921, NULL, NULL, '22JA00', '698', NULL, NULL, NULL),
	(76, 6, 9, 10583921, NULL, NULL, '22JA00', '699', NULL, NULL, NULL),
	(77, 6, 13, 10583921, NULL, NULL, '22JA00', '700', NULL, NULL, NULL),
	(78, 6, 16, 10583921, NULL, NULL, '22JA00', '701', NULL, NULL, NULL),
	(79, 6, 13, 10583921, NULL, NULL, '22JA00', '702', NULL, NULL, NULL),
	(80, 6, 16, 10583921, NULL, NULL, '22JA00', '703', NULL, NULL, NULL),
	(81, 6, 1, 10583921, NULL, NULL, '22JA00', '704', NULL, NULL, NULL),
	(82, 6, 1, 10583921, NULL, NULL, '22JA00', '707', NULL, NULL, NULL),
	(83, 8, 7, 10583899, NULL, NULL, '2254306', '85', NULL, NULL, NULL),
	(84, 8, 7, 10583899, NULL, NULL, '2254306', '81', NULL, NULL, NULL),
	(85, 8, 7, 10583899, NULL, NULL, '2254306', '83', NULL, NULL, NULL),
	(86, 8, 7, 10583899, NULL, NULL, '2254306', '77', NULL, NULL, NULL),
	(87, 8, 7, 10583899, NULL, NULL, '2254306', '79', NULL, NULL, NULL),
	(88, 8, 7, 10583899, NULL, NULL, '2254306', '78', NULL, NULL, NULL),
	(89, 8, 7, 10583899, NULL, NULL, '2254306', '80', NULL, NULL, NULL),
	(90, 8, 7, 10583899, NULL, NULL, '2254306', '84', NULL, NULL, NULL),
	(91, 8, 10, 10583899, NULL, NULL, '2254306', '43', NULL, NULL, NULL),
	(92, 8, 7, 10583899, NULL, NULL, '2254306', '44', NULL, NULL, NULL),
	(93, 8, 7, 10583899, NULL, NULL, '2254306', '90', NULL, NULL, NULL),
	(94, 8, 7, 10583899, NULL, NULL, '2254306', '87', NULL, NULL, NULL),
	(95, 8, 7, 10583899, NULL, NULL, '2254306', '88', NULL, NULL, NULL),
	(96, 8, 7, 10583899, NULL, NULL, '2254306', '86', NULL, NULL, NULL),
	(97, 8, 7, 10583899, NULL, NULL, '2254306', '89', NULL, NULL, NULL),
	(98, 9, 10, 10583899, NULL, NULL, '2254306', '46', NULL, NULL, NULL),
	(99, 9, 14, 10583899, NULL, NULL, '2254306', '49', NULL, NULL, NULL),
	(100, 9, 10, 10583899, NULL, NULL, '2254306', '48', NULL, NULL, NULL),
	(101, 9, 10, 10583899, NULL, NULL, '2254306', '47', NULL, NULL, NULL),
	(102, 9, 10, 10583899, NULL, NULL, '2254306', '45', NULL, NULL, NULL),
	(103, 9, 10, 10583899, NULL, NULL, '2254306', '56', NULL, NULL, NULL),
	(104, 9, 10, 10583899, NULL, NULL, '2254306', '53', NULL, NULL, NULL),
	(105, 9, 10, 10583899, NULL, NULL, '2254306', '54', NULL, NULL, NULL),
	(106, 9, 10, 10583899, NULL, NULL, '2254306', '52', NULL, NULL, NULL),
	(107, 9, 10, 10583899, NULL, NULL, '2254306', '51', NULL, NULL, NULL),
	(108, 9, 10, 10583899, NULL, NULL, '2254306', '55', NULL, NULL, NULL),
	(109, 9, 10, 10583899, NULL, NULL, '2254306', '57', NULL, NULL, NULL),
	(110, 9, 14, 10583899, NULL, NULL, '2254306', '60', NULL, NULL, NULL),
	(111, 9, 14, 10583899, NULL, NULL, '2254306', '58', NULL, NULL, NULL),
	(112, 9, 10, 10583899, NULL, NULL, '2254306', '59', NULL, NULL, NULL),
	(113, 9, 14, 10583899, NULL, NULL, '2254306', '50', NULL, NULL, NULL),
	(114, 10, 14, 10583899, NULL, NULL, '2256289', '20', NULL, NULL, NULL),
	(115, 10, 14, 10583899, NULL, NULL, '2256289', '25', NULL, NULL, NULL),
	(116, 10, 14, 10583899, NULL, NULL, '2256289', '28', NULL, NULL, NULL),
	(117, 10, 14, 10583899, NULL, NULL, '2256289', '15', NULL, NULL, NULL),
	(118, 10, 14, 10583899, NULL, NULL, '2256289', '26', NULL, NULL, NULL),
	(119, 10, 17, 10583899, NULL, NULL, '2256289', '18', NULL, NULL, NULL),
	(120, 10, 17, 10583899, NULL, NULL, '2256289', '21', NULL, NULL, NULL),
	(121, 10, 17, 10583899, NULL, NULL, '2256289', '27', NULL, NULL, NULL),
	(122, 10, 17, 10583899, NULL, NULL, '2256289', '30', NULL, NULL, NULL),
	(123, 10, 17, 10583899, NULL, NULL, '2256289', '29', NULL, NULL, NULL),
	(124, 10, 17, 10583899, NULL, NULL, '2256289', '24', NULL, NULL, NULL),
	(125, 10, 17, 10583899, NULL, NULL, '2256289', '23', NULL, NULL, NULL),
	(126, 10, 14, 10583899, NULL, NULL, '2256289', '17', NULL, NULL, NULL),
	(127, 10, 14, 10583899, NULL, NULL, '2256289', '19', NULL, NULL, NULL),
	(128, 10, 14, 10583899, NULL, NULL, '2256289', '16', NULL, NULL, NULL),
	(129, 10, 30, 10584687, NULL, NULL, '2256289', '14', NULL, NULL, NULL),
	(130, 11, 26, 10584687, NULL, NULL, '2256289', '58', NULL, NULL, NULL),
	(131, 11, 29, 10583899, NULL, NULL, '2256289', '60', NULL, NULL, NULL),
	(132, 11, 26, 10584687, NULL, NULL, '2256289', '59', NULL, NULL, NULL),
	(133, 11, 26, 10584687, NULL, NULL, '2256289', '53', NULL, NULL, NULL),
	(134, 11, 29, 10583899, NULL, NULL, '2256289', '54', NULL, NULL, NULL),
	(135, 11, 29, 10583899, NULL, NULL, '2256289', '57', NULL, NULL, NULL),
	(136, 11, 30, 10584687, NULL, NULL, '2256289', '49', NULL, NULL, NULL),
	(137, 11, 29, 10583899, NULL, NULL, '2256289', '50', NULL, NULL, NULL),
	(138, 11, 29, 10583899, NULL, NULL, '2256289', '21', NULL, NULL, NULL),
	(139, 11, 17, 10583899, NULL, NULL, '2256289', '52', NULL, NULL, NULL),
	(140, 11, 17, 10583899, NULL, NULL, '2256289', '46', NULL, NULL, NULL),
	(141, 11, 17, 10583899, NULL, NULL, '2256289', '45', NULL, NULL, NULL),
	(142, 11, 17, 10583899, NULL, NULL, '2256289', '47', NULL, NULL, NULL),
	(143, 11, 29, 10583899, NULL, NULL, '2256289', '51', NULL, NULL, NULL),
	(144, 11, 29, 10583899, NULL, NULL, '2256289', '56', NULL, NULL, NULL),
	(145, 11, 29, 10583899, NULL, NULL, '2256289', '55', NULL, NULL, NULL),
	(146, 12, 26, 10584687, NULL, NULL, '2256289', '73', NULL, NULL, NULL),
	(147, 12, 26, 10584687, NULL, NULL, '2256289', '69', NULL, NULL, NULL),
	(148, 12, 26, 10584687, NULL, NULL, '2256289', '65', NULL, NULL, NULL),
	(149, 12, 26, 10584687, NULL, NULL, '2256289', '61', NULL, NULL, NULL),
	(150, 12, 26, 10584687, NULL, NULL, '2256289', '72', NULL, NULL, NULL),
	(151, 12, 26, 10584687, NULL, NULL, '2256289', '74', NULL, NULL, NULL),
	(152, 12, 26, 10584687, NULL, NULL, '2256289', '44', NULL, NULL, NULL),
	(153, 12, 26, 10584687, NULL, NULL, '2256289', '43', NULL, NULL, NULL),
	(154, 12, 26, 10584687, NULL, NULL, '2256289', '68', NULL, NULL, NULL),
	(155, 12, 26, 10584687, NULL, NULL, '2256289', '62', NULL, NULL, NULL),
	(156, 12, 30, 10584687, NULL, NULL, '2256289', '71', NULL, NULL, NULL),
	(157, 12, 30, 10584687, NULL, NULL, '2256289', '63', NULL, NULL, NULL),
	(158, 12, 30, 10584687, NULL, NULL, '2256289', '67', NULL, NULL, NULL),
	(159, 12, 30, 10584687, NULL, NULL, '2256289', '70', NULL, NULL, NULL),
	(160, 12, 26, 10584687, NULL, NULL, '2256289', '66', NULL, NULL, NULL),
	(161, 12, 30, 10584687, NULL, NULL, '2256289', '64', NULL, NULL, NULL),
	(162, 13, 30, 10584687, NULL, NULL, '2256289', '39', NULL, NULL, NULL),
	(163, 13, 30, 10584687, NULL, NULL, '2256289', '37', NULL, NULL, NULL),
	(164, 13, 30, 10584687, NULL, NULL, '2256289', '35', NULL, NULL, NULL),
	(165, 13, 30, 10584687, NULL, NULL, '2256289', '38', NULL, NULL, NULL),
	(166, 13, 30, 10584687, NULL, NULL, '2256289', '36', NULL, NULL, NULL),
	(167, 13, 30, 10584687, NULL, NULL, '2256289', '41', NULL, NULL, NULL),
	(168, 13, 30, 10584687, NULL, NULL, '2256289', '31', NULL, NULL, NULL),
	(169, 13, 30, 10584687, NULL, NULL, '2256289', '42', NULL, NULL, NULL),
	(170, 13, 29, 10583899, NULL, NULL, '2256289', '48', NULL, NULL, NULL),
	(171, 13, 30, 10584687, NULL, NULL, '2256289', '34', NULL, NULL, NULL),
	(172, 13, 30, 10584687, NULL, NULL, '2256289', '32', NULL, NULL, NULL),
	(173, 13, 17, 10583899, NULL, NULL, '2256289', '22', NULL, NULL, NULL),
	(174, 13, 30, 10584687, NULL, NULL, '2256289', '11', NULL, NULL, NULL),
	(175, 13, 30, 10584687, NULL, NULL, '2256289', '12', NULL, NULL, NULL),
	(176, 13, 30, 10584687, NULL, NULL, '2256289', '13', NULL, NULL, NULL),
	(177, 13, 30, 10584687, NULL, NULL, '2256289', '33', NULL, NULL, NULL),
	(178, 14, 5, 10583818, NULL, NULL, '0537', '10582512-24', 2211, 'PNR', NULL),
	(179, 14, 5, 10583818, NULL, NULL, '0537', '10582512-25', 2211, 'PNR', NULL),
	(180, 14, 5, 10583818, NULL, NULL, '0543', '10582710-03', 2211, 'PNR', NULL),
	(181, 14, 5, 10583818, NULL, NULL, '0543', '10582710-04', 2211, 'PNR', NULL),
	(182, 14, 5, 10583818, NULL, NULL, '0543', '10582710-07', 2211, 'PNR', NULL),
	(183, 15, 5, 10583818, NULL, NULL, '0545', '10582710-19', 2211, 'PNR', NULL),
	(184, 15, 5, 10583818, NULL, NULL, '0546', '10582710-20', 2211, 'PNR', NULL),
	(185, 15, 8, 10583818, NULL, NULL, '0547', '10582710-21', 2211, 'PNR', NULL),
	(186, 15, 8, 10583818, NULL, NULL, '0547', '10582710-22', 2211, 'PNR', NULL),
	(187, 15, 5, 10583818, NULL, NULL, '0547', '10582710-23', 2211, 'PNR', NULL),
	(188, 15, 5, 10583818, NULL, NULL, '0547', '10582710-24', 2211, 'PNR', NULL),
	(189, 15, 5, 10583818, NULL, NULL, '0547', '10582710-25', 2211, 'PNR', NULL),
	(190, 15, 5, 10583818, NULL, NULL, '0547', '10582710-26', 2211, 'PNR', NULL),
	(191, 15, 8, 10583818, NULL, NULL, '0547', '10582710-27', 2211, 'PNR', NULL),
	(192, 15, 8, 10583818, NULL, NULL, '0547', '10582710-28', 2211, 'PNR', NULL),
	(193, 15, 8, 10583818, NULL, NULL, '0547', '10582710-29', 2211, 'PNR', NULL),
	(194, 15, 8, 10583818, NULL, NULL, '0548', '10582710-30', 2211, 'PNR', NULL),
	(195, 15, 8, 10583818, NULL, NULL, '0548', '10582710-31', 2211, 'PNR', NULL),
	(196, 15, 8, 10583818, NULL, NULL, '0548', '10582710-32', 2211, 'PNR', NULL),
	(197, 15, 5, 10583818, NULL, NULL, '0548', '10582710-33', 2211, 'PNR', NULL),
	(198, 15, 5, 10583818, NULL, NULL, '0548', '10582710-34', 2211, 'PNR', NULL),
	(199, 15, 11, 10583818, NULL, NULL, '0548', '10582710-35', 2211, 'PNR', NULL),
	(200, 15, 11, 10583818, NULL, NULL, '0548', '10582710-36', 2211, 'PNR', NULL),
	(201, 15, 8, 10583818, NULL, NULL, '0548', '10582710-37', 2211, 'PNR', NULL),
	(202, 15, 8, 10583818, NULL, NULL, '0548', '10582710-38', 2211, 'PNR', NULL),
	(203, 15, 8, 10583818, NULL, NULL, '0548', '10582710-39', 2211, 'PNR', NULL),
	(204, 15, 8, 10583818, NULL, NULL, '0549', '10582710-40', 2211, 'PNR', NULL),
	(205, 15, 11, 10583818, NULL, NULL, '0549', '10582710-41', 2211, 'PNR', NULL),
	(206, 15, 11, 10583818, NULL, NULL, '0549', '10582710-42', 2211, 'PNR', NULL),
	(207, 15, 8, 10583818, NULL, NULL, '0549', '10582710-43', 2211, 'PNR', NULL),
	(208, 15, 8, 10583818, NULL, NULL, '0549', '10582710-44', 2211, 'PNR', NULL),
	(209, 15, 5, 10583818, NULL, NULL, '0549', '10582710-45', 2211, 'PNR', NULL),
	(210, 15, 5, 10583818, NULL, NULL, '0549', '10582710-46', 2211, 'PNR', NULL),
	(211, 15, 8, 10583818, NULL, NULL, '0549', '10582710-47', 2211, 'PNR', NULL),
	(212, 15, 8, 10583818, NULL, NULL, '0549', '10582710-48', 2211, 'PNR', NULL),
	(213, 15, 8, 10583818, NULL, NULL, '0550', '10582710-49', 2211, 'PNR', NULL),
	(214, 15, 8, 10583818, NULL, NULL, '0550', '10582710-50', 2211, 'PNR', NULL),
	(215, 16, 11, 10583818, NULL, NULL, '0550', '10582710-51', 2211, 'PNR', NULL),
	(216, 16, 11, 10583818, NULL, NULL, '0550', '10582710-52', 2211, 'PNR', NULL),
	(217, 16, 11, 10583818, NULL, NULL, '0550', '10582710-53', 2211, 'PNR', NULL),
	(218, 16, 11, 10583818, NULL, NULL, '0550', '10582710-54', 2211, 'PNR', NULL),
	(219, 16, 12, 10583818, NULL, NULL, '0550', '10582710-55', 2211, 'PNR', NULL),
	(220, 16, 12, 10583818, NULL, NULL, '0550', '10582710-56', 2211, 'PNR', NULL),
	(221, 16, 12, 10583818, NULL, NULL, '0550', '10582710-57', 2211, 'PNR', NULL),
	(222, 16, 12, 10583818, NULL, NULL, '0551', '10582710-58', 2211, 'PNR', NULL),
	(223, 16, 12, 10583818, NULL, NULL, '0551', '10582710-59', 2211, 'PNR', NULL),
	(224, 16, 12, 10583818, NULL, NULL, '0551', '10582710-60', 2211, 'PNR', NULL),
	(225, 16, 12, 10583818, NULL, NULL, '0551', '10582710-61', 2211, 'PNR', NULL),
	(226, 16, 12, 10583818, NULL, NULL, '0551', '10582710-62', 2211, 'PNR', NULL),
	(227, 16, 11, 10583818, NULL, NULL, '0551', '10582710-63', 2211, 'PNR', NULL),
	(228, 16, 11, 10583818, NULL, NULL, '0551', '10582710-64', 2211, 'PNR', NULL),
	(229, 16, 12, 10583818, NULL, NULL, '0551', '10582710-65', 2211, 'PNR', NULL),
	(230, 16, 12, 10583818, NULL, NULL, '0551', '10582710-66', 2211, 'PNR', NULL),
	(231, 16, 15, 10583818, NULL, NULL, '0551', '10582710-67', 2211, 'PNR', NULL),
	(232, 16, 15, 10583818, NULL, NULL, '0552', '10582710-68', 2211, 'PNR', NULL),
	(233, 16, 12, 10583818, NULL, NULL, '0552', '10582710-69', 2211, 'PNR', NULL),
	(234, 16, 15, 10583818, NULL, NULL, '0552', '10582710-70', 2211, 'PNR', NULL),
	(235, 16, 12, 10583818, NULL, NULL, '0552', '10582710-71', 2211, 'PNR', NULL),
	(236, 16, 12, 10583818, NULL, NULL, '0552', '10582710-72', 2211, 'PNR', NULL),
	(237, 16, 15, 10583818, NULL, NULL, '0552', '10582710-73', 2211, 'PNR', NULL),
	(238, 16, 15, 10583818, NULL, NULL, '0552', '10582710-74', 2211, 'PNR', NULL),
	(239, 16, 11, 10583818, NULL, NULL, '0552', '10582710-75', 2211, 'PNR', NULL),
	(240, 16, 11, 10583818, NULL, NULL, '0552', '10582710-76', 2211, 'PNR', NULL),
	(241, 16, 11, 10583818, NULL, NULL, '0552', '10582710-77', 2211, 'PNR', NULL),
	(242, 16, 11, 10583818, NULL, NULL, '0553', '10582710-78', 2211, 'PNR', NULL),
	(243, 16, 11, 10583818, NULL, NULL, '0553', '10582710-79', 2211, 'PNR', NULL),
	(244, 16, 11, 10583818, NULL, NULL, '0553', '10582710-80', 2211, 'PNR', NULL),
	(245, 16, 12, 10583818, NULL, NULL, '0553', '10582710-81', 2211, 'PNR', NULL),
	(246, 16, 12, 10583818, NULL, NULL, '0553', '10582710-82', 2211, 'PNR', NULL),
	(247, 17, 21, 10584469, NULL, NULL, '0553', '10582710-83', 2211, 'PNR', NULL),
	(248, 17, 21, 10584469, NULL, NULL, '0553', '10582710-84', 2211, 'PNR', NULL),
	(249, 17, 31, 10584469, NULL, NULL, '0553', '10582710-85', 2211, 'PNR', NULL),
	(250, 17, 25, 10584469, NULL, NULL, '0553', '10582710-86', 2211, 'PNR', NULL),
	(251, 17, 25, 10584469, NULL, NULL, '0554', '10582710-87', 2211, 'PNR', NULL),
	(252, 17, 25, 10584469, NULL, NULL, '0554', '10582710-88', 2211, 'PNR', NULL),
	(253, 17, 33, 10584469, NULL, NULL, '0554', '10582710-89', 2211, 'PNR', NULL),
	(254, 17, 33, 10584469, NULL, NULL, '0554', '10582710-90', 2211, 'PNR', NULL),
	(255, 17, 25, 10584469, NULL, NULL, '0554', '10582710-91', 2211, 'PNR', NULL),
	(256, 17, 21, 10584469, NULL, NULL, '0554', '10582710-92', 2211, 'PNR', NULL),
	(257, 17, 25, 10584469, NULL, NULL, '0554', '10582710-93', 2211, 'PNR', NULL),
	(258, 17, 25, 10584469, NULL, NULL, '0554', '10582710-94', 2211, 'PNR', NULL),
	(259, 17, 33, 10584469, NULL, NULL, '0554', '10582710-95', 2211, 'PNR', NULL),
	(260, 17, 33, 10584469, NULL, NULL, '0554', '10582710-96', 2211, 'PNR', NULL),
	(261, 17, 31, 10584469, NULL, NULL, '0555', '10582710-97', 2211, 'PNR', NULL),
	(262, 17, 31, 10584469, NULL, NULL, '0555', '10582710-98', 2211, 'PNR', NULL),
	(263, 17, 31, 10584469, NULL, NULL, '0555', '10582710-99', 2211, 'PNR', NULL),
	(264, 17, 31, 10584469, NULL, NULL, '0555', '10582710-100', 2211, 'PNR', NULL),
	(265, 17, 31, 10584469, NULL, NULL, '0555', '10582710-101', 2211, 'PNR', NULL),
	(266, 17, 31, 10584469, NULL, NULL, '0555', '10582710-102', 2211, 'PNR', NULL),
	(267, 17, 31, 10584469, NULL, NULL, '0555', '10582710-103', 2211, 'PNR', NULL),
	(268, 17, 15, 10583818, NULL, NULL, '0555', '10582710-104', 2211, 'PNR', NULL),
	(269, 17, 21, 10584469, NULL, NULL, '0555', '10582710-105', 2211, 'PNR', NULL),
	(270, 17, 21, 10584469, NULL, NULL, '0556', '10582710-106', 2211, 'PNR', NULL),
	(271, 17, 21, 10584469, NULL, NULL, '0556', '10582710-107', 2211, 'PNR', NULL),
	(272, 17, 25, 10584469, NULL, NULL, '0556', '10582710-108', 2211, 'PNR', NULL),
	(273, 17, 25, 10584469, NULL, NULL, '0556', '10582710-109', 2211, 'PNR', NULL),
	(274, 17, 15, 10583818, NULL, NULL, '0556', '10582710-110', 2211, 'PNR', NULL),
	(275, 17, 15, 10583818, NULL, NULL, '0556', '10582710-111', 2211, 'PNR', NULL),
	(276, 17, 21, 10584469, NULL, NULL, '0556', '10582710-112', 2211, 'PNR', NULL),
	(277, 17, 31, 10584469, NULL, NULL, '0556', '10582710-113', 2211, 'PNR', NULL),
	(278, 17, 25, 10584469, NULL, NULL, '0556', '10582710-114', 2211, 'PNR', NULL),
	(279, 18, 36, 10584756, NULL, NULL, '709849007', '21', NULL, NULL, NULL),
	(280, 18, 68, 10585503, 204, 1, '709849007', '25', NULL, NULL, 0),
	(281, 19, 4, 0, NULL, NULL, 'I2-220923', '201', NULL, NULL, NULL),
	(282, 19, 4, 0, NULL, NULL, 'I2-220923', '192', NULL, NULL, NULL),
	(283, 19, 4, 0, NULL, NULL, 'I2-220923', '200', NULL, NULL, NULL),
	(284, 19, 4, 0, NULL, NULL, 'I2-220923', '209', NULL, NULL, NULL),
	(285, 19, 4, 0, NULL, NULL, 'I2-220923', '198', NULL, NULL, NULL),
	(286, 19, 4, 0, NULL, NULL, 'I2-220923', '116', NULL, NULL, NULL),
	(287, 19, 4, 0, NULL, NULL, 'I2-220923', '173', NULL, NULL, NULL),
	(288, 19, 4, 0, NULL, NULL, 'I2-220923', '131', NULL, NULL, NULL),
	(289, 19, 4, 0, NULL, NULL, 'I2-220912', '174', NULL, NULL, NULL),
	(290, 19, 18, 10584321, NULL, NULL, 'I2-220912', '190', NULL, NULL, NULL),
	(291, 19, 4, 0, NULL, NULL, 'I2-220912', '160', NULL, NULL, NULL),
	(292, 19, 4, 0, NULL, NULL, 'I2-220912', '169', NULL, NULL, NULL),
	(293, 19, 4, 0, NULL, NULL, 'I2-220912', '132', NULL, NULL, NULL),
	(294, 20, 18, 10584321, NULL, NULL, 'I2-220923', '059', NULL, NULL, NULL),
	(295, 20, 18, 10584321, NULL, NULL, 'I2-220923', '041', NULL, NULL, NULL),
	(296, 20, 18, 10584321, NULL, NULL, 'I2-220923', '163', NULL, NULL, NULL),
	(297, 20, 18, 10584321, NULL, NULL, 'I2-220923', '084', NULL, NULL, NULL),
	(298, 20, 18, 10584321, NULL, NULL, 'I2-220923', '079', NULL, NULL, NULL),
	(299, 20, 18, 10584321, NULL, NULL, 'I2-220923', '068', NULL, NULL, NULL),
	(300, 20, 18, 10584321, NULL, NULL, 'I2-220923', '063', NULL, NULL, NULL),
	(301, 20, 18, 10584321, NULL, NULL, 'I2-220923', '066', NULL, NULL, NULL),
	(302, 20, 18, 10584321, NULL, NULL, 'I2-220923', '069', NULL, NULL, NULL),
	(303, 20, 18, 10584321, NULL, NULL, 'I2-220923', '070', NULL, NULL, NULL),
	(304, 20, 18, 10584321, NULL, NULL, 'I2-220923', '051', NULL, NULL, NULL),
	(305, 20, 18, 10584321, NULL, NULL, 'I2-220923', '060', NULL, NULL, NULL),
	(306, 20, 18, 10584321, NULL, NULL, 'I2-220923', '156', NULL, NULL, NULL),
	(307, 20, 18, 10584321, NULL, NULL, 'I2-220924', '232', NULL, NULL, NULL),
	(308, 20, 18, 10584321, NULL, NULL, 'I2-220928', '048', NULL, NULL, NULL),
	(309, 20, 18, 10584321, NULL, NULL, 'I2-220928', '042', NULL, NULL, NULL),
	(310, 21, 20, 10584321, NULL, NULL, 'I2-220928', '180', NULL, NULL, NULL),
	(311, 21, 20, 10584321, NULL, NULL, 'I2-220928', '064', NULL, NULL, NULL),
	(312, 21, 20, 10584321, NULL, NULL, 'I2-220928', '132', NULL, NULL, NULL),
	(313, 21, 20, 10584321, NULL, NULL, 'I2-220928', '145', NULL, NULL, NULL),
	(314, 21, 20, 10584321, NULL, NULL, 'I2-220928', '001', NULL, NULL, NULL),
	(315, 21, 20, 10584321, NULL, NULL, 'I2-220928', '151', NULL, NULL, NULL),
	(316, 21, 20, 10584321, NULL, NULL, 'I2-220928', '170', NULL, NULL, NULL),
	(317, 21, 20, 10584321, NULL, NULL, 'I2-220928', '173', NULL, NULL, NULL),
	(318, 21, 20, 10584321, NULL, NULL, 'I2-220928', '019', NULL, NULL, NULL),
	(319, 21, 20, 10584321, NULL, NULL, 'I2-220928', '152', NULL, NULL, NULL),
	(320, 21, 20, 10584321, NULL, NULL, 'I2-220928', '071', NULL, NULL, NULL),
	(321, 21, 20, 10584321, NULL, NULL, 'I2-220928', '015', NULL, NULL, NULL),
	(322, 21, 20, 10584321, NULL, NULL, 'I2-220923', '144', NULL, NULL, NULL),
	(323, 21, 20, 10584321, NULL, NULL, 'I2-220923', '042', NULL, NULL, NULL),
	(324, 21, 20, 10584321, NULL, NULL, 'I2-220923', '153', NULL, NULL, NULL),
	(325, 21, 20, 10584321, NULL, NULL, 'I2-220923', '163', NULL, NULL, NULL),
	(326, 22, 4, 0, NULL, NULL, 'I2-220915', '228', NULL, NULL, NULL),
	(327, 14, 5, 10583818, NULL, NULL, '0537', '10582512-16', NULL, NULL, NULL),
	(328, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10232', NULL, NULL, NULL),
	(329, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10214', NULL, NULL, NULL),
	(330, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10269', NULL, NULL, NULL),
	(331, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10312', NULL, NULL, NULL),
	(332, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10278', NULL, NULL, NULL),
	(333, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10250', NULL, NULL, NULL),
	(334, 23, 19, 10584313, NULL, NULL, 'CV1270722', '07783', NULL, NULL, NULL),
	(335, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10205', NULL, NULL, NULL),
	(336, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10152', NULL, NULL, NULL),
	(337, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10125', NULL, NULL, NULL),
	(338, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10134', NULL, NULL, NULL),
	(339, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10116', NULL, NULL, NULL),
	(340, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10143', NULL, NULL, NULL),
	(341, 23, 19, 10584313, NULL, NULL, 'CV1270722', '12132', NULL, NULL, NULL),
	(342, 23, 19, 10584313, NULL, NULL, 'CV1270722', '12123', NULL, NULL, NULL),
	(343, 23, 19, 10584313, NULL, NULL, 'CV1270722', '10161', NULL, NULL, NULL),
	(344, 24, 24, 10584313, NULL, NULL, 'CV1270722', '08969', NULL, NULL, NULL),
	(345, 24, 24, 10584313, NULL, NULL, 'CV1270722', '09057', NULL, NULL, NULL),
	(346, 24, 24, 10584313, NULL, NULL, 'CV1270722', '08987', NULL, NULL, NULL),
	(347, 24, 24, 10584313, NULL, NULL, 'CV1270722', '08889', NULL, NULL, NULL),
	(348, 24, 19, 10584313, NULL, NULL, 'CV1270722', '09002', NULL, NULL, NULL),
	(349, 24, 19, 10584313, NULL, NULL, 'CV1270722', '08950', NULL, NULL, NULL),
	(350, 24, 24, 10584313, NULL, NULL, 'CV1270722', '08852', NULL, NULL, NULL),
	(351, 24, 24, 10584313, NULL, NULL, 'CV1270722', '08843', NULL, NULL, NULL),
	(352, 24, 58, 10585202, NULL, NULL, 'CV1270722', '10321', NULL, NULL, NULL),
	(353, 24, 58, 10585202, NULL, NULL, 'CV1270722', '10303', NULL, NULL, NULL),
	(354, 24, 58, 10585202, NULL, NULL, 'CV1270722', '11151', NULL, NULL, NULL),
	(355, 24, 58, 10585202, NULL, NULL, 'CV1270722', '11124', NULL, NULL, NULL),
	(356, 24, 58, 10585202, NULL, NULL, 'CV1270722', '11080', NULL, NULL, NULL),
	(357, 24, 58, 10585202, NULL, NULL, 'CV1270722', '11071', NULL, NULL, NULL),
	(358, 24, 58, 10585202, NULL, NULL, 'CV1270722', '11106', NULL, NULL, NULL),
	(359, 24, 58, 10585202, NULL, NULL, 'CV1270722', '09011', NULL, NULL, NULL),
	(370, 26, 32, 10584314, NULL, NULL, 'I2-220915', '250', NULL, NULL, NULL),
	(371, 26, 32, 10584314, NULL, NULL, 'I2-220915', '241', NULL, NULL, NULL),
	(372, 26, 27, 10584321, NULL, NULL, 'I2-220915', '253', NULL, NULL, NULL),
	(373, 26, 28, 10584314, NULL, NULL, 'I2-220915', '251', NULL, NULL, NULL),
	(374, 26, 28, 10584314, NULL, NULL, 'I2-220912', '354', NULL, NULL, NULL),
	(375, 26, 28, 10584314, NULL, NULL, 'I2-220912', '351', NULL, NULL, NULL),
	(376, 26, 28, 10584314, NULL, NULL, 'I2-220912', '303', NULL, NULL, NULL),
	(377, 26, 28, 10584314, NULL, NULL, 'I2-220912', '322', NULL, NULL, NULL),
	(378, 26, 28, 10584314, NULL, NULL, 'I2-220912', '319', NULL, NULL, NULL),
	(379, 26, 28, 10584314, NULL, NULL, 'I2-220912', '350', NULL, NULL, NULL),
	(380, 26, 28, 10584314, NULL, NULL, 'I2-220912', '323', NULL, NULL, NULL),
	(381, 26, 28, 10584314, NULL, NULL, 'I2-220912', '308', NULL, NULL, NULL),
	(382, 26, 28, 10584314, NULL, NULL, 'I2-220912', '248', NULL, NULL, NULL),
	(383, 26, 28, 10584314, NULL, NULL, 'I2-220912', '371', NULL, NULL, NULL),
	(384, 26, 28, 10584314, NULL, NULL, 'I2-220915', '237', NULL, NULL, NULL),
	(385, 26, 28, 10584314, NULL, NULL, 'I2-220915', '235', NULL, NULL, NULL),
	(386, 27, 34, 10584314, NULL, NULL, 'I2-220927', '419', NULL, NULL, NULL),
	(387, 27, 34, 10584314, NULL, NULL, 'I2-220927', '444', NULL, NULL, NULL),
	(388, 27, 34, 10584314, NULL, NULL, 'I2-220927', '391', NULL, NULL, NULL),
	(389, 27, 34, 10584314, NULL, NULL, 'I2-220927', '442', NULL, NULL, NULL),
	(390, 27, 34, 10584314, NULL, NULL, 'I2-220927', '403', NULL, NULL, NULL),
	(391, 27, 34, 10584314, NULL, NULL, 'I2-220927', '417', NULL, NULL, NULL),
	(392, 27, 34, 10584314, NULL, NULL, 'I2-220927', '404', NULL, NULL, NULL),
	(393, 27, 32, 10584314, NULL, NULL, 'I2-220927', '438', NULL, NULL, NULL),
	(394, 27, 32, 10584314, NULL, NULL, 'I2-220927', '435', NULL, NULL, NULL),
	(395, 27, 32, 10584314, NULL, NULL, 'I2-220927', '440', NULL, NULL, NULL),
	(396, 27, 32, 10584314, NULL, NULL, 'I2-220928', '089', NULL, NULL, NULL),
	(397, 27, 32, 10584314, NULL, NULL, 'I2-220928', '099', NULL, NULL, NULL),
	(398, 27, 32, 10584314, NULL, NULL, 'I2-220928', '059', NULL, NULL, NULL),
	(399, 27, 32, 10584314, NULL, NULL, 'I2-220928', '182', NULL, NULL, NULL),
	(400, 27, 32, 10584314, NULL, NULL, 'I2-220928', '058', NULL, NULL, NULL),
	(401, 27, 32, 10584314, NULL, NULL, 'I2-220928', '074', NULL, NULL, NULL),
	(402, 28, NULL, NULL, NULL, NULL, '0236', '10581056-68', 2210, 'PNR', NULL),
	(403, 28, NULL, NULL, NULL, NULL, '0236', '10581056-69', 2210, 'PNR', NULL),
	(404, 28, NULL, NULL, NULL, NULL, '0236', '10581056-70', 2210, 'PNR', NULL),
	(405, 28, NULL, NULL, NULL, NULL, '0236', '10581056-71', 2210, 'PNR', NULL),
	(406, 28, NULL, NULL, NULL, NULL, '0236', '10581056-72', 2210, 'PNR', NULL),
	(407, 28, NULL, NULL, NULL, NULL, '0237', '10581056-73', 2210, 'PNR', NULL),
	(408, 29, NULL, NULL, NULL, NULL, 'PNR', '00000000-245', 52, '2211', NULL),
	(409, 29, NULL, NULL, NULL, NULL, 'PNR', '00000000-246', 52, '2211', NULL),
	(410, 29, NULL, NULL, NULL, NULL, 'PNR', '00000000-247', 52, '2211', NULL),
	(411, 29, NULL, NULL, NULL, NULL, 'PNR', '00000000-248', 52, '2211', NULL),
	(412, 29, NULL, NULL, NULL, NULL, 'PNR', '00000000-249', 52, '2211', NULL),
	(413, 29, 42, 10585021, NULL, NULL, 'PNR', '00000000-250', 52, '2211', NULL),
	(414, 29, 45, 10585021, NULL, NULL, 'PNR', '10582710-115', 557, '2211', NULL),
	(415, 29, 45, 10585021, NULL, NULL, 'PNR', '10582710-116', 557, '2211', NULL),
	(416, 29, 45, 10585021, NULL, NULL, 'PNR', '10582710-117', 557, '2211', NULL),
	(417, 29, 42, 10585021, NULL, NULL, 'PNR', '10582710-118', 557, '2211', NULL),
	(418, 29, 47, 10585021, NULL, NULL, 'PNR', '10582710-119', 557, '2211', NULL),
	(419, 29, 47, 10585021, NULL, NULL, 'PNR', '10582710-120', 557, '2211', NULL),
	(420, 29, 50, 10585261, NULL, NULL, 'PNR', '10582710-121', 557, '2211', NULL),
	(421, 29, 50, 10585261, NULL, NULL, 'PNR', '10582710-122', 557, '2211', NULL),
	(422, 29, 42, 10585021, NULL, NULL, 'PNR', '10582710-123', 557, '2211', NULL),
	(423, 29, 42, 10585021, NULL, NULL, 'PNR', '10582710-124', 557, '2211', NULL),
	(424, 29, 45, 10585021, NULL, NULL, 'PNR', '10582710-125', 558, '2211', NULL),
	(425, 29, 45, 10585021, NULL, NULL, 'PNR', '10582710-126', 558, '2211', NULL),
	(426, 29, 50, 10585261, NULL, NULL, 'PNR', '10582710-127', 558, '2211', NULL),
	(427, 29, 50, 10585261, NULL, NULL, 'PNR', '10582710-128', 558, '2211', NULL),
	(428, 29, 42, 10585021, NULL, NULL, 'PNR', '10582710-129', 558, '2211', NULL),
	(429, 29, 42, 10585021, NULL, NULL, 'PNR', '10582710-130', 558, '2211', NULL),
	(430, 29, 42, 10585021, NULL, NULL, 'PNR', '10582710-131', 558, '2211', NULL),
	(431, 29, 42, 10585021, NULL, NULL, 'PNR', '10582710-132', 558, '2211', NULL),
	(432, 29, 45, 10585021, NULL, NULL, 'PNR', '10582710-133', 558, '2211', NULL),
	(433, 29, 47, 10585021, NULL, NULL, 'PNR', '10582710-134', 559, '2211', NULL),
	(434, 29, 47, 10585021, NULL, NULL, 'PNR', '10582710-135', 559, '2211', NULL),
	(435, 29, 45, 10585021, NULL, NULL, 'PNR', '10582710-136', 559, '2211', NULL),
	(436, 29, 45, 10585021, NULL, NULL, 'PNR', '10582710-137', 559, '2211', NULL),
	(437, 29, 45, 10585021, NULL, NULL, 'PNR', '10582710-138', 559, '2211', NULL),
	(438, 29, 33, 10584469, NULL, NULL, 'PNR', '10582710-139', 559, '2211', NULL),
	(439, 29, 33, 10584469, NULL, NULL, 'PNR', '10582710-140', 559, '2211', NULL),
	(440, 30, 67, 10585505, NULL, NULL, '709848976', '34', NULL, NULL, NULL),
	(441, 30, 23, 10584321, NULL, NULL, '709848976', '28', NULL, NULL, NULL),
	(442, 31, 34, 10584314, NULL, NULL, 'I2-220927', '379', NULL, NULL, NULL),
	(443, 31, 34, 10584314, NULL, NULL, 'I2-220923', '050', NULL, NULL, NULL),
	(444, 31, 34, 10584314, NULL, NULL, 'I2-220923', '061', NULL, NULL, NULL),
	(445, 31, 34, 10584314, NULL, NULL, 'I2-220923', '040', NULL, NULL, NULL),
	(446, 31, 34, 10584314, NULL, NULL, 'I2-220923', '064', NULL, NULL, NULL),
	(447, 31, 34, 10584314, NULL, NULL, 'I2-220923', '056', NULL, NULL, NULL),
	(448, 31, 38, 10584646, NULL, NULL, 'I2-220923', '010', NULL, NULL, NULL),
	(449, 31, 34, 10584314, NULL, NULL, 'I2-220923', '042', NULL, NULL, NULL),
	(450, 31, 38, 10584646, NULL, NULL, 'I2-220923', '067', NULL, NULL, NULL),
	(451, 31, 34, 10584314, NULL, NULL, 'I2-220923', '057', NULL, NULL, NULL),
	(452, 31, 34, 10584314, NULL, NULL, 'I2-220923', '049', NULL, NULL, NULL),
	(453, 31, 34, 10584314, NULL, NULL, 'I2-220923', '058', NULL, NULL, NULL),
	(454, 31, 38, 10584646, NULL, NULL, 'I2-220923', '032', NULL, NULL, NULL),
	(455, 31, 38, 10584646, NULL, NULL, 'I2-220923', '022', NULL, NULL, NULL),
	(456, 31, 38, 10584646, NULL, NULL, 'I2-220923', '011', NULL, NULL, NULL),
	(457, 31, 34, 10584314, NULL, NULL, 'I2-220923', '065', NULL, NULL, NULL),
	(458, 32, 22, 10584321, NULL, NULL, 'I2-220923', '150', NULL, NULL, NULL),
	(459, 32, 22, 10584321, NULL, NULL, 'I2-220923', '154', NULL, NULL, NULL),
	(460, 32, 22, 10584321, NULL, NULL, 'I2-220923', '214', NULL, NULL, NULL),
	(461, 32, 22, 10584321, NULL, NULL, 'I2-220923', '095', NULL, NULL, NULL),
	(462, 32, 22, 10584321, NULL, NULL, 'I2-220923', '185', NULL, NULL, NULL),
	(463, 32, 22, 10584321, NULL, NULL, 'I2-220923', '183', NULL, NULL, NULL),
	(464, 32, 22, 10584321, NULL, NULL, 'I2-220923', '165', NULL, NULL, NULL),
	(465, 32, 22, 10584321, NULL, NULL, 'I2-220923', '152', NULL, NULL, NULL),
	(466, 32, 22, 10584321, NULL, NULL, 'I2-220923', '082', NULL, NULL, NULL),
	(467, 32, 22, 10584321, NULL, NULL, 'I2-220923', '171', NULL, NULL, NULL),
	(468, 32, 22, 10584321, NULL, NULL, 'I2-220923', '120', NULL, NULL, NULL),
	(469, 32, 22, 10584321, NULL, NULL, 'I2-220927', '303', NULL, NULL, NULL),
	(470, 32, 22, 10584321, NULL, NULL, 'I2-220927', '319', NULL, NULL, NULL),
	(471, 32, 22, 10584321, NULL, NULL, 'I2-220927', '323', NULL, NULL, NULL),
	(472, 32, 22, 10584321, NULL, NULL, 'I2-220927', '321', NULL, NULL, NULL),
	(473, 32, 22, 10584321, NULL, NULL, 'I2-220927', '276', NULL, NULL, NULL),
	(474, 33, 37, 10584314, NULL, NULL, 'I2-220925', '039', NULL, NULL, NULL),
	(475, 33, 37, 10584314, NULL, NULL, 'I2-220925', '050', NULL, NULL, NULL),
	(476, 33, 37, 10584314, NULL, NULL, 'I2-220925', '035', NULL, NULL, NULL),
	(477, 33, 38, 10584646, NULL, NULL, 'I2-220925', '045', NULL, NULL, NULL),
	(478, 33, 37, 10584314, NULL, NULL, 'I2-220925', '052', NULL, NULL, NULL),
	(479, 33, 38, 10584646, NULL, NULL, 'I2-220925', '048', NULL, NULL, NULL),
	(480, 33, 38, 10584646, NULL, NULL, 'I2-220925', '040', NULL, NULL, NULL),
	(481, 33, 38, 10584646, NULL, NULL, 'I2-220925', '037', NULL, NULL, NULL),
	(482, 33, 37, 10584314, NULL, NULL, 'I2-220925', '047', NULL, NULL, NULL),
	(483, 33, 37, 10584314, NULL, NULL, 'I2-220925', '041', NULL, NULL, NULL),
	(484, 33, 37, 10584314, NULL, NULL, 'I2-220925', '051', NULL, NULL, NULL),
	(485, 33, 37, 10584314, NULL, NULL, 'I2-220925', '043', NULL, NULL, NULL),
	(486, 33, 38, 10584646, NULL, NULL, 'I2-220925', '042', NULL, NULL, NULL),
	(487, 33, 38, 10584646, NULL, NULL, 'I2-220925', '054', NULL, NULL, NULL),
	(488, 33, 34, 10584314, NULL, NULL, 'I2-220925', '010', NULL, NULL, NULL),
	(489, 33, 38, 10584646, NULL, NULL, 'I2-220925', '087', NULL, NULL, NULL),
	(490, 34, 38, 10584646, NULL, NULL, 'I2-220925', '038', NULL, NULL, NULL),
	(491, 34, 40, 10584646, NULL, NULL, 'I2-220924', '051', NULL, NULL, NULL),
	(492, 34, 40, 10584646, NULL, NULL, 'I2-220924', '069', NULL, NULL, NULL),
	(493, 34, 38, 10584646, NULL, NULL, 'I2-220924', '047', NULL, NULL, NULL),
	(494, 34, 40, 10584646, NULL, NULL, 'I2-220924', '053', NULL, NULL, NULL),
	(495, 34, 38, 10584646, NULL, NULL, 'I2-220924', '070', NULL, NULL, NULL),
	(496, 34, 40, 10584646, NULL, NULL, 'I2-220924', '060', NULL, NULL, NULL),
	(497, 34, 37, 10584314, NULL, NULL, 'I2-220924', '061', NULL, NULL, NULL),
	(498, 34, 38, 10584646, NULL, NULL, 'I2-220924', '032', NULL, NULL, NULL),
	(499, 34, 40, 10584646, NULL, NULL, 'I2-220924', '079', NULL, NULL, NULL),
	(500, 34, 40, 10584646, NULL, NULL, 'I2-220924', '063', NULL, NULL, NULL),
	(501, 34, 40, 10584646, NULL, NULL, 'I2-220924', '041', NULL, NULL, NULL),
	(502, 34, 40, 10584646, NULL, NULL, 'I2-220924', '050', NULL, NULL, NULL),
	(503, 34, 40, 10584646, NULL, NULL, 'I2-220924', '068', NULL, NULL, NULL),
	(504, 34, 40, 10584646, NULL, NULL, 'I2-220924', '067', NULL, NULL, NULL),
	(505, 34, 37, 10584314, NULL, NULL, 'I2-220924', '049', NULL, NULL, NULL),
	(506, 35, 35, 10584756, NULL, NULL, '22JA00', '049', NULL, NULL, NULL),
	(507, 35, 35, 10584756, NULL, NULL, '22JA00', '048', NULL, NULL, NULL),
	(508, 35, 35, 10584756, NULL, NULL, '22JA00', '044', NULL, NULL, NULL),
	(509, 35, 35, 10584756, NULL, NULL, '22JA00', '047', NULL, NULL, NULL),
	(510, 35, 35, 10584756, NULL, NULL, '22JA00', '053', NULL, NULL, NULL),
	(511, 35, 35, 10584756, NULL, NULL, '22JA00', '045', NULL, NULL, NULL),
	(512, 35, 35, 10584756, NULL, NULL, '22JA00', '046', NULL, NULL, NULL),
	(513, 35, 35, 10584756, NULL, NULL, '22IA06', '731', NULL, NULL, NULL),
	(514, 35, 35, 10584756, NULL, NULL, '22IA06', '854', NULL, NULL, NULL),
	(515, 35, 35, 10584756, NULL, NULL, '22IA06', '857', NULL, NULL, NULL),
	(516, 35, 35, 10584756, NULL, NULL, '22IA06', '790', NULL, NULL, NULL),
	(517, 35, 35, 10584756, NULL, NULL, '22IA06', '850', NULL, NULL, NULL),
	(518, 35, 35, 10584756, NULL, NULL, '22IA06', '786', NULL, NULL, NULL),
	(519, 35, 35, 10584756, NULL, NULL, '22IA06', '822', NULL, NULL, NULL),
	(520, 35, 35, 10584756, NULL, NULL, '22IA06', '850', NULL, NULL, NULL),
	(521, 35, 35, 10584756, NULL, NULL, '22IA06', '790', NULL, NULL, NULL),
	(522, 35, 35, 10584756, NULL, NULL, '22IA06', '856', NULL, NULL, NULL),
	(523, 35, 35, 10584756, NULL, NULL, '22IA06', '855', NULL, NULL, NULL),
	(524, 35, 35, 10584756, NULL, NULL, '22IA06', '852', NULL, NULL, NULL),
	(525, 35, 35, 10584756, NULL, NULL, '22IA06', '579', NULL, NULL, NULL),
	(526, 36, 56, 10585261, NULL, NULL, 'PNR', '10582710-141', 559, '2211', NULL),
	(527, 36, 56, 10585261, NULL, NULL, 'PNR', '10582710-142', 559, '2211', NULL),
	(528, 36, 53, 10585261, NULL, NULL, 'PNR', '10582710-143', 559, '2211', NULL),
	(529, 36, 50, 10585261, NULL, NULL, 'PNR', '10582711-001', 561, '2211', NULL),
	(530, 36, 53, 10585261, NULL, NULL, 'PNR', '10582711-002', 561, '2211', NULL),
	(531, 36, 53, 10585261, NULL, NULL, 'PNR', '10582711-003', 561, '2211', NULL),
	(532, 36, 53, 10585261, NULL, NULL, 'PNR', '10582711-004', 561, '2211', NULL),
	(533, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-005', 561, '2211', NULL),
	(534, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-006', 562, '2211', NULL),
	(535, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-007', 562, '2211', NULL),
	(536, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-008', 562, '2211', NULL),
	(537, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-009', 562, '2211', NULL),
	(538, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-010', 562, '2211', NULL),
	(539, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-011', 562, '2211', NULL),
	(540, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-012', 562, '2211', NULL),
	(541, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-013', 562, '2211', NULL),
	(542, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-014', 563, '2211', NULL),
	(543, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-015', 563, '2211', NULL),
	(544, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-016', 563, '2211', NULL),
	(545, 36, 50, 10585261, NULL, NULL, 'PNR', '10582711-017', 564, '2211', NULL),
	(546, 36, 50, 10585261, NULL, NULL, 'PNR', '10582711-018', 564, '2211', NULL),
	(547, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-019', 564, '2211', NULL),
	(548, 36, 50, 10585261, NULL, NULL, 'PNR', '10582711-020', 565, '2211', NULL),
	(549, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-021', 565, '2211', NULL),
	(550, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-022', 565, '2211', NULL),
	(551, 36, 53, 10585261, NULL, NULL, 'PNR', '10582711-023', 565, '2211', NULL),
	(552, 36, 53, 10585261, NULL, NULL, 'PNR', '10582711-024', 565, '2211', NULL),
	(553, 36, 56, 10585261, NULL, NULL, 'PNR', '10582711-025', 565, '2211', NULL),
	(554, 36, 59, 10585261, NULL, NULL, 'PNR', '10582711-026', 565, '2211', NULL),
	(555, 36, 53, 10585261, NULL, NULL, 'PNR', '10582711-027', 565, '2211', NULL),
	(556, 36, 53, 10585261, NULL, NULL, 'PNR', '10582711-028', 565, '2211', NULL),
	(557, 36, 53, 10585261, NULL, NULL, 'PNR', '10582711-029', 565, '2211', NULL),
	(558, 37, 44, 10584943, NULL, NULL, '2255372', '63', NULL, NULL, NULL),
	(559, 37, 44, 10584943, NULL, NULL, '2255372', '66', NULL, NULL, NULL),
	(560, 37, 44, 10584943, NULL, NULL, '2255372', '67', NULL, NULL, NULL),
	(561, 37, 44, 10584943, NULL, NULL, '2255372', '70', NULL, NULL, NULL),
	(562, 37, 44, 10584943, NULL, NULL, '2255372', '62', NULL, NULL, NULL),
	(563, 37, 44, 10584943, NULL, NULL, '2255372', '64', NULL, NULL, NULL),
	(564, 37, 44, 10584943, NULL, NULL, '2255372', '69', NULL, NULL, NULL),
	(565, 37, 44, 10584943, NULL, NULL, '2255372', '60', NULL, NULL, NULL),
	(566, 37, 41, 10584943, NULL, NULL, '2255372', '71', NULL, NULL, NULL),
	(567, 37, 41, 10584943, NULL, NULL, '2255372', '74', NULL, NULL, NULL),
	(568, 37, 41, 10584943, NULL, NULL, '2255372', '75', NULL, NULL, NULL),
	(569, 37, 41, 10584943, NULL, NULL, '2255372', '73', NULL, NULL, NULL),
	(570, 37, 41, 10584943, NULL, NULL, '2255372', '61', NULL, NULL, NULL),
	(571, 37, 41, 10584943, NULL, NULL, '2255372', '68', NULL, NULL, NULL),
	(572, 37, 41, 10584943, NULL, NULL, '2255372', '65', NULL, NULL, NULL),
	(573, 37, 41, 10584943, NULL, NULL, '2255372', '72', NULL, NULL, NULL),
	(574, 38, 43, 10585061, NULL, NULL, '2255371', '13', NULL, NULL, NULL),
	(575, 38, 43, 10585061, NULL, NULL, '2255371', '14', NULL, NULL, NULL),
	(576, 38, 43, 10585061, NULL, NULL, '2255371', '11', NULL, NULL, NULL),
	(577, 38, 43, 10585061, NULL, NULL, '2255371', '08', NULL, NULL, NULL),
	(578, 38, 43, 10585061, NULL, NULL, '2255371', '12', NULL, NULL, NULL),
	(579, 38, 43, 10585061, NULL, NULL, '2255371', '01', NULL, NULL, NULL),
	(580, 38, 43, 10585061, NULL, NULL, '2255371', '06', NULL, NULL, NULL),
	(581, 38, 43, 10585061, NULL, NULL, '2255371', '48', NULL, NULL, NULL),
	(582, 38, NULL, NULL, NULL, NULL, '2255371', '02', NULL, NULL, NULL),
	(583, 38, NULL, NULL, NULL, NULL, '2255371', '04', NULL, NULL, NULL),
	(584, 38, NULL, NULL, NULL, NULL, '2255371', '05', NULL, NULL, NULL),
	(585, 38, NULL, NULL, NULL, NULL, '2255371', '03', NULL, NULL, NULL),
	(586, 38, 43, 10585061, NULL, NULL, '2255371', '07', NULL, NULL, NULL),
	(587, 38, NULL, NULL, NULL, NULL, '2255371', '09', NULL, NULL, NULL),
	(588, 38, 43, 10585061, NULL, NULL, '2255371', '10', NULL, NULL, NULL),
	(589, 38, NULL, NULL, NULL, NULL, '2255371', '49', NULL, NULL, NULL),
	(590, 39, 46, 10585061, NULL, NULL, '2255371', '034', NULL, NULL, NULL),
	(591, 39, 46, 10585061, NULL, NULL, '2255371', '042', NULL, NULL, NULL),
	(592, 39, NULL, NULL, NULL, NULL, '2255371', '033', NULL, NULL, NULL),
	(593, 39, NULL, NULL, NULL, NULL, '2255371', '039', NULL, NULL, NULL),
	(594, 39, 46, 10585061, NULL, NULL, '2255371', '038', NULL, NULL, NULL),
	(595, 39, 52, 10585201, NULL, NULL, '2255371', '037', NULL, NULL, NULL),
	(596, 39, 52, 10585201, NULL, NULL, '2255371', '040', NULL, NULL, NULL),
	(597, 39, 46, 10585061, NULL, NULL, '2255371', '036', NULL, NULL, NULL),
	(598, 39, 52, 10585201, NULL, NULL, '2255371', '035', NULL, NULL, NULL),
	(599, 39, 52, 10585201, NULL, NULL, '2255371', '041', NULL, NULL, NULL),
	(600, 39, 52, 10585201, NULL, NULL, '2255371', '043', NULL, NULL, NULL),
	(601, 39, 52, 10585201, NULL, NULL, '2255371', '031', NULL, NULL, NULL),
	(602, 39, 52, 10585201, NULL, NULL, '2255371', '044', NULL, NULL, NULL),
	(603, 39, 52, 10585201, NULL, NULL, '2255371', '046', NULL, NULL, NULL),
	(604, 39, NULL, NULL, NULL, NULL, '2255371', '047', NULL, NULL, NULL),
	(605, 39, NULL, NULL, NULL, NULL, '2255371', '045', NULL, NULL, NULL),
	(607, 40, NULL, NULL, NULL, NULL, '2255371', '29', NULL, NULL, NULL),
	(608, 40, NULL, NULL, NULL, NULL, '2255371', '30', NULL, NULL, NULL),
	(609, 40, NULL, NULL, NULL, NULL, '2255371', '20', NULL, NULL, NULL),
	(610, 40, NULL, NULL, NULL, NULL, '2255371', '25', NULL, NULL, NULL),
	(611, 40, NULL, NULL, NULL, NULL, '2255371', '26', NULL, NULL, NULL),
	(612, 40, NULL, NULL, NULL, NULL, '2255371', '27', NULL, NULL, NULL),
	(613, 40, NULL, NULL, NULL, NULL, '2255371', '22', NULL, NULL, NULL),
	(614, 40, NULL, NULL, NULL, NULL, '2255371', '28', NULL, NULL, NULL),
	(615, 40, NULL, NULL, NULL, NULL, '2255371', '18', NULL, NULL, NULL),
	(616, 40, NULL, NULL, NULL, NULL, '2255371', '15', NULL, NULL, NULL),
	(617, 40, NULL, NULL, NULL, NULL, '2255371', '17', NULL, NULL, NULL),
	(618, 40, NULL, NULL, NULL, NULL, '2255371', '21', NULL, NULL, NULL),
	(619, 40, NULL, NULL, NULL, NULL, '2255371', '19', NULL, NULL, NULL),
	(620, 40, NULL, NULL, NULL, NULL, '2255371', '24', NULL, NULL, NULL),
	(621, 40, NULL, NULL, NULL, NULL, '2255371', '16', NULL, NULL, NULL),
	(622, 40, NULL, NULL, NULL, NULL, '2255371', '23', NULL, NULL, NULL),
	(623, 41, 48, 10585122, NULL, NULL, 'I2-220926', '394', NULL, NULL, NULL),
	(624, 41, 48, 10585122, NULL, NULL, 'I2-220926', '396', NULL, NULL, NULL),
	(625, 41, 48, 10585122, NULL, NULL, 'I2-220926', '413', NULL, NULL, NULL),
	(626, 41, 48, 10585122, NULL, NULL, 'I2-220926', '400', NULL, NULL, NULL),
	(627, 41, 48, 10585122, NULL, NULL, 'I2-220926', '364', NULL, NULL, NULL),
	(628, 41, 49, 10585122, NULL, NULL, 'I2-220926', '377', NULL, NULL, NULL),
	(629, 41, 49, 10585122, NULL, NULL, 'I2-220926', '350', NULL, NULL, NULL),
	(630, 41, 49, 10585122, NULL, NULL, 'I2-220926', '371', NULL, NULL, NULL),
	(631, 41, 48, 10585122, NULL, NULL, 'I2-220926', '416', NULL, NULL, NULL),
	(632, 41, 48, 10585122, NULL, NULL, 'I2-220926', '362', NULL, NULL, NULL),
	(633, 41, 48, 10585122, NULL, NULL, 'I2-220925', '077', NULL, NULL, NULL),
	(634, 41, 48, 10585122, NULL, NULL, 'I2-220925', '204', NULL, NULL, NULL),
	(635, 41, 48, 10585122, NULL, NULL, 'I2-220925', '026', NULL, NULL, NULL),
	(636, 41, 48, 10585122, NULL, NULL, 'I2-220925', '018', NULL, NULL, NULL),
	(637, 41, 48, 10585122, NULL, NULL, 'I2-220925', '008', NULL, NULL, NULL),
	(638, 41, 49, 10585122, NULL, NULL, 'I2-220925', '004', NULL, NULL, NULL),
	(654, 42, 57, 10585203, 194, 3, 'I2-220926', '235', NULL, NULL, NULL),
	(655, 42, 57, 10585203, 194, 2, 'I2-220926', '240', NULL, NULL, NULL),
	(656, 42, 57, 10585203, NULL, NULL, 'I2-220926', '254', NULL, NULL, NULL),
	(657, 42, 57, 10585203, 194, 3, 'I2-220926', '255', NULL, NULL, NULL),
	(658, 42, 60, 10585203, NULL, NULL, 'I2-220926', '279', NULL, NULL, NULL),
	(659, 42, 60, 10585203, NULL, NULL, 'I2-220926', '150', NULL, NULL, NULL),
	(660, 42, 60, 10585203, 200, 1, 'I2-220926', '237', NULL, NULL, NULL),
	(661, 42, 54, 10585203, NULL, NULL, 'I2-220926', '292', NULL, NULL, NULL),
	(662, 42, 60, 10585203, NULL, NULL, 'I2-220923', '231', NULL, NULL, NULL),
	(663, 42, 60, 10585203, 200, 1, 'I2-220923', '212', NULL, NULL, NULL),
	(664, 42, 54, 10585203, 194, 2, 'I2-220923', '223', NULL, NULL, NULL),
	(665, 42, 54, 10585203, 194, 2, 'I2-220923', '184', NULL, NULL, NULL),
	(666, 42, 54, 10585203, 194, 1, 'I2-220923', '192', NULL, NULL, NULL),
	(667, 42, 57, 10585203, NULL, NULL, 'I2-220923', '210', NULL, NULL, NULL),
	(668, 42, 60, 10585203, NULL, NULL, 'I2-220924', '356', NULL, NULL, NULL),
	(669, 42, 57, 10585203, 194, 3, 'I2-220924', '353', NULL, NULL, NULL),
	(670, 43, 54, 10585203, 190, 3, 'I2-220926', '238', NULL, NULL, NULL),
	(671, 43, 51, 10585203, NULL, NULL, 'I2-220926', '252', NULL, NULL, NULL),
	(672, 43, 51, 10585203, 190, 1, 'I2-220926', '203', NULL, NULL, NULL),
	(673, 43, 51, 10585203, NULL, NULL, 'I2-220926', '414', NULL, NULL, NULL),
	(674, 43, 51, 10585203, NULL, NULL, 'I2-220926', '251', NULL, NULL, NULL),
	(675, 43, 51, 10585203, NULL, NULL, 'I2-220926', '256', NULL, NULL, NULL),
	(676, 43, 54, 10585203, 190, 2, 'I2-220926', '233', NULL, NULL, NULL),
	(677, 43, 54, 10585203, NULL, NULL, 'I2-220926', '262', NULL, NULL, NULL),
	(678, 43, 54, 10585203, 190, 2, 'I2-220926', '232', NULL, NULL, NULL),
	(679, 43, 51, 10585203, 190, 1, 'I2-220926', '219', NULL, NULL, NULL),
	(680, 43, 51, 10585203, 194, 1, 'I2-220926', '253', NULL, NULL, NULL),
	(681, 43, 51, 10585203, 190, 1, 'I2-220926', '191', NULL, NULL, NULL),
	(682, 43, 54, 10585203, 190, 3, 'I2-220926', '417', NULL, NULL, NULL),
	(683, 43, 51, 10585203, 194, 1, 'I2-220926', '239', NULL, NULL, NULL),
	(684, 43, 51, 10585203, 190, 3, 'I2-220923', '201', NULL, NULL, NULL),
	(685, 43, 54, 10585203, 190, 2, 'I2-220923', '213', NULL, NULL, NULL),
	(686, 44, NULL, NULL, NULL, NULL, '2255372', '77', NULL, NULL, NULL),
	(687, 44, NULL, NULL, NULL, NULL, '2255372', '76', NULL, NULL, NULL),
	(688, 44, NULL, NULL, NULL, NULL, '2255372', '79', NULL, NULL, NULL),
	(689, 44, NULL, NULL, NULL, NULL, '2255372', '78', NULL, NULL, NULL),
	(690, 44, NULL, NULL, NULL, NULL, '2255372', '80', NULL, NULL, NULL),
	(691, 44, NULL, NULL, NULL, NULL, '2255372', '81', NULL, NULL, NULL),
	(692, 44, NULL, NULL, NULL, NULL, '2255372', '83', NULL, NULL, NULL),
	(693, 44, NULL, NULL, NULL, NULL, '2255372', '84', NULL, NULL, NULL),
	(694, 44, NULL, NULL, NULL, NULL, '2255372', '82', NULL, NULL, NULL),
	(695, 44, NULL, NULL, NULL, NULL, '2255372', '87', NULL, NULL, NULL),
	(696, 44, NULL, NULL, NULL, NULL, '2255372', '85', NULL, NULL, NULL),
	(697, 44, NULL, NULL, NULL, NULL, '2255372', '86', NULL, NULL, NULL),
	(698, 44, NULL, NULL, NULL, NULL, '2255372', '88', NULL, NULL, NULL),
	(699, 44, NULL, NULL, NULL, NULL, '2255372', '89', NULL, NULL, NULL),
	(700, 44, NULL, NULL, NULL, NULL, '2255372', '90', NULL, NULL, NULL),
	(701, 44, NULL, NULL, NULL, NULL, '2255372', '32', NULL, NULL, NULL),
	(702, 45, NULL, NULL, NULL, NULL, '2255373', '78', NULL, NULL, NULL),
	(703, 45, NULL, NULL, NULL, NULL, '2255373', '61', NULL, NULL, NULL),
	(704, 45, NULL, NULL, NULL, NULL, '2255373', '71', NULL, NULL, NULL),
	(705, 45, NULL, NULL, NULL, NULL, '2255373', '70', NULL, NULL, NULL),
	(706, 45, NULL, NULL, NULL, NULL, '2255373', '72', NULL, NULL, NULL),
	(707, 45, NULL, NULL, NULL, NULL, '2255373', '77', NULL, NULL, NULL),
	(708, 45, NULL, NULL, NULL, NULL, '2255373', '75', NULL, NULL, NULL),
	(709, 45, NULL, NULL, NULL, NULL, '2255373', '73', NULL, NULL, NULL),
	(710, 45, NULL, NULL, NULL, NULL, '2255373', '74', NULL, NULL, NULL),
	(711, 45, NULL, NULL, NULL, NULL, '2255373', '66', NULL, NULL, NULL),
	(712, 45, NULL, NULL, NULL, NULL, '2255373', '65', NULL, NULL, NULL),
	(713, 45, NULL, NULL, NULL, NULL, '2255373', '67', NULL, NULL, NULL),
	(714, 45, NULL, NULL, NULL, NULL, '2255373', '64', NULL, NULL, NULL),
	(715, 45, NULL, NULL, NULL, NULL, '2255373', '69', NULL, NULL, NULL),
	(716, 45, NULL, NULL, NULL, NULL, '2255373', '68', NULL, NULL, NULL),
	(717, 45, NULL, NULL, NULL, NULL, '2255373', '76', NULL, NULL, NULL),
	(718, 46, NULL, NULL, NULL, NULL, '2255373', '88', NULL, NULL, NULL),
	(719, 46, NULL, NULL, NULL, NULL, '2255373', '89', NULL, NULL, NULL),
	(720, 46, NULL, NULL, NULL, NULL, '2255373', '84', NULL, NULL, NULL),
	(721, 46, NULL, NULL, NULL, NULL, '2255373', '85', NULL, NULL, NULL),
	(722, 46, NULL, NULL, NULL, NULL, '2255373', '86', NULL, NULL, NULL),
	(723, 46, NULL, NULL, NULL, NULL, '2255373', '87', NULL, NULL, NULL),
	(724, 46, NULL, NULL, NULL, NULL, '2255373', '90', NULL, NULL, NULL),
	(725, 46, NULL, NULL, NULL, NULL, '2255373', '22', NULL, NULL, NULL),
	(726, 46, NULL, NULL, NULL, NULL, '2255373', '24', NULL, NULL, NULL),
	(727, 46, NULL, NULL, NULL, NULL, '2255373', '27', NULL, NULL, NULL),
	(728, 46, NULL, NULL, NULL, NULL, '2255373', '29', NULL, NULL, NULL),
	(729, 46, NULL, NULL, NULL, NULL, '2255373', '25', NULL, NULL, NULL),
	(730, 46, NULL, NULL, NULL, NULL, '2255373', '23', NULL, NULL, NULL),
	(731, 46, NULL, NULL, NULL, NULL, '2255373', '30', NULL, NULL, NULL),
	(732, 46, NULL, NULL, NULL, NULL, '2255373', '26', NULL, NULL, NULL),
	(733, 46, NULL, NULL, NULL, NULL, '2255373', '28', NULL, NULL, NULL),
	(734, 47, NULL, NULL, NULL, NULL, '2255373', '80', NULL, NULL, NULL),
	(735, 47, NULL, NULL, NULL, NULL, '2255373', '79', NULL, NULL, NULL),
	(736, 47, NULL, NULL, NULL, NULL, '2255373', '82', NULL, NULL, NULL),
	(737, 47, NULL, NULL, NULL, NULL, '2255373', '83', NULL, NULL, NULL),
	(738, 47, NULL, NULL, NULL, NULL, '2255373', '81', NULL, NULL, NULL),
	(739, 47, NULL, NULL, NULL, NULL, '2255372', '4', NULL, NULL, NULL),
	(740, 47, NULL, NULL, NULL, NULL, '2255372', '5', NULL, NULL, NULL),
	(741, 47, NULL, NULL, NULL, NULL, '2255372', '1', NULL, NULL, NULL),
	(742, 47, NULL, NULL, NULL, NULL, '2255372', '2', NULL, NULL, NULL),
	(743, 47, NULL, NULL, NULL, NULL, '2255372', '7', NULL, NULL, NULL),
	(744, 47, NULL, NULL, NULL, NULL, '2255372', '6', NULL, NULL, NULL),
	(745, 47, NULL, NULL, NULL, NULL, '2255372', '8', NULL, NULL, NULL),
	(746, 47, NULL, NULL, NULL, NULL, '2255372', '9', NULL, NULL, NULL),
	(747, 47, NULL, NULL, NULL, NULL, '2255372', '3', NULL, NULL, NULL),
	(748, 47, NULL, NULL, NULL, NULL, '2255372', '10', NULL, NULL, NULL),
	(749, 47, NULL, NULL, NULL, NULL, '2255372', '11', NULL, NULL, NULL),
	(750, 48, 39, 10584314, NULL, NULL, 'I2-220927', '462', NULL, NULL, NULL),
	(751, 48, 48, 10585122, NULL, NULL, 'I2-220918', '188', NULL, NULL, NULL),
	(752, 48, 48, 10585122, NULL, NULL, 'I2-220919', '021', NULL, NULL, NULL),
	(753, 48, 48, 10585122, NULL, NULL, 'I2-220925', '140', NULL, NULL, NULL),
	(754, 48, 48, 10585122, NULL, NULL, 'I2-220925', '126', NULL, NULL, NULL),
	(755, 48, 48, 10585122, NULL, NULL, 'I2-220925', '119', NULL, NULL, NULL),
	(756, 48, 48, 10585122, NULL, NULL, 'I2-220925', '125', NULL, NULL, NULL),
	(757, 48, 48, 10585122, NULL, NULL, 'I2-220925', '132', NULL, NULL, NULL),
	(758, 48, 39, 10584314, NULL, NULL, 'I2-220925', '143', NULL, NULL, NULL),
	(759, 48, 39, 10584314, NULL, NULL, 'I2-220925', '134', NULL, NULL, NULL),
	(760, 48, 39, 10584314, NULL, NULL, 'I2-220925', '139', NULL, NULL, NULL),
	(761, 48, 39, 10584314, NULL, NULL, 'I2-220925', '131', NULL, NULL, NULL),
	(762, 48, 39, 10584314, NULL, NULL, 'I2-220925', '129', NULL, NULL, NULL),
	(763, 48, 40, 10584646, NULL, NULL, 'I2-220925', '133', NULL, NULL, NULL),
	(764, 48, 40, 10584646, NULL, NULL, 'I2-220925', '135', NULL, NULL, NULL),
	(765, 48, 48, 10585122, NULL, NULL, 'I2-220925', '138', NULL, NULL, NULL),
	(766, 49, NULL, NULL, NULL, NULL, '2255373', '32', NULL, NULL, NULL),
	(767, 49, NULL, NULL, NULL, NULL, '2255373', '38', NULL, NULL, NULL),
	(768, 49, NULL, NULL, NULL, NULL, '2255373', '39', NULL, NULL, NULL),
	(769, 49, NULL, NULL, NULL, NULL, '2255373', '40', NULL, NULL, NULL),
	(770, 49, NULL, NULL, NULL, NULL, '2255373', '41', NULL, NULL, NULL),
	(771, 49, NULL, NULL, NULL, NULL, '2255373', '43', NULL, NULL, NULL),
	(772, 49, NULL, NULL, NULL, NULL, '2255373', '44', NULL, NULL, NULL),
	(773, 49, NULL, NULL, NULL, NULL, '2255373', '36', NULL, NULL, NULL),
	(774, 49, NULL, NULL, NULL, NULL, '2255373', '63', NULL, NULL, NULL),
	(775, 49, NULL, NULL, NULL, NULL, '2255373', '34', NULL, NULL, NULL),
	(776, 49, NULL, NULL, NULL, NULL, '2255373', '35', NULL, NULL, NULL),
	(777, 49, NULL, NULL, NULL, NULL, '2255373', '62', NULL, NULL, NULL),
	(778, 49, NULL, NULL, NULL, NULL, '2255373', '33', NULL, NULL, NULL),
	(779, 49, NULL, NULL, NULL, NULL, '2255373', '37', NULL, NULL, NULL),
	(780, 49, NULL, NULL, NULL, NULL, '2255373', '31', NULL, NULL, NULL),
	(781, 49, NULL, NULL, NULL, NULL, '2255373', '42', NULL, NULL, NULL),
	(782, 50, NULL, NULL, NULL, NULL, '2255373', '51', NULL, NULL, NULL),
	(783, 50, NULL, NULL, NULL, NULL, '2255373', '54', NULL, NULL, NULL),
	(784, 50, NULL, NULL, NULL, NULL, '2255373', '56', NULL, NULL, NULL),
	(785, 50, NULL, NULL, NULL, NULL, '2255373', '57', NULL, NULL, NULL),
	(786, 50, NULL, NULL, NULL, NULL, '2255373', '59', NULL, NULL, NULL),
	(787, 50, NULL, NULL, NULL, NULL, '2255373', '60', NULL, NULL, NULL),
	(788, 50, NULL, NULL, NULL, NULL, '2255373', '58', NULL, NULL, NULL),
	(789, 50, NULL, NULL, NULL, NULL, '2255373', '53', NULL, NULL, NULL),
	(790, 50, NULL, NULL, NULL, NULL, '2255373', '45', NULL, NULL, NULL),
	(791, 50, NULL, NULL, NULL, NULL, '2255373', '46', NULL, NULL, NULL),
	(792, 50, NULL, NULL, NULL, NULL, '2255373', '47', NULL, NULL, NULL),
	(793, 50, NULL, NULL, NULL, NULL, '2255373', '48', NULL, NULL, NULL),
	(794, 50, NULL, NULL, NULL, NULL, '2255373', '49', NULL, NULL, NULL),
	(795, 50, NULL, NULL, NULL, NULL, '2255373', '50', NULL, NULL, NULL),
	(796, 50, NULL, NULL, NULL, NULL, '2255373', '52', NULL, NULL, NULL),
	(797, 50, NULL, NULL, NULL, NULL, '2255373', '55', NULL, NULL, NULL),
	(798, 51, NULL, NULL, NULL, NULL, 'CS5241122', '0075', NULL, NULL, NULL),
	(799, 51, NULL, NULL, NULL, NULL, 'CS5241122', '0031', NULL, NULL, NULL),
	(800, 51, NULL, NULL, NULL, NULL, 'CS5171122', '0166', NULL, NULL, NULL),
	(801, 51, NULL, NULL, NULL, NULL, 'CS5171122', '0032', NULL, NULL, NULL),
	(802, 51, NULL, NULL, NULL, NULL, 'CS5171122', '0030', NULL, NULL, NULL),
	(803, 51, NULL, NULL, NULL, NULL, 'CS5171122', '0063', NULL, NULL, NULL),
	(804, 51, NULL, NULL, NULL, NULL, 'CS5171122', '0167', NULL, NULL, NULL),
	(805, 51, NULL, NULL, NULL, NULL, 'CS5171122', '0023', NULL, NULL, NULL),
	(806, 51, NULL, NULL, NULL, NULL, 'CS5171122', '0074', NULL, NULL, NULL),
	(807, 51, NULL, NULL, NULL, NULL, 'CS5171122', '0029', NULL, NULL, NULL),
	(808, 51, 55, 10585202, NULL, NULL, 'CS5171122', '0168', NULL, NULL, NULL),
	(809, 51, 55, 10585202, NULL, NULL, 'CS5171122', '0022', NULL, NULL, NULL),
	(810, 51, 55, 10585202, NULL, NULL, 'CS5171122', '0049', NULL, NULL, NULL),
	(811, 51, 55, 10585202, NULL, NULL, 'CS5171122', '0055', NULL, NULL, NULL),
	(812, 51, 55, 10585202, NULL, NULL, 'CS5171122', '0056', NULL, NULL, NULL),
	(813, 51, 55, 10585202, NULL, NULL, 'CS5171122', '0050', NULL, NULL, NULL),
	(814, 51, 55, 10585202, NULL, NULL, 'CS5171122', '0043', NULL, NULL, NULL),
	(815, 51, 55, 10585202, NULL, NULL, 'CS5171122', '0035', NULL, NULL, NULL),
	(816, 51, 55, 10585202, NULL, NULL, 'CS5171122', '0036', NULL, NULL, NULL),
	(817, 51, 55, 10585202, NULL, NULL, 'CS5171122', '0044', NULL, NULL, NULL),
	(818, 52, 55, 10585202, NULL, NULL, 'CS5171122', '0351', NULL, NULL, NULL),
	(819, 52, 55, 10585202, NULL, NULL, 'CS5171122', '0323', NULL, NULL, NULL),
	(820, 52, 55, 10585202, NULL, NULL, 'CS5171122', '0342', NULL, NULL, NULL),
	(821, 52, 55, 10585202, NULL, NULL, 'CS5171122', '0327', NULL, NULL, NULL),
	(822, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0242', NULL, NULL, NULL),
	(823, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0271', NULL, NULL, NULL),
	(824, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0232', NULL, NULL, NULL),
	(825, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0245', NULL, NULL, NULL),
	(826, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0269', NULL, NULL, NULL),
	(827, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0272', NULL, NULL, NULL),
	(828, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0264', NULL, NULL, NULL),
	(829, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0249', NULL, NULL, NULL),
	(830, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0248', NULL, NULL, NULL),
	(831, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0250', NULL, NULL, NULL),
	(832, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0244', NULL, NULL, NULL),
	(833, 52, 61, 10585202, NULL, NULL, 'CS5171122', '0270', NULL, NULL, NULL),
	(834, 52, 64, 10585202, NULL, NULL, 'CS5171122', '0336', NULL, NULL, NULL),
	(835, 52, 64, 10585202, NULL, NULL, 'CS5171122', '0335', NULL, NULL, NULL),
	(836, 52, 64, 10585202, NULL, NULL, 'CS5171122', '0251', NULL, NULL, NULL),
	(837, 52, 64, 10585202, NULL, NULL, 'CS5171122', '0347', NULL, NULL, NULL),
	(838, 53, 64, 10585202, NULL, NULL, 'CS5171122', '0252', NULL, NULL, NULL),
	(839, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0268', NULL, NULL, NULL),
	(840, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0253', NULL, NULL, NULL),
	(841, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0243', NULL, NULL, NULL),
	(842, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0267', NULL, NULL, NULL),
	(843, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0256', NULL, NULL, NULL),
	(844, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0247', NULL, NULL, NULL),
	(845, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0265', NULL, NULL, NULL),
	(846, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0236', NULL, NULL, NULL),
	(847, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0237', NULL, NULL, NULL),
	(848, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0238', NULL, NULL, NULL),
	(849, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0241', NULL, NULL, NULL),
	(850, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0246', NULL, NULL, NULL),
	(851, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0262', NULL, NULL, NULL),
	(852, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0235', NULL, NULL, NULL),
	(853, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0276', NULL, NULL, NULL),
	(854, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0239', NULL, NULL, NULL),
	(855, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0266', NULL, NULL, NULL),
	(856, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0240', NULL, NULL, NULL),
	(857, 53, NULL, NULL, NULL, NULL, 'CS5171122', '0230', NULL, NULL, NULL),
	(858, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0072', NULL, NULL, NULL),
	(859, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0069', NULL, NULL, NULL),
	(860, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0070', NULL, NULL, NULL),
	(861, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0071', NULL, NULL, NULL),
	(862, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0054', NULL, NULL, NULL),
	(863, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0068', NULL, NULL, NULL),
	(864, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0060', NULL, NULL, NULL),
	(865, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0073', NULL, NULL, NULL),
	(866, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0059', NULL, NULL, NULL),
	(867, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0064', NULL, NULL, NULL),
	(868, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0053', NULL, NULL, NULL),
	(869, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0067', NULL, NULL, NULL),
	(870, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0155', NULL, NULL, NULL),
	(871, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0153', NULL, NULL, NULL),
	(872, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0080', NULL, NULL, NULL),
	(873, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0156', NULL, NULL, NULL),
	(874, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0154', NULL, NULL, NULL),
	(875, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0149', NULL, NULL, NULL),
	(876, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0078', NULL, NULL, NULL),
	(877, 54, NULL, NULL, NULL, NULL, 'CS5241122', '0076', NULL, NULL, NULL),
	(878, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0526', NULL, NULL, NULL),
	(879, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0538', NULL, NULL, NULL),
	(880, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0568', NULL, NULL, NULL),
	(881, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0508', NULL, NULL, NULL),
	(882, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0532', NULL, NULL, NULL),
	(883, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0534', NULL, NULL, NULL),
	(884, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0522', NULL, NULL, NULL),
	(885, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0542', NULL, NULL, NULL),
	(886, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0506', NULL, NULL, NULL),
	(887, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0505', NULL, NULL, NULL),
	(888, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0535', NULL, NULL, NULL),
	(889, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0517', NULL, NULL, NULL),
	(890, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0528', NULL, NULL, NULL),
	(891, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0537', NULL, NULL, NULL),
	(892, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0590', NULL, NULL, NULL),
	(893, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0540', NULL, NULL, NULL),
	(894, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0524', NULL, NULL, NULL),
	(895, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0512', NULL, NULL, NULL),
	(896, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0521', NULL, NULL, NULL),
	(897, 55, NULL, NULL, NULL, NULL, 'CS5221122', '0530', NULL, NULL, NULL),
	(898, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0529', NULL, NULL, NULL),
	(899, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0527', NULL, NULL, NULL),
	(900, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0500', NULL, NULL, NULL),
	(901, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0587', NULL, NULL, NULL),
	(902, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0511', NULL, NULL, NULL),
	(903, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0514', NULL, NULL, NULL),
	(904, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0589', NULL, NULL, NULL),
	(905, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0515', NULL, NULL, NULL),
	(906, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0499', NULL, NULL, NULL),
	(907, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0516', NULL, NULL, NULL),
	(908, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0595', NULL, NULL, NULL),
	(909, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0505', NULL, NULL, NULL),
	(910, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0497', NULL, NULL, NULL),
	(911, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0502', NULL, NULL, NULL),
	(912, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0520', NULL, NULL, NULL),
	(913, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0494', NULL, NULL, NULL),
	(914, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0523', NULL, NULL, NULL),
	(915, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0496', NULL, NULL, NULL),
	(916, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0503', NULL, NULL, NULL),
	(917, 56, NULL, NULL, NULL, NULL, 'CS5221122', '0504', NULL, NULL, NULL),
	(918, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0548', NULL, NULL, NULL),
	(919, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0571', NULL, NULL, NULL),
	(920, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0574', NULL, NULL, NULL),
	(921, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0585', NULL, NULL, NULL),
	(922, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0579', NULL, NULL, NULL),
	(923, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0572', NULL, NULL, NULL),
	(924, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0539', NULL, NULL, NULL),
	(925, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0583', NULL, NULL, NULL),
	(926, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0551', NULL, NULL, NULL),
	(927, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0586', NULL, NULL, NULL),
	(928, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0543', NULL, NULL, NULL),
	(929, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0552', NULL, NULL, NULL),
	(930, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0519', NULL, NULL, NULL),
	(931, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0525', NULL, NULL, NULL),
	(932, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0560', NULL, NULL, NULL),
	(933, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0573', NULL, NULL, NULL),
	(934, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0554', NULL, NULL, NULL),
	(935, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0533', NULL, NULL, NULL),
	(936, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0564', NULL, NULL, NULL),
	(937, 57, NULL, NULL, NULL, NULL, 'CS5221122', '0556', NULL, NULL, NULL),
	(938, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0498', NULL, NULL, NULL),
	(939, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0507', NULL, NULL, NULL),
	(940, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0493', NULL, NULL, NULL),
	(941, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0501', NULL, NULL, NULL),
	(942, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0510', NULL, NULL, NULL),
	(943, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0325', NULL, NULL, NULL),
	(944, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0492', NULL, NULL, NULL),
	(945, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0491', NULL, NULL, NULL),
	(946, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0331', NULL, NULL, NULL),
	(947, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0352', NULL, NULL, NULL),
	(948, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0334', NULL, NULL, NULL),
	(949, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0343', NULL, NULL, NULL),
	(950, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0353', NULL, NULL, NULL),
	(951, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0358', NULL, NULL, NULL),
	(952, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0367', NULL, NULL, NULL),
	(953, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0366', NULL, NULL, NULL),
	(954, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0345', NULL, NULL, NULL),
	(955, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0389', NULL, NULL, NULL),
	(956, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0340', NULL, NULL, NULL),
	(957, 58, NULL, NULL, NULL, NULL, 'CS5221122', '0337', NULL, NULL, NULL),
	(958, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0028', NULL, NULL, NULL),
	(959, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0042', NULL, NULL, NULL),
	(960, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0006', NULL, NULL, NULL),
	(961, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0019', NULL, NULL, NULL),
	(962, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0014', NULL, NULL, NULL),
	(963, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0020', NULL, NULL, NULL),
	(964, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0026', NULL, NULL, NULL),
	(965, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0005', NULL, NULL, NULL),
	(966, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0013', NULL, NULL, NULL),
	(967, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0027', NULL, NULL, NULL),
	(968, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0024', NULL, NULL, NULL),
	(969, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0018', NULL, NULL, NULL),
	(970, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0025', NULL, NULL, NULL),
	(971, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0017', NULL, NULL, NULL),
	(972, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0007', NULL, NULL, NULL),
	(973, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0015', NULL, NULL, NULL),
	(974, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0019', NULL, NULL, NULL),
	(975, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0021', NULL, NULL, NULL),
	(976, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0033', NULL, NULL, NULL),
	(977, 59, NULL, NULL, NULL, NULL, 'CS5241122', '0041', NULL, NULL, NULL),
	(978, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0518', NULL, NULL, NULL),
	(979, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0544', NULL, NULL, NULL),
	(980, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0545', NULL, NULL, NULL),
	(981, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0546', NULL, NULL, NULL),
	(982, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0547', NULL, NULL, NULL),
	(983, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0550', NULL, NULL, NULL),
	(984, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0557', NULL, NULL, NULL),
	(985, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0566', NULL, NULL, NULL),
	(986, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0570', NULL, NULL, NULL),
	(987, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0577', NULL, NULL, NULL),
	(988, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0581', NULL, NULL, NULL),
	(989, 60, NULL, NULL, NULL, NULL, 'CS5221122', '0588', NULL, NULL, NULL),
	(990, 60, NULL, NULL, NULL, NULL, 'CS5241122', '0001', NULL, NULL, NULL),
	(991, 60, NULL, NULL, NULL, NULL, 'CS5241122', '0002', NULL, NULL, NULL),
	(992, 60, NULL, NULL, NULL, NULL, 'CS5241122', '0003', NULL, NULL, NULL),
	(993, 60, NULL, NULL, NULL, NULL, 'CS5241122', '0004', NULL, NULL, NULL),
	(994, 60, NULL, NULL, NULL, NULL, 'CS5241122', '0009', NULL, NULL, NULL),
	(995, 60, NULL, NULL, NULL, NULL, 'CS5241122', '0010', NULL, NULL, NULL),
	(996, 60, NULL, NULL, NULL, NULL, 'CS5241122', '0011', NULL, NULL, NULL),
	(997, 60, NULL, NULL, NULL, NULL, 'CS5241122', '0012', NULL, NULL, NULL),
	(998, 61, 59, 10585261, NULL, NULL, 'PNR', '10583011-32', 566, '2211', NULL),
	(999, 61, 59, 10585261, NULL, NULL, 'PNR', '10583011-33', 566, '2211', NULL),
	(1000, 61, 59, 10585261, NULL, NULL, 'PNR', '10583011-34', 566, '2211', NULL),
	(1001, 61, 59, 10585261, NULL, NULL, 'PNR', '10583011-35', 566, '2211', NULL),
	(1002, 61, 59, 10585261, NULL, NULL, 'PNR', '10583011-36', 566, '2211', NULL),
	(1003, 61, 59, 10585261, NULL, NULL, 'PNR', '10583011-37', 566, '2211', NULL),
	(1004, 61, 59, 10585261, NULL, NULL, 'PNR', '10583011-38', 566, '2211', NULL),
	(1005, 61, 59, 10585261, NULL, NULL, 'PNR', '10583011-39', 566, '2211', NULL),
	(1006, 61, 59, 10585261, NULL, NULL, 'PNR', '10583787-01', 581, '2212', NULL),
	(1007, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-02', 581, '2212', NULL),
	(1008, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-03', 581, '2212', NULL),
	(1009, 61, NULL, NULL, NULL, NULL, 'PNR', '10583787-04', 581, '2212', NULL),
	(1010, 61, NULL, NULL, NULL, NULL, 'PNR', '10583787-05', 581, '2212', NULL),
	(1011, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-06', 581, '2212', NULL),
	(1012, 61, NULL, NULL, NULL, NULL, 'PNR', '10583787-07', 581, '2212', NULL),
	(1013, 61, NULL, NULL, NULL, NULL, 'PNR', '10583787-08', 582, '2212', NULL),
	(1014, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-09', 582, '2212', NULL),
	(1015, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-10', 582, '2212', NULL),
	(1016, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-11', 582, '2212', NULL),
	(1017, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-12', 582, '2212', NULL),
	(1018, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-13', 582, '2212', NULL),
	(1019, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-14', 582, '2212', NULL),
	(1020, 61, NULL, NULL, NULL, NULL, 'PNR', '10583787-15', 582, '2212', NULL),
	(1021, 61, NULL, NULL, NULL, NULL, 'PNR', '10583787-16', 582, '2212', NULL),
	(1022, 61, NULL, NULL, NULL, NULL, 'PNR', '10583787-17', 583, '2212', NULL),
	(1023, 61, NULL, NULL, NULL, NULL, 'PNR', '10583787-18', 583, '2212', NULL),
	(1024, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-19', 583, '2212', NULL),
	(1025, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-20', 583, '2212', NULL),
	(1026, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-21', 583, '2212', NULL),
	(1027, 61, 62, 10585261, NULL, NULL, 'PNR', '10583787-22', 583, '2212', NULL),
	(1028, 61, NULL, NULL, NULL, NULL, 'PNR', '10583787-23', 583, '2212', NULL),
	(1029, 61, NULL, NULL, NULL, NULL, 'PNR', '10583787-24', 583, '2212', NULL),
	(1030, 62, 63, 10585203, NULL, NULL, 'H1-221001', '072', NULL, NULL, NULL),
	(1031, 62, 63, 10585203, NULL, NULL, 'H1-221001', '069', NULL, NULL, NULL),
	(1032, 62, 60, 10585203, NULL, NULL, 'H1-221001', '060', NULL, NULL, NULL),
	(1033, 62, 60, 10585203, NULL, NULL, 'H1-221001', '118', NULL, NULL, NULL),
	(1034, 62, 63, 10585203, NULL, NULL, 'H1-221001', '059', NULL, NULL, NULL),
	(1035, 62, 63, 10585203, NULL, NULL, 'H1-221001', '075', NULL, NULL, NULL),
	(1036, 62, 63, 10585203, NULL, NULL, 'H1-221001', '053', NULL, NULL, NULL),
	(1037, 62, 63, 10585203, NULL, NULL, 'H1-221001', '076', NULL, NULL, NULL),
	(1038, 62, 63, 10585203, NULL, NULL, 'H1-221001', '079', NULL, NULL, NULL),
	(1039, 62, 63, 10585203, NULL, NULL, 'H1-221001', '105', NULL, NULL, NULL),
	(1040, 62, 65, 10585503, NULL, NULL, 'H1-221001', '065', NULL, NULL, NULL),
	(1041, 62, 65, 10585503, NULL, NULL, 'H1-221001', '110', NULL, NULL, NULL),
	(1042, 62, 60, 10585203, 200, 1, 'H1-221001', '127', NULL, NULL, NULL),
	(1043, 62, 60, 10585203, NULL, NULL, 'H1-221001', '126', NULL, NULL, NULL),
	(1046, 62, 63, 10585203, NULL, NULL, 'H1-221001', '068', NULL, NULL, NULL),
	(1047, 62, 63, 10585203, NULL, NULL, 'H1-221001', '065', NULL, NULL, NULL),
	(1048, 63, NULL, NULL, NULL, NULL, 'H1-220930', '097', NULL, NULL, NULL),
	(1049, 63, NULL, NULL, NULL, NULL, 'H1-220930', '094', NULL, NULL, NULL),
	(1050, 63, NULL, NULL, NULL, NULL, 'H1-220930', '170', NULL, NULL, NULL),
	(1051, 63, NULL, NULL, NULL, NULL, 'H1-220930', '167', NULL, NULL, NULL),
	(1052, 63, NULL, NULL, NULL, NULL, 'H1-220930', '106', NULL, NULL, NULL),
	(1053, 63, NULL, NULL, NULL, NULL, 'H1-220930', '159', NULL, NULL, NULL),
	(1054, 63, 66, 10585505, NULL, NULL, 'H1-220930', '179', NULL, NULL, NULL),
	(1055, 63, 66, 10585505, NULL, NULL, 'H1-220930', '165', NULL, NULL, NULL),
	(1056, 63, NULL, NULL, NULL, NULL, 'H1-220930', '108', NULL, NULL, NULL),
	(1057, 63, NULL, NULL, NULL, NULL, 'H1-220930', '105', NULL, NULL, NULL),
	(1058, 63, NULL, NULL, NULL, NULL, 'H1-220930', '109', NULL, NULL, NULL),
	(1059, 63, NULL, NULL, NULL, NULL, 'H1-220930', '162', NULL, NULL, NULL),
	(1060, 63, NULL, NULL, NULL, NULL, 'H1-220930', '112', NULL, NULL, NULL),
	(1061, 63, NULL, NULL, NULL, NULL, 'H1-220930', '100', NULL, NULL, NULL),
	(1062, 63, NULL, NULL, NULL, NULL, 'H1-220930', '160', NULL, NULL, NULL),
	(1063, 63, NULL, NULL, NULL, NULL, 'H1-220930', '169', NULL, NULL, NULL),
	(1064, 64, 65, 10585503, 204, 2, 'H1-220930', '154', NULL, NULL, NULL),
	(1065, 64, 65, 10585503, NULL, NULL, 'H1-220930', '177', NULL, NULL, NULL),
	(1066, 64, 65, 10585503, 204, 1, 'H1-220930', '101', NULL, NULL, NULL),
	(1067, 64, 66, 10585505, NULL, NULL, 'H1-220930', '098', NULL, NULL, NULL),
	(1068, 64, 66, 10585505, NULL, NULL, 'H1-220930', '110', NULL, NULL, NULL),
	(1069, 64, 66, 10585505, NULL, NULL, 'H1-220930', '166', NULL, NULL, NULL),
	(1070, 64, 66, 10585505, NULL, NULL, 'H1-220930', '163', NULL, NULL, NULL),
	(1071, 64, 66, 10585505, NULL, NULL, 'H1-220930', '111', NULL, NULL, NULL),
	(1072, 64, 66, 10585505, NULL, NULL, 'H1-220930', '102', NULL, NULL, NULL),
	(1073, 64, 65, 10585503, 204, 3, 'H1-220930', '176', NULL, NULL, NULL),
	(1074, 64, 65, 10585503, 204, 1, 'H1-220930', '096', NULL, NULL, NULL),
	(1075, 64, 66, 10585505, NULL, NULL, 'H1-220930', '104', NULL, NULL, NULL),
	(1076, 64, 66, 10585505, NULL, NULL, 'H1-220930', '103', NULL, NULL, NULL),
	(1077, 64, 65, 10585503, 204, 2, 'H1-220930', '171', NULL, NULL, NULL),
	(1078, 64, 65, 10585503, NULL, NULL, 'H1-220930', '387', NULL, NULL, NULL),
	(1079, 64, 65, 10585503, NULL, NULL, 'H1-220930', '401', NULL, NULL, NULL),
	(1080, 65, NULL, NULL, NULL, NULL, 'I2-220930', '306', NULL, NULL, NULL),
	(1081, 65, NULL, NULL, NULL, NULL, 'I2-220930', '361', NULL, NULL, NULL),
	(1082, 65, NULL, NULL, NULL, NULL, 'I2-220930', '375', NULL, NULL, NULL),
	(1083, 65, NULL, NULL, NULL, NULL, 'I2-220930', '369', NULL, NULL, NULL),
	(1084, 65, NULL, NULL, NULL, NULL, 'I2-220930', '354', NULL, NULL, NULL),
	(1085, 65, NULL, NULL, NULL, NULL, 'I2-220930', '327', NULL, NULL, NULL),
	(1086, 65, NULL, NULL, NULL, NULL, 'I2-220930', '388', NULL, NULL, NULL),
	(1087, 65, NULL, NULL, NULL, NULL, 'I2-220930', '386', NULL, NULL, NULL),
	(1088, 65, NULL, NULL, NULL, NULL, 'I2-220930', '317', NULL, NULL, NULL),
	(1089, 65, NULL, NULL, NULL, NULL, 'I2-220930', '287', NULL, NULL, NULL),
	(1090, 65, NULL, NULL, NULL, NULL, 'I2-220930', '304', NULL, NULL, NULL),
	(1091, 65, NULL, NULL, NULL, NULL, 'I2-220930', '314', NULL, NULL, NULL),
	(1092, 65, NULL, NULL, NULL, NULL, 'I2-220930', '315', NULL, NULL, NULL),
	(1093, 65, NULL, NULL, NULL, NULL, 'I2-220930', '299', NULL, NULL, NULL),
	(1094, 65, NULL, NULL, NULL, NULL, 'I2-220930', '316', NULL, NULL, NULL),
	(1095, 65, NULL, NULL, NULL, NULL, 'I2-220930', '352', NULL, NULL, NULL),
	(1096, 66, NULL, NULL, NULL, NULL, 'I2-221001', '070', NULL, NULL, NULL),
	(1097, 66, NULL, NULL, NULL, NULL, 'I2-221001', '112', NULL, NULL, NULL),
	(1098, 66, NULL, NULL, NULL, NULL, 'I2-221001', '109', NULL, NULL, NULL),
	(1099, 66, NULL, NULL, NULL, NULL, 'I2-221001', '114', NULL, NULL, NULL),
	(1100, 66, NULL, NULL, NULL, NULL, 'I2-221001', '115', NULL, NULL, NULL),
	(1101, 66, NULL, NULL, NULL, NULL, 'I2-221001', '112', NULL, NULL, NULL),
	(1102, 66, NULL, NULL, NULL, NULL, 'I2-221001', '123', NULL, NULL, NULL),
	(1103, 66, NULL, NULL, NULL, NULL, 'I2-221001', '063', NULL, NULL, NULL),
	(1104, 66, NULL, NULL, NULL, NULL, 'I2-221001', '065', NULL, NULL, NULL),
	(1105, 66, NULL, NULL, NULL, NULL, 'I2-221001', '009', NULL, NULL, NULL),
	(1106, 66, NULL, NULL, NULL, NULL, 'I2-221001', '076', NULL, NULL, NULL),
	(1107, 66, NULL, NULL, NULL, NULL, 'I2-221001', '111', NULL, NULL, NULL),
	(1108, 66, NULL, NULL, NULL, NULL, 'I2-221001', '104', NULL, NULL, NULL),
	(1109, 66, NULL, NULL, NULL, NULL, 'I2-221001', '113', NULL, NULL, NULL),
	(1110, 66, NULL, NULL, NULL, NULL, 'I2-221001', '110', NULL, NULL, NULL),
	(1111, 66, NULL, NULL, NULL, NULL, 'I2-221001', '000', NULL, NULL, NULL),
	(1112, 67, NULL, NULL, NULL, NULL, 'I2-221001', '037', NULL, NULL, NULL),
	(1113, 67, NULL, NULL, NULL, NULL, 'I2-221001', '085', NULL, NULL, NULL),
	(1114, 67, NULL, NULL, NULL, NULL, 'I2-221001', '010', NULL, NULL, NULL),
	(1115, 67, NULL, NULL, NULL, NULL, 'I2-221001', '059', NULL, NULL, NULL),
	(1116, 67, NULL, NULL, NULL, NULL, 'I2-221001', '031', NULL, NULL, NULL),
	(1117, 67, NULL, NULL, NULL, NULL, 'I2-221001', '008', NULL, NULL, NULL),
	(1118, 67, NULL, NULL, NULL, NULL, 'I2-221001', '040', NULL, NULL, NULL),
	(1119, 67, NULL, NULL, NULL, NULL, 'I2-221001', '039', NULL, NULL, NULL),
	(1120, 67, NULL, NULL, NULL, NULL, 'I2-221001', '015', NULL, NULL, NULL),
	(1121, 67, NULL, NULL, NULL, NULL, 'I2-221001', '021', NULL, NULL, NULL),
	(1122, 67, NULL, NULL, NULL, NULL, 'I2-221001', '004', NULL, NULL, NULL),
	(1123, 67, NULL, NULL, NULL, NULL, 'I2-221001', '044', NULL, NULL, NULL),
	(1124, 67, NULL, NULL, NULL, NULL, 'I2-221001', '062', NULL, NULL, NULL),
	(1125, 67, NULL, NULL, NULL, NULL, 'I2-221001', '090', NULL, NULL, NULL),
	(1126, 67, NULL, NULL, NULL, NULL, 'I2-221001', '086', NULL, NULL, NULL),
	(1127, 67, NULL, NULL, NULL, NULL, 'I2-221001', '000', NULL, NULL, NULL),
	(1128, 68, NULL, NULL, NULL, NULL, 'I2-221001', '056', NULL, NULL, NULL),
	(1129, 68, NULL, NULL, NULL, NULL, 'I2-221001', '087', NULL, NULL, NULL),
	(1130, 68, NULL, NULL, NULL, NULL, 'I2-221001', '189', NULL, NULL, NULL),
	(1131, 68, NULL, NULL, NULL, NULL, 'I2-221001', '181', NULL, NULL, NULL),
	(1132, 68, NULL, NULL, NULL, NULL, 'I2-221001', '080', NULL, NULL, NULL),
	(1133, 68, NULL, NULL, NULL, NULL, 'I2-221001', '092', NULL, NULL, NULL),
	(1134, 68, NULL, NULL, NULL, NULL, 'I2-221001', '208', NULL, NULL, NULL),
	(1135, 68, NULL, NULL, NULL, NULL, 'I2-221001', '194', NULL, NULL, NULL),
	(1136, 68, NULL, NULL, NULL, NULL, 'I2-221001', '193', NULL, NULL, NULL),
	(1137, 68, NULL, NULL, NULL, NULL, 'I2-221001', '179', NULL, NULL, NULL),
	(1138, 68, NULL, NULL, NULL, NULL, 'I2-221001', '197', NULL, NULL, NULL),
	(1139, 68, NULL, NULL, NULL, NULL, 'I2-221001', '180', NULL, NULL, NULL),
	(1140, 68, NULL, NULL, NULL, NULL, 'I2-221001', '071', NULL, NULL, NULL),
	(1141, 68, NULL, NULL, NULL, NULL, 'I2-221001', '093', NULL, NULL, NULL),
	(1143, 68, NULL, NULL, NULL, NULL, 'I2-221001', '000', NULL, NULL, NULL),
	(1144, 68, NULL, NULL, NULL, NULL, 'I2-221001', '108', NULL, NULL, NULL);
/*!40000 ALTER TABLE `pbb` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.pbbused
CREATE TABLE IF NOT EXISTS `pbbused` (
  `PbbUsedID` int(225) NOT NULL AUTO_INCREMENT,
  `PlanID` int(11) NOT NULL,
  `Shift` int(11) NOT NULL,
  `Jenis` int(11) DEFAULT NULL,
  `Stok_Awal` int(15) NOT NULL DEFAULT '0',
  `Terima` int(15) NOT NULL DEFAULT '0',
  `Kotor` int(15) NOT NULL DEFAULT '0',
  `Return` int(15) NOT NULL DEFAULT '0',
  `Dipakai` int(15) NOT NULL DEFAULT '0',
  `Stok_Akhir` int(15) NOT NULL DEFAULT '0',
  `Pewarna` int(255) DEFAULT NULL,
  PRIMARY KEY (`PbbUsedID`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.pbbused: ~14 rows (lebih kurang)
/*!40000 ALTER TABLE `pbbused` DISABLE KEYS */;
REPLACE INTO `pbbused` (`PbbUsedID`, `PlanID`, `Shift`, `Jenis`, `Stok_Awal`, `Terima`, `Kotor`, `Return`, `Dipakai`, `Stok_Akhir`, `Pewarna`) VALUES
	(1, 190, 1, 1, 0, 3300000, 0, 0, 3280896, 19104, NULL),
	(2, 190, 2, 1, 19104, 3300000, 0, 0, 3271680, 47424, NULL),
	(3, 190, 3, 1, 47424, 3300000, 0, 0, 3271680, 75744, NULL),
	(4, 194, 1, 1, 75744, 3300000, 0, 0, 3271680, 104064, NULL),
	(5, 194, 2, 1, 104064, 3300000, 0, 0, 3271680, 132384, NULL),
	(6, 194, 3, 1, 132384, 3300000, 0, 0, 3271680, 160704, NULL),
	(7, 200, 1, 1, 160704, 3300000, 0, 0, 114, 3460590, NULL),
	(8, 202, 1, 1, 3460590, 0, 0, 0, 14, 3460576, NULL),
	(9, 204, 1, 1, 3460576, 2200000, 20000, 0, 1199550, 4461026, NULL),
	(10, 204, 2, 1, 4461026, 2200000, 40000, 0, 1287900, 5373126, NULL),
	(11, 204, 3, 1, 5373126, 1100000, 0, 0, 1001792, 5471334, NULL),
	(12, 204, 1, 2, 0, 20000, 0, 0, 1980, 18020, NULL),
	(13, 204, 2, 2, 18020, 0, 0, 0, 1876, 16144, NULL),
	(14, 204, 3, 2, 16144, 0, 0, 0, 1450, 14694, NULL);
/*!40000 ALTER TABLE `pbbused` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.plan
CREATE TABLE IF NOT EXISTS `plan` (
  `PlanID` int(11) NOT NULL AUTO_INCREMENT,
  `DatePlan` date DEFAULT NULL,
  `Week` int(5) DEFAULT NULL,
  `MesinID` int(1) DEFAULT NULL,
  `ProductID` int(6) DEFAULT NULL,
  `QtyPlan` int(3) DEFAULT NULL,
  `Prioritas` tinytext COLLATE armscii8_bin,
  `MaterialID` int(2) DEFAULT NULL,
  `POOR` int(8) DEFAULT NULL,
  `NoPBB_ID` int(11) DEFAULT NULL,
  `NoPBB_ID2` int(11) DEFAULT NULL,
  `WH_Conf` tinyint(1) DEFAULT NULL,
  `pbb1_Conf` tinyint(1) DEFAULT NULL,
  `pbb2_Conf` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`PlanID`) USING BTREE,
  KEY `FK_plan_mesin` (`MesinID`),
  KEY `FK_plan_material` (`MaterialID`),
  KEY `FK_plan_product` (`ProductID`),
  CONSTRAINT `FK_plan_material` FOREIGN KEY (`MaterialID`) REFERENCES `material` (`MaterialID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_plan_mesin` FOREIGN KEY (`MesinID`) REFERENCES `mesin` (`MesinID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_plan_product` FOREIGN KEY (`ProductID`) REFERENCES `product` (`ProductID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=209 DEFAULT CHARSET=armscii8 COLLATE=armscii8_bin;

-- Membuang data untuk tabel warehouse.plan: ~98 rows (lebih kurang)
/*!40000 ALTER TABLE `plan` DISABLE KEYS */;
REPLACE INTO `plan` (`PlanID`, `DatePlan`, `Week`, `MesinID`, `ProductID`, `QtyPlan`, `Prioritas`, `MaterialID`, `POOR`, `NoPBB_ID`, `NoPBB_ID2`, `WH_Conf`, `pbb1_Conf`, `pbb2_Conf`) VALUES
	(103, '2022-12-06', 49, 1, 7, 20, 'A', 17, 10583817, 2, NULL, NULL, 1, 1),
	(104, '2022-12-06', 49, 1, 4, 510, 'B', 16, 10583921, 1, NULL, NULL, 1, 1),
	(105, '2022-12-06', 49, 2, 12, 165, 'A', 22, 10583085, 3, NULL, NULL, 1, 1),
	(106, '2022-12-06', 49, 2, 11, 87, 'B', 17, 10583945, 4, NULL, NULL, 1, 1),
	(107, '2022-12-06', 49, 3, 8, 52, 'A', 1, 10583818, 5, NULL, NULL, 1, 1),
	(108, '2022-12-07', 49, 1, 4, 705, 'A', 16, 10583921, 6, NULL, NULL, 1, 1),
	(109, '2022-12-07', 49, 2, 18, 32, 'A', 22, 10583899, 7, NULL, NULL, 1, 1),
	(110, '2022-12-07', 49, 3, 8, 52, 'A', 1, 10583818, 8, NULL, NULL, 1, 1),
	(111, '2022-12-08', 49, 3, 8, 52, 'A', 1, 10583818, 11, NULL, NULL, 1, 1),
	(112, '2022-12-09', 49, 3, 8, 39, 'A', 1, 10583818, 12, NULL, NULL, 1, 1),
	(113, '2022-12-10', 49, 3, 8, 32, 'A', 1, 10583818, 15, NULL, NULL, 1, 1),
	(114, '2022-12-09', 49, 1, 4, 720, 'A', 16, 10583921, 13, NULL, NULL, 1, 1),
	(115, '2022-12-10', 49, 1, 4, 36, 'A', 16, 10583921, 16, NULL, NULL, 1, 1),
	(117, '2022-12-08', 49, 1, 4, 47, 'A', 16, 10583921, 9, NULL, NULL, 1, 1),
	(118, '2022-12-08', 49, 2, 18, 53, 'A', 22, 10583899, 10, NULL, NULL, 1, 1),
	(119, '2022-12-09', 49, 2, 18, 53, 'A', 22, 10583899, 14, NULL, NULL, 1, 1),
	(120, '2022-12-10', 49, 2, 18, 53, 'A', 22, 10583899, 17, NULL, NULL, 1, 1),
	(121, '2022-12-11', 49, 2, 18, 31, 'A', 22, 10583899, 29, NULL, NULL, 1, 1),
	(122, '2022-11-25', 47, 3, 8, 16, 'A', 1, 10583086, NULL, NULL, NULL, 1, 1),
	(123, '2022-11-30', 48, 3, 8, 16, 'A', 1, 10583474, NULL, NULL, NULL, 1, 1),
	(124, '2022-12-02', 48, 1, 7, 8, 'A', 17, 10583339, NULL, NULL, NULL, 1, 1),
	(125, '2022-12-05', 49, 1, 7, 36, 'A', 17, 10583817, NULL, NULL, NULL, 1, 1),
	(126, '2022-12-04', 48, 2, 11, 106, 'A', 17, 10583085, NULL, NULL, NULL, 1, 1),
	(128, '2022-11-12', 45, 2, 12, 21, 'A', 22, 10582395, NULL, NULL, NULL, 1, 1),
	(129, '2022-06-24', 25, 1, 16, 18, 'A', 23, 10573006, NULL, NULL, NULL, 1, 1),
	(130, '2022-06-25', 25, 1, 16, 24, 'A', 23, 10573006, NULL, NULL, NULL, 1, 1),
	(131, '2022-12-01', 48, 3, 8, 26, 'A', 1, 10583474, NULL, NULL, NULL, 1, 1),
	(133, '2022-12-05', 49, 2, 11, 70, 'A', 17, 10583085, NULL, NULL, NULL, 1, 1),
	(134, '2022-12-05', 49, 2, 12, 24, 'A', 22, 10583898, NULL, NULL, NULL, 1, 1),
	(135, '2022-11-27', 47, 1, 4, 45, 'A', 21, 10583163, NULL, NULL, NULL, 1, 1),
	(136, '2021-01-04', 1, 2, 11, 2, 'A', 18, 0, NULL, NULL, NULL, 1, 1),
	(137, '2022-07-16', 28, 1, 4, 1, 'A', 23, 10574227, NULL, NULL, NULL, 1, 1),
	(138, '2022-08-10', 32, 1, 4, 1, 'A', 23, 10575805, NULL, NULL, NULL, 1, 1),
	(139, '2022-12-03', 48, 1, 4, 2, 'A', 22, 10583600, NULL, NULL, NULL, 1, 1),
	(140, '2022-10-20', 42, 2, 12, 39, 'A', 21, 10580921, NULL, NULL, NULL, 1, 1),
	(141, '2022-12-11', 49, 1, 4, 39, 'A', 16, 10583921, NULL, NULL, NULL, 1, 1),
	(142, '2022-12-11', 49, 1, 4, 9, 'B', 22, 10584328, NULL, NULL, NULL, 1, 1),
	(143, '2022-12-11', 49, 2, 15, 10, 'A', 22, 10584220, NULL, NULL, NULL, 1, 1),
	(144, '2022-12-12', 50, 1, 4, 47, 'A', 22, 10584328, NULL, NULL, NULL, 1, 1),
	(145, '2022-12-13', 50, 1, 7, 69, 'A', 18, 10584313, 19, NULL, NULL, 1, 1),
	(146, '2022-12-14', 50, 1, 7, 70, 'A', 18, 10584313, 24, NULL, NULL, 1, 1),
	(147, '2022-12-12', 50, 2, 11, 69, 'A', 17, 10584321, 18, NULL, NULL, 1, 1),
	(148, '2022-12-13', 50, 2, 11, 105, 'A', 17, 10584321, 20, NULL, NULL, 1, 1),
	(149, '2022-12-14', 50, 2, 11, 105, 'A', 17, 10584321, 22, 23, NULL, 1, 1),
	(150, '2022-12-15', 50, 2, 11, 50, 'A', 17, 10584321, 27, NULL, NULL, 1, 1),
	(151, '2022-12-14', 50, 3, 8, 26, 'A', 1, 10584469, 21, NULL, NULL, 1, 1),
	(152, '2022-12-15', 50, 3, 8, 26, 'A', 1, 10584469, 25, NULL, NULL, 1, 1),
	(153, '2022-12-16', 50, 3, 8, 22, 'A', 1, 10584469, 31, NULL, NULL, 1, 1),
	(154, '2022-12-15', 50, 1, 7, 40, 'B', 17, 10584314, 28, NULL, NULL, 1, 1),
	(155, '2022-12-16', 50, 1, 7, 69, 'A', 17, 10584314, 32, NULL, NULL, 1, 1),
	(157, '2022-12-17', 50, 1, 7, 46, 'A', 17, 10584314, 34, NULL, NULL, 1, 1),
	(158, '2022-04-13', 15, 2, 15, 1, 'B', 23, 10568550, NULL, NULL, NULL, 1, 1),
	(160, '2022-12-15', 50, 1, 7, 30, 'A', 18, 10584313, NULL, NULL, NULL, 1, 1),
	(161, '2022-12-15', 50, 2, 12, 38, 'A', 22, 10584687, 26, NULL, NULL, 1, 1),
	(162, '2022-12-16', 50, 2, 12, 74, 'A', 22, 10584687, 30, NULL, NULL, 1, 1),
	(163, '2022-12-17', 50, 3, 8, 25, 'A', 1, 10584469, 33, NULL, NULL, 1, 1),
	(164, '2022-12-17', 50, 2, 12, 43, 'A', 22, 10584687, NULL, NULL, NULL, 1, 1),
	(165, '2022-12-17', 50, 2, 12, 30, 'A', 16, 10584756, 35, 36, NULL, 1, 1),
	(167, '2022-12-18', 50, 1, 7, 70, 'A', 17, 10584314, NULL, NULL, NULL, 1, 1),
	(168, '2022-12-18', 50, 2, 12, 66, 'A', 16, 10584756, NULL, NULL, NULL, 1, 1),
	(169, '2022-12-19', 51, 1, 7, 69, 'A', 17, 10584314, 37, NULL, NULL, 1, 1),
	(170, '2022-12-19', 51, 2, 11, 84, 'A', 17, 10584646, 38, NULL, NULL, 1, 1),
	(171, '2022-12-20', 51, 1, 7, 69, 'A', 17, 10584314, 39, NULL, NULL, 1, 1),
	(172, '2022-12-20', 51, 2, 11, 101, 'A', 17, 10584646, 40, NULL, NULL, 1, 1),
	(173, '2022-12-20', 51, 2, 12, 2, 'B', 22, 10584943, 41, NULL, NULL, 1, 1),
	(174, '2022-12-21', 51, 3, 8, 26, 'A', 1, 10585021, 42, NULL, NULL, 1, 1),
	(175, '2022-12-21', 51, 1, 7, 49, 'A', 17, 10585021, NULL, NULL, NULL, 1, 1),
	(176, '2022-12-21', 51, 1, 4, 15, 'A', 22, 10585061, 43, NULL, NULL, 1, 1),
	(177, '2022-12-21', 51, 2, 12, 69, 'B', 22, 10584943, 44, NULL, NULL, 1, 1),
	(178, '2022-12-22', 51, 3, 8, 26, 'A', 1, 10585021, 45, NULL, NULL, 1, 1),
	(179, '2022-12-22', 51, 1, 4, 47, 'A', 22, 10585061, 46, NULL, NULL, 1, 1),
	(180, '2022-12-23', 51, 3, 8, 12, 'A', 1, 10585021, 47, NULL, NULL, 1, 1),
	(181, '2022-12-23', 51, 1, 7, 62, 'A', 17, 10585122, 48, NULL, NULL, 1, 1),
	(182, '2022-12-23', 51, 1, 4, 1, 'B', 22, 10585061, NULL, NULL, NULL, 1, 1),
	(183, '2022-12-24', 51, 1, 7, 62, 'A', 17, 10585122, 49, NULL, NULL, 1, 1),
	(185, '2022-12-26', 52, 3, 8, 26, 'A', 1, 10585261, 50, NULL, NULL, 1, 1),
	(186, '2022-12-26', 52, 1, 7, 41, 'A', 17, 10585203, 51, NULL, NULL, 1, 1),
	(187, '2022-12-26', 52, 2, 18, 32, 'A', 22, 10585201, 52, NULL, NULL, 1, 1),
	(189, '2022-12-27', 52, 3, 8, 26, 'A', 1, 10585261, 53, NULL, NULL, 1, 1),
	(190, '2022-12-27', 52, 1, 7, 63, 'A', 17, 10585203, 54, NULL, NULL, 1, 1),
	(191, '2022-12-27', 52, 2, 18, 48, 'A', 23, 10585202, 55, NULL, NULL, 1, 1),
	(192, '2022-12-27', 52, 2, 18, 6, 'B', 22, 10585201, NULL, NULL, NULL, 1, 1),
	(193, '2022-12-28', 52, 3, 8, 52, 'A', 1, 10585261, 56, NULL, NULL, 1, 1),
	(194, '2022-12-28', 52, 1, 7, 62, 'A', 17, 10585203, 57, NULL, NULL, 1, 1),
	(195, '2022-12-28', 52, 2, 18, 53, 'A', 23, 10585202, 58, NULL, NULL, 1, 1),
	(196, '2022-12-29', 52, 3, 8, 52, 'A', 1, 10585261, 59, NULL, NULL, 1, 1),
	(197, '2022-12-29', 52, 1, 7, 65, 'A', 17, 10585203, 60, NULL, NULL, 1, 1),
	(198, '2022-12-29', 52, 2, 18, 54, 'A', 23, 10585202, 61, NULL, NULL, 1, 1),
	(199, '2022-12-30', 52, 3, 8, 48, 'A', 1, 10585261, 62, NULL, NULL, 1, 1),
	(200, '2022-12-30', 52, 1, 7, 66, 'A', 17, 10585203, 63, NULL, NULL, 1, 1),
	(201, '2022-12-30', 52, 2, 18, 53, 'A', 23, 10585202, 64, NULL, NULL, 1, 1),
	(202, '2022-12-31', 52, 1, 7, 41, 'A', 17, 10585203, NULL, NULL, NULL, 1, 1),
	(203, '2022-12-31', 52, 2, 18, 4, 'A', 23, 10585202, NULL, NULL, NULL, 1, 1),
	(204, '2023-01-02', 1, 1, 7, 56, 'A', 17, 10585503, 65, 68, NULL, NULL, NULL),
	(205, '2023-01-02', 1, 2, 10, 270, 'A', 23, 10585504, NULL, NULL, NULL, NULL, NULL),
	(206, '2023-01-02', 1, 2, 11, 61, 'B', 17, 10585505, 66, 67, NULL, NULL, NULL),
	(207, '2023-01-02', 1, 3, 8, 32, 'A', 1, 10585261, NULL, NULL, NULL, NULL, NULL),
	(208, '2023-01-03', 1, 2, 11, 45, 'A', 17, 10585504, 69, NULL, NULL, NULL, NULL);
/*!40000 ALTER TABLE `plan` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.po_tbl
CREATE TABLE IF NOT EXISTS `po_tbl` (
  `PO_ID` int(11) NOT NULL AUTO_INCREMENT,
  `No_PO` varchar(50) DEFAULT NULL,
  `CustomerID` int(3) DEFAULT NULL,
  `TanggalPO` date DEFAULT NULL,
  PRIMARY KEY (`PO_ID`),
  KEY `FK__customer` (`CustomerID`),
  CONSTRAINT `FK__customer` FOREIGN KEY (`CustomerID`) REFERENCES `customer` (`CustomerID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.po_tbl: ~24 rows (lebih kurang)
/*!40000 ALTER TABLE `po_tbl` DISABLE KEYS */;
REPLACE INTO `po_tbl` (`PO_ID`, `No_PO`, `CustomerID`, `TanggalPO`) VALUES
	(5, '144/BTA-BJM-PO/X1/22', 1, '2022-11-25'),
	(6, 'CS-200058534', 11, '2022-10-25'),
	(7, 'PO2211-00162', 5, '2022-11-15'),
	(8, '2064/LOG/SS/12/22/KPB-GRK', 2, '2022-12-01'),
	(9, '1930/LOG/SS/11/22/KPB-MJO', 4, '2022-11-15'),
	(10, '2038/LOG/SS/11/22/KPB-MJO', 4, '2022-11-29'),
	(11, 'ZRP 4503956207', 3, '2022-05-19'),
	(12, 'ZRP 4504165180', 3, '2022-11-14'),
	(13, 'ZRP 4504121282', 9, '2022-10-06'),
	(14, 'ZRP 4504157854', 9, '2022-11-08'),
	(15, 'AWI-PO-22008941', 6, '2022-11-25'),
	(16, 'ZRP 4504184654', 3, '2022-12-01'),
	(17, '00186/PO.KP/11/2022', 14, '2022-11-14'),
	(18, '047/MPPB/PO/2022', 7, '2022-12-19'),
	(19, 'ZRP 4504200572 ', 9, '2022-12-15'),
	(20, '152/BTA-BJM-PO/XII/22', 1, '2022-12-14'),
	(21, '00203/PO.KP/12/2022', 14, '2022-12-19'),
	(22, 'HJA 12.43L', 8, '2022-12-23'),
	(23, 'HJA 12.42L', 8, '2022-12-23'),
	(24, 'ZRP 4504219467', 9, '2022-12-30'),
	(25, 'ZRP 4504220671', 3, '2023-01-02'),
	(26, 'ZRP 4504220672', 3, '2023-01-02'),
	(27, '2324/LOG/SS/12/22/KPB-GRK', 2, '2022-12-29'),
	(28, '2306/LOG/SS/12/22/KPB-GRK', 2, '2022-12-29');
/*!40000 ALTER TABLE `po_tbl` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.product
CREATE TABLE IF NOT EXISTS `product` (
  `ProductID` int(11) NOT NULL AUTO_INCREMENT,
  `Material` varchar(6) NOT NULL,
  `ItemDescription` varchar(50) NOT NULL,
  `SLoc` varchar(4) NOT NULL,
  `QtyUnit` int(5) NOT NULL,
  `Gram` float NOT NULL,
  `Speed` float NOT NULL,
  `Pewarna` int(11) DEFAULT NULL,
  `Jenis` varchar(5) NOT NULL,
  `Folder` varchar(100) NOT NULL,
  PRIMARY KEY (`ProductID`),
  KEY `MaterialID` (`Pewarna`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.product: ~16 rows (lebih kurang)
/*!40000 ALTER TABLE `product` DISABLE KEYS */;
REPLACE INTO `product` (`ProductID`, `Material`, `ItemDescription`, `SLoc`, `QtyUnit`, `Gram`, `Speed`, `Pewarna`, `Jenis`, `Folder`) VALUES
	(4, '567606', 'PREFORM MW 14.20G CLEAR', 'BOX2', 1080, 14.2, 8.18, NULL, 'clear', '\\172.18.121.11COAMW14.20G'),
	(5, '567606', 'PREFORM MW 14.20G CLEAR', 'NTN2', 11016, 14.2, 8.18, NULL, 'clear', '\\172.18.121.11COAMW14.20G'),
	(6, '567604', 'PREFORM MW 14.20G BLUISH', 'BOX2', 1080, 14.2, 8.18, 13, 'color', '\\172.18.121.11COAMW14.20G'),
	(7, '567605', 'PREFORM MW 14.20G BLUISH M', 'NTN2', 11016, 14.2, 8.18, 13, 'color', '\\172.18.121.11COAMW14.20G'),
	(8, '567762', 'BOT HF-NC 1810 350ML CLEAR F-TEA', 'PLT2', 4851, 1, 16800, NULL, 'btl', '\\172.18.121.11COAHF-NC350ML-FTEA'),
	(9, '567766', 'BOT HF-NC 1810 500ML CLEAR FTEA', 'PLT2', 3420, 1, 16800, NULL, 'btl', '\\172.18.121.11COAHF-NC500ML-FTEA'),
	(10, '567914', 'PREFORM MW 27.50G BLUISH', 'BOX2', 576, 27.5, 10.3, 13, 'color', '\\172.18.121.11COAMW27.50G'),
	(11, '567915', 'PREFORM MW 27.50G BLUISH M', 'NTN2', 6048, 27.5, 10.3, 13, 'color', '\\172.18.121.11COAMW27.50G'),
	(12, '567916', 'PREFORM MW 27.50G CLEAR', 'BOX2', 576, 27.5, 10.3, NULL, 'clear', '\\172.18.121.11COAMW27.50G'),
	(13, '567874', 'PREFORM CSD 27.50G CLEAR', 'JBB2', 11088, 27.5, 14, NULL, 'csd', '\\172.18.121.11COACSD27.50G'),
	(14, '567874', 'PREFORM CSD 27.50G CLEAR', 'BOX2', 864, 27.5, 14, NULL, 'csd', '\\172.18.121.11COACSD27.50G'),
	(15, '581040', 'PREFORM CSD 27.50G ORANGE', 'BOX2', 864, 27.5, 14, 15, 'csd', '\\172.18.121.11COACSD27.50G'),
	(16, '567887', 'PREFORM MW 12.40G BLUE', 'NTN2', 12600, 12.4, 0, 14, 'color', '\\172.18.121.11COAMW12.40G'),
	(17, '567888', 'PREFORM MW 12.40G BLUE M', 'NTN2', 12600, 12.4, 0, 14, 'color', '\\172.18.121.11COAMW12.40G'),
	(18, '567874', 'PREFORM CSD 27.50G CLEAR', 'NTN2', 8352, 27.5, 0, NULL, 'csd', '11'),
	(19, '567891', 'PREFORM MW 12.40G CLEAR', 'BOX2', 1224, 12.4, 0, NULL, '', 'ii\r\n');
/*!40000 ALTER TABLE `product` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.reject
CREATE TABLE IF NOT EXISTS `reject` (
  `Reject_ID` int(255) NOT NULL AUTO_INCREMENT,
  `PlanID` int(11) NOT NULL,
  `Shift` int(11) NOT NULL,
  `Jenis` int(11) NOT NULL,
  `STPJ_ID` int(11) DEFAULT NULL,
  `Cav` int(2) NOT NULL DEFAULT '0',
  `Time_RJK` time NOT NULL,
  `NoDok` varchar(25) NOT NULL,
  `Reason` varchar(100) NOT NULL,
  `Qty` int(7) NOT NULL,
  PRIMARY KEY (`Reject_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.reject: ~24 rows (lebih kurang)
/*!40000 ALTER TABLE `reject` DISABLE KEYS */;
REPLACE INTO `reject` (`Reject_ID`, `PlanID`, `Shift`, `Jenis`, `STPJ_ID`, `Cav`, `Time_RJK`, `NoDok`, `Reason`, `Qty`) VALUES
	(1, 190, 1, 2, NULL, 0, '07:00:00', '', 'Non Counter', 141),
	(2, 190, 2, 2, NULL, 0, '15:00:00', '', 'Non Counter', 48),
	(3, 190, 3, 2, NULL, 0, '23:00:00', '', 'Gumpalan', 48),
	(4, 194, 1, 2, NULL, 0, '07:00:00', '', 'Non Counter', 48),
	(5, 194, 2, 2, NULL, 0, '18:00:00', '', 'Non Counter', 46),
	(6, 194, 3, 2, NULL, 0, '03:00:00', '', 'Non Counter', 47),
	(16, 200, 1, 1, NULL, 72, '10:00:00', '', 'Ulir Rusak', 1),
	(17, 200, 1, 1, NULL, 48, '10:00:00', '', 'Bum Mark/Gosong', 1),
	(18, 200, 1, 1, NULL, 26, '10:00:00', '', 'Contamination Grease / Oli', 1),
	(19, 200, 1, 3, NULL, 0, '08:00:00', '001/pdg/2022', 'Short Shot, Flowmark Bottom, Contamination Grease / Oli, ', 250),
	(42, 204, 1, 2, NULL, 0, '07:00:00', '', 'Non Counter', 3471),
	(46, 204, 1, 1, 5172, 10, '07:20:00', '', 'Ulir Rusak', 1),
	(47, 204, 1, 1, NULL, 36, '08:00:00', '', 'Bintik Logam', 1),
	(48, 204, 1, 1, 5173, 60, '07:57:00', '', 'Silver Bottom', 1),
	(49, 204, 1, 1, 5173, 55, '07:57:00', '', 'Odor / Berbau', 1),
	(51, 204, 1, 4, 5172, 71, '07:20:00', '', 'Flash Di Ulir', 1),
	(52, 204, 1, 1, NULL, 61, '09:00:00', '', 'Flowmark Bottom', 1),
	(53, 204, 1, 3, NULL, 0, '08:00:00', '001/pdg/01/2023', 'Silver Bottom, Lip Oval, ', 350),
	(54, 204, 3, 2, NULL, 0, '02:00:00', '', 'Gumpalan', 400),
	(55, 207, 1, 2, NULL, 0, '07:00:00', '', 'Lip Oval', 43),
	(56, 207, 2, 2, NULL, 0, '16:00:00', '', 'Ulir Rusak', 30),
	(57, 207, 2, 2, NULL, 0, '17:00:00', '', 'Gores EOAT', 80),
	(58, 205, 1, 2, NULL, 0, '00:00:08', '', 'Non Counter', 34),
	(60, 204, 2, 1, NULL, 10, '16:00:00', '', 'Flash Lip', 2);
/*!40000 ALTER TABLE `reject` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.return
CREATE TABLE IF NOT EXISTS `return` (
  `ReturnID` int(150) NOT NULL AUTO_INCREMENT,
  `Date_Return` date NOT NULL,
  `DetailEkspedisi_ID` int(11) NOT NULL,
  `CustomerID` int(11) NOT NULL,
  `SJ_Return` varchar(50) NOT NULL,
  `Packaging` varchar(25) NOT NULL,
  `Qty` int(10) NOT NULL,
  `Qty2` int(10) NOT NULL,
  `Deskripsi` varchar(150) NOT NULL,
  PRIMARY KEY (`ReturnID`),
  KEY `CustomerID` (`CustomerID`),
  KEY `DetailEkspedisi_ID` (`DetailEkspedisi_ID`),
  CONSTRAINT `return_ibfk_1` FOREIGN KEY (`CustomerID`) REFERENCES `customer` (`CustomerID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `return_ibfk_2` FOREIGN KEY (`DetailEkspedisi_ID`) REFERENCES `detailekspedisi` (`DetailEkspedisi_ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.return: ~4 rows (lebih kurang)
/*!40000 ALTER TABLE `return` DISABLE KEYS */;
REPLACE INTO `return` (`ReturnID`, `Date_Return`, `DetailEkspedisi_ID`, `CustomerID`, `SJ_Return`, `Packaging`, `Qty`, `Qty2`, `Deskripsi`) VALUES
	(14, '2023-01-07', 4, 3, '43212300', 'NICKTAINER', 76, 0, ''),
	(15, '2023-01-06', 9, 2, 'khda/i001', 'PALET', 25, 25, ''),
	(19, '2023-01-09', 2, 9, 'pdn/2023', 'NICKTAINER', 127, 0, ''),
	(20, '2023-01-11', 1, 2, '12345', 'PALET', 100, 50, '');
/*!40000 ALTER TABLE `return` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.spec
CREATE TABLE IF NOT EXISTS `spec` (
  `SpecID` int(11) NOT NULL AUTO_INCREMENT,
  `Kode` varchar(5) NOT NULL,
  `Spec` varchar(50) NOT NULL,
  `Kode2` varchar(5) NOT NULL,
  `Spec2` varchar(25) NOT NULL,
  `Kode3` varchar(3) NOT NULL,
  `Spec3` varchar(25) NOT NULL,
  PRIMARY KEY (`SpecID`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.spec: ~38 rows (lebih kurang)
/*!40000 ALTER TABLE `spec` DISABLE KEYS */;
REPLACE INTO `spec` (`SpecID`, `Kode`, `Spec`, `Kode2`, `Spec2`, `Kode3`, `Spec3`) VALUES
	(1, 'W', 'WEIGHT', 'W', 'WEIGHT', 'W', 'WEIGHT'),
	(2, 'SLD', 'SUPPORT LEDGE DIAMETER', 'Z', 'RING DIAMETER', 'Z', 'RING DIAMETER'),
	(3, 'A', 'SNAP DIAMETER', 'A', 'SNAP DIAMETER', 'A', 'SNAP DIAMETER'),
	(4, 'T', 'THREAD DIAMETER', 'T', 'THREAD DIAMETER', 'T', 'THREAD DIAMETER'),
	(5, 'E2', 'PREFORM MOUTH OUTSIDE DIAMETER', 'E', 'OUTER DIAMETER', 'C', 'OUTER DIAMETER'),
	(6, 'ID', 'PREFORM MOUTH INSIDE DIAMETER', 'ID', 'INNER DIAMETER', 'ID', 'INNER DIAMETER'),
	(7, 'E1', 'UPPER NECK DIAMETER', 'E1', 'UPPER NECK DIAMETER', 'B2', 'BODY DIAMETER'),
	(8, 'USLD', 'UNDER SUPPORT LEDGE DIAMETER', 'B', 'NECK DIAMETER', 'B', 'NECK DIAMETER'),
	(9, 'd', 'BOTTOM PREFORM DIAMETER', 'BD', 'BOTTOM DIAMETER', 'B1', 'BOTTOM DIAMETER'),
	(10, 'D', 'SNAP HEIGHT', 'D', 'THREAD HEIGHT', 'D', 'THREAD HEIGHT'),
	(11, 'H1', 'NECK HEIGHT', 'X', 'NECK HEIGHT', 'T2', 'NECK HEIGHT'),
	(12, 'H', 'TOTAL HEIGHT', 'TL', 'TOTAL HEIGHT', 'TL', 'TOTAL HEIGHT'),
	(13, 't0', 'PREFORM THICKNESS t0', 't1', 'TOP BODY THICKNESS t1', 't1', 'TOP BODY THICKNESS'),
	(14, 't1', 'PREFORM THICKNESS t1', 't2', 'MIDDLE BODY THICKNESS t2', 't2', 'MIDDLE BODY THICKNESS'),
	(15, 't3', 'PREFORM THICKNESS t3', 't3', 'BOTTOM BODY THICKNESS t3', 't3', 'BOTTOM BODY THICKNESS'),
	(16, 'CD', 'COLORANT DOSAGE', '', '', '', ''),
	(17, 'IV', 'INTRINSIC VISCOSITY', '', '', '', ''),
	(18, 'AA', 'ACETALDEHIDE', '', '', '', ''),
	(19, '', 'Yeast Mold', '', '', '', ''),
	(20, '', 'TPC', '', '', '', ''),
	(21, '', 'Coliform', '', '', '', ''),
	(22, '', 'Pseudomonas', '', '', '', ''),
	(23, 'TO', 'TOTAL HEIGHT', '', '', '', ''),
	(24, 'T2', 'NECK HEIGHT', '', '', '', ''),
	(25, 'id', 'INNER DIAMETER', '', '', '', ''),
	(26, 'c', 'OUTER DIAMETER', '', '', '', ''),
	(27, 'T', 'TREAD DIAMETER', '', '', '', ''),
	(28, 'A', 'SNAP DIAMETER', '', '', '', ''),
	(29, 'Z', 'RING DIAMETER', '', '', '', ''),
	(30, 'd', 'NECK DIAMETER', '', '', '', ''),
	(31, 'D1', 'BODY DIAMETER', '', '', '', ''),
	(32, 'D2', 'BOTTOM DIAMETER', '', '', '', ''),
	(33, 'D3', 'BOTTOM DIAMETER', '', '', '', ''),
	(34, 'D4', 'BOTTOM DIAMETER', '', '', '', ''),
	(41, '', 'FILL POINT', '', '', '', ''),
	(43, 'E2', 'PREFORM MOUTH OUTSIDE DIAMETER (MAX)', 'E', 'OUTER DIAMETER (MAX)', 'C', 'OUTER DIAMETER (MAX)'),
	(44, '', 'Perpendicularity/ketegakan', '', '', '', ''),
	(45, '', 'Top Load', '', '', '', '');
/*!40000 ALTER TABLE `spec` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.standard
CREATE TABLE IF NOT EXISTS `standard` (
  `StdID` int(11) NOT NULL AUTO_INCREMENT,
  `SpecID` int(11) NOT NULL,
  `ProductID` int(11) NOT NULL,
  `CL` float NOT NULL,
  `Allowance` float NOT NULL,
  PRIMARY KEY (`StdID`),
  KEY `SpecID` (`SpecID`),
  KEY `ProductID` (`ProductID`),
  CONSTRAINT `standard_ibfk_5` FOREIGN KEY (`SpecID`) REFERENCES `spec` (`SpecID`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `standard_ibfk_6` FOREIGN KEY (`ProductID`) REFERENCES `product` (`ProductID`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=222 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.standard: ~208 rows (lebih kurang)
/*!40000 ALTER TABLE `standard` DISABLE KEYS */;
REPLACE INTO `standard` (`StdID`, `SpecID`, `ProductID`, `CL`, `Allowance`) VALUES
	(9, 1, 4, 14.18, 0.2),
	(10, 2, 4, 34, 0.2),
	(11, 3, 4, 30.2, 0.15),
	(12, 4, 4, 30, 0.15),
	(13, 5, 4, 28, 0.15),
	(14, 43, 4, 28, 0.15),
	(15, 6, 4, 25.3, 0.13),
	(16, 7, 4, 28, 0.15),
	(17, 8, 4, 28, 0.15),
	(18, 9, 4, 18.8, 0.2),
	(19, 10, 4, 13.2, 0.15),
	(20, 11, 4, 18.5, 0.15),
	(21, 12, 4, 86, 0.5),
	(22, 13, 4, 1.45, 0.1),
	(23, 14, 4, 2.22, 0.1),
	(24, 1, 8, 21.99, 0.3),
	(25, 23, 8, 200, 1),
	(26, 24, 8, 21.01, 0.25),
	(27, 25, 8, 20.6, 0.25),
	(28, 26, 8, 24.94, 0.18),
	(29, 27, 8, 27.43, 0.18),
	(30, 28, 8, 27.97, 0.18),
	(31, 29, 8, 33.5, 0.3),
	(32, 30, 8, 26.16, 0.15),
	(33, 31, 8, 56, 0.6),
	(34, 32, 8, 56, 0.6),
	(35, 33, 8, 56, 0.6),
	(36, 34, 8, 56, 0.6),
	(42, 15, 4, 2.22, 0.1),
	(43, 1, 6, 14.18, 0.2),
	(44, 2, 6, 34, 0.2),
	(45, 3, 6, 30.2, 0.15),
	(46, 4, 6, 30, 0.15),
	(47, 5, 6, 28, 0.15),
	(48, 43, 6, 28, 0.15),
	(49, 6, 6, 25.3, 0.13),
	(50, 7, 6, 28, 0.15),
	(51, 8, 6, 28, 0.15),
	(52, 9, 6, 18.8, 0.2),
	(53, 10, 6, 13.2, 0.15),
	(54, 11, 6, 18.5, 0.15),
	(55, 12, 6, 86, 0.5),
	(56, 13, 6, 1.45, 0.1),
	(57, 14, 6, 2.22, 0.1),
	(58, 15, 6, 2.22, 0.1),
	(59, 1, 18, 27.5, 0.3),
	(60, 2, 18, 33, 0.38),
	(61, 3, 18, 27.97, 0.13),
	(62, 4, 18, 27.43, 0.13),
	(63, 5, 18, 24.94, 0.13),
	(64, 43, 18, 24.94, 0.13),
	(65, 8, 18, 25.71, 0.15),
	(66, 6, 18, 21.74, 0.13),
	(67, 9, 18, 22.4, 0.15),
	(68, 7, 18, 25.7, 0.15),
	(69, 10, 18, 14.1, 0.2),
	(70, 11, 18, 21, 0.25),
	(71, 12, 18, 100.05, 0.5),
	(72, 13, 18, 2.03, 0.19),
	(73, 14, 18, 3.95, 0.19),
	(74, 15, 18, 3.95, 0.19),
	(75, 41, 8, 361, 15),
	(76, 44, 8, 3.8, 3.8),
	(77, 45, 8, 17, 20),
	(78, 1, 7, 14.18, 0.2),
	(79, 2, 7, 34, 0.2),
	(80, 3, 7, 30.2, 0.15),
	(81, 4, 7, 30, 0.15),
	(82, 5, 7, 28, 0.15),
	(83, 43, 7, 28, 0.15),
	(84, 6, 7, 25.3, 0.13),
	(85, 7, 7, 28, 0.15),
	(86, 8, 7, 28, 0.15),
	(87, 9, 7, 18.8, 0.2),
	(88, 10, 7, 13.2, 0.15),
	(89, 11, 7, 18.5, 0.15),
	(90, 12, 7, 86, 0.5),
	(91, 13, 7, 1.45, 0.1),
	(92, 14, 7, 2.22, 0.1),
	(93, 15, 7, 2.22, 0.1),
	(94, 1, 11, 27.5, 0.25),
	(95, 2, 11, 34, 0.38),
	(96, 3, 11, 30.2, 0.1),
	(97, 4, 11, 30, 0.15),
	(98, 5, 11, 28, 0.15),
	(99, 43, 11, 28, 0.15),
	(100, 6, 11, 25.3, 0.13),
	(101, 7, 11, 28, 0.15),
	(102, 8, 11, 28, 0.17),
	(103, 9, 11, 25.7, 0.2),
	(104, 10, 11, 13.2, 0.15),
	(105, 11, 11, 18.5, 0.15),
	(106, 12, 11, 119, 0.5),
	(107, 13, 11, 1.45, 0.1),
	(108, 14, 11, 2.5, 0.1),
	(109, 15, 11, 2.5, 0.1),
	(110, 1, 10, 27.5, 0.25),
	(111, 2, 10, 34, 0.38),
	(112, 3, 10, 30.2, 0.1),
	(113, 4, 10, 30, 0.15),
	(114, 5, 10, 28, 0.15),
	(115, 43, 10, 28, 0.15),
	(116, 6, 10, 25.3, 0.13),
	(117, 7, 10, 28, 0.15),
	(118, 8, 10, 28, 0.17),
	(119, 9, 10, 25.7, 0.2),
	(120, 10, 10, 13.2, 0.15),
	(121, 11, 10, 18.5, 0.15),
	(122, 12, 10, 119, 0.5),
	(123, 13, 10, 1.45, 0.1),
	(124, 14, 10, 2.5, 0.1),
	(125, 15, 10, 2.5, 0.1),
	(126, 1, 9, 25.7, 0.3),
	(127, 23, 9, 214, 0.5),
	(128, 24, 9, 21.01, 0.25),
	(129, 25, 9, 20.6, 0.25),
	(130, 26, 9, 24.94, 0.18),
	(131, 27, 9, 27.43, 0.18),
	(132, 28, 9, 27.97, 0.18),
	(133, 29, 9, 33, 0.3),
	(134, 30, 9, 25.7, 0.15),
	(135, 31, 9, 65, 0.8),
	(136, 32, 9, 65, 0.8),
	(137, 33, 9, 65, 0.8),
	(138, 34, 9, 65, 0.8),
	(139, 41, 9, 500, 20),
	(140, 44, 9, 3.8, 3.8),
	(141, 45, 9, 17, 20),
	(142, 1, 12, 27.5, 0.25),
	(143, 2, 12, 34, 0.38),
	(144, 3, 12, 30.2, 0.1),
	(145, 4, 12, 30, 0.15),
	(146, 5, 12, 28, 0.15),
	(147, 43, 12, 28, 0.15),
	(148, 6, 12, 25.3, 0.13),
	(149, 7, 12, 28, 0.15),
	(150, 8, 12, 28, 0.17),
	(151, 9, 12, 25.7, 0.2),
	(152, 10, 12, 13.2, 0.15),
	(153, 11, 12, 18.5, 0.15),
	(154, 12, 12, 119, 0.5),
	(155, 13, 12, 1.45, 0.1),
	(156, 14, 12, 2.5, 0.1),
	(157, 15, 12, 2.5, 0.1),
	(158, 1, 5, 14.18, 0.2),
	(159, 2, 5, 34, 0.2),
	(160, 3, 5, 30.2, 0.1),
	(161, 4, 5, 30, 0.15),
	(162, 5, 5, 28, 0.15),
	(163, 43, 5, 28, 0.15),
	(164, 6, 5, 25.3, 0.13),
	(165, 7, 5, 28, 0.15),
	(166, 8, 5, 28, 0.15),
	(167, 9, 5, 18.8, 0.25),
	(168, 10, 5, 13.2, 0.15),
	(169, 11, 5, 18.5, 0.15),
	(170, 12, 5, 86, 0.5),
	(171, 13, 5, 1.45, 0.19),
	(172, 14, 5, 2.22, 0.19),
	(173, 15, 5, 2.22, 0.19),
	(174, 1, 13, 27.5, 0.3),
	(175, 2, 13, 33, 0.38),
	(176, 3, 13, 27.97, 0.13),
	(177, 4, 13, 27.43, 0.13),
	(178, 5, 13, 24.94, 0.13),
	(179, 43, 13, 24.94, 0.13),
	(180, 8, 13, 25.71, 0.15),
	(181, 6, 13, 21.74, 0.13),
	(182, 9, 13, 22.4, 0.15),
	(183, 7, 13, 25.7, 0.15),
	(184, 10, 13, 14.1, 0.2),
	(185, 11, 13, 21, 0.25),
	(186, 12, 13, 100.05, 0.5),
	(187, 13, 13, 2.03, 0.19),
	(188, 14, 13, 3.95, 0.19),
	(189, 15, 13, 3.95, 0.19),
	(190, 1, 14, 27.5, 0.3),
	(191, 2, 14, 33, 0.38),
	(192, 3, 14, 27.97, 0.13),
	(193, 4, 14, 27.43, 0.13),
	(194, 5, 14, 24.94, 0.13),
	(195, 43, 14, 24.94, 0.13),
	(196, 8, 14, 25.71, 0.15),
	(197, 6, 14, 21.74, 0.13),
	(198, 9, 14, 22.4, 0.15),
	(199, 7, 14, 25.7, 0.15),
	(200, 10, 14, 14.1, 0.2),
	(201, 11, 14, 21, 0.25),
	(202, 12, 14, 100.05, 0.5),
	(203, 13, 14, 2.03, 0.19),
	(204, 14, 14, 3.95, 0.19),
	(205, 15, 14, 3.95, 0.19),
	(206, 1, 15, 27.5, 0.3),
	(207, 2, 15, 33, 0.38),
	(208, 3, 15, 27.97, 0.13),
	(209, 4, 15, 27.43, 0.13),
	(210, 5, 15, 24.94, 0.13),
	(211, 43, 15, 24.94, 0.13),
	(212, 8, 15, 25.71, 0.15),
	(213, 6, 15, 21.74, 0.13),
	(214, 9, 15, 22.4, 0.15),
	(215, 7, 15, 25.7, 0.15),
	(216, 10, 15, 14.1, 0.2),
	(217, 11, 15, 21, 0.25),
	(218, 12, 15, 100.05, 0.5),
	(219, 13, 15, 2.03, 0.19),
	(220, 14, 15, 3.95, 0.19),
	(221, 15, 15, 3.95, 0.19);
/*!40000 ALTER TABLE `standard` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.stpj
CREATE TABLE IF NOT EXISTS `stpj` (
  `STPJ_ID` int(255) NOT NULL AUTO_INCREMENT,
  `PlanID` int(11) DEFAULT NULL,
  `Shift` int(1) NOT NULL,
  `Jam` time DEFAULT NULL,
  `Del_ID` int(11) DEFAULT NULL,
  `Material` varchar(35) NOT NULL,
  `Kode` int(7) DEFAULT NULL,
  `NoLot` varchar(15) DEFAULT NULL,
  `Nick` int(10) DEFAULT NULL,
  `Qty` int(3) NOT NULL DEFAULT '1',
  `Lock` int(1) NOT NULL,
  `Status` int(1) DEFAULT NULL,
  PRIMARY KEY (`STPJ_ID`),
  KEY `PlanID` (`PlanID`),
  KEY `Del_ID` (`Del_ID`),
  CONSTRAINT `stpj_ibfk_1` FOREIGN KEY (`PlanID`) REFERENCES `plan` (`PlanID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `stpj_ibfk_2` FOREIGN KEY (`Del_ID`) REFERENCES `deliverytbl` (`Del_ID`) ON DELETE SET NULL ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=5246 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.stpj: ~4.034 rows (lebih kurang)
/*!40000 ALTER TABLE `stpj` DISABLE KEYS */;
REPLACE INTO `stpj` (`STPJ_ID`, `PlanID`, `Shift`, `Jam`, `Del_ID`, `Material`, `Kode`, `NoLot`, `Nick`, `Qty`, `Lock`, `Status`) VALUES
	(15, 122, 0, NULL, 5, '', 65, '0345', NULL, 1, 0, NULL),
	(16, 122, 0, NULL, 5, '', 66, '0345', NULL, 1, 0, NULL),
	(17, 122, 0, NULL, 5, '', 67, '0345', NULL, 1, 0, NULL),
	(18, 122, 0, NULL, 5, '', 68, '0345', NULL, 1, 0, NULL),
	(19, 122, 0, NULL, 5, '', 69, '0345', NULL, 1, 0, NULL),
	(20, 122, 0, NULL, 5, '', 70, '0345', NULL, 1, 0, NULL),
	(21, 122, 0, NULL, 5, '', 71, '0345', NULL, 1, 0, NULL),
	(22, 122, 0, NULL, 5, '', 72, '0345', NULL, 1, 0, NULL),
	(23, 122, 0, NULL, 5, '', 73, '0345', NULL, 1, 0, NULL),
	(24, 122, 0, NULL, 5, '', 74, '0345', NULL, 1, 0, NULL),
	(25, 122, 0, NULL, 5, '', 75, '0345', NULL, 1, 0, NULL),
	(26, 122, 0, NULL, 5, '', 76, '0345', NULL, 1, 0, NULL),
	(27, 122, 0, NULL, 5, '', 77, '0345', NULL, 1, 0, NULL),
	(28, 122, 0, NULL, 5, '', 78, '0345', NULL, 1, 0, NULL),
	(29, 122, 0, NULL, 5, '', 79, '0345', NULL, 1, 0, NULL),
	(30, 122, 0, NULL, 5, '', 80, '0345', NULL, 1, 0, NULL),
	(31, 123, 0, NULL, 6, '', 1, '0346', NULL, 1, 0, NULL),
	(32, 123, 0, NULL, 6, '', 2, '0346', NULL, 1, 0, NULL),
	(33, 123, 0, NULL, 6, '', 3, '0346', NULL, 1, 0, NULL),
	(34, 123, 0, NULL, 6, '', 4, '0346', NULL, 1, 0, NULL),
	(35, 123, 0, NULL, 6, '', 5, '0346', NULL, 1, 0, NULL),
	(36, 123, 0, NULL, 6, '', 6, '0346', NULL, 1, 0, NULL),
	(37, 123, 0, NULL, 6, '', 7, '0346', NULL, 1, 0, NULL),
	(38, 123, 0, NULL, 6, '', 8, '0346', NULL, 1, 0, NULL),
	(39, 123, 0, NULL, 6, '', 9, '0346', NULL, 1, 0, NULL),
	(40, 123, 0, NULL, 6, '', 10, '0346', NULL, 1, 0, NULL),
	(41, 123, 0, NULL, 6, '', 11, '0346', NULL, 1, 0, NULL),
	(42, 123, 0, NULL, 6, '', 12, '0346', NULL, 1, 0, NULL),
	(43, 123, 0, NULL, 6, '', 13, '0346', NULL, 1, 0, NULL),
	(44, 123, 0, NULL, 6, '', 14, '0346', NULL, 1, 0, NULL),
	(45, 123, 0, NULL, 6, '', 15, '0346', NULL, 1, 0, NULL),
	(46, 123, 0, NULL, 6, '', 16, '0346', NULL, 1, 0, NULL),
	(63, 124, 0, NULL, 7, '', 348, '0524', 0, 1, 0, NULL),
	(64, 124, 0, NULL, 7, '', 349, '0524', 0, 1, 0, NULL),
	(65, 124, 0, NULL, 7, '', 350, '0524', 0, 1, 0, NULL),
	(66, 124, 0, NULL, 7, '', 351, '0524', 0, 1, 0, NULL),
	(67, 124, 0, NULL, 7, '', 352, '0524', 0, 1, 0, NULL),
	(68, 124, 0, NULL, 7, '', 353, '0524', 0, 1, 0, NULL),
	(69, 124, 0, NULL, 7, '', 354, '0524', 0, 1, 0, NULL),
	(70, 124, 0, NULL, 7, '', 355, '0524', 0, 1, 0, NULL),
	(71, 125, 0, NULL, 7, '', 1, '0529', 0, 1, 0, NULL),
	(72, 125, 0, NULL, 7, '', 2, '0529', 0, 1, 0, NULL),
	(73, 125, 0, NULL, 7, '', 3, '0529', 7988, 1, 0, NULL),
	(74, 125, 0, NULL, 7, '', 4, '0529', 3618, 1, 0, NULL),
	(75, 125, 0, NULL, 7, '', 5, '0529', 5514, 1, 0, NULL),
	(76, 125, 0, NULL, 7, '', 6, '0529', 9432, 1, 0, NULL),
	(77, 125, 0, NULL, 7, '', 7, '0529', 7954, 1, 0, NULL),
	(78, 125, 0, NULL, 7, '', 8, '0529', 10892, 1, 0, NULL),
	(79, 125, 0, NULL, 7, '', 9, '0529', 10659, 1, 0, NULL),
	(80, 125, 0, NULL, 7, '', 10, '0529', 13730, 1, 0, NULL),
	(81, 125, 0, NULL, 7, '', 11, '0529', 7404, 1, 0, NULL),
	(82, 125, 0, NULL, 7, '', 12, '0529', 5563, 1, 0, NULL),
	(83, 125, 0, NULL, 7, '', 13, '0529', 8537, 1, 0, NULL),
	(84, 125, 0, NULL, 7, '', 14, '0529', 3429, 1, 0, NULL),
	(85, 125, 0, NULL, 7, '', 15, '0529', 7123, 1, 0, NULL),
	(86, 125, 0, NULL, 7, '', 16, '0529', 2279, 1, 0, NULL),
	(87, 125, 0, NULL, 7, '', 17, '0529', 13763, 1, 0, NULL),
	(88, 125, 0, NULL, 7, '', 18, '0529', 13768, 1, 0, NULL),
	(89, 125, 0, NULL, 7, '', 19, '0529', 13687, 1, 0, NULL),
	(90, 125, 0, NULL, 7, '', 20, '0529', 10826, 1, 0, NULL),
	(91, 125, 0, NULL, 7, '', 21, '0529', 10577, 1, 0, NULL),
	(92, 125, 0, NULL, 7, '', 22, '0529', 7849, 1, 0, NULL),
	(93, 125, 0, NULL, 7, '', 23, '0529', 5331, 1, 0, NULL),
	(94, 125, 0, NULL, 7, '', 24, '0529', 6249, 1, 0, NULL),
	(95, 125, 0, NULL, 7, '', 25, '0529', 5367, 1, 0, NULL),
	(96, 125, 0, NULL, 7, '', 26, '0529', 2143, 1, 0, NULL),
	(97, 125, 0, NULL, 7, '', 27, '0529', 4792, 1, 0, NULL),
	(98, 125, 0, NULL, 7, '', 28, '0529', 5344, 1, 0, NULL),
	(99, 125, 0, NULL, 7, '', 29, '0529', 13411, 1, 0, NULL),
	(100, 125, 0, NULL, 7, '', 30, '0529', 8042, 1, 0, NULL),
	(101, 125, 0, NULL, 7, '', 31, '0529', 4488, 1, 0, NULL),
	(102, 125, 0, NULL, 7, '', 32, '0529', 5311, 1, 0, NULL),
	(103, 125, 0, NULL, 42, '', 33, '0529', 12733, 1, 0, NULL),
	(104, 125, 0, NULL, 42, '', 34, '0529', 7360, 1, 0, NULL),
	(105, 125, 0, NULL, 42, '', 35, '0529', 234, 1, 0, NULL),
	(106, 125, 0, NULL, 42, '', 36, '0529', 5244, 1, 0, NULL),
	(224, 126, 0, NULL, 9, '', 1165, '0521', 0, 1, 0, NULL),
	(225, 126, 0, NULL, 9, '', 1166, '0521', 0, 1, 0, NULL),
	(226, 126, 0, NULL, 9, '', 1167, '0522', 0, 1, 0, NULL),
	(227, 126, 0, NULL, 9, '', 1168, '0522', 0, 1, 0, NULL),
	(228, 126, 0, NULL, 9, '', 1169, '0522', 0, 1, 0, NULL),
	(229, 126, 0, NULL, 9, '', 1170, '0522', 0, 1, 0, NULL),
	(230, 126, 0, NULL, 9, '', 1171, '0522', 0, 1, 0, NULL),
	(231, 126, 0, NULL, 9, '', 1172, '0522', 0, 1, 0, NULL),
	(232, 126, 0, NULL, 9, '', 1173, '0522', 0, 1, 0, NULL),
	(233, 126, 0, NULL, 9, '', 1174, '0522', 0, 1, 0, NULL),
	(234, 126, 0, NULL, 9, '', 1175, '0522', 0, 1, 0, NULL),
	(235, 126, 0, NULL, 9, '', 1176, '0522', 0, 1, 0, NULL),
	(236, 126, 0, NULL, 9, '', 1177, '0522', 0, 1, 0, NULL),
	(237, 126, 0, NULL, 9, '', 1178, '0522', 0, 1, 0, NULL),
	(238, 126, 0, NULL, 9, '', 1179, '0522', 0, 1, 0, NULL),
	(239, 126, 0, NULL, 9, '', 1180, '0522', 0, 1, 0, NULL),
	(240, 126, 0, NULL, 9, '', 1181, '0522', 0, 1, 0, NULL),
	(241, 126, 0, NULL, 9, '', 1182, '0522', 0, 1, 0, NULL),
	(242, 126, 0, NULL, 9, '', 1183, '0522', 0, 1, 0, NULL),
	(243, 126, 0, NULL, 9, '', 1184, '0522', 0, 1, 0, NULL),
	(244, 126, 0, NULL, 9, '', 1185, '0522', 0, 1, 0, NULL),
	(245, 126, 0, NULL, 9, '', 1186, '0522', 0, 1, 0, NULL),
	(246, 126, 0, NULL, 9, '', 1187, '0522', 0, 1, 0, NULL),
	(247, 126, 0, NULL, 9, '', 1188, '0522', 0, 1, 0, NULL),
	(248, 126, 0, NULL, 9, '', 1189, '0522', 0, 1, 0, NULL),
	(249, 126, 0, NULL, 9, '', 1190, '0522', 0, 1, 0, NULL),
	(250, 126, 0, NULL, 9, '', 1191, '0522', 0, 1, 0, NULL),
	(251, 126, 0, NULL, 9, '', 1192, '0522', 0, 1, 0, NULL),
	(252, 126, 0, NULL, 9, '', 1193, '0522', 0, 1, 0, NULL),
	(253, 126, 0, NULL, 9, '', 1194, '0522', 0, 1, 0, NULL),
	(254, 126, 0, NULL, 9, '', 1195, '0522', 0, 1, 0, NULL),
	(255, 126, 0, NULL, 9, '', 1196, '0522', 0, 1, 0, NULL),
	(256, 126, 0, NULL, 9, '', 1197, '0522', 0, 1, 0, NULL),
	(257, 126, 0, NULL, 9, '', 1198, '0522', 0, 1, 0, NULL),
	(258, 126, 0, NULL, 9, '', 1199, '0522', 0, 1, 0, NULL),
	(259, 126, 0, NULL, 9, '', 1200, '0522', 0, 1, 0, NULL),
	(260, 126, 0, NULL, 9, '', 1201, '0522', 0, 1, 0, NULL),
	(261, 126, 0, NULL, 9, '', 1202, '0522', 0, 1, 0, NULL),
	(262, 126, 0, NULL, 15, '', 1203, '0523', 0, 1, 0, NULL),
	(263, 126, 0, NULL, 15, '', 1204, '0523', 0, 1, 0, NULL),
	(264, 126, 0, NULL, 15, '', 1205, '0523', 0, 1, 0, NULL),
	(265, 126, 0, NULL, 15, '', 1206, '0523', 0, 1, 0, NULL),
	(266, 126, 0, NULL, 15, '', 1207, '0523', 0, 1, 0, NULL),
	(267, 126, 0, NULL, 15, '', 1208, '0523', 0, 1, 0, NULL),
	(268, 126, 0, NULL, 15, '', 1209, '0523', 0, 1, 0, NULL),
	(269, 126, 0, NULL, 15, '', 1210, '0523', 0, 1, 0, NULL),
	(270, 126, 0, NULL, 15, '', 1211, '0523', 0, 1, 0, NULL),
	(271, 126, 0, NULL, 15, '', 1212, '0523', 0, 1, 0, NULL),
	(272, 126, 0, NULL, 15, '', 1213, '0523', 0, 1, 0, NULL),
	(273, 126, 0, NULL, 15, '', 1214, '0523', 0, 1, 0, NULL),
	(274, 126, 0, NULL, 15, '', 1215, '0523', 0, 1, 0, NULL),
	(275, 126, 0, NULL, 15, '', 1216, '0523', 0, 1, 0, NULL),
	(276, 126, 0, NULL, 15, '', 1217, '0523', 0, 1, 0, NULL),
	(277, 126, 0, NULL, 15, '', 1218, '0523', 0, 1, 0, NULL),
	(278, 126, 0, NULL, 15, '', 1219, '0523', 0, 1, 0, NULL),
	(279, 126, 0, NULL, 15, '', 1220, '0523', 0, 1, 0, NULL),
	(280, 126, 0, NULL, 15, '', 1221, '0523', 0, 1, 0, NULL),
	(281, 126, 0, NULL, 15, '', 1222, '0523', 0, 1, 0, NULL),
	(282, 126, 0, NULL, 15, '', 1223, '0523', 0, 1, 0, NULL),
	(283, 126, 0, NULL, 15, '', 1224, '0523', 0, 1, 0, NULL),
	(284, 126, 0, NULL, 15, '', 1225, '0523', 0, 1, 0, NULL),
	(285, 126, 0, NULL, 15, '', 1226, '0523', 0, 1, 0, NULL),
	(286, 126, 0, NULL, 15, '', 1227, '0523', 0, 1, 0, NULL),
	(287, 126, 0, NULL, 15, '', 1228, '0523', 0, 1, 0, NULL),
	(288, 126, 0, NULL, 15, '', 1229, '0523', 0, 1, 0, NULL),
	(289, 126, 0, NULL, 15, '', 1230, '0523', 0, 1, 0, NULL),
	(290, 126, 0, NULL, 15, '', 1231, '0523', 0, 1, 0, NULL),
	(291, 126, 0, NULL, 15, '', 1232, '0523', 0, 1, 0, NULL),
	(292, 126, 0, NULL, 15, '', 1233, '0523', 0, 1, 0, NULL),
	(293, 126, 0, NULL, 15, '', 1234, '0523', 0, 1, 0, NULL),
	(294, 126, 0, NULL, 15, '', 1235, '0523', 0, 1, 0, NULL),
	(295, 126, 0, NULL, 15, '', 1236, '0523', 0, 1, 0, NULL),
	(297, 126, 0, NULL, 9, '', 1079, '0521', 0, 1, 0, NULL),
	(298, 126, 0, NULL, 9, '', 1080, '0521', 0, 1, 0, NULL),
	(369, 128, 0, NULL, 10, '', 95, '0466', 0, 9, 0, NULL),
	(370, 128, 0, NULL, 10, '', 96, '0466', 0, 15, 0, NULL),
	(371, 128, 0, NULL, 10, '', 97, '0466', 0, 15, 0, NULL),
	(372, 128, 0, NULL, 10, '', 98, '0466', 0, 15, 0, NULL),
	(373, 128, 0, NULL, 10, '', 99, '0466', 0, 15, 0, NULL),
	(374, 128, 0, NULL, 10, '', 100, '0466', 0, 15, 0, NULL),
	(375, 128, 0, NULL, 10, '', 101, '0466', 0, 15, 0, NULL),
	(376, 128, 0, NULL, 10, '', 102, '0466', 0, 15, 0, NULL),
	(377, 128, 0, NULL, 10, '', 103, '0466', 0, 15, 0, NULL),
	(378, 128, 0, NULL, 10, '', 104, '0466', 0, 15, 0, NULL),
	(379, 128, 0, NULL, 10, '', 105, '0466', 0, 15, 0, NULL),
	(380, 128, 0, NULL, 10, '', 106, '0466', 0, 15, 0, NULL),
	(381, 128, 0, NULL, 10, '', 107, '0466', 0, 15, 0, NULL),
	(382, 128, 0, NULL, 10, '', 108, '0466', 0, 15, 0, NULL),
	(383, 128, 0, NULL, 10, '', 109, '0466', 0, 15, 0, NULL),
	(384, 128, 0, NULL, 10, '', 110, '0466', 0, 15, 0, NULL),
	(385, 128, 0, NULL, 10, '', 111, '0466', 0, 15, 0, NULL),
	(386, 128, 0, NULL, 10, '', 112, '0466', 0, 15, 0, NULL),
	(387, 128, 0, NULL, 10, '', 113, '0466', 0, 15, 0, NULL),
	(388, 128, 0, NULL, 10, '', 114, '0466', 0, 15, 0, NULL),
	(389, 128, 0, NULL, 10, '', 115, '0466', 0, 6, 0, NULL),
	(390, 129, 0, NULL, 11, '', 127, '0044', 4991, 1, 0, NULL),
	(391, 129, 0, NULL, 11, '', 128, '0044', 12433, 1, 0, NULL),
	(392, 129, 0, NULL, 11, '', 129, '0044', 1757, 1, 0, NULL),
	(393, 129, 0, NULL, 11, '', 130, '0044', 6767, 1, 0, NULL),
	(394, 129, 0, NULL, 11, '', 131, '0044', 8984, 1, 0, NULL),
	(395, 129, 0, NULL, 11, '', 132, '0044', 2513, 1, 0, NULL),
	(396, 129, 0, NULL, 11, '', 133, '0044', 9887, 1, 0, NULL),
	(397, 129, 0, NULL, 11, '', 134, '0044', 9770, 1, 0, NULL),
	(398, 129, 0, NULL, 11, '', 135, '0044', 11735, 1, 0, NULL),
	(399, 129, 0, NULL, 11, '', 136, '0044', 9980, 1, 0, NULL),
	(400, 129, 0, NULL, 11, '', 137, '0044', 9009, 1, 0, NULL),
	(401, 129, 0, NULL, 11, '', 138, '0044', 2675, 1, 0, NULL),
	(402, 129, 0, NULL, 11, '', 139, '0044', 10193, 1, 0, NULL),
	(403, 129, 0, NULL, 11, '', 140, '0044', 13709, 1, 0, NULL),
	(404, 129, 0, NULL, 11, '', 141, '0044', 3034, 1, 0, NULL),
	(405, 129, 0, NULL, 11, '', 142, '0044', 4406, 1, 0, NULL),
	(406, 129, 0, NULL, 11, '', 143, '0044', 5321, 1, 0, NULL),
	(407, 129, 0, NULL, 11, '', 144, '0044', 5961, 1, 0, NULL),
	(408, 130, 0, NULL, 11, '', 145, '0045', 9708, 1, 0, NULL),
	(409, 130, 0, NULL, 11, '', 146, '0045', 11698, 1, 0, NULL),
	(410, 130, 0, NULL, 11, '', 147, '0045', 13694, 1, 0, NULL),
	(411, 130, 0, NULL, 11, '', 148, '0045', 136, 1, 0, NULL),
	(412, 130, 0, NULL, 11, '', 149, '0045', 11105, 1, 0, NULL),
	(413, 130, 0, NULL, 11, '', 150, '0045', 7152, 1, 0, NULL),
	(414, 130, 0, NULL, 11, '', 151, '0045', 2717, 1, 0, NULL),
	(415, 130, 0, NULL, 11, '', 152, '0045', 12875, 1, 0, NULL),
	(416, 130, 0, NULL, 11, '', 153, '0045', 6201, 1, 0, NULL),
	(417, 130, 0, NULL, 11, '', 154, '0045', 11898, 1, 0, NULL),
	(418, 130, 0, NULL, 11, '', 155, '0045', 1961, 1, 0, NULL),
	(419, 130, 0, NULL, 11, '', 156, '0045', 2005, 1, 0, NULL),
	(420, 130, 0, NULL, 11, '', 157, '0045', 6834, 1, 0, NULL),
	(421, 130, 0, NULL, 11, '', 158, '0045', 8978, 1, 0, NULL),
	(422, 130, 0, NULL, 11, '', 159, '0045', 10939, 1, 0, NULL),
	(423, 130, 0, NULL, 11, '', 160, '0045', 13314, 1, 0, NULL),
	(424, 130, 0, NULL, 11, '', 161, '0045', 8287, 1, 0, NULL),
	(425, 130, 0, NULL, 11, '', 162, '0045', 7615, 1, 0, NULL),
	(426, 130, 0, NULL, 11, '', 163, '0045', 8406, 1, 0, NULL),
	(427, 130, 0, NULL, 11, '', 164, '0045', 10745, 1, 0, NULL),
	(428, 130, 0, NULL, 11, '', 165, '0045', 10231, 1, 0, NULL),
	(429, 130, 0, NULL, 11, '', 166, '0045', 2634, 1, 0, NULL),
	(430, 130, 0, NULL, 11, '', 167, '0045', 11287, 1, 0, NULL),
	(431, 130, 0, NULL, 11, '', 168, '0045', 288, 1, 0, NULL),
	(433, 128, 0, NULL, 16, '', 115, '0466', NULL, 9, 0, NULL),
	(434, 131, 0, NULL, 12, '', 17, '0347', NULL, 1, 0, NULL),
	(435, 131, 0, NULL, 12, '', 18, '0347', NULL, 1, 0, NULL),
	(436, 131, 0, NULL, 12, '', 19, '0347', NULL, 1, 0, NULL),
	(437, 131, 0, NULL, 12, '', 20, '0347', NULL, 1, 0, NULL),
	(438, 131, 0, NULL, 12, '', 21, '0347', NULL, 1, 0, NULL),
	(439, 131, 0, NULL, 12, '', 22, '0347', NULL, 1, 0, NULL),
	(440, 131, 0, NULL, 12, '', 23, '0347', NULL, 1, 0, NULL),
	(441, 131, 0, NULL, 12, '', 24, '0347', NULL, 1, 0, NULL),
	(442, 131, 0, NULL, 12, '', 25, '0347', NULL, 1, 0, NULL),
	(443, 131, 0, NULL, 12, '', 26, '0347', NULL, 1, 0, NULL),
	(444, 131, 0, NULL, 12, '', 27, '0347', NULL, 1, 0, NULL),
	(445, 131, 0, NULL, 12, '', 28, '0347', NULL, 1, 0, NULL),
	(446, 131, 0, NULL, 12, '', 29, '0347', NULL, 1, 0, NULL),
	(447, 131, 0, NULL, 12, '', 30, '0347', NULL, 1, 0, NULL),
	(448, 131, 0, NULL, 12, '', 31, '0347', NULL, 1, 0, NULL),
	(449, 131, 0, NULL, 12, '', 32, '0347', NULL, 1, 0, NULL),
	(450, 131, 0, NULL, 13, '', 33, '0347', NULL, 1, 0, NULL),
	(451, 131, 0, NULL, 13, '', 34, '0347', NULL, 1, 0, NULL),
	(452, 131, 0, NULL, 13, '', 35, '0347', NULL, 1, 0, NULL),
	(453, 131, 0, NULL, 13, '', 36, '0347', NULL, 1, 0, NULL),
	(454, 131, 0, NULL, 13, '', 37, '0347', NULL, 1, 0, NULL),
	(455, 131, 0, NULL, 13, '', 38, '0347', NULL, 1, 0, NULL),
	(456, 131, 0, NULL, 13, '', 39, '0347', NULL, 1, 0, NULL),
	(457, 131, 0, NULL, 13, '', 40, '0347', NULL, 1, 0, NULL),
	(458, 131, 0, NULL, 13, '', 41, '0347', NULL, 1, 0, NULL),
	(459, 131, 0, NULL, 13, '', 42, '0347', NULL, 1, 0, NULL),
	(460, 107, 0, NULL, 13, '', 1, '0348', NULL, 1, 0, NULL),
	(461, 107, 0, NULL, 13, '', 2, '0348', NULL, 1, 0, NULL),
	(462, 107, 0, NULL, 13, '', 3, '0348', NULL, 1, 0, NULL),
	(463, 107, 0, NULL, 13, '', 4, '0348', NULL, 1, 0, NULL),
	(464, 107, 0, NULL, 13, '', 5, '0348', NULL, 1, 0, NULL),
	(465, 107, 0, NULL, 13, '', 6, '0348', NULL, 1, 0, NULL),
	(466, 107, 0, NULL, 14, '', 7, '0348', NULL, 1, 0, NULL),
	(467, 107, 0, NULL, 14, '', 8, '0348', NULL, 1, 0, NULL),
	(468, 107, 0, NULL, 14, '', 9, '0348', NULL, 1, 0, NULL),
	(469, 107, 0, NULL, 14, '', 10, '0348', NULL, 1, 0, NULL),
	(470, 107, 0, NULL, 14, '', 11, '0348', NULL, 1, 0, NULL),
	(471, 107, 0, NULL, 14, '', 12, '0348', NULL, 1, 0, NULL),
	(472, 107, 0, NULL, 14, '', 13, '0348', NULL, 1, 0, NULL),
	(473, 107, 0, NULL, 14, '', 14, '0348', NULL, 1, 0, NULL),
	(474, 107, 0, NULL, 14, '', 15, '0348', NULL, 1, 0, NULL),
	(475, 107, 0, NULL, 14, '', 16, '0348', NULL, 1, 0, NULL),
	(476, 107, 0, NULL, 14, '', 17, '0348', NULL, 1, 0, NULL),
	(477, 107, 0, NULL, 14, '', 18, '0348', NULL, 1, 0, NULL),
	(478, 107, 0, NULL, 14, '', 19, '0348', NULL, 1, 0, NULL),
	(479, 107, 0, NULL, 14, '', 20, '0348', NULL, 1, 0, NULL),
	(480, 107, 0, NULL, 14, '', 21, '0348', NULL, 1, 0, NULL),
	(481, 107, 0, NULL, 14, '', 22, '0348', NULL, 1, 0, NULL),
	(482, 107, 0, NULL, 19, '', 23, '0348', NULL, 1, 0, NULL),
	(483, 107, 0, NULL, 19, '', 24, '0348', NULL, 1, 0, NULL),
	(484, 107, 0, NULL, 19, '', 25, '0348', NULL, 1, 0, NULL),
	(485, 107, 0, NULL, 19, '', 26, '0348', NULL, 1, 0, NULL),
	(486, 107, 0, NULL, 19, '', 27, '0348', NULL, 1, 0, NULL),
	(487, 107, 0, NULL, 19, '', 28, '0348', NULL, 1, 0, NULL),
	(488, 107, 0, NULL, 19, '', 29, '0348', NULL, 1, 0, NULL),
	(489, 107, 0, NULL, 19, '', 30, '0348', NULL, 1, 0, NULL),
	(490, 107, 0, NULL, 19, '', 31, '0348', NULL, 1, 0, NULL),
	(491, 107, 0, NULL, 19, '', 32, '0348', NULL, 1, 0, NULL),
	(492, 107, 0, NULL, 19, '', 33, '0348', NULL, 1, 0, NULL),
	(493, 107, 0, NULL, 19, '', 34, '0348', NULL, 1, 0, NULL),
	(494, 107, 0, NULL, 19, '', 35, '0348', NULL, 1, 0, NULL),
	(495, 107, 0, NULL, 19, '', 36, '0348', NULL, 1, 0, NULL),
	(496, 107, 0, NULL, 19, '', 37, '0348', NULL, 1, 0, NULL),
	(497, 107, 0, NULL, 19, '', 38, '0348', NULL, 1, 0, NULL),
	(498, 107, 0, NULL, 20, '', 39, '0348', NULL, 1, 0, NULL),
	(499, 107, 0, NULL, 20, '', 40, '0348', NULL, 1, 0, NULL),
	(500, 107, 0, NULL, 20, '', 41, '0348', NULL, 1, 0, NULL),
	(501, 107, 0, NULL, 20, '', 42, '0348', NULL, 1, 0, NULL),
	(502, 107, 0, NULL, 20, '', 43, '0348', NULL, 1, 0, NULL),
	(503, 107, 0, NULL, 20, '', 44, '0348', NULL, 1, 0, NULL),
	(504, 107, 0, NULL, 20, '', 45, '0348', NULL, 1, 0, NULL),
	(505, 107, 0, NULL, 20, '', 46, '0348', NULL, 1, 0, NULL),
	(506, 107, 0, NULL, 20, '', 47, '0348', NULL, 1, 0, NULL),
	(507, 107, 0, NULL, 20, '', 48, '0348', NULL, 1, 0, NULL),
	(508, 107, 0, NULL, 20, '', 49, '0348', NULL, 1, 0, NULL),
	(509, 107, 0, NULL, 20, '', 50, '0348', NULL, 1, 0, NULL),
	(510, 107, 0, NULL, 20, '', 51, '0348', NULL, 1, 0, NULL),
	(511, 107, 0, NULL, 20, '', 52, '0348', NULL, 1, 0, NULL),
	(582, 133, 0, NULL, 15, '', 1237, '0524', 4819, 1, 0, NULL),
	(583, 133, 0, NULL, 15, '', 1238, '0524', 12895, 1, 0, NULL),
	(584, 133, 0, NULL, 15, '', 1239, '0524', 11479, 1, 0, NULL),
	(585, 133, 0, NULL, 15, '', 1240, '0524', 3440, 1, 0, NULL),
	(586, 133, 0, NULL, 15, '', 1241, '0524', 2170, 1, 0, NULL),
	(587, 133, 0, NULL, 15, '', 1242, '0524', 5408, 1, 0, NULL),
	(588, 133, 0, NULL, 21, '', 1243, '0524', 4041, 1, 0, NULL),
	(589, 133, 0, NULL, 21, '', 1244, '0524', 5305, 1, 0, NULL),
	(590, 133, 0, NULL, 21, '', 1245, '0524', 3019, 1, 0, NULL),
	(591, 133, 0, NULL, 21, '', 1246, '0524', 3962, 1, 0, NULL),
	(592, 133, 0, NULL, 21, '', 1247, '0524', 3121, 1, 0, NULL),
	(593, 133, 0, NULL, 21, '', 1248, '0524', 7532, 1, 0, NULL),
	(594, 133, 0, NULL, 21, '', 1249, '0524', 3996, 1, 0, NULL),
	(595, 133, 0, NULL, 21, '', 1250, '0524', 11643, 1, 0, NULL),
	(596, 133, 0, NULL, 21, '', 1251, '0524', 5745, 1, 0, NULL),
	(597, 133, 0, NULL, 21, '', 1252, '0524', 2805, 1, 0, NULL),
	(598, 133, 0, NULL, 21, '', 1253, '0524', 4781, 1, 0, NULL),
	(599, 133, 0, NULL, 21, '', 1254, '0524', 13803, 1, 0, NULL),
	(600, 133, 0, NULL, 21, '', 1255, '0524', 2068, 1, 0, NULL),
	(601, 133, 0, NULL, 21, '', 1256, '0524', 2760, 1, 0, NULL),
	(602, 133, 0, NULL, 21, '', 1257, '0524', 9627, 1, 0, NULL),
	(603, 133, 0, NULL, 21, '', 1258, '0524', 3905, 1, 0, NULL),
	(604, 133, 0, NULL, 21, '', 1259, '0524', 10871, 1, 0, NULL),
	(605, 133, 0, NULL, 21, '', 1260, '0524', 6614, 1, 0, NULL),
	(606, 133, 0, NULL, 21, '', 1261, '0524', 3555, 1, 0, NULL),
	(607, 133, 0, NULL, 21, '', 1262, '0524', 5297, 1, 0, NULL),
	(608, 133, 0, NULL, 21, '', 1263, '0524', 7021, 1, 0, NULL),
	(609, 133, 0, NULL, 21, '', 1264, '0524', 4837, 1, 0, NULL),
	(610, 133, 0, NULL, 21, '', 1265, '0524', 2116, 1, 0, NULL),
	(611, 133, 0, NULL, 21, '', 1266, '0524', 4886, 1, 0, NULL),
	(612, 133, 0, NULL, 21, '', 1267, '0524', 4136, 1, 0, NULL),
	(613, 133, 0, NULL, 21, '', 1268, '0524', 4169, 1, 0, NULL),
	(614, 133, 0, NULL, 21, '', 1269, '0524', 4935, 1, 0, NULL),
	(615, 133, 0, NULL, 21, '', 1270, '0524', 4708, 1, 0, NULL),
	(616, 133, 0, NULL, 21, '', 1271, '0524', 12722, 1, 0, NULL),
	(617, 133, 0, NULL, 21, '', 1272, '0525', 4773, 1, 0, NULL),
	(618, 133, 0, NULL, 21, '', 1273, '0525', 7574, 1, 0, NULL),
	(619, 133, 0, NULL, 21, '', 1274, '0525', 12591, 1, 0, NULL),
	(620, 133, 0, NULL, 21, '', 1275, '0525', 9374, 1, 0, NULL),
	(621, 133, 0, NULL, 21, '', 1276, '0525', 11614, 1, 0, NULL),
	(622, 133, 0, NULL, 21, '', 1277, '0525', 4183, 1, 0, NULL),
	(623, 133, 0, NULL, 21, '', 1278, '0525', 4587, 1, 0, NULL),
	(624, 133, 0, NULL, 21, '', 1279, '0525', 8879, 1, 0, NULL),
	(625, 133, 0, NULL, 21, '', 1280, '0525', 3738, 1, 0, NULL),
	(626, 133, 0, NULL, 21, '', 1281, '0525', 6478, 1, 0, NULL),
	(627, 133, 0, NULL, 21, '', 1282, '0525', 6250, 1, 0, NULL),
	(628, 133, 0, NULL, 26, '', 1283, '0525', 6826, 1, 0, NULL),
	(629, 133, 0, NULL, 26, '', 1284, '0525', 5679, 1, 0, NULL),
	(630, 133, 0, NULL, 26, '', 1285, '0525', 2333, 1, 0, NULL),
	(631, 133, 0, NULL, 26, '', 1286, '0525', 4296, 1, 0, NULL),
	(632, 133, 0, NULL, 26, '', 1287, '0525', 3143, 1, 0, NULL),
	(633, 133, 0, NULL, 26, '', 1288, '0525', 1932, 1, 0, NULL),
	(634, 133, 0, NULL, 26, '', 1289, '0525', 5341, 1, 0, NULL),
	(635, 133, 0, NULL, 26, '', 1290, '0525', 9295, 1, 0, NULL),
	(636, 133, 0, NULL, 26, '', 1291, '0525', 9124, 1, 0, NULL),
	(637, 133, 0, NULL, 26, '', 1292, '0525', 6751, 1, 0, NULL),
	(638, 133, 0, NULL, 26, '', 1293, '0525', 4220, 1, 0, NULL),
	(639, 133, 0, NULL, 26, '', 1294, '0525', 6910, 1, 0, NULL),
	(640, 133, 0, NULL, 26, '', 1295, '0525', 4163, 1, 0, NULL),
	(641, 133, 0, NULL, 26, '', 1296, '0525', 4124, 1, 0, NULL),
	(642, 133, 0, NULL, 26, '', 1297, '0525', 4141, 1, 0, NULL),
	(643, 133, 0, NULL, 26, '', 1298, '0525', 11968, 1, 0, NULL),
	(644, 133, 0, NULL, 26, '', 1299, '0525', 5314, 1, 0, NULL),
	(645, 133, 0, NULL, 26, '', 1300, '0525', 2966, 1, 0, NULL),
	(646, 133, 0, NULL, 26, '', 1301, '0525', 12097, 1, 0, NULL),
	(647, 133, 0, NULL, 26, '', 1302, '0525', 4881, 1, 0, NULL),
	(648, 133, 0, NULL, 26, '', 1303, '0525', 3734, 1, 0, NULL),
	(649, 133, 0, NULL, 26, '', 1304, '0525', 13072, 1, 0, NULL),
	(650, 133, 0, NULL, 26, '', 1305, '0525', 10948, 1, 0, NULL),
	(651, 133, 0, NULL, 26, '', 1306, '0525', 0, 1, 0, NULL),
	(652, 134, 0, NULL, 16, '', 1, '0526', 0, 15, 0, NULL),
	(653, 134, 0, NULL, 16, '', 2, '0526', 0, 15, 0, NULL),
	(654, 134, 0, NULL, 16, '', 3, '0526', 0, 15, 0, NULL),
	(655, 134, 0, NULL, 16, '', 4, '0526', 0, 15, 0, NULL),
	(656, 134, 0, NULL, 16, '', 5, '0526', 0, 15, 0, NULL),
	(657, 134, 0, NULL, 16, '', 6, '0526', 0, 15, 0, NULL),
	(658, 134, 0, NULL, 16, '', 7, '0526', 0, 15, 0, NULL),
	(659, 134, 0, NULL, 16, '', 8, '0526', 0, 15, 0, NULL),
	(660, 134, 0, NULL, 16, '', 9, '0526', 0, 15, 0, NULL),
	(661, 134, 0, NULL, 16, '', 10, '0526', 0, 15, 0, NULL),
	(662, 134, 0, NULL, 16, '', 11, '0526', 0, 15, 0, NULL),
	(663, 134, 0, NULL, 16, '', 12, '0526', 0, 15, 0, NULL),
	(664, 134, 0, NULL, 16, '', 13, '0526', 0, 15, 0, NULL),
	(665, 134, 0, NULL, 16, '', 14, '0526', 0, 15, 0, NULL),
	(666, 134, 0, NULL, 16, '', 15, '0526', 0, 15, 0, NULL),
	(667, 134, 0, NULL, 16, '', 16, '0526', 0, 15, 0, NULL),
	(668, 134, 0, NULL, 16, '', 17, '0526', 0, 15, 0, NULL),
	(669, 134, 0, NULL, 16, '', 18, '0526', 0, 15, 0, NULL),
	(670, 134, 0, NULL, 16, '', 19, '0526', 0, 15, 0, NULL),
	(671, 134, 0, NULL, 16, '', 20, '0526', 0, 6, 0, NULL),
	(672, 134, 0, NULL, 54, '', 21, '0526', 0, 15, 0, NULL),
	(673, 134, 0, NULL, 54, '', 22, '0526', 0, 15, 0, NULL),
	(674, 134, 0, NULL, 54, '', 23, '0526', 0, 15, 0, NULL),
	(675, 134, 0, NULL, 54, '', 24, '0526', 0, 15, 0, NULL),
	(676, 134, 0, NULL, 54, '', 20, '0526', NULL, 9, 0, NULL),
	(677, 110, 0, NULL, 20, '', 53, '0350', NULL, 1, 0, NULL),
	(678, 110, 0, NULL, 20, '', 54, '0350', NULL, 1, 0, NULL),
	(679, 110, 0, NULL, 24, '', 55, '0350', NULL, 1, 0, NULL),
	(680, 110, 0, NULL, 24, '', 56, '0350', NULL, 1, 0, NULL),
	(681, 110, 0, NULL, 24, '', 57, '0350', NULL, 1, 0, NULL),
	(682, 110, 0, NULL, 24, '', 58, '0350', NULL, 1, 0, NULL),
	(683, 110, 0, NULL, 24, '', 59, '0350', NULL, 1, 0, NULL),
	(684, 110, 0, NULL, 24, '', 60, '0350', NULL, 1, 0, NULL),
	(685, 110, 0, NULL, 24, '', 61, '0350', NULL, 1, 0, NULL),
	(686, 110, 0, NULL, 24, '', 62, '0350', NULL, 1, 0, NULL),
	(687, 110, 0, NULL, 24, '', 63, '0350', NULL, 1, 0, NULL),
	(688, 110, 0, NULL, 24, '', 64, '0350', NULL, 1, 0, NULL),
	(689, 110, 0, NULL, 24, '', 65, '0350', NULL, 1, 0, NULL),
	(690, 110, 0, NULL, 24, '', 66, '0350', NULL, 1, 0, NULL),
	(691, 110, 0, NULL, 24, '', 67, '0350', NULL, 1, 0, NULL),
	(692, 110, 0, NULL, 24, '', 68, '0350', NULL, 1, 0, NULL),
	(693, 110, 0, NULL, 24, '', 69, '0350', NULL, 1, 0, NULL),
	(694, 110, 0, NULL, 24, '', 70, '0350', NULL, 1, 0, NULL),
	(695, 110, 0, NULL, 25, '', 71, '0350', NULL, 1, 0, NULL),
	(696, 110, 0, NULL, 25, '', 72, '0350', NULL, 1, 0, NULL),
	(697, 110, 0, NULL, 25, '', 73, '0350', NULL, 1, 0, NULL),
	(698, 110, 0, NULL, 25, '', 74, '0350', NULL, 1, 0, NULL),
	(699, 110, 0, NULL, 25, '', 75, '0350', NULL, 1, 0, NULL),
	(700, 110, 0, NULL, 25, '', 76, '0350', NULL, 1, 0, NULL),
	(701, 110, 0, NULL, 25, '', 77, '0350', NULL, 1, 0, NULL),
	(702, 110, 0, NULL, 25, '', 78, '0350', NULL, 1, 0, NULL),
	(703, 110, 0, NULL, 25, '', 79, '0351', NULL, 1, 0, NULL),
	(704, 110, 0, NULL, 25, '', 80, '0351', NULL, 1, 0, NULL),
	(705, 110, 0, NULL, 25, '', 81, '0351', NULL, 1, 0, NULL),
	(706, 110, 0, NULL, 25, '', 82, '0351', NULL, 1, 0, NULL),
	(707, 110, 0, NULL, 25, '', 83, '0351', NULL, 1, 0, NULL),
	(708, 110, 0, NULL, 25, '', 84, '0351', NULL, 1, 0, NULL),
	(709, 110, 0, NULL, 25, '', 85, '0351', NULL, 1, 0, NULL),
	(710, 110, 0, NULL, 25, '', 86, '0351', NULL, 1, 0, NULL),
	(711, 110, 0, NULL, 31, '', 87, '0351', NULL, 1, 0, NULL),
	(712, 110, 0, NULL, 31, '', 88, '0351', NULL, 1, 0, NULL),
	(713, 110, 0, NULL, 31, '', 89, '0351', NULL, 1, 0, NULL),
	(714, 110, 0, NULL, 31, '', 90, '0351', NULL, 1, 0, NULL),
	(715, 110, 0, NULL, 31, '', 91, '0351', NULL, 1, 0, NULL),
	(716, 110, 0, NULL, 31, '', 92, '0351', NULL, 1, 0, NULL),
	(717, 110, 0, NULL, 31, '', 93, '0351', NULL, 1, 0, NULL),
	(718, 110, 0, NULL, 31, '', 94, '0351', NULL, 1, 0, NULL),
	(719, 110, 0, NULL, 31, '', 95, '0351', NULL, 1, 0, NULL),
	(720, 110, 0, NULL, 31, '', 96, '0351', NULL, 1, 0, NULL),
	(721, 110, 0, NULL, 31, '', 97, '0351', NULL, 1, 0, NULL),
	(722, 110, 0, NULL, 31, '', 98, '0351', NULL, 1, 0, NULL),
	(723, 110, 0, NULL, 31, '', 99, '0351', NULL, 1, 0, NULL),
	(724, 110, 0, NULL, 31, '', 100, '0351', NULL, 1, 0, NULL),
	(725, 110, 0, NULL, 31, '', 101, '0351', NULL, 1, 0, NULL),
	(726, 110, 0, NULL, 31, '', 102, '0351', NULL, 1, 0, NULL),
	(727, 110, 0, NULL, 32, '', 103, '0351', NULL, 1, 0, NULL),
	(728, 110, 0, NULL, 32, '', 104, '0351', NULL, 1, 0, NULL),
	(797, 104, 0, NULL, 17, '', 1, '0530', 0, 15, 0, NULL),
	(798, 104, 0, NULL, 17, '', 2, '0530', 0, 15, 0, NULL),
	(799, 104, 0, NULL, 17, '', 3, '0531', 0, 15, 0, NULL),
	(800, 104, 0, NULL, 17, '', 4, '0531', 0, 15, 0, NULL),
	(801, 104, 0, NULL, 17, '', 5, '0531', 0, 15, 0, NULL),
	(802, 104, 0, NULL, 17, '', 6, '0531', 0, 15, 0, NULL),
	(803, 104, 0, NULL, 17, '', 7, '0531', 0, 15, 0, NULL),
	(804, 104, 0, NULL, 17, '', 8, '0531', 0, 15, 0, NULL),
	(805, 104, 0, NULL, 17, '', 9, '0531', 0, 15, 0, NULL),
	(806, 104, 0, NULL, 17, '', 10, '0531', 0, 15, 0, NULL),
	(807, 104, 0, NULL, 17, '', 11, '0531', 0, 15, 0, NULL),
	(808, 104, 0, NULL, 17, '', 12, '0531', 0, 15, 0, NULL),
	(809, 104, 0, NULL, 17, '', 13, '0531', 0, 15, 0, NULL),
	(810, 104, 0, NULL, 17, '', 14, '0531', 0, 15, 0, NULL),
	(811, 104, 0, NULL, 17, '', 15, '0531', 0, 15, 0, NULL),
	(812, 104, 0, NULL, 17, '', 16, '0531', 0, 15, 0, NULL),
	(813, 104, 0, NULL, 17, '', 17, '0531', 0, 15, 0, NULL),
	(814, 104, 0, NULL, 18, '', 18, '0531', 0, 15, 0, NULL),
	(815, 104, 0, NULL, 18, '', 19, '0532', 0, 15, 0, NULL),
	(816, 104, 0, NULL, 18, '', 20, '0532', 0, 15, 0, NULL),
	(817, 104, 0, NULL, 18, '', 21, '0532', 0, 15, 0, NULL),
	(818, 104, 0, NULL, 18, '', 22, '0532', 0, 15, 0, NULL),
	(819, 104, 0, NULL, 18, '', 23, '0532', 0, 15, 0, NULL),
	(820, 104, 0, NULL, 18, '', 24, '0532', 0, 15, 0, NULL),
	(821, 104, 0, NULL, 18, '', 25, '0532', 0, 15, 0, NULL),
	(822, 104, 0, NULL, 18, '', 26, '0532', 0, 15, 0, NULL),
	(823, 104, 0, NULL, 18, '', 27, '0532', 0, 15, 0, NULL),
	(824, 104, 0, NULL, 18, '', 28, '0532', 0, 15, 0, NULL),
	(825, 104, 0, NULL, 18, '', 29, '0532', 0, 15, 0, NULL),
	(826, 104, 0, NULL, 18, '', 30, '0532', 0, 15, 0, NULL),
	(827, 104, 0, NULL, 18, '', 31, '0532', 0, 15, 0, NULL),
	(828, 104, 0, NULL, 18, '', 32, '0532', 0, 15, 0, NULL),
	(829, 104, 0, NULL, 18, '', 33, '0532', 0, 15, 0, NULL),
	(830, 104, 0, NULL, 18, '', 34, '0532', 0, 15, 0, NULL),
	(831, 135, 0, NULL, 17, '', 48, '0508', 0, 15, 0, NULL),
	(832, 135, 0, NULL, 17, '', 49, '0508', 0, 15, 0, NULL),
	(833, 135, 0, NULL, 17, '', 50, '0508', 0, 15, 0, NULL),
	(922, 108, 0, NULL, 18, '', 35, '0533', 0, 15, 0, NULL),
	(923, 108, 0, NULL, 18, '', 36, '0533', 0, 15, 0, NULL),
	(924, 108, 0, NULL, 18, '', 37, '0533', 0, 15, 0, NULL),
	(925, 108, 0, NULL, 22, '', 38, '0533', 0, 15, 0, NULL),
	(926, 108, 0, NULL, 22, '', 39, '0533', 0, 15, 0, NULL),
	(927, 108, 0, NULL, 22, '', 40, '0533', 0, 15, 0, NULL),
	(928, 108, 0, NULL, 22, '', 41, '0533', 0, 15, 0, NULL),
	(929, 108, 0, NULL, 22, '', 42, '0533', 0, 15, 0, NULL),
	(930, 108, 0, NULL, 22, '', 43, '0533', 0, 15, 0, NULL),
	(931, 108, 0, NULL, 22, '', 44, '0533', 0, 15, 0, NULL),
	(932, 108, 0, NULL, 22, '', 45, '0533', 0, 15, 0, NULL),
	(933, 108, 0, NULL, 22, '', 46, '0533', 0, 15, 0, NULL),
	(934, 108, 0, NULL, 22, '', 47, '0533', 0, 15, 0, NULL),
	(935, 108, 0, NULL, 22, '', 48, '0533', 0, 15, 0, NULL),
	(936, 108, 0, NULL, 22, '', 49, '0533', 0, 15, 0, NULL),
	(937, 108, 0, NULL, 22, '', 50, '0533', 0, 15, 0, NULL),
	(938, 108, 0, NULL, 22, '', 51, '0534', 0, 15, 0, NULL),
	(939, 108, 0, NULL, 22, '', 52, '0534', 0, 15, 0, NULL),
	(940, 108, 0, NULL, 22, '', 53, '0534', 0, 15, 0, NULL),
	(941, 108, 0, NULL, 22, '', 54, '0534', 0, 15, 0, NULL),
	(942, 108, 0, NULL, 22, '', 55, '0534', 0, 15, 0, NULL),
	(943, 108, 0, NULL, 22, '', 56, '0534', 0, 15, 0, NULL),
	(944, 108, 0, NULL, 22, '', 57, '0534', 0, 15, 0, NULL),
	(945, 108, 0, NULL, 23, '', 58, '0534', 0, 15, 0, NULL),
	(946, 108, 0, NULL, 23, '', 59, '0534', 0, 15, 0, NULL),
	(947, 108, 0, NULL, 23, '', 60, '0534', 0, 15, 0, NULL),
	(948, 108, 0, NULL, 23, '', 61, '0534', 0, 15, 0, NULL),
	(949, 108, 0, NULL, 23, '', 62, '0534', 0, 15, 0, NULL),
	(950, 108, 0, NULL, 23, '', 63, '0534', 0, 15, 0, NULL),
	(951, 108, 0, NULL, 23, '', 64, '0534', 0, 15, 0, NULL),
	(952, 108, 0, NULL, 23, '', 65, '0534', 0, 15, 0, NULL),
	(953, 108, 0, NULL, 23, '', 66, '0535', 0, 15, 0, NULL),
	(954, 108, 0, NULL, 23, '', 67, '0535', 0, 15, 0, NULL),
	(955, 108, 0, NULL, 23, '', 68, '0535', 0, 15, 0, NULL),
	(956, 108, 0, NULL, 23, '', 69, '0535', 0, 15, 0, NULL),
	(957, 108, 0, NULL, 23, '', 70, '0535', 0, 15, 0, NULL),
	(958, 108, 0, NULL, 23, '', 71, '0535', 0, 15, 0, NULL),
	(959, 108, 0, NULL, 23, '', 72, '0535', 0, 15, 0, NULL),
	(960, 108, 0, NULL, 23, '', 73, '0535', 0, 15, 0, NULL),
	(961, 108, 0, NULL, 23, '', 74, '0535', 0, 15, 0, NULL),
	(962, 108, 0, NULL, 23, '', 75, '0535', 0, 15, 0, NULL),
	(963, 108, 0, NULL, 23, '', 76, '0535', 0, 15, 0, NULL),
	(964, 108, 0, NULL, 23, '', 77, '0535', 0, 15, 0, NULL),
	(965, 108, 0, NULL, 28, '', 78, '0535', 0, 15, 0, NULL),
	(966, 108, 0, NULL, 28, '', 79, '0535', 0, 15, 0, NULL),
	(967, 108, 0, NULL, 28, '', 80, '0535', 0, 15, 0, NULL),
	(968, 108, 0, NULL, 28, '', 81, '0535', 0, 15, 0, NULL),
	(969, 136, 0, NULL, NULL, '', 4, '0001', 4765, 1, 1, NULL),
	(970, 136, 0, NULL, NULL, '', 5, '0001', 3234, 1, 1, NULL),
	(971, 137, 0, NULL, NULL, '', 171, '0300', 0, 15, 1, NULL),
	(972, 138, 0, NULL, NULL, '', 172, '0300', 0, 15, 1, NULL),
	(973, 139, 0, NULL, 44, '', 44, '0527', 0, 14, 0, NULL),
	(974, 139, 0, NULL, 44, '', 45, '0527', 0, 15, 0, NULL),
	(975, 106, 0, NULL, 26, '', 1, '0527', 1872, 1, 0, NULL),
	(976, 106, 0, NULL, 26, '', 2, '0527', 4124, 1, 0, NULL),
	(977, 106, 0, NULL, 26, '', 3, '0527', 4252, 1, 0, NULL),
	(978, 106, 0, NULL, 26, '', 4, '0527', 12169, 1, 0, NULL),
	(979, 106, 0, NULL, 26, '', 5, '0527', 7460, 1, 0, NULL),
	(980, 106, 0, NULL, 26, '', 6, '0527', 2424, 1, 0, NULL),
	(981, 106, 0, NULL, 26, '', 7, '0527', 2528, 1, 0, NULL),
	(982, 106, 0, NULL, 26, '', 8, '0527', 12161, 1, 0, NULL),
	(983, 106, 0, NULL, 26, '', 9, '0527', 11328, 1, 0, NULL),
	(984, 106, 0, NULL, 26, '', 10, '0527', 2508, 1, 0, NULL),
	(985, 106, 0, NULL, 26, '', 11, '0527', 9252, 1, 0, NULL),
	(986, 106, 0, NULL, 26, '', 12, '0527', 12544, 1, 0, NULL),
	(987, 106, 0, NULL, 26, '', 13, '0527', 11785, 1, 0, NULL),
	(988, 106, 0, NULL, 26, '', 14, '0527', 2322, 1, 0, NULL),
	(989, 106, 0, NULL, 26, '', 15, '0527', 12772, 1, 0, NULL),
	(990, 106, 0, NULL, 26, '', 16, '0527', 9016, 1, 0, NULL),
	(991, 106, 0, NULL, 33, '', 17, '0527', 2986, 1, 0, NULL),
	(992, 106, 0, NULL, 33, '', 18, '0527', 7410, 1, 0, NULL),
	(993, 106, 0, NULL, 33, '', 19, '0527', 6695, 1, 0, NULL),
	(994, 106, 0, NULL, 33, '', 20, '0527', 8017, 1, 0, NULL),
	(995, 106, 0, NULL, 33, '', 21, '0528', 6543, 1, 0, NULL),
	(996, 106, 0, NULL, 33, '', 22, '0528', 2966, 1, 0, NULL),
	(997, 106, 0, NULL, 33, '', 23, '0528', 8079, 1, 0, NULL),
	(998, 106, 0, NULL, 33, '', 24, '0528', 2383, 1, 0, NULL),
	(999, 106, 0, NULL, 33, '', 25, '0528', 5346, 1, 0, NULL),
	(1000, 106, 0, NULL, 33, '', 26, '0528', 8751, 1, 0, NULL),
	(1001, 106, 0, NULL, 33, '', 27, '0528', 7209, 1, 0, NULL),
	(1002, 106, 0, NULL, 33, '', 28, '0528', 7348, 1, 0, NULL),
	(1003, 106, 0, NULL, 33, '', 29, '0528', 2340, 1, 0, NULL),
	(1004, 106, 0, NULL, 33, '', 30, '0528', 10520, 1, 0, NULL),
	(1005, 106, 0, NULL, 33, '', 31, '0528', 6903, 1, 0, NULL),
	(1006, 106, 0, NULL, 33, '', 32, '0528', 13343, 1, 0, NULL),
	(1007, 106, 0, NULL, 33, '', 33, '0528', 9804, 1, 0, NULL),
	(1008, 106, 0, NULL, 33, '', 34, '0528', 1261, 1, 0, NULL),
	(1009, 106, 0, NULL, 33, '', 35, '0528', 10645, 1, 0, NULL),
	(1010, 106, 0, NULL, 33, '', 36, '0528', 7690, 1, 0, NULL),
	(1011, 106, 0, NULL, 33, '', 37, '0528', 5156, 1, 0, NULL),
	(1012, 106, 0, NULL, 33, '', 38, '0528', 0, 1, 0, NULL),
	(1013, 106, 0, NULL, 33, '', 39, '0528', 8841, 1, 0, NULL),
	(1014, 106, 0, NULL, 33, '', 40, '0528', 11971, 1, 0, NULL),
	(1015, 106, 0, NULL, 33, '', 41, '0528', 7352, 1, 0, NULL),
	(1016, 106, 0, NULL, 33, '', 42, '0528', 8768, 1, 0, NULL),
	(1017, 106, 0, NULL, 33, '', 43, '0528', 12613, 1, 0, NULL),
	(1018, 106, 0, NULL, 33, '', 44, '0528', 1586, 1, 0, NULL),
	(1019, 106, 0, NULL, 33, '', 45, '0528', 3708, 1, 0, NULL),
	(1020, 106, 0, NULL, 33, '', 46, '0528', 3250, 1, 0, NULL),
	(1021, 106, 0, NULL, 33, '', 47, '0528', 11759, 1, 0, NULL),
	(1022, 106, 0, NULL, 33, '', 48, '0528', 7400, 1, 0, NULL),
	(1023, 106, 0, NULL, 33, '', 49, '0528', 12080, 1, 0, NULL),
	(1024, 106, 0, NULL, 33, '', 50, '0528', 10399, 1, 0, NULL),
	(1025, 106, 0, NULL, 33, '', 51, '0528', 10532, 1, 0, NULL),
	(1026, 106, 0, NULL, 33, '', 52, '0528', 10616, 1, 0, NULL),
	(1027, 106, 0, NULL, 33, '', 53, '0528', 7123, 1, 0, NULL),
	(1028, 106, 0, NULL, 33, '', 54, '0528', 9233, 1, 0, NULL),
	(1029, 106, 0, NULL, 33, '', 55, '0528', 7807, 1, 0, NULL),
	(1030, 106, 0, NULL, 33, '', 56, '0529', 9174, 1, 0, NULL),
	(1031, 106, 0, NULL, 43, '', 57, '0529', 4951, 1, 0, NULL),
	(1032, 106, 0, NULL, 43, '', 58, '0529', 6553, 1, 0, NULL),
	(1033, 106, 0, NULL, 43, '', 59, '0529', 8608, 1, 0, NULL),
	(1034, 106, 0, NULL, 43, '', 60, '0529', 12515, 1, 0, NULL),
	(1035, 106, 0, NULL, 43, '', 61, '0529', 13498, 1, 0, NULL),
	(1036, 106, 0, NULL, 43, '', 62, '0529', 8193, 1, 0, NULL),
	(1037, 106, 0, NULL, 43, '', 63, '0529', 4605, 1, 0, NULL),
	(1038, 106, 0, NULL, 43, '', 64, '0529', 4250, 1, 0, NULL),
	(1039, 106, 0, NULL, 43, '', 65, '0529', 10605, 1, 0, NULL),
	(1040, 106, 0, NULL, 43, '', 66, '0529', 11606, 1, 0, NULL),
	(1041, 106, 0, NULL, 43, '', 67, '0529', 13392, 1, 0, NULL),
	(1042, 106, 0, NULL, 43, '', 68, '0529', 7294, 1, 0, NULL),
	(1043, 106, 0, NULL, 43, '', 69, '0529', 6090, 1, 0, NULL),
	(1044, 106, 0, NULL, 43, '', 70, '0529', 3949, 1, 0, NULL),
	(1045, 106, 0, NULL, 43, '', 71, '0529', 5354, 1, 0, NULL),
	(1046, 106, 0, NULL, 43, '', 72, '0529', 1882, 1, 0, NULL),
	(1047, 106, 0, NULL, 43, '', 73, '0529', 8884, 1, 0, NULL),
	(1048, 106, 0, NULL, 43, '', 74, '0529', 10095, 1, 0, NULL),
	(1049, 106, 0, NULL, 43, '', 75, '0529', 2810, 1, 0, NULL),
	(1050, 106, 0, NULL, 43, '', 76, '0529', 3103, 1, 0, NULL),
	(1051, 106, 0, NULL, 43, '', 77, '0529', 2084, 1, 0, NULL),
	(1052, 106, 0, NULL, 43, '', 78, '0529', 4126, 1, 0, NULL),
	(1053, 106, 0, NULL, 43, '', 79, '0529', 4487, 1, 0, NULL),
	(1054, 106, 0, NULL, 43, '', 80, '0529', 11773, 1, 0, NULL),
	(1055, 106, 0, NULL, 43, '', 81, '0529', 10119, 1, 0, NULL),
	(1056, 106, 0, NULL, 43, '', 82, '0529', 7935, 1, 0, NULL),
	(1057, 106, 0, NULL, 43, '', 83, '0529', 11019, 1, 0, NULL),
	(1058, 106, 0, NULL, 43, '', 84, '0529', 9773, 1, 0, NULL),
	(1059, 106, 0, NULL, 43, '', 85, '0529', 10783, 1, 0, NULL),
	(1060, 106, 0, NULL, 43, '', 86, '0529', 7063, 1, 0, NULL),
	(1061, 106, 0, NULL, 43, '', 87, '0529', 6871, 1, 0, NULL),
	(1062, 105, 0, NULL, 54, '', 25, '0527', 0, 15, 0, NULL),
	(1063, 105, 0, NULL, 54, '', 26, '0527', 0, 15, 0, NULL),
	(1064, 105, 0, NULL, 54, '', 27, '0527', 0, 15, 0, NULL),
	(1065, 105, 0, NULL, 54, '', 28, '0527', 0, 15, 0, NULL),
	(1066, 105, 0, NULL, 54, '', 29, '0527', 0, 15, 0, NULL),
	(1067, 105, 0, NULL, 54, '', 30, '0527', 0, 15, 0, NULL),
	(1068, 105, 0, NULL, 54, '', 31, '0527', 0, 15, 0, NULL),
	(1069, 105, 0, NULL, 54, '', 32, '0527', 0, 15, 0, NULL),
	(1070, 105, 0, NULL, 54, '', 33, '0527', 0, 15, 0, NULL),
	(1071, 105, 0, NULL, 54, '', 34, '0527', 0, 15, 0, NULL),
	(1072, 105, 0, NULL, 54, '', 35, '0527', 0, 15, 0, NULL),
	(1073, 103, 0, NULL, 42, '', 37, '0530', 13359, 1, 0, NULL),
	(1074, 103, 0, NULL, 42, '', 38, '0530', 2724, 1, 0, NULL),
	(1075, 103, 0, NULL, 42, '', 39, '0530', 5512, 1, 0, NULL),
	(1076, 103, 0, NULL, 42, '', 40, '0530', 8392, 1, 0, NULL),
	(1077, 103, 0, NULL, 42, '', 41, '0530', 4827, 1, 0, NULL),
	(1078, 103, 0, NULL, 42, '', 42, '0530', 3196, 1, 0, NULL),
	(1079, 103, 0, NULL, 42, '', 43, '0530', 9777, 1, 0, NULL),
	(1080, 103, 0, NULL, 42, '', 44, '0530', 5957, 1, 0, NULL),
	(1081, 103, 0, NULL, 42, '', 45, '0530', 4568, 1, 0, NULL),
	(1082, 103, 0, NULL, 42, '', 46, '0530', 3357, 1, 0, NULL),
	(1083, 103, 0, NULL, 42, '', 47, '0530', 2290, 1, 0, NULL),
	(1084, 103, 0, NULL, 42, '', 48, '0530', 3332, 1, 0, NULL),
	(1085, 103, 0, NULL, 42, '', 49, '0530', 2855, 1, 0, NULL),
	(1086, 103, 0, NULL, 42, '', 50, '0530', 3292, 1, 0, NULL),
	(1087, 103, 0, NULL, 42, '', 51, '0530', 4366, 1, 0, NULL),
	(1088, 103, 0, NULL, 42, '', 52, '0530', 10242, 1, 0, NULL),
	(1089, 103, 0, NULL, 42, '', 53, '0530', 5850, 1, 0, NULL),
	(1090, 103, 0, NULL, 42, '', 54, '0530', 12624, 1, 0, NULL),
	(1091, 103, 0, NULL, 42, '', 55, '0530', 4220, 1, 0, NULL),
	(1092, 103, 0, NULL, 42, '', 56, '0530', 8220, 1, 0, NULL),
	(1093, 109, 0, NULL, 27, '', 1, '0095', 8852, 1, 0, NULL),
	(1094, 109, 0, NULL, 27, '', 2, '0095', 9007, 1, 0, NULL),
	(1095, 109, 0, NULL, 27, '', 3, '0095', 7228, 1, 0, NULL),
	(1096, 109, 0, NULL, 27, '', 4, '0095', 13323, 1, 0, NULL),
	(1097, 109, 0, NULL, 27, '', 5, '0095', 1552, 1, 0, NULL),
	(1098, 109, 0, NULL, 27, '', 6, '0095', 813, 1, 0, NULL),
	(1099, 109, 0, NULL, 27, '', 7, '0095', 13688, 1, 0, NULL),
	(1100, 109, 0, NULL, 27, '', 8, '0095', 5083, 1, 0, NULL),
	(1101, 109, 0, NULL, 27, '', 9, '0095', 7730, 1, 0, NULL),
	(1102, 109, 0, NULL, 27, '', 10, '0095', 9109, 1, 0, NULL),
	(1103, 109, 0, NULL, 27, '', 11, '0095', 7917, 1, 0, NULL),
	(1104, 109, 0, NULL, 27, '', 12, '0095', 1170, 1, 0, NULL),
	(1105, 109, 0, NULL, 27, '', 13, '0095', 13716, 1, 0, NULL),
	(1106, 109, 0, NULL, 27, '', 14, '0095', 13749, 1, 0, NULL),
	(1107, 109, 0, NULL, 27, '', 15, '0095', 8633, 1, 0, NULL),
	(1108, 109, 0, NULL, 27, '', 16, '0096', 7806, 1, 0, NULL),
	(1109, 109, 0, NULL, 27, '', 17, '0096', 7794, 1, 0, NULL),
	(1110, 109, 0, NULL, 27, '', 18, '0096', 12850, 1, 0, NULL),
	(1111, 109, 0, NULL, 27, '', 19, '0096', 13754, 1, 0, NULL),
	(1112, 109, 0, NULL, 27, '', 20, '0096', 11760, 1, 0, NULL),
	(1113, 109, 0, NULL, 27, '', 21, '0096', 9936, 1, 0, NULL),
	(1114, 109, 0, NULL, 27, '', 22, '0096', 10918, 1, 0, NULL),
	(1115, 109, 0, NULL, 27, '', 23, '0096', 13108, 1, 0, NULL),
	(1116, 109, 0, NULL, 27, '', 24, '0096', 2720, 1, 0, NULL),
	(1117, 109, 0, NULL, 27, '', 25, '0096', 3795, 1, 0, NULL),
	(1118, 109, 0, NULL, 27, '', 26, '0096', 5327, 1, 0, NULL),
	(1119, 109, 0, NULL, 27, '', 27, '0096', 13276, 1, 0, NULL),
	(1120, 109, 0, NULL, 27, '', 28, '0096', 3658, 1, 0, NULL),
	(1121, 109, 0, NULL, 27, '', 29, '0096', 5879, 1, 0, NULL),
	(1122, 109, 0, NULL, 27, '', 30, '0096', 9602, 1, 0, NULL),
	(1123, 109, 0, NULL, 27, '', 31, '0096', 2211, 1, 0, NULL),
	(1124, 109, 0, NULL, 27, '', 32, '0096', 4859, 1, 0, NULL),
	(1125, 118, 0, NULL, 27, '', 33, '0097', 6729, 1, 0, NULL),
	(1126, 118, 0, NULL, 27, '', 34, '0097', 5892, 1, 0, NULL),
	(1127, 118, 0, NULL, 27, '', 35, '0097', 6025, 1, 0, NULL),
	(1128, 118, 0, NULL, 27, '', 36, '0097', 13414, 1, 0, NULL),
	(1129, 118, 0, NULL, 27, '', 37, '0097', 11433, 1, 0, NULL),
	(1130, 118, 0, NULL, 27, '', 38, '0097', 5143, 1, 0, NULL),
	(1131, 118, 0, NULL, 27, '', 39, '0097', 6516, 1, 0, NULL),
	(1132, 118, 0, NULL, 27, '', 40, '0097', 6412, 1, 0, NULL),
	(1133, 118, 0, NULL, 27, '', 41, '0097', 10010, 1, 0, NULL),
	(1134, 118, 0, NULL, 27, '', 42, '0097', 6298, 1, 0, NULL),
	(1135, 118, 0, NULL, 39, '', 43, '0097', 4207, 1, 0, NULL),
	(1136, 118, 0, NULL, 39, '', 44, '0097', 8398, 1, 0, NULL),
	(1137, 118, 0, NULL, 39, '', 45, '0097', 7788, 1, 0, NULL),
	(1138, 118, 0, NULL, 39, '', 46, '0097', 6065, 1, 0, NULL),
	(1139, 118, 0, NULL, 39, '', 47, '0097', 3812, 1, 0, NULL),
	(1140, 118, 0, NULL, 39, '', 48, '0097', 12260, 1, 0, NULL),
	(1141, 118, 0, NULL, 39, '', 49, '0097', 11779, 1, 0, NULL),
	(1142, 118, 0, NULL, 39, '', 50, '0097', 10659, 1, 0, NULL),
	(1143, 118, 0, NULL, 39, '', 51, '0098', 5303, 1, 0, NULL),
	(1144, 118, 0, NULL, 39, '', 52, '0098', 2288, 1, 0, NULL),
	(1145, 118, 0, NULL, 39, '', 53, '0098', 11570, 1, 0, NULL),
	(1146, 118, 0, NULL, 39, '', 54, '0098', 1411, 1, 0, NULL),
	(1147, 118, 0, NULL, 39, '', 55, '0098', 13695, 1, 0, NULL),
	(1148, 118, 0, NULL, 39, '', 56, '0098', 1018, 1, 0, NULL),
	(1149, 118, 0, NULL, 39, '', 57, '0098', 9399, 1, 0, NULL),
	(1150, 118, 0, NULL, 39, '', 58, '0098', 7990, 1, 0, NULL),
	(1151, 118, 0, NULL, 39, '', 59, '0098', 6169, 1, 0, NULL),
	(1152, 118, 0, NULL, 39, '', 60, '0098', 9643, 1, 0, NULL),
	(1153, 118, 0, NULL, 39, '', 61, '0098', 10219, 1, 0, NULL),
	(1154, 118, 0, NULL, 39, '', 62, '0098', 7411, 1, 0, NULL),
	(1155, 118, 0, NULL, 39, '', 63, '0098', 13678, 1, 0, NULL),
	(1156, 118, 0, NULL, 39, '', 64, '0098', 4040, 1, 0, NULL),
	(1157, 118, 0, NULL, 39, '', 65, '0098', 4020, 1, 0, NULL),
	(1158, 118, 0, NULL, 39, '', 66, '0098', 10964, 1, 0, NULL),
	(1159, 118, 0, NULL, 39, '', 67, '0098', 6529, 1, 0, NULL),
	(1160, 118, 0, NULL, 39, '', 68, '0098', 7493, 1, 0, NULL),
	(1161, 118, 0, NULL, 39, '', 69, '0099', 2761, 1, 0, NULL),
	(1162, 118, 0, NULL, 39, '', 70, '0099', 43, 1, 0, NULL),
	(1163, 118, 0, NULL, 39, '', 71, '0099', 5709, 1, 0, NULL),
	(1164, 118, 0, NULL, 39, '', 72, '0099', 1605, 1, 0, NULL),
	(1165, 118, 0, NULL, 39, '', 73, '0099', 6341, 1, 0, NULL),
	(1166, 118, 0, NULL, 39, '', 74, '0099', 4857, 1, 0, NULL),
	(1167, 118, 0, NULL, 39, '', 75, '0099', 5694, 1, 0, NULL),
	(1168, 118, 0, NULL, 39, '', 76, '0099', 5131, 1, 0, NULL),
	(1169, 118, 0, NULL, 39, '', 77, '0099', 8782, 1, 0, NULL),
	(1170, 118, 0, NULL, 39, '', 78, '0099', 2937, 1, 0, NULL),
	(1171, 118, 0, NULL, 39, '', 79, '0099', 6577, 1, 0, NULL),
	(1172, 118, 0, NULL, 39, '', 80, '0099', 5351, 1, 0, NULL),
	(1173, 118, 0, NULL, 39, '', 81, '0099', 2313, 1, 0, NULL),
	(1174, 118, 0, NULL, 39, '', 82, '0099', 2498, 1, 0, NULL),
	(1175, 118, 0, NULL, 39, '', 83, '0099', 11668, 1, 0, NULL),
	(1176, 118, 0, NULL, 39, '', 84, '0099', 4023, 1, 0, NULL),
	(1177, 118, 0, NULL, 49, '', 85, '0099', 1837, 1, 0, NULL),
	(1230, 111, 0, NULL, 32, '', 105, '0352', NULL, 1, 0, NULL),
	(1231, 111, 0, NULL, 32, '', 106, '0352', NULL, 1, 0, NULL),
	(1232, 111, 0, NULL, 32, '', 107, '0352', NULL, 1, 0, NULL),
	(1233, 111, 0, NULL, 32, '', 108, '0352', NULL, 1, 0, NULL),
	(1234, 111, 0, NULL, 32, '', 109, '0352', NULL, 1, 0, NULL),
	(1235, 111, 0, NULL, 32, '', 110, '0352', NULL, 1, 0, NULL),
	(1236, 111, 0, NULL, 32, '', 111, '0352', NULL, 1, 0, NULL),
	(1237, 111, 0, NULL, 32, '', 112, '0352', NULL, 1, 0, NULL),
	(1238, 111, 0, NULL, 32, '', 113, '0352', NULL, 1, 0, NULL),
	(1239, 111, 0, NULL, 32, '', 114, '0352', NULL, 1, 0, NULL),
	(1240, 111, 0, NULL, 32, '', 115, '0352', NULL, 1, 0, NULL),
	(1241, 111, 0, NULL, 32, '', 116, '0352', NULL, 1, 0, NULL),
	(1242, 111, 0, NULL, 32, '', 117, '0352', NULL, 1, 0, NULL),
	(1243, 111, 0, NULL, 32, '', 118, '0352', NULL, 1, 0, NULL),
	(1244, 111, 0, NULL, 46, '', 119, '0352', NULL, 1, 0, NULL),
	(1245, 111, 0, NULL, 46, '', 120, '0352', NULL, 1, 0, NULL),
	(1246, 111, 0, NULL, 46, '', 121, '0352', NULL, 1, 0, NULL),
	(1247, 111, 0, NULL, 46, '', 122, '0352', NULL, 1, 0, NULL),
	(1248, 111, 0, NULL, 46, '', 123, '0352', NULL, 1, 0, NULL),
	(1249, 111, 0, NULL, 46, '', 124, '0352', NULL, 1, 0, NULL),
	(1250, 111, 0, NULL, 46, '', 125, '0352', NULL, 1, 0, NULL),
	(1251, 111, 0, NULL, 46, '', 126, '0352', NULL, 1, 0, NULL),
	(1252, 111, 0, NULL, 46, '', 127, '0352', NULL, 1, 0, NULL),
	(1253, 111, 0, NULL, 46, '', 128, '0352', NULL, 1, 0, NULL),
	(1254, 111, 0, NULL, 46, '', 129, '0352', NULL, 1, 0, NULL),
	(1255, 111, 0, NULL, 46, '', 130, '0352', NULL, 1, 0, NULL),
	(1256, 111, 0, NULL, 46, '', 131, '0353', NULL, 1, 0, NULL),
	(1257, 111, 0, NULL, 46, '', 132, '0353', NULL, 1, 0, NULL),
	(1258, 111, 0, NULL, 46, '', 133, '0353', NULL, 1, 0, NULL),
	(1259, 111, 0, NULL, 46, '', 134, '0353', NULL, 1, 0, NULL),
	(1260, 111, 0, NULL, 51, '', 135, '0353', NULL, 1, 0, NULL),
	(1261, 111, 0, NULL, 51, '', 136, '0353', NULL, 1, 0, NULL),
	(1262, 111, 0, NULL, 51, '', 137, '0353', NULL, 1, 0, NULL),
	(1263, 111, 0, NULL, 51, '', 138, '0353', NULL, 1, 0, NULL),
	(1264, 111, 0, NULL, 51, '', 139, '0353', NULL, 1, 0, NULL),
	(1265, 111, 0, NULL, 51, '', 140, '0353', NULL, 1, 0, NULL),
	(1266, 111, 0, NULL, 51, '', 141, '0353', NULL, 1, 0, NULL),
	(1267, 111, 0, NULL, 51, '', 142, '0353', NULL, 1, 0, NULL),
	(1268, 111, 0, NULL, 51, '', 143, '0353', NULL, 1, 0, NULL),
	(1269, 111, 0, NULL, 51, '', 144, '0353', NULL, 1, 0, NULL),
	(1270, 111, 0, NULL, 51, '', 145, '0353', NULL, 1, 0, NULL),
	(1271, 111, 0, NULL, 51, '', 146, '0353', NULL, 1, 0, NULL),
	(1272, 111, 0, NULL, 51, '', 147, '0353', NULL, 1, 0, NULL),
	(1273, 111, 0, NULL, 51, '', 148, '0353', NULL, 1, 0, NULL),
	(1274, 111, 0, NULL, 51, '', 149, '0353', NULL, 1, 0, NULL),
	(1275, 111, 0, NULL, 51, '', 150, '0353', NULL, 1, 0, NULL),
	(1276, 111, 0, NULL, 52, '', 151, '0353', NULL, 1, 0, NULL),
	(1277, 111, 0, NULL, 52, '', 152, '0353', NULL, 1, 0, NULL),
	(1278, 111, 0, NULL, 52, '', 153, '0353', NULL, 1, 0, NULL),
	(1279, 111, 0, NULL, 52, '', 154, '0353', NULL, 1, 0, NULL),
	(1280, 111, 0, NULL, 52, '', 155, '0353', NULL, 1, 0, NULL),
	(1281, 111, 0, NULL, 52, '', 156, '0353', NULL, 1, 0, NULL),
	(1282, 117, 0, NULL, 28, '', 82, '0536', 0, 15, 0, NULL),
	(1283, 117, 0, NULL, 28, '', 83, '0536', 0, 15, 0, NULL),
	(1284, 117, 0, NULL, 28, '', 84, '0536', 0, 15, 0, NULL),
	(1285, 117, 0, NULL, 28, '', 85, '0536', 0, 15, 0, NULL),
	(1286, 117, 0, NULL, 28, '', 86, '0536', 0, 15, 0, NULL),
	(1287, 117, 0, NULL, 28, '', 87, '0536', 0, 15, 0, NULL),
	(1288, 117, 0, NULL, 28, '', 88, '0536', 0, 15, 0, NULL),
	(1289, 117, 0, NULL, 28, '', 89, '0536', 0, 15, 0, NULL),
	(1290, 117, 0, NULL, 28, '', 90, '0536', 0, 15, 0, NULL),
	(1291, 117, 0, NULL, 28, '', 91, '0536', 0, 15, 0, NULL),
	(1292, 117, 0, NULL, 28, '', 92, '0536', 0, 15, 0, NULL),
	(1293, 117, 0, NULL, 28, '', 93, '0536', 0, 15, 0, NULL),
	(1294, 117, 0, NULL, 28, '', 94, '0536', 0, 15, 0, NULL),
	(1295, 117, 0, NULL, 28, '', 95, '0536', 0, 15, 0, NULL),
	(1296, 117, 0, NULL, 28, '', 96, '0536', 0, 15, 0, NULL),
	(1297, 117, 0, NULL, 28, '', 97, '0536', 0, 15, 0, NULL),
	(1298, 117, 0, NULL, 29, '', 98, '0537', 0, 15, 0, NULL),
	(1299, 117, 0, NULL, 29, '', 99, '0537', 0, 15, 0, NULL),
	(1300, 117, 0, NULL, 29, '', 100, '0537', 0, 15, 0, NULL),
	(1301, 117, 0, NULL, 29, '', 101, '0537', 0, 15, 0, NULL),
	(1302, 117, 0, NULL, 29, '', 102, '0537', 0, 15, 0, NULL),
	(1303, 117, 0, NULL, 29, '', 103, '0537', 0, 15, 0, NULL),
	(1304, 117, 0, NULL, 29, '', 104, '0537', 0, 15, 0, NULL),
	(1305, 117, 0, NULL, 29, '', 105, '0537', 0, 15, 0, NULL),
	(1306, 117, 0, NULL, 29, '', 106, '0537', 0, 15, 0, NULL),
	(1307, 117, 0, NULL, 29, '', 107, '0537', 0, 15, 0, NULL),
	(1308, 117, 0, NULL, 29, '', 108, '0537', 0, 15, 0, NULL),
	(1309, 117, 0, NULL, 29, '', 109, '0537', 0, 15, 0, NULL),
	(1310, 117, 0, NULL, 29, '', 110, '0537', 0, 15, 0, NULL),
	(1311, 117, 0, NULL, 29, '', 111, '0537', 0, 15, 0, NULL),
	(1312, 117, 0, NULL, 29, '', 112, '0537', 0, 15, 0, NULL),
	(1313, 117, 0, NULL, 29, '', 113, '0537', 0, 15, 0, NULL),
	(1314, 117, 0, NULL, 29, '', 114, '0538', 0, 15, 0, NULL),
	(1315, 117, 0, NULL, 29, '', 115, '0538', 0, 15, 0, NULL),
	(1316, 117, 0, NULL, 29, '', 116, '0538', 0, 15, 0, NULL),
	(1317, 117, 0, NULL, 29, '', 117, '0538', 0, 15, 0, NULL),
	(1318, 117, 0, NULL, 30, '', 118, '0538', 0, 15, 0, NULL),
	(1319, 117, 0, NULL, 30, '', 119, '0538', 0, 15, 0, NULL),
	(1320, 117, 0, NULL, 30, '', 120, '0538', 0, 15, 0, NULL),
	(1321, 117, 0, NULL, 30, '', 121, '0538', 0, 15, 0, NULL),
	(1322, 117, 0, NULL, 30, '', 122, '0538', 0, 15, 0, NULL),
	(1323, 117, 0, NULL, 30, '', 123, '0538', 0, 15, 0, NULL),
	(1324, 117, 0, NULL, 30, '', 124, '0538', 0, 15, 0, NULL),
	(1325, 117, 0, NULL, 30, '', 125, '0538', 0, 15, 0, NULL),
	(1326, 117, 0, NULL, 30, '', 126, '0538', 0, 15, 0, NULL),
	(1327, 117, 0, NULL, 30, '', 127, '0538', 0, 15, 0, NULL),
	(1328, 117, 0, NULL, 30, '', 128, '0538', 0, 15, 0, NULL),
	(1329, 114, 0, NULL, 30, '', 129, '0539', 0, 15, 0, NULL),
	(1330, 114, 0, NULL, 30, '', 130, '0539', 0, 15, 0, NULL),
	(1331, 114, 0, NULL, 30, '', 131, '0539', 0, 15, 0, NULL),
	(1332, 114, 0, NULL, 30, '', 132, '0539', 0, 15, 0, NULL),
	(1333, 114, 0, NULL, 30, '', 133, '0539', 0, 15, 0, NULL),
	(1334, 114, 0, NULL, 30, '', 134, '0539', 0, 15, 0, NULL),
	(1335, 114, 0, NULL, 30, '', 135, '0539', 0, 15, 0, NULL),
	(1336, 114, 0, NULL, 30, '', 136, '0539', 0, 15, 0, NULL),
	(1337, 114, 0, NULL, 30, '', 137, '0539', 0, 15, 0, NULL),
	(1338, 114, 0, NULL, 34, '', 138, '0539', 0, 15, 0, NULL),
	(1339, 114, 0, NULL, 34, '', 139, '0539', 0, 15, 0, NULL),
	(1340, 114, 0, NULL, 34, '', 140, '0539', 0, 15, 0, NULL),
	(1341, 114, 0, NULL, 34, '', 141, '0539', 0, 15, 0, NULL),
	(1342, 114, 0, NULL, 34, '', 142, '0539', 0, 15, 0, NULL),
	(1343, 114, 0, NULL, 34, '', 143, '0539', 0, 15, 0, NULL),
	(1344, 114, 0, NULL, 34, '', 144, '0539', 0, 15, 0, NULL),
	(1345, 114, 0, NULL, 34, '', 145, '0540', 0, 15, 0, NULL),
	(1346, 114, 0, NULL, 34, '', 146, '0540', 0, 15, 0, NULL),
	(1347, 114, 0, NULL, 34, '', 147, '0540', 0, 15, 0, NULL),
	(1348, 114, 0, NULL, 34, '', 148, '0540', 0, 15, 0, NULL),
	(1349, 114, 0, NULL, 34, '', 149, '0540', 0, 15, 0, NULL),
	(1350, 114, 0, NULL, 34, '', 150, '0540', 0, 15, 0, NULL),
	(1351, 114, 0, NULL, 34, '', 151, '0540', 0, 15, 0, NULL),
	(1352, 114, 0, NULL, 34, '', 152, '0540', 0, 15, 0, NULL),
	(1353, 114, 0, NULL, 34, '', 153, '0540', 0, 15, 0, NULL),
	(1354, 114, 0, NULL, 34, '', 154, '0540', 0, 15, 0, NULL),
	(1355, 114, 0, NULL, 34, '', 155, '0540', 0, 15, 0, NULL),
	(1356, 114, 0, NULL, 34, '', 156, '0540', 0, 15, 0, NULL),
	(1357, 114, 0, NULL, 34, '', 157, '0540', 0, 15, 0, NULL),
	(1358, 114, 0, NULL, 35, '', 158, '0540', 0, 15, 0, NULL),
	(1359, 114, 0, NULL, 35, '', 159, '0540', 0, 15, 0, NULL),
	(1360, 114, 0, NULL, 35, '', 160, '0540', 0, 15, 0, NULL),
	(1361, 114, 0, NULL, 35, '', 161, '0541', 0, 15, 0, NULL),
	(1362, 114, 0, NULL, 35, '', 162, '0541', 0, 15, 0, NULL),
	(1363, 114, 0, NULL, 35, '', 163, '0541', 0, 15, 0, NULL),
	(1364, 114, 0, NULL, 35, '', 164, '0541', 0, 15, 0, NULL),
	(1365, 114, 0, NULL, 35, '', 165, '0541', 0, 15, 0, NULL),
	(1366, 114, 0, NULL, 35, '', 166, '0541', 0, 15, 0, NULL),
	(1367, 114, 0, NULL, 35, '', 167, '0541', 0, 15, 0, NULL),
	(1368, 114, 0, NULL, 35, '', 168, '0541', 0, 15, 0, NULL),
	(1369, 114, 0, NULL, 35, '', 169, '0541', 0, 15, 0, NULL),
	(1370, 114, 0, NULL, 35, '', 170, '0541', 0, 15, 0, NULL),
	(1371, 114, 0, NULL, 35, '', 171, '0541', 0, 15, 0, NULL),
	(1372, 114, 0, NULL, 35, '', 172, '0541', 0, 15, 0, NULL),
	(1373, 114, 0, NULL, 35, '', 173, '0541', 0, 15, 0, NULL),
	(1374, 114, 0, NULL, 35, '', 174, '0541', 0, 15, 0, NULL),
	(1375, 114, 0, NULL, 35, '', 175, '0541', 0, 15, 0, NULL),
	(1376, 114, 0, NULL, 35, '', 176, '0541', 0, 15, 0, NULL),
	(1377, 119, 0, NULL, 50, '', 86, '0100', 8444, 1, 0, NULL),
	(1378, 119, 0, NULL, 49, '', 87, '0100', 10956, 1, 0, NULL),
	(1379, 119, 0, NULL, 50, '', 88, '0100', 4090, 1, 0, NULL),
	(1380, 119, 0, NULL, 50, '', 89, '0100', 1152, 1, 0, NULL),
	(1381, 119, 0, NULL, 50, '', 90, '0100', 5084, 1, 0, NULL),
	(1382, 119, 0, NULL, 50, '', 91, '0100', 1986, 1, 0, NULL),
	(1383, 119, 0, NULL, 50, '', 92, '0100', 4348, 1, 0, NULL),
	(1384, 119, 0, NULL, 50, '', 93, '0100', 3175, 1, 0, NULL),
	(1385, 119, 0, NULL, 50, '', 94, '0100', 2283, 1, 0, NULL),
	(1386, 119, 0, NULL, 50, '', 95, '0100', 8549, 1, 0, NULL),
	(1387, 119, 0, NULL, 50, '', 96, '0100', 13396, 1, 0, NULL),
	(1388, 119, 0, NULL, 50, '', 97, '0100', 5440, 1, 0, NULL),
	(1389, 119, 0, NULL, 50, '', 98, '0100', 6342, 1, 0, NULL),
	(1390, 119, 0, NULL, 50, '', 99, '0100', 3649, 1, 0, NULL),
	(1391, 119, 0, NULL, 50, '', 100, '0100', 3689, 1, 0, NULL),
	(1392, 119, 0, NULL, 50, '', 101, '0100', 2799, 1, 0, NULL),
	(1393, 119, 0, NULL, 50, '', 102, '0100', 9186, 1, 0, NULL),
	(1394, 119, 0, NULL, 50, '', 103, '0100', 3115, 1, 0, NULL),
	(1395, 119, 0, NULL, 50, '', 104, '0101', 11976, 1, 0, NULL),
	(1396, 119, 0, NULL, 50, '', 105, '0101', 2352, 1, 0, NULL),
	(1397, 119, 0, NULL, 50, '', 106, '0101', 13185, 1, 0, NULL),
	(1398, 119, 0, NULL, 50, '', 107, '0101', 5795, 1, 0, NULL),
	(1399, 119, 0, NULL, 50, '', 108, '0101', 4790, 1, 0, NULL),
	(1400, 119, 0, NULL, 50, '', 109, '0101', 5683, 1, 0, NULL),
	(1401, 119, 0, NULL, 50, '', 110, '0101', 3265, 1, 0, NULL),
	(1402, 119, 0, NULL, 50, '', 111, '0101', 7255, 1, 0, NULL),
	(1403, 119, 0, NULL, 50, '', 112, '0101', 6940, 1, 0, NULL),
	(1404, 119, 0, NULL, 50, '', 113, '0101', 8676, 1, 0, NULL),
	(1405, 119, 0, NULL, 50, '', 114, '0101', 6766, 1, 0, NULL),
	(1406, 119, 0, NULL, 50, '', 115, '0101', 8427, 1, 0, NULL),
	(1407, 119, 0, NULL, 50, '', 116, '0101', 5017, 1, 0, NULL),
	(1408, 119, 0, NULL, 50, '', 117, '0101', 2094, 1, 0, NULL),
	(1409, 119, 0, NULL, 50, '', 118, '0101', 2034, 1, 0, NULL),
	(1410, 119, 0, NULL, 50, '', 119, '0101', 7604, 1, 0, NULL),
	(1411, 119, 0, NULL, 50, '', 120, '0101', 7922, 1, 0, NULL),
	(1412, 119, 0, NULL, 50, '', 121, '0101', 2286, 1, 0, NULL),
	(1413, 119, 0, NULL, 50, '', 122, '0102', 0, 1, 0, NULL),
	(1414, 119, 0, NULL, 50, '', 123, '0102', 0, 1, 0, NULL),
	(1415, 119, 0, NULL, 50, '', 124, '0102', 0, 1, 0, NULL),
	(1416, 119, 0, NULL, 50, '', 125, '0102', 0, 1, 0, NULL),
	(1417, 119, 0, NULL, 50, '', 126, '0102', 0, 1, 0, NULL),
	(1418, 119, 0, NULL, 78, '', 127, '0102', 0, 1, 0, NULL),
	(1419, 119, 0, NULL, 78, '', 128, '0102', 0, 1, 0, NULL),
	(1420, 119, 0, NULL, 78, '', 129, '0102', 0, 1, 0, NULL),
	(1421, 119, 0, NULL, 78, '', 130, '0102', 0, 1, 0, NULL),
	(1422, 119, 0, NULL, 78, '', 131, '0102', 0, 1, 0, NULL),
	(1423, 119, 0, NULL, 78, '', 132, '0102', 0, 1, 0, NULL),
	(1424, 119, 0, NULL, 78, '', 133, '0102', 0, 1, 0, NULL),
	(1425, 119, 0, NULL, 78, '', 134, '0102', 0, 1, 0, NULL),
	(1426, 119, 0, NULL, 78, '', 135, '0102', 0, 1, 0, NULL),
	(1427, 119, 0, NULL, 78, '', 136, '0102', 0, 1, 0, NULL),
	(1428, 119, 0, NULL, 78, '', 137, '0102', 0, 1, 0, NULL),
	(1429, 119, 0, NULL, 78, '', 138, '0102', 0, 1, 0, NULL),
	(1430, 113, 0, NULL, 56, '', 196, '0356', NULL, 1, 0, NULL),
	(1431, 113, 0, NULL, 56, '', 197, '0356', NULL, 1, 0, NULL),
	(1432, 113, 0, NULL, 56, '', 198, '0356', NULL, 1, 0, NULL),
	(1433, 113, 0, NULL, 61, '', 199, '0356', NULL, 1, 0, NULL),
	(1434, 113, 0, NULL, 61, '', 200, '0356', NULL, 1, 0, NULL),
	(1435, 113, 0, NULL, 61, '', 201, '0356', NULL, 1, 0, NULL),
	(1436, 113, 0, NULL, 61, '', 202, '0356', NULL, 1, 0, NULL),
	(1437, 113, 0, NULL, 61, '', 203, '0356', NULL, 1, 0, NULL),
	(1438, 113, 0, NULL, 61, '', 204, '0356', NULL, 1, 0, NULL),
	(1439, 113, 0, NULL, 61, '', 205, '0356', NULL, 1, 0, NULL),
	(1440, 113, 0, NULL, 61, '', 206, '0356', NULL, 1, 0, NULL),
	(1441, 113, 0, NULL, 61, '', 207, '0356', NULL, 1, 0, NULL),
	(1442, 113, 0, NULL, 61, '', 208, '0356', NULL, 1, 0, NULL),
	(1443, 113, 0, NULL, 61, '', 209, '0356', NULL, 1, 0, NULL),
	(1444, 113, 0, NULL, 61, '', 210, '0356', NULL, 1, 0, NULL),
	(1445, 113, 0, NULL, 61, '', 211, '0356', NULL, 1, 0, NULL),
	(1446, 113, 0, NULL, 61, '', 212, '0357', NULL, 1, 0, NULL),
	(1447, 113, 0, NULL, 61, '', 213, '0357', NULL, 1, 0, NULL),
	(1448, 113, 0, NULL, 61, '', 214, '0357', NULL, 1, 0, NULL),
	(1449, 113, 0, NULL, 64, '', 215, '0357', NULL, 1, 0, NULL),
	(1450, 113, 0, NULL, 64, '', 216, '0357', NULL, 1, 0, NULL),
	(1451, 113, 0, NULL, 64, '', 217, '0357', NULL, 1, 0, NULL),
	(1452, 113, 0, NULL, 64, '', 218, '0357', NULL, 1, 0, NULL),
	(1453, 113, 0, NULL, 64, '', 219, '0357', NULL, 1, 0, NULL),
	(1454, 113, 0, NULL, 64, '', 220, '0357', NULL, 1, 0, NULL),
	(1455, 113, 0, NULL, 64, '', 221, '0357', NULL, 1, 0, NULL),
	(1456, 113, 0, NULL, 64, '', 222, '0357', NULL, 1, 0, NULL),
	(1457, 113, 0, NULL, 64, '', 223, '0357', NULL, 1, 0, NULL),
	(1458, 113, 0, NULL, 64, '', 224, '0357', NULL, 1, 0, NULL),
	(1459, 113, 0, NULL, 64, '', 225, '0357', NULL, 1, 0, NULL),
	(1460, 113, 0, NULL, 64, '', 226, '0357', NULL, 1, 0, NULL),
	(1461, 113, 0, NULL, 64, '', 227, '0357', NULL, 1, 0, NULL),
	(1462, 115, 0, NULL, 35, '', 177, '0542', 0, 15, 0, NULL),
	(1463, 115, 0, NULL, 36, '', 178, '0542', 0, 15, 0, NULL),
	(1464, 115, 0, NULL, 36, '', 179, '0542', 0, 15, 0, NULL),
	(1465, 115, 0, NULL, 36, '', 180, '0542', 0, 15, 0, NULL),
	(1466, 115, 0, NULL, 36, '', 181, '0542', 0, 15, 0, NULL),
	(1467, 115, 0, NULL, 36, '', 182, '0542', 0, 15, 0, NULL),
	(1468, 115, 0, NULL, 36, '', 183, '0542', 0, 15, 0, NULL),
	(1469, 115, 0, NULL, 36, '', 184, '0542', 0, 15, 0, NULL),
	(1470, 115, 0, NULL, 36, '', 185, '0542', 0, 15, 0, NULL),
	(1471, 115, 0, NULL, 36, '', 186, '0542', 0, 15, 0, NULL),
	(1472, 115, 0, NULL, 36, '', 187, '0542', 0, 15, 0, NULL),
	(1473, 115, 0, NULL, 36, '', 188, '0543', 0, 15, 0, NULL),
	(1474, 115, 0, NULL, 36, '', 189, '0543', 0, 15, 0, NULL),
	(1475, 115, 0, NULL, 36, '', 190, '0543', 0, 15, 0, NULL),
	(1476, 115, 0, NULL, 36, '', 191, '0543', 0, 15, 0, NULL),
	(1477, 115, 0, NULL, 36, '', 192, '0543', 0, 15, 0, NULL),
	(1478, 115, 0, NULL, 36, '', 193, '0543', 0, 15, 0, NULL),
	(1479, 115, 0, NULL, 36, '', 194, '0543', 0, 15, 0, NULL),
	(1480, 115, 0, NULL, 36, '', 195, '0543', 0, 15, 0, NULL),
	(1481, 115, 0, NULL, 36, '', 196, '0543', 0, 15, 0, NULL),
	(1482, 115, 0, NULL, 36, '', 197, '0543', 0, 15, 0, NULL),
	(1483, 115, 0, NULL, 58, '', 198, '0544', 0, 15, 0, NULL),
	(1484, 115, 0, NULL, 58, '', 199, '0544', 0, 15, 0, NULL),
	(1485, 115, 0, NULL, 58, '', 200, '0544', 0, 15, 0, NULL),
	(1486, 115, 0, NULL, 58, '', 201, '0544', 0, 15, 0, NULL),
	(1487, 115, 0, NULL, 58, '', 202, '0544', 0, 15, 0, NULL),
	(1488, 115, 0, NULL, 58, '', 203, '0544', 0, 15, 0, NULL),
	(1489, 115, 0, NULL, 58, '', 204, '0544', 0, 15, 0, NULL),
	(1490, 115, 0, NULL, 58, '', 205, '0544', 0, 15, 0, NULL),
	(1491, 115, 0, NULL, 58, '', 206, '0544', 0, 15, 0, NULL),
	(1492, 115, 0, NULL, 58, '', 207, '0544', 0, 15, 0, NULL),
	(1493, 115, 0, NULL, 58, '', 208, '0544', 0, 15, 0, NULL),
	(1494, 115, 0, NULL, 58, '', 209, '0544', 0, 15, 0, NULL),
	(1495, 115, 0, NULL, 58, '', 210, '0544', 0, 15, 0, NULL),
	(1496, 115, 0, NULL, 58, '', 211, '0544', 0, 15, 0, NULL),
	(1497, 115, 0, NULL, 58, '', 212, '0544', 0, 15, 0, NULL),
	(1498, 120, 0, NULL, 78, '', 139, '0103', 10748, 1, 0, NULL),
	(1499, 120, 0, NULL, 78, '', 140, '0103', 8085, 1, 0, NULL),
	(1500, 120, 0, NULL, 78, '', 141, '0103', 8726, 1, 0, NULL),
	(1501, 120, 0, NULL, 78, '', 142, '0103', 9360, 1, 0, NULL),
	(1502, 120, 0, NULL, 78, '', 143, '0103', 12382, 1, 0, NULL),
	(1503, 120, 0, NULL, 78, '', 144, '0103', 10126, 1, 0, NULL),
	(1504, 120, 0, NULL, 78, '', 145, '0103', 12505, 1, 0, NULL),
	(1505, 120, 0, NULL, 78, '', 146, '0103', 13110, 1, 0, NULL),
	(1506, 120, 0, NULL, 78, '', 147, '0103', 13315, 1, 0, NULL),
	(1507, 120, 0, NULL, 78, '', 148, '0103', 11144, 1, 0, NULL),
	(1508, 120, 0, NULL, 78, '', 149, '0103', 9404, 1, 0, NULL),
	(1509, 120, 0, NULL, 78, '', 150, '0103', 6682, 1, 0, NULL),
	(1510, 120, 0, NULL, 78, '', 151, '0103', 2358, 1, 0, NULL),
	(1511, 120, 0, NULL, 78, '', 152, '0103', 3523, 1, 0, NULL),
	(1512, 120, 0, NULL, 78, '', 153, '0103', 6344, 1, 0, NULL),
	(1513, 120, 0, NULL, 78, '', 154, '0103', 3260, 1, 0, NULL),
	(1514, 120, 0, NULL, 78, '', 155, '0103', 2378, 1, 0, NULL),
	(1515, 120, 0, NULL, 78, '', 156, '0103', 7718, 1, 0, NULL),
	(1516, 120, 0, NULL, 78, '', 157, '0104', 1912, 1, 0, NULL),
	(1517, 120, 0, NULL, 78, '', 158, '0104', 4298, 1, 0, NULL),
	(1518, 120, 0, NULL, 78, '', 159, '0104', 3068, 1, 0, NULL),
	(1519, 120, 0, NULL, 78, '', 160, '0104', 2757, 1, 0, NULL),
	(1520, 120, 0, NULL, 78, '', 161, '0104', 2721, 1, 0, NULL),
	(1521, 120, 0, NULL, 78, '', 162, '0104', 2095, 1, 0, NULL),
	(1522, 120, 0, NULL, 78, '', 163, '0105', 1935, 1, 0, NULL),
	(1523, 120, 0, NULL, 78, '', 164, '0105', 8133, 1, 0, NULL),
	(1524, 120, 0, NULL, 78, '', 165, '0105', 8893, 1, 0, NULL),
	(1525, 120, 0, NULL, 78, '', 166, '0105', 9530, 1, 0, NULL),
	(1526, 120, 0, NULL, 78, '', 167, '0105', 2739, 1, 0, NULL),
	(1527, 120, 0, NULL, 78, '', 168, '0105', 12766, 1, 0, NULL),
	(1528, 120, 0, NULL, 99, '', 169, '0105', 2314, 1, 0, NULL),
	(1529, 120, 0, NULL, 99, '', 170, '0105', 7639, 1, 0, NULL),
	(1530, 120, 0, NULL, 99, '', 171, '0105', 3343, 1, 0, NULL),
	(1531, 120, 0, NULL, 99, '', 172, '0105', 6088, 1, 0, NULL),
	(1532, 120, 0, NULL, 99, '', 173, '0105', 10686, 1, 0, NULL),
	(1533, 120, 0, NULL, 99, '', 174, '0105', 4738, 1, 0, NULL),
	(1534, 120, 0, NULL, 99, '', 175, '0105', 4907, 1, 0, NULL),
	(1535, 120, 0, NULL, 99, '', 176, '0105', 6959, 1, 0, NULL),
	(1536, 120, 0, NULL, 99, '', 177, '0105', 1871, 1, 0, NULL),
	(1537, 120, 0, NULL, 99, '', 178, '0105', 4680, 1, 0, NULL),
	(1538, 120, 0, NULL, 99, '', 179, '0105', 3841, 1, 0, NULL),
	(1539, 120, 0, NULL, 99, '', 180, '0105', 2844, 1, 0, NULL),
	(1540, 140, 0, NULL, 37, '', 102, '0434', 0, 5, 0, NULL),
	(1541, 140, 0, NULL, 37, '', 103, '0434', 0, 15, 0, NULL),
	(1542, 140, 0, NULL, 37, '', 104, '0434', 0, 15, 0, NULL),
	(1543, 140, 0, NULL, 37, '', 105, '0434', 0, 15, 0, NULL),
	(1544, 140, 0, NULL, 37, '', 106, '0434', 0, 15, 0, NULL),
	(1545, 140, 0, NULL, 37, '', 107, '0434', 0, 15, 0, NULL),
	(1546, 140, 0, NULL, 37, '', 108, '0434', 0, 15, 0, NULL),
	(1547, 140, 0, NULL, 37, '', 109, '0434', 0, 15, 0, NULL),
	(1548, 140, 0, NULL, 37, '', 110, '0434', 0, 15, 0, NULL),
	(1549, 140, 0, NULL, 37, '', 111, '0434', 0, 15, 0, NULL),
	(1550, 140, 0, NULL, 37, '', 112, '0434', 0, 15, 0, NULL),
	(1551, 140, 0, NULL, 37, '', 113, '0434', 0, 15, 0, NULL),
	(1552, 140, 0, NULL, 37, '', 114, '0434', 0, 15, 0, NULL),
	(1553, 140, 0, NULL, 37, '', 115, '0434', 0, 15, 0, NULL),
	(1554, 140, 0, NULL, 37, '', 116, '0435', 0, 15, 0, NULL),
	(1555, 140, 0, NULL, 37, '', 117, '0435', 0, 15, 0, NULL),
	(1556, 140, 0, NULL, 37, '', 118, '0435', 0, 15, 0, NULL),
	(1557, 140, 0, NULL, 37, '', 119, '0435', 0, 15, 0, NULL),
	(1558, 140, 0, NULL, 37, '', 120, '0435', 0, 15, 0, NULL),
	(1559, 140, 0, NULL, 37, '', 121, '0435', 0, 15, 0, NULL),
	(1560, 140, 0, NULL, 37, '', 122, '0435', 0, 15, 0, NULL),
	(1561, 140, 0, NULL, 37, '', 123, '0435', 0, 15, 0, NULL),
	(1562, 140, 0, NULL, 37, '', 124, '0435', 0, 15, 0, NULL),
	(1563, 140, 0, NULL, 37, '', 125, '0435', 0, 15, 0, NULL),
	(1564, 140, 0, NULL, 37, '', 126, '0435', 0, 15, 0, NULL),
	(1565, 140, 0, NULL, 37, '', 127, '0435', 0, 15, 0, NULL),
	(1566, 140, 0, NULL, 37, '', 128, '0435', 0, 15, 0, NULL),
	(1567, 140, 0, NULL, 37, '', 129, '0435', 0, 15, 0, NULL),
	(1568, 140, 0, NULL, 37, '', 130, '0435', 0, 15, 0, NULL),
	(1569, 140, 0, NULL, 37, '', 131, '0435', 0, 15, 0, NULL),
	(1570, 140, 0, NULL, 37, '', 132, '0435', 0, 15, 0, NULL),
	(1571, 140, 0, NULL, 37, '', 133, '0435', 0, 15, 0, NULL),
	(1572, 140, 0, NULL, 95, '', 134, '0435', 0, 15, 0, NULL),
	(1573, 140, 0, NULL, 95, '', 135, '0435', 0, 15, 0, NULL),
	(1574, 140, 0, NULL, 95, '', 136, '0435', 0, 15, 0, NULL),
	(1575, 140, 0, NULL, 95, '', 137, '0435', 0, 15, 0, NULL),
	(1576, 140, 0, NULL, 95, '', 138, '0435', 0, 15, 0, NULL),
	(1577, 140, 0, NULL, 95, '', 139, '0435', 0, 15, 0, NULL),
	(1578, 140, 0, NULL, 95, '', 140, '0435', 0, 15, 0, NULL),
	(1619, 141, 0, NULL, 58, '', 213, '0545', 0, 15, 0, NULL),
	(1620, 141, 0, NULL, 58, '', 214, '0545', 0, 15, 0, NULL),
	(1621, 141, 0, NULL, 58, '', 215, '0545', 0, 15, 0, NULL),
	(1622, 141, 0, NULL, 58, '', 216, '0545', 0, 15, 0, NULL),
	(1623, 141, 0, NULL, 58, '', 217, '0545', 0, 15, 0, NULL),
	(1624, 141, 0, NULL, NULL, '', 218, '0545', 0, 15, 1, NULL),
	(1625, 141, 0, NULL, NULL, '', 219, '0545', 0, 15, 1, NULL),
	(1626, 141, 0, NULL, NULL, '', 220, '0545', 0, 15, 1, NULL),
	(1627, 141, 0, NULL, NULL, '', 221, '0545', 0, 15, 1, NULL),
	(1628, 141, 0, NULL, NULL, '', 222, '0545', 0, 15, 1, NULL),
	(1629, 141, 0, NULL, NULL, '', 223, '0545', 0, 15, 1, NULL),
	(1630, 141, 0, NULL, NULL, '', 224, '0545', 0, 15, 1, NULL),
	(1631, 141, 0, NULL, NULL, '', 225, '0545', 0, 15, 1, NULL),
	(1632, 141, 0, NULL, NULL, '', 226, '0545', 0, 15, 1, NULL),
	(1633, 141, 0, NULL, NULL, '', 227, '0545', 0, 15, 1, NULL),
	(1634, 141, 0, NULL, NULL, '', 228, '0545', 0, 15, 1, NULL),
	(1635, 141, 0, NULL, NULL, '', 229, '0546', 0, 15, 1, NULL),
	(1636, 141, 0, NULL, NULL, '', 230, '0546', 0, 15, 1, NULL),
	(1637, 141, 0, NULL, NULL, '', 231, '0546', 0, 15, 1, NULL),
	(1638, 141, 0, NULL, NULL, '', 232, '0546', 0, 15, 1, NULL),
	(1639, 141, 0, NULL, NULL, '', 233, '0546', 0, 15, 1, NULL),
	(1640, 141, 0, NULL, NULL, '', 234, '0546', 0, 15, 1, NULL),
	(1641, 141, 0, NULL, NULL, '', 235, '0546', 0, 15, 1, NULL),
	(1642, 141, 0, NULL, NULL, '', 236, '0546', 0, 15, 1, NULL),
	(1643, 141, 0, NULL, NULL, '', 237, '0546', 0, 15, 1, NULL),
	(1644, 141, 0, NULL, NULL, '', 238, '0546', 0, 15, 1, NULL),
	(1645, 141, 0, NULL, NULL, '', 239, '0546', 0, 15, 1, NULL),
	(1646, 141, 0, NULL, NULL, '', 240, '0546', 0, 15, 1, NULL),
	(1647, 141, 0, NULL, NULL, '', 241, '0546', 0, 15, 1, NULL),
	(1648, 141, 0, NULL, NULL, '', 242, '0546', 0, 15, 1, NULL),
	(1649, 141, 0, NULL, NULL, '', 243, '0546', 0, 15, 1, NULL),
	(1650, 141, 0, NULL, NULL, '', 244, '0546', 0, 15, 1, NULL),
	(1651, 141, 0, NULL, NULL, '', 245, '0547', 0, 15, 1, NULL),
	(1652, 141, 0, NULL, NULL, '', 246, '0547', 0, 15, 1, NULL),
	(1653, 141, 0, NULL, NULL, '', 247, '0547', 0, 15, 1, NULL),
	(1654, 141, 0, NULL, NULL, '', 248, '0547', 0, 15, 1, NULL),
	(1655, 141, 0, NULL, NULL, '', 249, '0547', 0, 15, 1, NULL),
	(1656, 141, 0, NULL, NULL, '', 250, '0547', 0, 15, 1, NULL),
	(1657, 141, 0, NULL, NULL, '', 251, '0547', 0, 15, 1, NULL),
	(1658, 142, 0, NULL, 44, '', 1, '0547', 0, 15, 0, NULL),
	(1659, 142, 0, NULL, 44, '', 2, '0547', 0, 15, 0, NULL),
	(1660, 142, 0, NULL, 44, '', 3, '0547', 0, 15, 0, NULL),
	(1661, 142, 0, NULL, 44, '', 4, '0547', 0, 15, 0, NULL),
	(1662, 142, 0, NULL, 44, '', 5, '0547', 0, 15, 0, NULL),
	(1663, 142, 0, NULL, 44, '', 6, '0547', 0, 15, 0, NULL),
	(1664, 142, 0, NULL, 44, '', 7, '0547', 0, 15, 0, NULL),
	(1665, 142, 0, NULL, 44, '', 8, '0547', 0, 15, 0, NULL),
	(1666, 142, 0, NULL, 44, '', 9, '0547', 0, 15, 0, NULL),
	(1667, 121, 0, NULL, 99, '', 181, '0106', 12583, 1, 0, NULL),
	(1668, 121, 0, NULL, 99, '', 182, '0106', 10608, 1, 0, NULL),
	(1669, 121, 0, NULL, 99, '', 183, '0106', 9256, 1, 0, NULL),
	(1670, 121, 0, NULL, 99, '', 184, '0106', 12680, 1, 0, NULL),
	(1671, 121, 0, NULL, 99, '', 185, '0106', 12831, 1, 0, NULL),
	(1672, 121, 0, NULL, 99, '', 186, '0106', 11176, 1, 0, NULL),
	(1673, 121, 0, NULL, 99, '', 187, '0106', 9251, 1, 0, NULL),
	(1674, 121, 0, NULL, 99, '', 188, '0106', 9588, 1, 0, NULL),
	(1675, 121, 0, NULL, 99, '', 189, '0106', 13648, 1, 0, NULL),
	(1676, 121, 0, NULL, 99, '', 190, '0106', 11834, 1, 0, NULL),
	(1677, 121, 0, NULL, 99, '', 191, '0106', 5698, 1, 0, NULL),
	(1678, 121, 0, NULL, 99, '', 192, '0106', 11572, 1, 0, NULL),
	(1679, 121, 0, NULL, 99, '', 193, '0106', 11414, 1, 0, NULL),
	(1680, 121, 0, NULL, 99, '', 194, '0106', 13617, 1, 0, NULL),
	(1681, 121, 0, NULL, 99, '', 195, '0106', 12884, 1, 0, NULL),
	(1682, 121, 0, NULL, 99, '', 196, '0106', 12786, 1, 0, NULL),
	(1683, 121, 0, NULL, 99, '', 197, '0106', 11583, 1, 0, NULL),
	(1684, 121, 0, NULL, 99, '', 198, '0107', 11405, 1, 0, NULL),
	(1685, 121, 0, NULL, 99, '', 199, '0107', 3958, 1, 0, NULL),
	(1686, 121, 0, NULL, 99, '', 200, '0107', 3593, 1, 0, NULL),
	(1687, 121, 0, NULL, 99, '', 201, '0107', 10989, 1, 0, NULL),
	(1688, 121, 0, NULL, 99, '', 202, '0107', 11292, 1, 0, NULL),
	(1689, 121, 0, NULL, 99, '', 203, '0107', 10157, 1, 0, NULL),
	(1690, 121, 0, NULL, 99, '', 204, '0107', 6739, 1, 0, NULL),
	(1691, 121, 0, NULL, 99, '', 205, '0107', 10439, 1, 0, NULL),
	(1692, 121, 0, NULL, 99, '', 206, '0107', 13262, 1, 0, NULL),
	(1693, 121, 0, NULL, 99, '', 207, '0107', 11229, 1, 0, NULL),
	(1694, 121, 0, NULL, 99, '', 208, '0107', 4948, 1, 0, NULL),
	(1695, 121, 0, NULL, 99, '', 209, '0107', 2716, 1, 0, NULL),
	(1696, 121, 0, NULL, 99, '', 210, '0107', 5877, 1, 0, NULL),
	(1697, 121, 0, NULL, NULL, '', 211, '0107', 3875, 1, 0, NULL),
	(1698, 143, 0, NULL, 38, '', 1, '0107', 0, 15, 0, NULL),
	(1699, 143, 0, NULL, 38, '', 2, '0107', 0, 15, 0, NULL),
	(1700, 143, 0, NULL, 38, '', 3, '0108', 0, 15, 0, NULL),
	(1701, 143, 0, NULL, 38, '', 4, '0108', 0, 15, 0, NULL),
	(1702, 143, 0, NULL, 38, '', 5, '0108', 0, 15, 0, NULL),
	(1703, 143, 0, NULL, 38, '', 6, '0108', 0, 15, 0, NULL),
	(1704, 143, 0, NULL, 38, '', 7, '0108', 0, 15, 0, NULL),
	(1705, 143, 0, NULL, 38, '', 8, '0108', 0, 5, 0, NULL),
	(1706, 143, 0, NULL, NULL, '', 9, '0108', 0, 15, 0, NULL),
	(1707, 143, 0, NULL, NULL, '', 10, '0108', 0, 15, 0, NULL),
	(1708, 144, 0, NULL, 44, '', 10, '0548', 0, 15, 0, NULL),
	(1709, 144, 0, NULL, 44, '', 11, '0548', 0, 15, 0, NULL),
	(1710, 144, 0, NULL, 44, '', 12, '0548', 0, 15, 0, NULL),
	(1711, 144, 0, NULL, 44, '', 13, '0548', 0, 15, 0, NULL),
	(1712, 144, 0, NULL, 44, '', 14, '0548', 0, 15, 0, NULL),
	(1713, 144, 0, NULL, 44, '', 15, '0548', 0, 15, 0, NULL),
	(1714, 144, 0, NULL, 44, '', 16, '0548', 0, 15, 0, NULL),
	(1715, 144, 0, NULL, 44, '', 17, '0548', 0, 15, 0, NULL),
	(1716, 144, 0, NULL, 44, '', 18, '0548', 0, 15, 0, NULL),
	(1717, 144, 0, NULL, 44, '', 19, '0548', 0, 1, 0, NULL),
	(1718, 144, 0, NULL, 53, '', 20, '0548', 0, 15, 0, NULL),
	(1719, 144, 0, NULL, 53, '', 21, '0548', 0, 15, 0, NULL),
	(1720, 144, 0, NULL, 53, '', 22, '0548', 0, 15, 0, NULL),
	(1721, 144, 0, NULL, 53, '', 23, '0548', 0, 15, 0, NULL),
	(1722, 144, 0, NULL, 53, '', 24, '0548', 0, 15, 0, NULL),
	(1723, 144, 0, NULL, 53, '', 25, '0549', 0, 15, 0, NULL),
	(1724, 144, 0, NULL, 53, '', 26, '0549', 0, 15, 0, NULL),
	(1725, 144, 0, NULL, 53, '', 27, '0549', 0, 15, 0, NULL),
	(1726, 144, 0, NULL, 53, '', 28, '0549', 0, 15, 0, NULL),
	(1727, 144, 0, NULL, 53, '', 29, '0549', 0, 15, 0, NULL),
	(1728, 144, 0, NULL, 53, '', 30, '0549', 0, 15, 0, NULL),
	(1729, 144, 0, NULL, 53, '', 31, '0549', 0, 15, 0, NULL),
	(1730, 144, 0, NULL, 53, '', 32, '0549', 0, 15, 0, NULL),
	(1731, 144, 0, NULL, 53, '', 33, '0549', 0, 15, 0, NULL),
	(1732, 144, 0, NULL, 53, '', 34, '0549', 0, 15, 0, NULL),
	(1733, 144, 0, NULL, 53, '', 35, '0549', 0, 15, 0, NULL),
	(1734, 144, 0, NULL, 53, '', 36, '0549', 0, 15, 0, NULL),
	(1735, 144, 0, NULL, 53, '', 37, '0549', 0, 15, 0, NULL),
	(1736, 144, 0, NULL, 53, '', 38, '0549', 0, 15, 0, NULL),
	(1737, 144, 0, NULL, 53, '', 39, '0549', 0, 1, 0, NULL),
	(1738, 144, 0, NULL, 84, '', 40, '0549', 0, 15, 0, NULL),
	(1739, 144, 0, NULL, 84, '', 41, '0550', 0, 15, 0, NULL),
	(1740, 144, 0, NULL, 84, '', 42, '0550', 0, 15, 0, NULL),
	(1741, 144, 0, NULL, 84, '', 43, '0550', 0, 15, 0, NULL),
	(1742, 144, 0, NULL, 84, '', 44, '0550', 0, 15, 0, NULL),
	(1743, 144, 0, NULL, 84, '', 45, '0550', 0, 15, 0, NULL),
	(1744, 144, 0, NULL, 84, '', 46, '0550', 0, 15, 0, NULL),
	(1745, 144, 0, NULL, 84, '', 47, '0550', 0, 15, 0, NULL),
	(1746, 144, 0, NULL, 84, '', 48, '0550', 0, 15, 0, NULL),
	(1747, 144, 0, NULL, 84, '', 49, '0550', 0, 15, 0, NULL),
	(1748, 144, 0, NULL, 84, '', 50, '0550', 0, 15, 0, NULL),
	(1749, 144, 0, NULL, 84, '', 51, '0550', 0, 15, 0, NULL),
	(1750, 144, 0, NULL, 84, '', 52, '0550', 0, 15, 0, NULL),
	(1751, 144, 0, NULL, 84, '', 53, '0550', 0, 15, 0, NULL),
	(1752, 144, 0, NULL, 84, '', 54, '0550', 0, 15, 0, NULL),
	(1753, 144, 0, NULL, 84, '', 55, '0550', 0, 15, 0, NULL),
	(1754, 144, 0, NULL, 84, '', 56, '0550', 0, 15, 0, NULL),
	(1755, 147, 0, NULL, 43, '', 1, '0530', 0, 1, 0, NULL),
	(1756, 147, 0, NULL, 43, '', 2, '0530', 0, 1, 0, NULL),
	(1757, 147, 0, NULL, 43, '', 3, '0530', 0, 1, 0, NULL),
	(1758, 147, 0, NULL, 43, '', 4, '0530', 0, 1, 0, NULL),
	(1759, 147, 0, NULL, 43, '', 5, '0530', 0, 1, 0, NULL),
	(1760, 147, 0, NULL, 43, '', 6, '0530', 0, 1, 0, NULL),
	(1761, 147, 0, NULL, 43, '', 7, '0530', 0, 1, 0, NULL),
	(1762, 147, 0, NULL, 43, '', 8, '0530', 0, 1, 0, NULL),
	(1763, 147, 0, NULL, 43, '', 9, '0530', 0, 1, 0, NULL),
	(1764, 147, 0, NULL, 47, '', 10, '0530', 0, 1, 0, NULL),
	(1765, 147, 0, NULL, 47, '', 11, '0530', 0, 1, 0, NULL),
	(1766, 147, 0, NULL, 47, '', 12, '0530', 0, 1, 0, NULL),
	(1767, 147, 0, NULL, 47, '', 13, '0530', 0, 1, 0, NULL),
	(1768, 147, 0, NULL, 47, '', 14, '0530', 0, 1, 0, NULL),
	(1769, 147, 0, NULL, 47, '', 15, '0530', 0, 1, 0, NULL),
	(1770, 147, 0, NULL, 47, '', 16, '0530', 0, 1, 0, NULL),
	(1771, 147, 0, NULL, 47, '', 17, '0530', 0, 1, 0, NULL),
	(1772, 147, 0, NULL, 47, '', 18, '0530', 0, 1, 0, NULL),
	(1773, 147, 0, NULL, 47, '', 19, '0530', 0, 1, 0, NULL),
	(1774, 147, 0, NULL, 47, '', 20, '0530', 0, 1, 0, NULL),
	(1775, 147, 0, NULL, 47, '', 21, '0530', 0, 1, 0, NULL),
	(1776, 147, 0, NULL, 47, '', 22, '0530', 0, 1, 0, NULL),
	(1777, 147, 0, NULL, 47, '', 23, '0530', 0, 1, 0, NULL),
	(1778, 147, 0, NULL, 47, '', 24, '0530', 0, 1, 0, NULL),
	(1779, 147, 0, NULL, 47, '', 25, '0530', 0, 1, 0, NULL),
	(1780, 147, 0, NULL, 47, '', 26, '0530', 0, 1, 0, NULL),
	(1781, 147, 0, NULL, 47, '', 27, '0530', 0, 1, 0, NULL),
	(1782, 147, 0, NULL, 47, '', 28, '0530', 0, 1, 0, NULL),
	(1783, 147, 0, NULL, 47, '', 29, '0530', 0, 1, 0, NULL),
	(1784, 147, 0, NULL, 47, '', 30, '0530', 0, 1, 0, NULL),
	(1785, 147, 0, NULL, 47, '', 31, '0530', 0, 1, 0, NULL),
	(1786, 147, 0, NULL, 47, '', 32, '0530', 0, 1, 0, NULL),
	(1787, 147, 0, NULL, 47, '', 33, '0530', 0, 1, 0, NULL),
	(1788, 147, 0, NULL, 47, '', 34, '0530', 0, 1, 0, NULL),
	(1789, 147, 0, NULL, 47, '', 35, '0531', 0, 1, 0, NULL),
	(1790, 147, 0, NULL, 47, '', 36, '0531', 0, 1, 0, NULL),
	(1791, 147, 0, NULL, 47, '', 37, '0531', 0, 1, 0, NULL),
	(1792, 147, 0, NULL, 47, '', 38, '0531', 0, 1, 0, NULL),
	(1793, 147, 0, NULL, 47, '', 39, '0531', 0, 1, 0, NULL),
	(1794, 147, 0, NULL, 47, '', 40, '0531', 0, 1, 0, NULL),
	(1795, 147, 0, NULL, 47, '', 41, '0531', 0, 1, 0, NULL),
	(1796, 147, 0, NULL, 47, '', 42, '0531', 0, 1, 0, NULL),
	(1797, 147, 0, NULL, 47, '', 43, '0531', 0, 1, 0, NULL),
	(1798, 147, 0, NULL, 47, '', 44, '0531', 0, 1, 0, NULL),
	(1799, 147, 0, NULL, 47, '', 45, '0531', 0, 1, 0, NULL),
	(1800, 147, 0, NULL, 47, '', 46, '0531', 0, 1, 0, NULL),
	(1801, 147, 0, NULL, 47, '', 47, '0531', 0, 1, 0, NULL),
	(1802, 147, 0, NULL, 47, '', 48, '0531', 0, 1, 0, NULL),
	(1803, 147, 0, NULL, 47, '', 49, '0531', 0, 1, 0, NULL),
	(1804, 147, 0, NULL, 47, '', 50, '0531', 0, 1, 0, NULL),
	(1805, 147, 0, NULL, 47, '', 51, '0531', 0, 1, 0, NULL),
	(1806, 147, 0, NULL, 63, '', 52, '0531', 0, 1, 0, NULL),
	(1807, 147, 0, NULL, 63, '', 53, '0531', 0, 1, 0, NULL),
	(1808, 147, 0, NULL, 63, '', 54, '0531', 0, 1, 0, NULL),
	(1809, 147, 0, NULL, 63, '', 55, '0531', 0, 1, 0, NULL),
	(1810, 147, 0, NULL, 63, '', 56, '0531', 0, 1, 0, NULL),
	(1811, 147, 0, NULL, 63, '', 57, '0531', 0, 1, 0, NULL),
	(1812, 147, 0, NULL, 63, '', 58, '0531', 0, 1, 0, NULL),
	(1813, 147, 0, NULL, 63, '', 59, '0531', 0, 1, 0, NULL),
	(1814, 147, 0, NULL, 63, '', 60, '0531', 0, 1, 0, NULL),
	(1815, 147, 0, NULL, 63, '', 61, '0531', 0, 1, 0, NULL),
	(1816, 147, 0, NULL, 63, '', 62, '0531', 0, 1, 0, NULL),
	(1817, 147, 0, NULL, 63, '', 63, '0531', 0, 1, 0, NULL),
	(1818, 147, 0, NULL, 63, '', 64, '0531', 0, 1, 0, NULL),
	(1819, 147, 0, NULL, 63, '', 65, '0531', 0, 1, 0, NULL),
	(1820, 147, 0, NULL, 63, '', 66, '0531', 0, 1, 0, NULL),
	(1821, 147, 0, NULL, 63, '', 67, '0531', 0, 1, 0, NULL),
	(1822, 147, 0, NULL, 63, '', 68, '0531', 0, 1, 0, NULL),
	(1823, 147, 0, NULL, 63, '', 69, '0531', 0, 1, 0, NULL),
	(1824, 145, 0, NULL, 42, '', 1, '0551', 13668, 1, 0, NULL),
	(1825, 145, 0, NULL, 42, '', 2, '0551', 2360, 1, 0, NULL),
	(1826, 145, 0, NULL, 42, '', 3, '0551', 2386, 1, 0, NULL),
	(1827, 145, 0, NULL, 42, '', 4, '0551', 862, 1, 0, NULL),
	(1828, 145, 0, NULL, 42, '', 5, '0551', 777, 1, 0, NULL),
	(1829, 145, 0, NULL, 42, '', 6, '0551', 1175, 1, 0, NULL),
	(1830, 145, 0, NULL, 42, '', 7, '0551', 0, 1, 0, NULL),
	(1831, 145, 0, NULL, 42, '', 8, '0551', 1411, 1, 0, NULL),
	(1832, 145, 0, NULL, 42, '', 9, '0551', 9518, 1, 0, NULL),
	(1833, 145, 0, NULL, 42, '', 10, '0551', 2872, 1, 0, NULL),
	(1834, 145, 0, NULL, 42, '', 11, '0551', 11627, 1, 0, NULL),
	(1835, 145, 0, NULL, 42, '', 12, '0551', 907, 1, 0, NULL),
	(1836, 145, 0, NULL, 42, '', 13, '0551', 8317, 1, 0, NULL),
	(1837, 145, 0, NULL, 42, '', 14, '0551', 11580, 1, 0, NULL),
	(1838, 145, 0, NULL, 42, '', 15, '0551', 10780, 1, 0, NULL),
	(1839, 145, 0, NULL, 42, '', 16, '0551', 5744, 1, 0, NULL),
	(1840, 145, 0, NULL, 45, '', 17, '0551', 7689, 1, 0, NULL),
	(1841, 145, 0, NULL, 45, '', 18, '0551', 8565, 1, 0, NULL),
	(1842, 145, 0, NULL, 45, '', 19, '0551', 5576, 1, 0, NULL),
	(1843, 145, 0, NULL, 45, '', 20, '0551', 1116, 1, 0, NULL),
	(1844, 145, 0, NULL, 45, '', 21, '0551', 10793, 1, 0, NULL),
	(1845, 145, 0, NULL, 45, '', 22, '0551', 3908, 1, 0, NULL),
	(1846, 145, 0, NULL, 45, '', 23, '0551', 3809, 1, 0, NULL),
	(1847, 145, 0, NULL, 45, '', 24, '0552', 8947, 1, 0, NULL),
	(1848, 145, 0, NULL, 45, '', 25, '0552', 4088, 1, 0, NULL),
	(1849, 145, 0, NULL, 45, '', 26, '0552', 7459, 1, 0, NULL),
	(1850, 145, 0, NULL, 45, '', 27, '0552', 9420, 1, 0, NULL),
	(1851, 145, 0, NULL, 45, '', 28, '0552', 13242, 1, 0, NULL),
	(1852, 145, 0, NULL, 45, '', 29, '0552', 13693, 1, 0, NULL),
	(1853, 145, 0, NULL, 45, '', 30, '0552', 9629, 1, 0, NULL),
	(1854, 145, 0, NULL, 45, '', 31, '0552', 13682, 1, 0, NULL),
	(1855, 145, 0, NULL, 45, '', 32, '0552', 7298, 1, 0, NULL),
	(1856, 145, 0, NULL, 45, '', 33, '0552', 11631, 1, 0, NULL),
	(1857, 145, 0, NULL, 45, '', 34, '0552', 13765, 1, 0, NULL),
	(1858, 145, 0, NULL, 45, '', 35, '0552', 11686, 1, 0, NULL),
	(1859, 145, 0, NULL, 45, '', 36, '0552', 13210, 1, 0, NULL),
	(1860, 145, 0, NULL, 45, '', 37, '0552', 11727, 1, 0, NULL),
	(1861, 145, 0, NULL, 45, '', 38, '0552', 0, 1, 0, NULL),
	(1862, 145, 0, NULL, 45, '', 39, '0552', 10059, 1, 0, NULL),
	(1863, 145, 0, NULL, 45, '', 40, '0552', 9641, 1, 0, NULL),
	(1864, 145, 0, NULL, 45, '', 41, '0552', 13203, 1, 0, NULL),
	(1865, 145, 0, NULL, 45, '', 42, '0552', 904, 1, 0, NULL),
	(1866, 145, 0, NULL, 45, '', 43, '0552', 8440, 1, 0, NULL),
	(1867, 145, 0, NULL, 45, '', 44, '0552', 9601, 1, 0, NULL),
	(1868, 145, 0, NULL, 45, '', 45, '0552', 10256, 1, 0, NULL),
	(1869, 145, 0, NULL, 45, '', 46, '0552', 382, 1, 0, NULL),
	(1870, 145, 0, NULL, 45, '', 47, '0553', 9140, 1, 0, NULL),
	(1871, 145, 0, NULL, 45, '', 48, '0553', 8923, 1, 0, NULL),
	(1872, 145, 0, NULL, 45, '', 49, '0553', 2786, 1, 0, NULL),
	(1873, 145, 0, NULL, 45, '', 50, '0553', 10996, 1, 0, NULL),
	(1874, 145, 0, NULL, 45, '', 51, '0553', 4522, 1, 0, NULL),
	(1875, 145, 0, NULL, 45, '', 52, '0553', 2503, 1, 0, NULL),
	(1876, 145, 0, NULL, 45, '', 53, '0553', 13033, 1, 0, NULL),
	(1877, 145, 0, NULL, 45, '', 54, '0553', 3328, 1, 0, NULL),
	(1878, 145, 0, NULL, 45, '', 55, '0553', 8040, 1, 0, NULL),
	(1879, 145, 0, NULL, 45, '', 56, '0553', 7389, 1, 0, NULL),
	(1880, 145, 0, NULL, 48, '', 57, '0553', 1953, 1, 0, NULL),
	(1881, 145, 0, NULL, 48, '', 58, '0553', 4551, 1, 0, NULL),
	(1882, 145, 0, NULL, 48, '', 59, '0553', 10602, 1, 0, NULL),
	(1883, 145, 0, NULL, 48, '', 60, '0553', 12014, 1, 0, NULL),
	(1884, 145, 0, NULL, 48, '', 61, '0553', 10192, 1, 0, NULL),
	(1885, 145, 0, NULL, 48, '', 62, '0553', 8285, 1, 0, NULL),
	(1886, 145, 0, NULL, 48, '', 63, '0553', 6134, 1, 0, NULL),
	(1887, 145, 0, NULL, 48, '', 64, '0553', 6157, 1, 0, NULL),
	(1888, 145, 0, NULL, 48, '', 65, '0553', 6302, 1, 0, NULL),
	(1889, 145, 0, NULL, 48, '', 66, '0553', 2741, 1, 0, NULL),
	(1890, 145, 0, NULL, 48, '', 67, '0553', 5245, 1, 0, NULL),
	(1891, 145, 0, NULL, 48, '', 68, '0553', 7136, 1, 0, NULL),
	(1892, 145, 0, NULL, 48, '', 69, '0553', 11637, 1, 0, NULL),
	(1893, 148, 0, NULL, 63, '', 70, '0532', 3259, 1, 0, NULL),
	(1894, 148, 0, NULL, 63, '', 71, '0532', 6843, 1, 0, NULL),
	(1895, 148, 0, NULL, 63, '', 72, '0532', 8891, 1, 0, NULL),
	(1896, 148, 0, NULL, 63, '', 73, '0532', 2176, 1, 0, NULL),
	(1897, 148, 0, NULL, 63, '', 74, '0532', 3785, 1, 0, NULL),
	(1898, 148, 0, NULL, 63, '', 75, '0532', 2206, 1, 0, NULL),
	(1899, 148, 0, NULL, 63, '', 76, '0532', 11400, 1, 0, NULL),
	(1900, 148, 0, NULL, 63, '', 77, '0532', 8683, 1, 0, NULL),
	(1901, 148, 0, NULL, 63, '', 78, '0532', 3598, 1, 0, NULL),
	(1902, 148, 0, NULL, 63, '', 79, '0532', 4976, 1, 0, NULL),
	(1903, 148, 0, NULL, 63, '', 80, '0532', 9908, 1, 0, NULL),
	(1904, 148, 0, NULL, 63, '', 81, '0532', 9382, 1, 0, NULL),
	(1905, 148, 0, NULL, 63, '', 82, '0532', 11191, 1, 0, NULL),
	(1906, 148, 0, NULL, 63, '', 83, '0532', 7109, 1, 0, NULL),
	(1907, 148, 0, NULL, 63, '', 84, '0532', 12109, 1, 0, NULL),
	(1908, 148, 0, NULL, 63, '', 85, '0532', 4867, 1, 0, NULL),
	(1909, 148, 0, NULL, 63, '', 86, '0532', 3510, 1, 0, NULL),
	(1910, 148, 0, NULL, 63, '', 87, '0532', 4059, 1, 0, NULL),
	(1911, 148, 0, NULL, 63, '', 88, '0532', 4580, 1, 0, NULL),
	(1912, 148, 0, NULL, 63, '', 89, '0532', 2734, 1, 0, NULL),
	(1913, 148, 0, NULL, 63, '', 90, '0532', 5142, 1, 0, NULL),
	(1914, 148, 0, NULL, 63, '', 91, '0532', 5592, 1, 0, NULL),
	(1915, 148, 0, NULL, 67, '', 92, '0532', 5459, 1, 0, NULL),
	(1916, 148, 0, NULL, 67, '', 93, '0532', 4760, 1, 0, NULL),
	(1917, 148, 0, NULL, 67, '', 94, '0532', 5197, 1, 0, NULL),
	(1918, 148, 0, NULL, 67, '', 95, '0532', 2780, 1, 0, NULL),
	(1919, 148, 0, NULL, 67, '', 96, '0532', 4744, 1, 0, NULL),
	(1920, 148, 0, NULL, 67, '', 97, '0532', 2527, 1, 0, NULL),
	(1921, 148, 0, NULL, 67, '', 98, '0532', 5018, 1, 0, NULL),
	(1922, 148, 0, NULL, 67, '', 99, '0532', 2019, 1, 0, NULL),
	(1923, 148, 0, NULL, 67, '', 100, '0532', 1858, 1, 0, NULL),
	(1924, 148, 0, NULL, 67, '', 101, '0532', 3817, 1, 0, NULL),
	(1925, 148, 0, NULL, 67, '', 102, '0532', 3239, 1, 0, NULL),
	(1926, 148, 0, NULL, 67, '', 103, '0532', 5830, 1, 0, NULL),
	(1927, 148, 0, NULL, 67, '', 104, '0532', 4770, 1, 0, NULL),
	(1928, 148, 0, NULL, 67, '', 105, '0533', 1896, 1, 0, NULL),
	(1929, 148, 0, NULL, 67, '', 106, '0533', 4424, 1, 0, NULL),
	(1930, 148, 0, NULL, 67, '', 107, '0533', 3636, 1, 0, NULL),
	(1931, 148, 0, NULL, 67, '', 108, '0533', 5774, 1, 0, NULL),
	(1932, 148, 0, NULL, 67, '', 109, '0533', 7186, 1, 0, NULL),
	(1933, 148, 0, NULL, 67, '', 110, '0533', 6459, 1, 0, NULL),
	(1934, 148, 0, NULL, 67, '', 111, '0533', 3623, 1, 0, NULL),
	(1935, 148, 0, NULL, 67, '', 112, '0533', 7894, 1, 0, NULL),
	(1936, 148, 0, NULL, 67, '', 113, '0533', 5419, 1, 0, NULL),
	(1937, 148, 0, NULL, 67, '', 114, '0533', 3308, 1, 0, NULL),
	(1938, 148, 0, NULL, 67, '', 115, '0533', 4360, 1, 0, NULL),
	(1939, 148, 0, NULL, 67, '', 116, '0533', 6742, 1, 0, NULL),
	(1940, 148, 0, NULL, 67, '', 117, '0533', 6406, 1, 0, NULL),
	(1941, 148, 0, NULL, 67, '', 118, '0533', 1875, 1, 0, NULL),
	(1942, 148, 0, NULL, 67, '', 119, '0533', 5130, 1, 0, NULL),
	(1943, 148, 0, NULL, 67, '', 120, '0533', 3073, 1, 0, NULL),
	(1944, 148, 0, NULL, 67, '', 121, '0533', 7312, 1, 0, NULL),
	(1945, 148, 0, NULL, 67, '', 122, '0533', 7106, 1, 0, NULL),
	(1946, 148, 0, NULL, 67, '', 123, '0533', 6171, 1, 0, NULL),
	(1947, 148, 0, NULL, 67, '', 124, '0533', 2146, 1, 0, NULL),
	(1948, 148, 0, NULL, 67, '', 125, '0533', 5123, 1, 0, NULL),
	(1949, 148, 0, NULL, 67, '', 126, '0533', 4303, 1, 0, NULL),
	(1950, 148, 0, NULL, 67, '', 127, '0533', 5221, 1, 0, NULL),
	(1951, 148, 0, NULL, 67, '', 128, '0533', 3234, 1, 0, NULL),
	(1952, 148, 0, NULL, 67, '', 129, '0533', 5684, 1, 0, NULL),
	(1953, 148, 0, NULL, 67, '', 130, '0533', 3325, 1, 0, NULL),
	(1954, 148, 0, NULL, 67, '', 131, '0533', 5902, 1, 0, NULL),
	(1955, 148, 0, NULL, 67, '', 132, '0533', 4046, 1, 0, NULL),
	(1956, 148, 0, NULL, 67, '', 133, '0533', 5058, 1, 0, NULL),
	(1957, 148, 0, NULL, 68, '', 134, '0533', 2458, 1, 0, NULL),
	(1958, 148, 0, NULL, 68, '', 135, '0533', 2742, 1, 0, NULL),
	(1959, 148, 0, NULL, 68, '', 136, '0533', 4442, 1, 0, NULL),
	(1960, 148, 0, NULL, 68, '', 137, '0533', 4047, 1, 0, NULL),
	(1961, 148, 0, NULL, 68, '', 138, '0533', 5015, 1, 0, NULL),
	(1962, 148, 0, NULL, 68, '', 139, '0533', 4913, 1, 0, NULL),
	(1963, 148, 0, NULL, 68, '', 140, '0534', 8089, 1, 0, NULL),
	(1964, 148, 0, NULL, 68, '', 141, '0534', 4191, 1, 0, NULL),
	(1965, 148, 0, NULL, 68, '', 142, '0534', 5499, 1, 0, NULL),
	(1966, 148, 0, NULL, 68, '', 143, '0534', 4805, 1, 0, NULL),
	(1967, 148, 0, NULL, 68, '', 144, '0534', 4765, 1, 0, NULL),
	(1968, 148, 0, NULL, 68, '', 145, '0534', 5574, 1, 0, NULL),
	(1969, 148, 0, NULL, 68, '', 146, '0534', 2390, 1, 0, NULL),
	(1970, 148, 0, NULL, 68, '', 147, '0534', 4915, 1, 0, NULL),
	(1971, 148, 0, NULL, 68, '', 148, '0534', 6190, 1, 0, NULL),
	(1972, 148, 0, NULL, 68, '', 149, '0534', 3575, 1, 0, NULL),
	(1973, 148, 0, NULL, 68, '', 150, '0534', 4795, 1, 0, NULL),
	(1974, 148, 0, NULL, 68, '', 151, '0534', 6683, 1, 0, NULL),
	(1975, 148, 0, NULL, 68, '', 152, '0534', 5513, 1, 0, NULL),
	(1976, 148, 0, NULL, 68, '', 153, '0534', 2391, 1, 0, NULL),
	(1977, 148, 0, NULL, 68, '', 154, '0534', 5250, 1, 0, NULL),
	(1978, 148, 0, NULL, 68, '', 155, '0534', 3811, 1, 0, NULL),
	(1979, 148, 0, NULL, 68, '', 156, '0534', 7389, 1, 0, NULL),
	(1980, 148, 0, NULL, 68, '', 157, '0534', 1953, 1, 0, NULL),
	(1981, 148, 0, NULL, 68, '', 158, '0534', 5601, 1, 0, NULL),
	(1982, 148, 0, NULL, 68, '', 159, '0534', 6601, 1, 0, NULL),
	(1983, 148, 0, NULL, 68, '', 160, '0534', 6015, 1, 0, NULL),
	(1984, 148, 0, NULL, 68, '', 161, '0534', 2910, 1, 0, NULL),
	(1985, 148, 0, NULL, 68, '', 162, '0534', 4960, 1, 0, NULL),
	(1986, 148, 0, NULL, 68, '', 163, '0534', 2837, 1, 0, NULL),
	(1987, 148, 0, NULL, 68, '', 164, '0534', 3366, 1, 0, NULL),
	(1988, 148, 0, NULL, 68, '', 165, '0534', 3084, 1, 0, NULL),
	(1989, 148, 0, NULL, 68, '', 166, '0534', 2385, 1, 0, NULL),
	(1990, 148, 0, NULL, 68, '', 167, '0534', 5538, 1, 0, NULL),
	(1991, 148, 0, NULL, 68, '', 168, '0534', 3411, 1, 0, NULL),
	(1992, 148, 0, NULL, 68, '', 169, '0534', 4172, 1, 0, NULL),
	(1993, 148, 0, NULL, 68, '', 170, '0534', 6072, 1, 0, NULL),
	(1994, 148, 0, NULL, 68, '', 171, '0534', 2828, 1, 0, NULL),
	(1995, 148, 0, NULL, 68, '', 172, '0534', 2177, 1, 0, NULL),
	(1996, 148, 0, NULL, 68, '', 173, '0534', 2499, 1, 0, NULL),
	(1997, 148, 0, NULL, 68, '', 174, '0534', 4230, 1, 0, NULL),
	(1998, 143, 0, NULL, NULL, '', 8, '0108', NULL, 10, 0, NULL),
	(1999, 158, 0, NULL, NULL, '', 1, '001', 0, 15, 1, NULL),
	(2000, 146, 0, NULL, 48, '', 70, '0554', 9283, 1, 0, NULL),
	(2001, 146, 0, NULL, 48, '', 71, '0554', 11686, 1, 0, NULL),
	(2002, 146, 0, NULL, 48, '', 72, '0554', 4914, 1, 0, NULL),
	(2003, 146, 0, NULL, 48, '', 73, '0554', 8987, 1, 0, NULL),
	(2004, 146, 0, NULL, 48, '', 74, '0554', 9246, 1, 0, NULL),
	(2005, 146, 0, NULL, 48, '', 75, '0554', 6371, 1, 0, NULL),
	(2006, 146, 0, NULL, 48, '', 76, '0554', 9118, 1, 0, NULL),
	(2007, 146, 0, NULL, 48, '', 77, '0554', 7377, 1, 0, NULL),
	(2008, 146, 0, NULL, 48, '', 78, '0554', 10599, 1, 0, NULL),
	(2009, 146, 0, NULL, 48, '', 79, '0554', 11052, 1, 0, NULL),
	(2010, 146, 0, NULL, 48, '', 80, '0554', 10727, 1, 0, NULL),
	(2011, 146, 0, NULL, 48, '', 81, '0554', 10455, 1, 0, NULL),
	(2012, 146, 0, NULL, 48, '', 82, '0554', 4598, 1, 0, NULL),
	(2013, 146, 0, NULL, 48, '', 83, '0554', 1786, 1, 0, NULL),
	(2014, 146, 0, NULL, 48, '', 84, '0554', 1496, 1, 0, NULL),
	(2015, 146, 0, NULL, 48, '', 85, '0554', 8117, 1, 0, NULL),
	(2016, 146, 0, NULL, 48, '', 86, '0554', 13407, 1, 0, NULL),
	(2017, 146, 0, NULL, 48, '', 87, '0554', 397, 1, 0, NULL),
	(2018, 146, 0, NULL, 48, '', 88, '0554', 7624, 1, 0, NULL),
	(2019, 146, 0, NULL, 48, '', 89, '0554', 7620, 1, 0, NULL),
	(2020, 146, 0, NULL, 48, '', 90, '0554', 8743, 1, 0, NULL),
	(2021, 146, 0, NULL, 48, '', 91, '0554', 11567, 1, 0, NULL),
	(2022, 146, 0, NULL, 48, '', 92, '0554', 0, 1, 0, NULL),
	(2023, 146, 0, NULL, 48, '', 93, '0554', 7609, 1, 0, NULL),
	(2024, 146, 0, NULL, 48, '', 94, '0554', 13115, 1, 0, NULL),
	(2025, 146, 0, NULL, 48, '', 95, '0554', 753, 1, 0, NULL),
	(2026, 146, 0, NULL, 48, '', 96, '0554', 6655, 1, 0, NULL),
	(2027, 146, 0, NULL, 57, '', 97, '0555', 13147, 1, 0, NULL),
	(2028, 146, 0, NULL, 57, '', 98, '0555', 744, 1, 0, NULL),
	(2029, 146, 0, NULL, 57, '', 99, '0555', 4633, 1, 0, NULL),
	(2030, 146, 0, NULL, 57, '', 100, '0555', 11486, 1, 0, NULL),
	(2031, 146, 0, NULL, 57, '', 101, '0555', 8905, 1, 0, NULL),
	(2032, 146, 0, NULL, 57, '', 102, '0555', 12577, 1, 0, NULL),
	(2033, 146, 0, NULL, 57, '', 103, '0555', 788, 1, 0, NULL),
	(2034, 146, 0, NULL, 57, '', 104, '0555', 2275, 1, 0, NULL),
	(2035, 146, 0, NULL, 57, '', 105, '0555', 5352, 1, 0, NULL),
	(2036, 146, 0, NULL, 57, '', 106, '0555', 5714, 1, 0, NULL),
	(2037, 146, 0, NULL, 57, '', 107, '0555', 5816, 1, 0, NULL),
	(2038, 146, 0, NULL, 57, '', 108, '0555', 11051, 1, 0, NULL),
	(2039, 146, 0, NULL, 57, '', 109, '0555', 10422, 1, 0, NULL),
	(2040, 146, 0, NULL, 57, '', 110, '0555', 1805, 1, 0, NULL),
	(2041, 146, 0, NULL, 57, '', 111, '0555', 9091, 1, 0, NULL),
	(2042, 146, 0, NULL, 57, '', 112, '0555', 5053, 1, 0, NULL),
	(2043, 146, 0, NULL, 57, '', 113, '0555', 3271, 1, 0, NULL),
	(2044, 146, 0, NULL, 57, '', 114, '0555', 1136, 1, 0, NULL),
	(2045, 146, 0, NULL, 57, '', 115, '0555', 3758, 1, 0, NULL),
	(2046, 146, 0, NULL, 57, '', 116, '0556', 3758, 1, 0, NULL),
	(2047, 146, 0, NULL, 57, '', 117, '0556', 615, 1, 0, NULL),
	(2048, 146, 0, NULL, 57, '', 118, '0556', 8674, 1, 0, NULL),
	(2049, 146, 0, NULL, 57, '', 119, '0556', 13228, 1, 0, NULL),
	(2050, 146, 0, NULL, 57, '', 120, '0556', 6140, 1, 0, NULL),
	(2051, 146, 0, NULL, 57, '', 121, '0556', 3914, 1, 0, NULL),
	(2052, 146, 0, NULL, 57, '', 122, '0556', 8054, 1, 0, NULL),
	(2053, 146, 0, NULL, 57, '', 123, '0556', 5467, 1, 0, NULL),
	(2054, 146, 0, NULL, 57, '', 124, '0556', 4836, 1, 0, NULL),
	(2055, 146, 0, NULL, 57, '', 125, '0556', 8640, 1, 0, NULL),
	(2056, 146, 0, NULL, 57, '', 126, '0556', 4427, 1, 0, NULL),
	(2057, 146, 0, NULL, 57, '', 127, '0556', 9911, 1, 0, NULL),
	(2058, 146, 0, NULL, 57, '', 128, '0556', 8025, 1, 0, NULL),
	(2059, 146, 0, NULL, 57, '', 129, '0556', 5144, 1, 0, NULL),
	(2060, 146, 0, NULL, 57, '', 130, '0556', 10759, 1, 0, NULL),
	(2061, 146, 0, NULL, 57, '', 131, '0556', 7542, 1, 0, NULL),
	(2062, 146, 0, NULL, 57, '', 132, '0556', 3502, 1, 0, NULL),
	(2063, 146, 0, NULL, 57, '', 133, '0556', 9662, 1, 0, NULL),
	(2064, 146, 0, NULL, 57, '', 134, '0556', 10898, 1, 0, NULL),
	(2065, 146, 0, NULL, 57, '', 135, '0556', 11849, 1, 0, NULL),
	(2066, 146, 0, NULL, 57, '', 136, '0556', 8369, 1, 0, NULL),
	(2067, 146, 0, NULL, 60, '', 137, '0556', 12272, 1, 0, NULL),
	(2068, 146, 0, NULL, 60, '', 138, '0556', 7998, 1, 0, NULL),
	(2069, 146, 0, NULL, 60, '', 139, '0556', 2588, 1, 0, NULL),
	(2070, 149, 0, NULL, 69, '', 175, '0535', 5788, 1, 0, NULL),
	(2071, 149, 0, NULL, 108, '', 176, '0535', 5148, 1, 0, NULL),
	(2072, 149, 0, NULL, 108, '', 177, '0535', 4645, 1, 0, NULL),
	(2073, 149, 0, NULL, 108, '', 178, '0535', 2962, 1, 0, NULL),
	(2074, 149, 0, NULL, 108, '', 179, '0535', 6062, 1, 0, NULL),
	(2075, 149, 0, NULL, 108, '', 180, '0535', 2341, 1, 0, NULL),
	(2076, 149, 0, NULL, 108, '', 181, '0535', 11260, 1, 0, NULL),
	(2077, 149, 0, NULL, 108, '', 182, '0535', 4811, 1, 0, NULL),
	(2078, 149, 0, NULL, 108, '', 183, '0535', 6611, 1, 0, NULL),
	(2079, 149, 0, NULL, 108, '', 184, '0535', 5881, 1, 0, NULL),
	(2080, 149, 0, NULL, 108, '', 185, '0535', 3468, 1, 0, NULL),
	(2081, 149, 0, NULL, 108, '', 186, '0535', 3907, 1, 0, NULL),
	(2082, 149, 0, NULL, 108, '', 187, '0535', 5955, 1, 0, NULL),
	(2083, 149, 0, NULL, 108, '', 188, '0535', 6639, 1, 0, NULL),
	(2084, 149, 0, NULL, 108, '', 189, '0535', 6605, 1, 0, NULL),
	(2085, 149, 0, NULL, 108, '', 190, '0535', 4903, 1, 0, NULL),
	(2086, 149, 0, NULL, 108, '', 191, '0535', 2328, 1, 0, NULL),
	(2087, 149, 0, NULL, 108, '', 192, '0535', 3710, 1, 0, NULL),
	(2088, 149, 0, NULL, 108, '', 193, '0535', 2609, 1, 0, NULL),
	(2089, 149, 0, NULL, 108, '', 194, '0535', 4365, 1, 0, NULL),
	(2090, 149, 0, NULL, 108, '', 195, '0535', 4094, 1, 0, NULL),
	(2091, 149, 0, NULL, 108, '', 196, '0535', 1838, 1, 0, NULL),
	(2092, 149, 0, NULL, 108, '', 197, '0535', 2959, 1, 0, NULL),
	(2093, 149, 0, NULL, 108, '', 198, '0535', 9498, 1, 0, NULL),
	(2094, 149, 0, NULL, 108, '', 199, '0535', 2270, 1, 0, NULL),
	(2095, 149, 0, NULL, 108, '', 200, '0535', 7126, 1, 0, NULL),
	(2096, 149, 0, NULL, 108, '', 201, '0535', 6312, 1, 0, NULL),
	(2097, 149, 0, NULL, 108, '', 202, '0535', 1827, 1, 0, NULL),
	(2098, 149, 0, NULL, 108, '', 203, '0535', 5713, 1, 0, NULL),
	(2099, 149, 0, NULL, 108, '', 204, '0535', 7037, 1, 0, NULL),
	(2100, 149, 0, NULL, 108, '', 205, '0535', 6869, 1, 0, NULL),
	(2101, 149, 0, NULL, 108, '', 206, '0535', 4103, 1, 0, NULL),
	(2102, 149, 0, NULL, 108, '', 207, '0535', 3110, 1, 0, NULL),
	(2103, 149, 0, NULL, 108, '', 208, '0535', 9735, 1, 0, NULL),
	(2104, 149, 0, NULL, 108, '', 209, '0535', 9697, 1, 0, NULL),
	(2105, 149, 0, NULL, 108, '', 210, '0536', 3018, 1, 0, NULL),
	(2106, 149, 0, NULL, 108, '', 211, '0536', 8813, 1, 0, NULL),
	(2107, 149, 0, NULL, 108, '', 212, '0536', 2174, 1, 0, NULL),
	(2108, 149, 0, NULL, 108, '', 213, '0536', 3186, 1, 0, NULL),
	(2109, 149, 0, NULL, 108, '', 214, '0536', 5990, 1, 0, NULL),
	(2110, 149, 0, NULL, 108, '', 215, '0536', 3132, 1, 0, NULL),
	(2111, 149, 0, NULL, 108, '', 216, '0536', 7080, 1, 0, NULL),
	(2112, 149, 0, NULL, 108, '', 217, '0536', 5781, 1, 0, NULL),
	(2113, 149, 0, NULL, 109, '', 218, '0536', 2765, 1, 0, NULL),
	(2114, 149, 0, NULL, 109, '', 219, '0536', 6479, 1, 0, NULL),
	(2115, 149, 0, NULL, 109, '', 220, '0536', 9730, 1, 0, NULL),
	(2116, 149, 0, NULL, 109, '', 221, '0536', 10752, 1, 0, NULL),
	(2117, 149, 0, NULL, 109, '', 222, '0536', 5565, 1, 0, NULL),
	(2118, 149, 0, NULL, 109, '', 223, '0536', 13422, 1, 0, NULL),
	(2119, 149, 0, NULL, 109, '', 224, '0536', 3387, 1, 0, NULL),
	(2120, 149, 0, NULL, 109, '', 225, '0536', 3898, 1, 0, NULL),
	(2121, 149, 0, NULL, 109, '', 226, '0536', 2689, 1, 0, NULL),
	(2122, 149, 0, NULL, 109, '', 227, '0536', 6673, 1, 0, NULL),
	(2123, 149, 0, NULL, 109, '', 228, '0536', 5267, 1, 0, NULL),
	(2124, 149, 0, NULL, 109, '', 229, '0536', 8467, 1, 0, NULL),
	(2125, 149, 0, NULL, 109, '', 230, '0536', 2481, 1, 0, NULL),
	(2126, 149, 0, NULL, 109, '', 231, '0536', 12390, 1, 0, NULL),
	(2127, 149, 0, NULL, 109, '', 232, '0536', 4512, 1, 0, NULL),
	(2128, 149, 0, NULL, 109, '', 233, '0536', 2092, 1, 0, NULL),
	(2129, 149, 0, NULL, 109, '', 234, '0536', 7677, 1, 0, NULL),
	(2130, 149, 0, NULL, 109, '', 235, '0536', 0, 1, 0, NULL),
	(2131, 149, 0, NULL, 109, '', 236, '0536', 2726, 1, 0, NULL),
	(2132, 149, 0, NULL, 109, '', 237, '0536', 2617, 1, 0, NULL),
	(2133, 149, 0, NULL, 109, '', 238, '0536', 3854, 1, 0, NULL),
	(2134, 149, 0, NULL, 109, '', 239, '0536', 2656, 1, 0, NULL),
	(2135, 149, 0, NULL, 109, '', 240, '0536', 8817, 1, 0, NULL),
	(2136, 149, 0, NULL, 109, '', 241, '0536', 5594, 1, 0, NULL),
	(2137, 149, 0, NULL, 109, '', 242, '0536', 3644, 1, 0, NULL),
	(2138, 149, 0, NULL, 109, '', 243, '0536', 12189, 1, 0, NULL),
	(2139, 149, 0, NULL, 109, '', 244, '0536', 4297, 1, 0, NULL),
	(2140, 149, 0, NULL, 109, '', 245, '0537', 3995, 1, 0, NULL),
	(2141, 149, 0, NULL, 109, '', 246, '0537', 5000, 1, 0, NULL),
	(2142, 149, 0, NULL, 109, '', 247, '0537', 5931, 1, 0, NULL),
	(2143, 149, 0, NULL, 109, '', 248, '0537', 3716, 1, 0, NULL),
	(2144, 149, 0, NULL, 109, '', 249, '0537', 3212, 1, 0, NULL),
	(2145, 149, 0, NULL, 109, '', 250, '0537', 5398, 1, 0, NULL),
	(2146, 149, 0, NULL, 109, '', 251, '0537', 6822, 1, 0, NULL),
	(2147, 149, 0, NULL, 109, '', 252, '0537', 5342, 1, 0, NULL),
	(2148, 149, 0, NULL, 109, '', 253, '0537', 5984, 1, 0, NULL),
	(2149, 149, 0, NULL, 109, '', 254, '0537', 6791, 1, 0, NULL),
	(2150, 149, 0, NULL, 109, '', 255, '0537', 3933, 1, 0, NULL),
	(2151, 149, 0, NULL, 109, '', 256, '0537', 3805, 1, 0, NULL),
	(2152, 149, 0, NULL, 109, '', 257, '0537', 2631, 1, 0, NULL),
	(2153, 149, 0, NULL, 109, '', 258, '0537', 7103, 1, 0, NULL),
	(2154, 149, 0, NULL, 109, '', 259, '0537', 7074, 1, 0, NULL),
	(2155, 149, 0, NULL, 110, '', 260, '0537', 6506, 1, 0, NULL),
	(2156, 149, 0, NULL, 110, '', 261, '0537', 4799, 1, 0, NULL),
	(2157, 149, 0, NULL, 110, '', 262, '0537', 6714, 1, 0, NULL),
	(2158, 149, 0, NULL, 110, '', 263, '0537', 13508, 1, 0, NULL),
	(2159, 149, 0, NULL, 110, '', 264, '0537', 2249, 1, 0, NULL),
	(2160, 149, 0, NULL, 110, '', 265, '0537', 6795, 1, 0, NULL),
	(2161, 149, 0, NULL, 110, '', 266, '0537', 12655, 1, 0, NULL),
	(2162, 149, 0, NULL, 110, '', 267, '0537', 2673, 1, 0, NULL),
	(2163, 149, 0, NULL, 110, '', 268, '0537', 5654, 1, 0, NULL),
	(2164, 149, 0, NULL, 110, '', 269, '0537', 3713, 1, 0, NULL),
	(2165, 149, 0, NULL, 110, '', 270, '0537', 5179, 1, 0, NULL),
	(2166, 149, 0, NULL, 110, '', 271, '0537', 3977, 1, 0, NULL),
	(2167, 149, 0, NULL, 110, '', 272, '0537', 4525, 1, 0, NULL),
	(2168, 149, 0, NULL, 110, '', 273, '0537', 4100, 1, 0, NULL),
	(2169, 149, 0, NULL, 110, '', 274, '0537', 4100, 1, 0, NULL),
	(2170, 149, 0, NULL, 110, '', 275, '0537', 4845, 1, 0, NULL),
	(2171, 149, 0, NULL, 110, '', 276, '0537', 2927, 1, 0, NULL),
	(2172, 149, 0, NULL, 110, '', 277, '0537', 10590, 1, 0, NULL),
	(2173, 149, 0, NULL, 110, '', 278, '0537', 6542, 1, 0, NULL),
	(2174, 149, 0, NULL, 110, '', 279, '0537', 7148, 1, 0, NULL),
	(2175, 151, 0, NULL, 64, '', 1, '0358', NULL, 1, 0, NULL),
	(2176, 151, 0, NULL, 64, '', 2, '0358', NULL, 1, 0, NULL),
	(2177, 151, 0, NULL, 64, '', 3, '0358', NULL, 1, 0, NULL),
	(2178, 151, 0, NULL, 65, '', 4, '0358', NULL, 1, 0, NULL),
	(2179, 151, 0, NULL, 65, '', 5, '0358', NULL, 1, 0, NULL),
	(2180, 151, 0, NULL, 65, '', 6, '0358', NULL, 1, 0, NULL),
	(2181, 151, 0, NULL, 65, '', 7, '0358', NULL, 1, 0, NULL),
	(2182, 151, 0, NULL, 65, '', 8, '0358', NULL, 1, 0, NULL),
	(2183, 151, 0, NULL, 65, '', 9, '0358', NULL, 1, 0, NULL),
	(2184, 151, 0, NULL, 65, '', 10, '0358', NULL, 1, 0, NULL),
	(2185, 151, 0, NULL, 65, '', 11, '0358', NULL, 1, 0, NULL),
	(2186, 151, 0, NULL, 65, '', 12, '0358', NULL, 1, 0, NULL),
	(2187, 151, 0, NULL, 65, '', 13, '0358', NULL, 1, 0, NULL),
	(2188, 151, 0, NULL, 65, '', 14, '0358', NULL, 1, 0, NULL),
	(2189, 151, 0, NULL, 65, '', 15, '0358', NULL, 1, 0, NULL),
	(2190, 151, 0, NULL, 65, '', 16, '0358', NULL, 1, 0, NULL),
	(2191, 151, 0, NULL, 65, '', 17, '0358', NULL, 1, 0, NULL),
	(2192, 151, 0, NULL, 65, '', 18, '0358', NULL, 1, 0, NULL),
	(2193, 151, 0, NULL, 65, '', 19, '0358', NULL, 1, 0, NULL),
	(2194, 151, 0, NULL, 73, '', 20, '0358', NULL, 1, 0, NULL),
	(2195, 151, 0, NULL, 73, '', 21, '0358', NULL, 1, 0, NULL),
	(2196, 151, 0, NULL, 73, '', 22, '0358', NULL, 1, 0, NULL),
	(2197, 151, 0, NULL, 73, '', 23, '0358', NULL, 1, 0, NULL),
	(2198, 151, 0, NULL, 73, '', 24, '0358', NULL, 1, 0, NULL),
	(2199, 151, 0, NULL, 73, '', 25, '0358', NULL, 1, 0, NULL),
	(2200, 151, 0, NULL, 73, '', 26, '0358', NULL, 1, 0, NULL),
	(2202, 144, 0, NULL, 53, '', 19, '0548', NULL, 14, 0, NULL),
	(2241, 152, 0, NULL, 73, '', 27, '0359', NULL, 1, 0, NULL),
	(2242, 152, 0, NULL, 73, '', 28, '0359', NULL, 1, 0, NULL),
	(2243, 152, 0, NULL, 73, '', 29, '0359', NULL, 1, 0, NULL),
	(2244, 152, 0, NULL, 73, '', 30, '0359', NULL, 1, 0, NULL),
	(2245, 152, 0, NULL, 73, '', 31, '0359', NULL, 1, 0, NULL),
	(2246, 152, 0, NULL, 73, '', 32, '0359', NULL, 1, 0, NULL),
	(2247, 152, 0, NULL, 73, '', 33, '0359', NULL, 1, 0, NULL),
	(2248, 152, 0, NULL, 73, '', 34, '0359', NULL, 1, 0, NULL),
	(2249, 152, 0, NULL, 73, '', 35, '0359', NULL, 1, 0, NULL),
	(2250, 152, 0, NULL, 74, '', 36, '0359', NULL, 1, 0, NULL),
	(2251, 152, 0, NULL, 74, '', 37, '0359', NULL, 1, 0, NULL),
	(2252, 152, 0, NULL, 74, '', 38, '0359', NULL, 1, 0, NULL),
	(2253, 152, 0, NULL, 74, '', 39, '0359', NULL, 1, 0, NULL),
	(2254, 152, 0, NULL, 74, '', 40, '0359', NULL, 1, 0, NULL),
	(2255, 152, 0, NULL, 74, '', 41, '0359', NULL, 1, 0, NULL),
	(2256, 152, 0, NULL, 74, '', 42, '0359', NULL, 1, 0, NULL),
	(2257, 152, 0, NULL, 74, '', 43, '0359', NULL, 1, 0, NULL),
	(2258, 152, 0, NULL, 74, '', 44, '0359', NULL, 1, 0, NULL),
	(2259, 152, 0, NULL, 74, '', 45, '0359', NULL, 1, 0, NULL),
	(2260, 152, 0, NULL, 74, '', 46, '0359', NULL, 1, 0, NULL),
	(2261, 152, 0, NULL, 74, '', 47, '0359', NULL, 1, 0, NULL),
	(2262, 152, 0, NULL, 74, '', 48, '0359', NULL, 1, 0, NULL),
	(2263, 152, 0, NULL, 74, '', 49, '0359', NULL, 1, 0, NULL),
	(2264, 152, 0, NULL, 74, '', 50, '0359', NULL, 1, 0, NULL),
	(2265, 152, 0, NULL, 74, '', 51, '0359', NULL, 1, 0, NULL),
	(2266, 152, 0, NULL, 75, '', 52, '0359', NULL, 1, 0, NULL),
	(2267, 161, 0, NULL, 54, '', 1, '0539', 0, 15, 0, NULL),
	(2268, 161, 0, NULL, 54, '', 2, '0539', 0, 15, 0, NULL),
	(2269, 161, 0, NULL, 54, '', 3, '0539', 0, 15, 0, NULL),
	(2270, 161, 0, NULL, 54, '', 4, '0539', 0, 15, 0, NULL),
	(2271, 161, 0, NULL, 54, '', 5, '0539', 0, 6, 0, NULL),
	(2272, 161, 0, NULL, 59, '', 6, '0539', 0, 15, 0, NULL),
	(2273, 161, 0, NULL, 59, '', 7, '0539', 0, 15, 0, NULL),
	(2274, 161, 0, NULL, 59, '', 8, '0539', 0, 15, 0, NULL),
	(2275, 161, 0, NULL, 59, '', 9, '0539', 0, 15, 0, NULL),
	(2276, 161, 0, NULL, 59, '', 10, '0539', 0, 15, 0, NULL),
	(2277, 161, 0, NULL, 59, '', 11, '0539', 0, 15, 0, NULL),
	(2278, 161, 0, NULL, 59, '', 12, '0539', 0, 15, 0, NULL),
	(2279, 161, 0, NULL, 59, '', 13, '0539', 0, 15, 0, NULL),
	(2280, 161, 0, NULL, 59, '', 14, '0539', 0, 15, 0, NULL),
	(2281, 161, 0, NULL, 59, '', 15, '0540', 0, 15, 0, NULL),
	(2282, 161, 0, NULL, 59, '', 16, '0540', 0, 15, 0, NULL),
	(2283, 161, 0, NULL, 59, '', 17, '0540', 0, 15, 0, NULL),
	(2284, 161, 0, NULL, 59, '', 18, '0540', 0, 15, 0, NULL),
	(2285, 161, 0, NULL, 59, '', 19, '0540', 0, 15, 0, NULL),
	(2286, 161, 0, NULL, 59, '', 20, '0540', 0, 15, 0, NULL),
	(2287, 161, 0, NULL, 59, '', 21, '0540', 0, 15, 0, NULL),
	(2288, 161, 0, NULL, 59, '', 22, '0540', 0, 15, 0, NULL),
	(2289, 161, 0, NULL, 59, '', 23, '0540', 0, 15, 0, NULL),
	(2290, 161, 0, NULL, 59, '', 24, '0540', 0, 15, 0, NULL),
	(2291, 161, 0, NULL, 59, '', 25, '0540', 0, 6, 0, NULL),
	(2292, 161, 0, NULL, 71, '', 26, '0540', 0, 15, 0, NULL),
	(2293, 161, 0, NULL, 71, '', 27, '0540', 0, 15, 0, NULL),
	(2294, 161, 0, NULL, 71, '', 28, '0540', 0, 15, 0, NULL),
	(2295, 161, 0, NULL, 71, '', 29, '0540', 0, 15, 0, NULL),
	(2296, 161, 0, NULL, 71, '', 30, '0540', 0, 15, 0, NULL),
	(2297, 161, 0, NULL, 71, '', 31, '0540', 0, 15, 0, NULL),
	(2298, 161, 0, NULL, 71, '', 32, '0540', 0, 15, 0, NULL),
	(2299, 161, 0, NULL, 71, '', 33, '0540', 0, 15, 0, NULL),
	(2300, 161, 0, NULL, 71, '', 34, '0540', 0, 15, 0, NULL),
	(2301, 161, 0, NULL, 71, '', 35, '0540', 0, 15, 0, NULL),
	(2302, 161, 0, NULL, 71, '', 36, '0540', 0, 15, 0, NULL),
	(2303, 161, 0, NULL, 71, '', 37, '0540', 0, 15, 0, NULL),
	(2304, 161, 0, NULL, 71, '', 38, '0540', 0, 15, 0, NULL),
	(2365, 160, 0, NULL, 60, '', 140, '0557', 10515, 1, 0, NULL),
	(2366, 160, 0, NULL, 60, '', 141, '0557', 13069, 1, 0, NULL),
	(2367, 160, 0, NULL, 60, '', 142, '0557', 7435, 1, 0, NULL),
	(2368, 160, 0, NULL, 60, '', 143, '0557', 7686, 1, 0, NULL),
	(2369, 160, 0, NULL, 60, '', 144, '0557', 9869, 1, 0, NULL),
	(2370, 160, 0, NULL, 60, '', 145, '0557', 11038, 1, 0, NULL),
	(2371, 160, 0, NULL, 60, '', 146, '0557', 9301, 1, 0, NULL),
	(2372, 160, 0, NULL, 60, '', 147, '0557', 12724, 1, 0, NULL),
	(2373, 160, 0, NULL, 60, '', 148, '0557', 11552, 1, 0, NULL),
	(2374, 160, 0, NULL, 60, '', 149, '0557', 12406, 1, 0, NULL),
	(2375, 160, 0, NULL, 60, '', 150, '0557', 10577, 1, 0, NULL),
	(2376, 160, 0, NULL, 60, '', 151, '0557', 13452, 1, 0, NULL),
	(2377, 160, 0, NULL, 60, '', 152, '0557', 7988, 1, 0, NULL),
	(2378, 160, 0, NULL, 60, '', 153, '0557', 12484, 1, 0, NULL),
	(2379, 160, 0, NULL, 60, '', 154, '0557', 12455, 1, 0, NULL),
	(2380, 160, 0, NULL, 60, '', 155, '0557', 11922, 1, 0, NULL),
	(2381, 160, 0, NULL, 60, '', 156, '0557', 10387, 1, 0, NULL),
	(2382, 160, 0, NULL, 60, '', 157, '0557', 10456, 1, 0, NULL),
	(2383, 160, 0, NULL, 60, '', 158, '0557', 10770, 1, 0, NULL),
	(2384, 160, 0, NULL, 60, '', 159, '0557', 10457, 1, 0, NULL),
	(2385, 160, 0, NULL, 60, '', 160, '0557', 9590, 1, 0, NULL),
	(2386, 160, 0, NULL, 60, '', 161, '0557', 8593, 1, 0, NULL),
	(2387, 160, 0, NULL, 60, '', 162, '0557', 2841, 1, 0, NULL),
	(2388, 160, 0, NULL, 60, '', 163, '0558', 3568, 1, 0, NULL),
	(2389, 160, 0, NULL, 60, '', 164, '0558', 13441, 1, 0, NULL),
	(2390, 160, 0, NULL, 60, '', 165, '0558', 3912, 1, 0, NULL),
	(2391, 160, 0, NULL, 60, '', 166, '0558', 8477, 1, 0, NULL),
	(2392, 160, 0, NULL, 60, '', 167, '0558', 8128, 1, 0, NULL),
	(2393, 160, 0, NULL, 60, '', 168, '0558', 727, 1, 0, NULL),
	(2395, 154, 0, NULL, 60, '', 1, '0558', 10541, 1, 0, NULL),
	(2396, 154, 0, NULL, 60, '', 2, '0558', 6147, 1, 0, NULL),
	(2397, 154, 0, NULL, 60, '', 3, '0558', 1994, 1, 0, NULL),
	(2398, 154, 0, NULL, 60, '', 4, '0558', 10892, 1, 0, NULL),
	(2399, 154, 0, NULL, 60, '', 5, '0558', 10654, 1, 0, NULL),
	(2400, 154, 0, NULL, 62, '', 6, '0558', 7514, 1, 0, NULL),
	(2401, 154, 0, NULL, 62, '', 7, '0558', 6848, 1, 0, NULL),
	(2402, 154, 0, NULL, 62, '', 8, '0558', 1151, 1, 0, NULL),
	(2403, 154, 0, NULL, 62, '', 9, '0558', 4170, 1, 0, NULL),
	(2404, 154, 0, NULL, 62, '', 10, '0558', 12650, 1, 0, NULL),
	(2405, 154, 0, NULL, 62, '', 11, '0558', 8066, 1, 0, NULL),
	(2406, 154, 0, NULL, 62, '', 12, '0558', 4537, 1, 0, NULL),
	(2407, 154, 0, NULL, 62, '', 13, '0558', 13775, 1, 0, NULL),
	(2408, 154, 0, NULL, 62, '', 14, '0558', 4362, 1, 0, NULL),
	(2409, 154, 0, NULL, 62, '', 15, '0558', 5631, 1, 0, NULL),
	(2410, 154, 0, NULL, 62, '', 16, '0558', 13736, 1, 0, NULL),
	(2411, 154, 0, NULL, 62, '', 17, '0558', 2657, 1, 0, NULL),
	(2412, 154, 0, NULL, 62, '', 18, '0559', 8692, 1, 0, NULL),
	(2413, 154, 0, NULL, 62, '', 19, '0559', 9375, 1, 0, NULL),
	(2414, 154, 0, NULL, 62, '', 20, '0559', 6220, 1, 0, NULL),
	(2415, 154, 0, NULL, 62, '', 21, '0559', 1324, 1, 0, NULL),
	(2416, 154, 0, NULL, 62, '', 22, '0559', 2051, 1, 0, NULL),
	(2417, 154, 0, NULL, 62, '', 23, '0559', 4937, 1, 0, NULL),
	(2418, 154, 0, NULL, 62, '', 24, '0559', 8741, 1, 0, NULL),
	(2419, 154, 0, NULL, 62, '', 25, '0559', 577, 1, 0, NULL),
	(2420, 154, 0, NULL, 62, '', 26, '0559', 3421, 1, 0, NULL),
	(2421, 154, 0, NULL, 62, '', 27, '0559', 7341, 1, 0, NULL),
	(2422, 154, 0, NULL, 62, '', 28, '0559', 13294, 1, 0, NULL),
	(2423, 154, 0, NULL, 62, '', 29, '0559', 11479, 1, 0, NULL),
	(2424, 154, 0, NULL, 62, '', 30, '0559', 13040, 1, 0, NULL),
	(2425, 154, 0, NULL, 62, '', 31, '0559', 2974, 1, 0, NULL),
	(2426, 154, 0, NULL, 62, '', 32, '0559', 9454, 1, 0, NULL),
	(2427, 154, 0, NULL, 62, '', 33, '0559', 7657, 1, 0, NULL),
	(2428, 154, 0, NULL, 62, '', 34, '0559', 9495, 1, 0, NULL),
	(2429, 154, 0, NULL, 62, '', 35, '0559', 4645, 1, 0, NULL),
	(2430, 154, 0, NULL, 62, '', 36, '0559', 5175, 1, 0, NULL),
	(2431, 154, 0, NULL, 62, '', 37, '0559', 0, 1, 0, NULL),
	(2432, 154, 0, NULL, 62, '', 38, '0559', 0, 1, 0, NULL),
	(2433, 154, 0, NULL, 62, '', 39, '0559', 0, 1, 0, NULL),
	(2434, 154, 0, NULL, 62, '', 40, '0559', 0, 1, 0, NULL),
	(2435, 150, 0, NULL, 110, '', 280, '0538', 2612, 1, 0, NULL),
	(2436, 150, 0, NULL, 110, '', 281, '0538', 5908, 1, 0, NULL),
	(2437, 150, 0, NULL, 110, '', 282, '0538', 5508, 1, 0, NULL),
	(2438, 150, 0, NULL, 110, '', 283, '0538', 4670, 1, 0, NULL),
	(2439, 150, 0, NULL, 110, '', 284, '0538', 1949, 1, 0, NULL),
	(2440, 150, 0, NULL, 110, '', 285, '0538', 9156, 1, 0, NULL),
	(2441, 150, 0, NULL, 110, '', 286, '0538', 4566, 1, 0, NULL),
	(2442, 150, 0, NULL, 110, '', 287, '0538', 12416, 1, 0, NULL),
	(2443, 150, 0, NULL, 110, '', 288, '0538', 11799, 1, 0, NULL),
	(2444, 150, 0, NULL, 110, '', 289, '0538', 11351, 1, 0, NULL),
	(2445, 150, 0, NULL, 110, '', 290, '0538', 2139, 1, 0, NULL),
	(2446, 150, 0, NULL, 110, '', 291, '0538', 2112, 1, 0, NULL),
	(2447, 150, 0, NULL, 110, '', 292, '0538', 6179, 1, 0, NULL),
	(2448, 150, 0, NULL, 110, '', 293, '0538', 2898, 1, 0, NULL),
	(2449, 150, 0, NULL, 110, '', 294, '0538', 11078, 1, 0, NULL),
	(2450, 150, 0, NULL, 110, '', 295, '0538', 4263, 1, 0, NULL),
	(2451, 150, 0, NULL, 110, '', 296, '0538', 1933, 1, 0, NULL),
	(2452, 150, 0, NULL, 110, '', 297, '0538', 4944, 1, 0, NULL),
	(2453, 150, 0, NULL, 110, '', 298, '0538', 7654, 1, 0, NULL),
	(2454, 150, 0, NULL, 110, '', 299, '0538', 3618, 1, 0, NULL),
	(2455, 150, 0, NULL, 110, '', 300, '0538', 6671, 1, 0, NULL),
	(2456, 150, 0, NULL, 110, '', 301, '0538', 2610, 1, 0, NULL),
	(2457, 150, 0, NULL, 111, '', 302, '0538', 5367, 1, 0, NULL),
	(2458, 150, 0, NULL, 111, '', 303, '0538', 2873, 1, 0, NULL),
	(2459, 150, 0, NULL, 111, '', 304, '0538', 3219, 1, 0, NULL),
	(2460, 150, 0, NULL, 111, '', 305, '0538', 10208, 1, 0, NULL),
	(2461, 150, 0, NULL, 111, '', 306, '0538', 2362, 1, 0, NULL),
	(2462, 150, 0, NULL, 111, '', 307, '0538', 2362, 1, 0, NULL),
	(2463, 150, 0, NULL, 111, '', 308, '0538', 4945, 1, 0, NULL),
	(2464, 150, 0, NULL, 111, '', 309, '0538', 2908, 1, 0, NULL),
	(2465, 150, 0, NULL, 111, '', 310, '0538', 6220, 1, 0, NULL),
	(2466, 150, 0, NULL, 111, '', 311, '0538', 6423, 1, 0, NULL),
	(2467, 150, 0, NULL, 111, '', 312, '0538', 3294, 1, 0, NULL),
	(2468, 150, 0, NULL, 111, '', 313, '0538', 4462, 1, 0, NULL),
	(2469, 150, 0, NULL, 111, '', 314, '0538', 2205, 1, 0, NULL),
	(2470, 150, 0, NULL, 111, '', 315, '0539', 6390, 1, 0, NULL),
	(2471, 150, 0, NULL, 111, '', 316, '0539', 6857, 1, 0, NULL),
	(2472, 150, 0, NULL, 111, '', 317, '0539', 3487, 1, 0, NULL),
	(2473, 150, 0, NULL, 111, '', 318, '0539', 7719, 1, 0, NULL),
	(2474, 150, 0, NULL, 111, '', 319, '0539', 6658, 1, 0, NULL),
	(2475, 150, 0, NULL, 111, '', 320, '0539', 6752, 1, 0, NULL),
	(2476, 150, 0, NULL, 111, '', 321, '0539', 2803, 1, 0, NULL),
	(2477, 150, 0, NULL, 111, '', 322, '0539', 1998, 1, 0, NULL),
	(2478, 150, 0, NULL, 111, '', 323, '0539', 11743, 1, 0, NULL),
	(2479, 150, 0, NULL, 111, '', 324, '0539', 3194, 1, 0, NULL),
	(2480, 150, 0, NULL, 111, '', 325, '0539', 7976, 1, 0, NULL),
	(2481, 150, 0, NULL, 111, '', 326, '0539', 7436, 1, 0, NULL),
	(2482, 150, 0, NULL, 111, '', 327, '0539', 5889, 1, 0, NULL),
	(2483, 150, 0, NULL, 111, '', 328, '0539', 0, 1, 0, NULL),
	(2484, 150, 0, NULL, 111, '', 329, '0539', 0, 1, 0, NULL),
	(2485, 162, 0, NULL, 71, '', 39, '0541', 0, 15, 0, NULL),
	(2486, 162, 0, NULL, 71, '', 40, '0541', 0, 15, 0, NULL),
	(2487, 162, 0, NULL, 71, '', 41, '0541', 0, 15, 0, NULL),
	(2488, 162, 0, NULL, 71, '', 42, '0541', 0, 15, 0, NULL),
	(2489, 162, 0, NULL, 71, '', 43, '0541', 0, 15, 0, NULL),
	(2490, 162, 0, NULL, 71, '', 44, '0541', 0, 15, 0, NULL),
	(2491, 162, 0, NULL, 71, '', 45, '0541', 0, 15, 0, NULL),
	(2492, 162, 0, NULL, 71, '', 46, '0541', 0, 15, 0, NULL),
	(2493, 162, 0, NULL, 71, '', 47, '0541', 0, 15, 0, NULL),
	(2494, 162, 0, NULL, 71, '', 48, '0541', 0, 15, 0, NULL),
	(2495, 162, 0, NULL, 71, '', 49, '0541', 0, 15, 0, NULL),
	(2496, 162, 0, NULL, 71, '', 50, '0541', 0, 15, 0, NULL),
	(2497, 162, 0, NULL, 71, '', 51, '0541', 0, 15, 0, NULL),
	(2498, 162, 0, NULL, 71, '', 52, '0541', 0, 15, 0, NULL),
	(2499, 162, 0, NULL, 71, '', 53, '0541', 0, 15, 0, NULL),
	(2500, 162, 0, NULL, 71, '', 54, '0541', 0, 15, 0, NULL),
	(2501, 162, 0, NULL, 71, '', 55, '0541', 0, 15, 0, NULL),
	(2502, 162, 0, NULL, 71, '', 56, '0541', 0, 1, 0, NULL),
	(2503, 162, 0, NULL, 81, '', 57, '0541', 0, 15, 0, NULL),
	(2504, 162, 0, NULL, 81, '', 58, '0541', 0, 15, 0, NULL),
	(2505, 162, 0, NULL, 81, '', 59, '0541', 0, 15, 0, NULL),
	(2506, 162, 0, NULL, 81, '', 60, '0541', 0, 15, 0, NULL),
	(2507, 162, 0, NULL, 81, '', 61, '0541', 0, 15, 0, NULL),
	(2508, 162, 0, NULL, 81, '', 62, '0541', 0, 15, 0, NULL),
	(2509, 162, 0, NULL, 81, '', 63, '0541', 0, 15, 0, NULL),
	(2510, 162, 0, NULL, 81, '', 64, '0542', 0, 15, 0, NULL),
	(2511, 162, 0, NULL, 81, '', 65, '0542', 0, 15, 0, NULL),
	(2512, 162, 0, NULL, 81, '', 66, '0542', 0, 15, 0, NULL),
	(2513, 162, 0, NULL, 81, '', 67, '0542', 0, 15, 0, NULL),
	(2514, 162, 0, NULL, 81, '', 68, '0542', 0, 15, 0, NULL),
	(2515, 162, 0, NULL, 81, '', 69, '0542', 0, 15, 0, NULL),
	(2516, 162, 0, NULL, 81, '', 70, '0542', 0, 15, 0, NULL),
	(2517, 162, 0, NULL, 81, '', 71, '0542', 0, 15, 0, NULL),
	(2518, 162, 0, NULL, 81, '', 72, '0542', 0, 15, 0, NULL),
	(2519, 162, 0, NULL, 81, '', 73, '0542', 0, 15, 0, NULL),
	(2520, 162, 0, NULL, 81, '', 74, '0542', 0, 15, 0, NULL),
	(2521, 162, 0, NULL, 81, '', 75, '0542', 0, 15, 0, NULL),
	(2522, 162, 0, NULL, 81, '', 76, '0542', 0, 1, 0, NULL),
	(2523, 162, 0, NULL, 82, '', 77, '0542', 0, 15, 0, NULL),
	(2524, 162, 0, NULL, 82, '', 78, '0542', 0, 15, 0, NULL),
	(2525, 162, 0, NULL, 82, '', 79, '0542', 0, 15, 0, NULL),
	(2526, 162, 0, NULL, 82, '', 80, '0542', 0, 15, 0, NULL),
	(2527, 162, 0, NULL, 82, '', 81, '0542', 0, 15, 0, NULL),
	(2528, 162, 0, NULL, 82, '', 82, '0542', 0, 15, 0, NULL),
	(2529, 162, 0, NULL, 82, '', 83, '0542', 0, 15, 0, NULL),
	(2530, 162, 0, NULL, 82, '', 84, '0542', 0, 15, 0, NULL),
	(2531, 162, 0, NULL, 82, '', 85, '0542', 0, 15, 0, NULL),
	(2532, 162, 0, NULL, 82, '', 86, '0542', 0, 15, 0, NULL),
	(2533, 162, 0, NULL, 82, '', 87, '0542', 0, 15, 0, NULL),
	(2534, 162, 0, NULL, 82, '', 88, '0543', 0, 15, 0, NULL),
	(2535, 162, 0, NULL, 82, '', 89, '0543', 0, 15, 0, NULL),
	(2536, 162, 0, NULL, 82, '', 90, '0543', 0, 15, 0, NULL),
	(2537, 162, 0, NULL, 82, '', 91, '0543', 0, 15, 0, NULL),
	(2538, 162, 0, NULL, 82, '', 92, '0543', 0, 15, 0, NULL),
	(2539, 162, 0, NULL, 82, '', 93, '0543', 0, 15, 0, NULL),
	(2540, 162, 0, NULL, 82, '', 94, '0543', 0, 15, 0, NULL),
	(2541, 162, 0, NULL, 82, '', 95, '0543', 0, 15, 0, NULL),
	(2542, 162, 0, NULL, 82, '', 96, '0543', 0, 1, 0, NULL),
	(2543, 162, 0, NULL, NULL, '', 97, '0543', 0, 15, 1, NULL),
	(2544, 162, 0, NULL, NULL, '', 98, '0543', 0, 15, 1, NULL),
	(2545, 162, 0, NULL, NULL, '', 99, '0543', 0, 15, 1, NULL),
	(2546, 162, 0, NULL, NULL, '', 100, '0543', 0, 15, 1, NULL),
	(2547, 162, 0, NULL, NULL, '', 101, '0543', 0, 15, 1, NULL),
	(2548, 162, 0, NULL, NULL, '', 102, '0543', 0, 15, 1, NULL),
	(2549, 162, 0, NULL, NULL, '', 103, '0543', 0, 15, 1, NULL),
	(2550, 162, 0, NULL, NULL, '', 104, '0543', 0, 15, 1, NULL),
	(2551, 162, 0, NULL, NULL, '', 105, '0543', 0, 15, 1, NULL),
	(2552, 162, 0, NULL, NULL, '', 106, '0543', 0, 15, 1, NULL),
	(2553, 162, 0, NULL, NULL, '', 107, '0543', 0, 15, 1, NULL),
	(2554, 162, 0, NULL, NULL, '', 108, '0543', 0, 15, 1, NULL),
	(2555, 162, 0, NULL, NULL, '', 109, '0543', 0, 15, 1, NULL),
	(2556, 162, 0, NULL, NULL, '', 110, '0543', 0, 15, 1, NULL),
	(2557, 162, 0, NULL, NULL, '', 111, '0543', 0, 15, 1, NULL),
	(2558, 162, 0, NULL, NULL, '', 112, '0543', 0, 15, 1, NULL),
	(2559, 155, 0, NULL, 62, '', 41, '0560', 8437, 1, 0, NULL),
	(2560, 155, 0, NULL, 62, '', 42, '0560', 12853, 1, 0, NULL),
	(2561, 155, 0, NULL, 62, '', 43, '0560', 5042, 1, 0, NULL),
	(2562, 155, 0, NULL, 62, '', 44, '0560', 9044, 1, 0, NULL),
	(2563, 155, 0, NULL, 62, '', 45, '0560', 0, 1, 0, NULL),
	(2564, 155, 0, NULL, 72, '', 46, '0560', 4178, 1, 0, NULL),
	(2565, 155, 0, NULL, 72, '', 47, '0560', 2336, 1, 0, NULL),
	(2566, 155, 0, NULL, 72, '', 48, '0560', 8003, 1, 0, NULL),
	(2567, 155, 0, NULL, 72, '', 49, '0560', 9531, 1, 0, NULL),
	(2568, 155, 0, NULL, 72, '', 50, '0560', 2261, 1, 0, NULL),
	(2569, 155, 0, NULL, 72, '', 51, '0560', 2711, 1, 0, NULL),
	(2570, 155, 0, NULL, 72, '', 52, '0560', 5167, 1, 0, NULL),
	(2571, 155, 0, NULL, 72, '', 53, '0560', 10438, 1, 0, NULL),
	(2572, 155, 0, NULL, 72, '', 54, '0560', 3722, 1, 0, NULL),
	(2573, 155, 0, NULL, 72, '', 55, '0560', 5973, 1, 0, NULL),
	(2574, 155, 0, NULL, 72, '', 56, '0560', 13247, 1, 0, NULL),
	(2575, 155, 0, NULL, 72, '', 57, '0560', 7010, 1, 0, NULL),
	(2576, 155, 0, NULL, 72, '', 58, '0560', 9745, 1, 0, NULL),
	(2577, 155, 0, NULL, 72, '', 59, '0560', 11724, 1, 0, NULL),
	(2578, 155, 0, NULL, 72, '', 60, '0560', 9892, 1, 0, NULL),
	(2579, 155, 0, NULL, 72, '', 61, '0560', 10296, 1, 0, NULL),
	(2580, 155, 0, NULL, 72, '', 62, '0560', 7472, 1, 0, NULL),
	(2581, 155, 0, NULL, 72, '', 63, '0560', 7753, 1, 0, NULL),
	(2582, 155, 0, NULL, 72, '', 64, '0561', 2471, 1, 0, NULL),
	(2583, 155, 0, NULL, 72, '', 65, '0561', 13054, 1, 0, NULL),
	(2584, 155, 0, NULL, 72, '', 66, '0561', 8481, 1, 0, NULL),
	(2585, 155, 0, NULL, 72, '', 67, '0561', 13733, 1, 0, NULL),
	(2586, 155, 0, NULL, 72, '', 68, '0561', 6276, 1, 0, NULL),
	(2587, 155, 0, NULL, 72, '', 69, '0561', 6440, 1, 0, NULL),
	(2588, 155, 0, NULL, 72, '', 70, '0561', 8528, 1, 0, NULL),
	(2589, 155, 0, NULL, 72, '', 71, '0561', 9749, 1, 0, NULL),
	(2590, 155, 0, NULL, 72, '', 72, '0561', 4055, 1, 0, NULL),
	(2591, 155, 0, NULL, 72, '', 73, '0561', 6346, 1, 0, NULL),
	(2592, 155, 0, NULL, 72, '', 74, '0561', 2651, 1, 0, NULL),
	(2593, 155, 0, NULL, 72, '', 75, '0561', 6785, 1, 0, NULL),
	(2594, 155, 0, NULL, 72, '', 76, '0561', 4685, 1, 0, NULL),
	(2595, 155, 0, NULL, 72, '', 77, '0561', 5569, 1, 0, NULL),
	(2596, 155, 0, NULL, 72, '', 78, '0561', 2919, 1, 0, NULL),
	(2597, 155, 0, NULL, 72, '', 79, '0561', 5375, 1, 0, NULL),
	(2598, 155, 0, NULL, 72, '', 80, '0561', 10206, 1, 0, NULL),
	(2599, 155, 0, NULL, 72, '', 81, '0561', 11539, 1, 0, NULL),
	(2600, 155, 0, NULL, 72, '', 82, '0561', 7232, 1, 0, NULL),
	(2601, 155, 0, NULL, 72, '', 83, '0561', 9638, 1, 0, NULL),
	(2602, 155, 0, NULL, 72, '', 84, '0561', 11871, 1, 0, NULL),
	(2603, 155, 0, NULL, 72, '', 85, '0561', 11264, 1, 0, NULL),
	(2604, 155, 0, NULL, 80, '', 86, '0561', 6846, 1, 0, NULL),
	(2605, 155, 0, NULL, 80, '', 87, '0562', 10673, 1, 0, NULL),
	(2606, 155, 0, NULL, 80, '', 88, '0562', 3806, 1, 0, NULL),
	(2607, 155, 0, NULL, 80, '', 89, '0562', 12356, 1, 0, NULL),
	(2608, 155, 0, NULL, 80, '', 90, '0562', 8853, 1, 0, NULL),
	(2609, 155, 0, NULL, 80, '', 91, '0562', 12664, 1, 0, NULL),
	(2610, 155, 0, NULL, 80, '', 92, '0562', 13153, 1, 0, NULL),
	(2611, 155, 0, NULL, 80, '', 93, '0562', 12925, 1, 0, NULL),
	(2612, 155, 0, NULL, 80, '', 94, '0562', 3948, 1, 0, NULL),
	(2613, 155, 0, NULL, 80, '', 95, '0562', 13371, 1, 0, NULL),
	(2614, 155, 0, NULL, 80, '', 96, '0562', 11780, 1, 0, NULL),
	(2615, 155, 0, NULL, 80, '', 97, '0562', 13607, 1, 0, NULL),
	(2616, 155, 0, NULL, 80, '', 98, '0562', 7876, 1, 0, NULL),
	(2617, 155, 0, NULL, 80, '', 99, '0562', 9663, 1, 0, NULL),
	(2618, 155, 0, NULL, 80, '', 100, '0562', 0, 1, 0, NULL),
	(2619, 155, 0, NULL, 80, '', 101, '0562', 0, 1, 0, NULL),
	(2620, 155, 0, NULL, 80, '', 102, '0562', 0, 1, 0, NULL),
	(2621, 155, 0, NULL, 80, '', 103, '0562', 0, 1, 0, NULL),
	(2622, 155, 0, NULL, 80, '', 104, '0562', 0, 1, 0, NULL),
	(2623, 155, 0, NULL, 80, '', 105, '0562', 0, 1, 0, NULL),
	(2624, 155, 0, NULL, 80, '', 106, '0562', 0, 1, 0, NULL),
	(2625, 155, 0, NULL, 80, '', 107, '0562', 0, 1, 0, NULL),
	(2626, 155, 0, NULL, 80, '', 108, '0562', 0, 1, 0, NULL),
	(2627, 155, 0, NULL, 80, '', 109, '0562', 0, 1, 0, NULL),
	(2628, 153, 0, NULL, 75, '', 53, '0360', NULL, 1, 0, NULL),
	(2629, 153, 0, NULL, 75, '', 54, '0360', NULL, 1, 0, NULL),
	(2630, 153, 0, NULL, 75, '', 55, '0360', NULL, 1, 0, NULL),
	(2631, 153, 0, NULL, 75, '', 56, '0360', NULL, 1, 0, NULL),
	(2632, 153, 0, NULL, 75, '', 57, '0360', NULL, 1, 0, NULL),
	(2633, 153, 0, NULL, 75, '', 58, '0360', NULL, 1, 0, NULL),
	(2634, 153, 0, NULL, 75, '', 59, '0360', NULL, 1, 0, NULL),
	(2635, 153, 0, NULL, 75, '', 60, '0360', NULL, 1, 0, NULL),
	(2636, 153, 0, NULL, 75, '', 61, '0360', NULL, 1, 0, NULL),
	(2637, 153, 0, NULL, 75, '', 62, '0360', NULL, 1, 0, NULL),
	(2638, 153, 0, NULL, 75, '', 63, '0360', NULL, 1, 0, NULL),
	(2639, 153, 0, NULL, 75, '', 64, '0360', NULL, 1, 0, NULL),
	(2640, 153, 0, NULL, 75, '', 65, '0360', NULL, 1, 0, NULL),
	(2641, 153, 0, NULL, 75, '', 66, '0360', NULL, 1, 0, NULL),
	(2642, 153, 0, NULL, 75, '', 67, '0360', NULL, 1, 0, NULL),
	(2643, 153, 0, NULL, 90, '', 68, '0360', NULL, 1, 0, NULL),
	(2644, 153, 0, NULL, 90, '', 69, '0360', NULL, 1, 0, NULL),
	(2645, 153, 0, NULL, 90, '', 70, '0360', NULL, 1, 0, NULL),
	(2646, 153, 0, NULL, 90, '', 71, '0360', NULL, 1, 0, NULL),
	(2647, 153, 0, NULL, 90, '', 72, '0360', NULL, 1, 0, NULL),
	(2648, 153, 0, NULL, 90, '', 73, '0360', NULL, 1, 0, NULL),
	(2649, 153, 0, NULL, 90, '', 74, '0360', NULL, 1, 0, NULL),
	(2698, 112, 0, NULL, 52, '', 157, '0354', NULL, 1, 0, NULL),
	(2699, 112, 0, NULL, 52, '', 158, '0354', NULL, 1, 0, NULL),
	(2700, 112, 0, NULL, 52, '', 159, '0354', NULL, 1, 0, NULL),
	(2701, 112, 0, NULL, 52, '', 160, '0354', NULL, 1, 0, NULL),
	(2702, 112, 0, NULL, 52, '', 161, '0354', NULL, 1, 0, NULL),
	(2703, 112, 0, NULL, 52, '', 162, '0354', NULL, 1, 0, NULL),
	(2704, 112, 0, NULL, 52, '', 163, '0354', NULL, 1, 0, NULL),
	(2705, 112, 0, NULL, 52, '', 164, '0354', NULL, 1, 0, NULL),
	(2706, 112, 0, NULL, 52, '', 165, '0354', NULL, 1, 0, NULL),
	(2707, 112, 0, NULL, 52, '', 166, '0354', NULL, 1, 0, NULL),
	(2708, 112, 0, NULL, 55, '', 167, '0354', NULL, 1, 0, NULL),
	(2709, 112, 0, NULL, 55, '', 168, '0354', NULL, 1, 0, NULL),
	(2710, 112, 0, NULL, 55, '', 169, '0354', NULL, 1, 0, NULL),
	(2711, 112, 0, NULL, 55, '', 170, '0354', NULL, 1, 0, NULL),
	(2712, 112, 0, NULL, 55, '', 171, '0354', NULL, 1, 0, NULL),
	(2713, 112, 0, NULL, 55, '', 172, '0354', NULL, 1, 0, NULL),
	(2714, 112, 0, NULL, 55, '', 173, '0354', NULL, 1, 0, NULL),
	(2715, 112, 0, NULL, 55, '', 174, '0354', NULL, 1, 0, NULL),
	(2716, 112, 0, NULL, 55, '', 175, '0354', NULL, 1, 0, NULL),
	(2717, 112, 0, NULL, 55, '', 176, '0354', NULL, 1, 0, NULL),
	(2718, 112, 0, NULL, 55, '', 177, '0355', NULL, 1, 0, NULL),
	(2719, 112, 0, NULL, 55, '', 178, '0355', NULL, 1, 0, NULL),
	(2720, 112, 0, NULL, 55, '', 179, '0355', NULL, 1, 0, NULL),
	(2721, 112, 0, NULL, 55, '', 180, '0355', NULL, 1, 0, NULL),
	(2722, 112, 0, NULL, 55, '', 181, '0355', NULL, 1, 0, NULL),
	(2723, 112, 0, NULL, 55, '', 182, '0355', NULL, 1, 0, NULL),
	(2724, 112, 0, NULL, 56, '', 183, '0355', NULL, 1, 0, NULL),
	(2725, 112, 0, NULL, 56, '', 184, '0355', NULL, 1, 0, NULL),
	(2726, 112, 0, NULL, 56, '', 185, '0355', NULL, 1, 0, NULL),
	(2727, 112, 0, NULL, 56, '', 186, '0355', NULL, 1, 0, NULL),
	(2728, 112, 0, NULL, 56, '', 187, '0355', NULL, 1, 0, NULL),
	(2729, 112, 0, NULL, 56, '', 188, '0355', NULL, 1, 0, NULL),
	(2730, 112, 0, NULL, 56, '', 189, '0355', NULL, 1, 0, NULL),
	(2731, 112, 0, NULL, 56, '', 190, '0355', NULL, 1, 0, NULL),
	(2732, 112, 0, NULL, 56, '', 191, '0355', NULL, 1, 0, NULL),
	(2733, 112, 0, NULL, 56, '', 192, '0355', NULL, 1, 0, NULL),
	(2734, 112, 0, NULL, 56, '', 193, '0355', NULL, 1, 0, NULL),
	(2735, 112, 0, NULL, 56, '', 194, '0355', NULL, 1, 0, NULL),
	(2736, 112, 0, NULL, 56, '', 195, '0355', NULL, 1, 0, NULL),
	(2737, 144, 0, NULL, 84, '', 39, '0549', NULL, 14, 0, NULL),
	(2738, 161, 0, NULL, 59, '', 5, '0539', NULL, 9, 0, NULL),
	(2739, 157, 0, NULL, 80, '', 110, '0563', 9603, 1, 0, NULL),
	(2740, 157, 0, NULL, 80, '', 111, '0563', 10538, 1, 0, NULL),
	(2741, 157, 0, NULL, 80, '', 112, '0563', 12988, 1, 0, NULL),
	(2742, 157, 0, NULL, 80, '', 113, '0563', 11198, 1, 0, NULL),
	(2743, 157, 0, NULL, 80, '', 114, '0563', 9170, 1, 0, NULL),
	(2744, 157, 0, NULL, 80, '', 115, '0563', 10208, 1, 0, NULL),
	(2745, 157, 0, NULL, 80, '', 116, '0563', 8762, 1, 0, NULL),
	(2746, 157, 0, NULL, 80, '', 117, '0563', 403, 1, 0, NULL),
	(2747, 157, 0, NULL, 80, '', 118, '0563', 3802, 1, 0, NULL),
	(2748, 157, 0, NULL, 80, '', 119, '0563', 6387, 1, 0, NULL),
	(2749, 157, 0, NULL, 80, '', 120, '0563', 940, 1, 0, NULL),
	(2750, 157, 0, NULL, 80, '', 121, '0563', 4391, 1, 0, NULL),
	(2751, 157, 0, NULL, 80, '', 122, '0563', 11165, 1, 0, NULL),
	(2752, 157, 0, NULL, 80, '', 123, '0563', 8020, 1, 0, NULL),
	(2753, 157, 0, NULL, 80, '', 124, '0563', 10182, 1, 0, NULL),
	(2754, 157, 0, NULL, 80, '', 125, '0563', 9965, 1, 0, NULL),
	(2755, 157, 0, NULL, 88, '', 126, '0563', 8545, 1, 0, NULL),
	(2756, 157, 0, NULL, 88, '', 127, '0563', 9126, 1, 0, NULL),
	(2757, 157, 0, NULL, 88, '', 128, '0563', 6952, 1, 0, NULL),
	(2758, 157, 0, NULL, 88, '', 129, '0563', 6924, 1, 0, NULL),
	(2759, 157, 0, NULL, 88, '', 130, '0563', 12164, 1, 0, NULL),
	(2760, 157, 0, NULL, 88, '', 131, '0563', 8912, 1, 0, NULL),
	(2761, 157, 0, NULL, 88, '', 132, '0563', 10575, 1, 0, NULL),
	(2762, 157, 0, NULL, 88, '', 133, '0564', 7820, 1, 0, NULL),
	(2763, 157, 0, NULL, 88, '', 134, '0564', 3100, 1, 0, NULL),
	(2764, 157, 0, NULL, 88, '', 135, '0564', 11855, 1, 0, NULL),
	(2765, 157, 0, NULL, 88, '', 136, '0564', 10551, 1, 0, NULL),
	(2766, 157, 0, NULL, 88, '', 137, '0564', 9150, 1, 0, NULL),
	(2767, 157, 0, NULL, 88, '', 138, '0564', 7145, 1, 0, NULL),
	(2768, 157, 0, NULL, 88, '', 139, '0564', 9889, 1, 0, NULL),
	(2769, 157, 0, NULL, 88, '', 140, '0564', 2318, 1, 0, NULL),
	(2770, 157, 0, NULL, 88, '', 141, '0564', 6513, 1, 0, NULL),
	(2771, 157, 0, NULL, 88, '', 142, '0564', 5562, 1, 0, NULL),
	(2772, 157, 0, NULL, 88, '', 143, '0564', 3860, 1, 0, NULL),
	(2773, 157, 0, NULL, 88, '', 144, '0564', 4640, 1, 0, NULL),
	(2774, 157, 0, NULL, 88, '', 145, '0564', 3506, 1, 0, NULL),
	(2775, 157, 0, NULL, 88, '', 146, '0564', 4628, 1, 0, NULL),
	(2776, 157, 0, NULL, 88, '', 147, '0564', 11949, 1, 0, NULL),
	(2777, 157, 0, NULL, 88, '', 148, '0564', 5820, 1, 0, NULL),
	(2778, 157, 0, NULL, 88, '', 149, '0564', 906, 1, 0, NULL),
	(2779, 157, 0, NULL, 88, '', 150, '0564', 2743, 1, 0, NULL),
	(2780, 157, 0, NULL, 88, '', 151, '0564', 2473, 1, 0, NULL),
	(2781, 157, 0, NULL, 88, '', 152, '0564', 4521, 1, 0, NULL),
	(2782, 157, 0, NULL, 88, '', 153, '0564', 7917, 1, 0, NULL),
	(2783, 157, 0, NULL, 88, '', 154, '0564', 8782, 1, 0, NULL),
	(2784, 157, 0, NULL, 88, '', 155, '0564', 4651, 1, 0, NULL),
	(2785, 163, 0, NULL, 90, '', 75, '0361', NULL, 1, 0, NULL),
	(2786, 163, 0, NULL, 90, '', 76, '0361', NULL, 1, 0, NULL),
	(2787, 163, 0, NULL, 90, '', 77, '0361', NULL, 1, 0, NULL),
	(2788, 163, 0, NULL, 90, '', 78, '0361', NULL, 1, 0, NULL),
	(2789, 163, 0, NULL, 90, '', 79, '0361', NULL, 1, 0, NULL),
	(2790, 163, 0, NULL, 90, '', 80, '0361', NULL, 1, 0, NULL),
	(2791, 163, 0, NULL, 90, '', 81, '0361', NULL, 1, 0, NULL),
	(2792, 163, 0, NULL, 90, '', 82, '0361', NULL, 1, 0, NULL),
	(2793, 163, 0, NULL, 90, '', 83, '0361', NULL, 1, 0, NULL),
	(2794, 163, 0, NULL, 91, '', 84, '0361', NULL, 1, 0, NULL),
	(2795, 163, 0, NULL, 91, '', 85, '0361', NULL, 1, 0, NULL),
	(2796, 163, 0, NULL, 91, '', 86, '0361', NULL, 1, 0, NULL),
	(2797, 163, 0, NULL, 91, '', 87, '0361', NULL, 1, 0, NULL),
	(2798, 163, 0, NULL, 91, '', 88, '0361', NULL, 1, 0, NULL),
	(2799, 163, 0, NULL, 91, '', 89, '0361', NULL, 1, 0, NULL),
	(2800, 163, 0, NULL, 91, '', 90, '0362', NULL, 1, 0, NULL),
	(2801, 163, 0, NULL, 91, '', 91, '0362', NULL, 1, 0, NULL),
	(2802, 163, 0, NULL, 91, '', 92, '0362', NULL, 1, 0, NULL),
	(2803, 163, 0, NULL, 91, '', 93, '0362', NULL, 1, 0, NULL),
	(2804, 163, 0, NULL, 91, '', 94, '0362', NULL, 1, 0, NULL),
	(2805, 163, 0, NULL, 91, '', 95, '0362', NULL, 1, 0, NULL),
	(2806, 163, 0, NULL, 91, '', 96, '0362', NULL, 1, 0, NULL),
	(2807, 163, 0, NULL, 91, '', 97, '0362', NULL, 1, 0, NULL),
	(2808, 163, 0, NULL, 91, '', 98, '0362', NULL, 1, 0, NULL),
	(2809, 163, 0, NULL, 91, '', 99, '0362', NULL, 1, 0, NULL),
	(2840, 164, 0, NULL, NULL, '', 113, '0544', 0, 15, 1, NULL),
	(2841, 164, 0, NULL, NULL, '', 114, '0544', 0, 15, 1, NULL),
	(2842, 164, 0, NULL, NULL, '', 115, '0544', 0, 15, 1, NULL),
	(2843, 164, 0, NULL, NULL, '', 116, '0544', 0, 15, 1, NULL),
	(2844, 164, 0, NULL, NULL, '', 117, '0544', 0, 15, 1, NULL),
	(2845, 164, 0, NULL, NULL, '', 118, '0544', 0, 15, 1, NULL),
	(2846, 164, 0, NULL, NULL, '', 119, '0544', 0, 15, 1, NULL),
	(2847, 164, 0, NULL, NULL, '', 120, '0544', 0, 15, 1, NULL),
	(2848, 164, 0, NULL, NULL, '', 121, '0544', 0, 15, 1, NULL),
	(2849, 164, 0, NULL, NULL, '', 122, '0544', 0, 15, 1, NULL),
	(2850, 164, 0, NULL, NULL, '', 123, '0544', 0, 15, 1, NULL),
	(2851, 164, 0, NULL, NULL, '', 124, '0544', 0, 15, 1, NULL),
	(2852, 164, 0, NULL, NULL, '', 125, '0544', 0, 15, 1, NULL),
	(2853, 164, 0, NULL, NULL, '', 126, '0544', 0, 15, 1, NULL),
	(2854, 164, 0, NULL, NULL, '', 127, '0544', 0, 15, 1, NULL),
	(2855, 164, 0, NULL, NULL, '', 128, '0544', 0, 15, 1, NULL),
	(2856, 164, 0, NULL, NULL, '', 129, '0544', 0, 15, 1, NULL),
	(2857, 164, 0, NULL, NULL, '', 130, '0544', 0, 15, 1, NULL),
	(2858, 164, 0, NULL, NULL, '', 131, '0544', 0, 15, 1, NULL),
	(2859, 164, 0, NULL, NULL, '', 132, '0544', 0, 15, 1, NULL),
	(2860, 164, 0, NULL, NULL, '', 133, '0544', 0, 15, 1, NULL),
	(2861, 164, 0, NULL, NULL, '', 134, '0544', 0, 15, 1, NULL),
	(2862, 164, 0, NULL, NULL, '', 135, '0544', 0, 15, 1, NULL),
	(2863, 164, 0, NULL, NULL, '', 136, '0544', 0, 15, 1, NULL),
	(2864, 164, 0, NULL, NULL, '', 137, '0545', 0, 15, 1, NULL),
	(2865, 164, 0, NULL, NULL, '', 138, '0545', 0, 15, 1, NULL),
	(2866, 164, 0, NULL, NULL, '', 139, '0545', 0, 15, 1, NULL),
	(2867, 164, 0, NULL, NULL, '', 140, '0545', 0, 15, 1, NULL),
	(2868, 164, 0, NULL, NULL, '', 141, '0545', 0, 15, 1, NULL),
	(2869, 164, 0, NULL, NULL, '', 142, '0545', 0, 15, 1, NULL),
	(2870, 164, 0, NULL, NULL, '', 143, '0545', 0, 15, 1, NULL),
	(2871, 164, 0, NULL, NULL, '', 144, '0545', 0, 15, 1, NULL),
	(2872, 164, 0, NULL, NULL, '', 145, '0545', 0, 15, 1, NULL),
	(2873, 164, 0, NULL, NULL, '', 146, '0545', 0, 15, 1, NULL),
	(2874, 164, 0, NULL, NULL, '', 147, '0545', 0, 15, 1, NULL),
	(2875, 164, 0, NULL, NULL, '', 148, '0545', 0, 15, 1, NULL),
	(2876, 164, 0, NULL, NULL, '', 149, '0545', 0, 15, 1, NULL),
	(2877, 164, 0, NULL, NULL, '', 150, '0545', 0, 15, 1, NULL),
	(2878, 164, 0, NULL, NULL, '', 151, '0545', 0, 15, 1, NULL),
	(2879, 164, 0, NULL, NULL, '', 152, '0545', 0, 15, 1, NULL),
	(2880, 164, 0, NULL, NULL, '', 153, '0545', 0, 15, 1, NULL),
	(2881, 164, 0, NULL, NULL, '', 154, '0545', 0, 15, 1, NULL),
	(2882, 164, 0, NULL, NULL, '', 155, '0545', 0, 15, 1, NULL),
	(2883, 165, 0, NULL, 95, '', 1, '0545', 0, 15, 0, NULL),
	(2884, 165, 0, NULL, 95, '', 2, '0545', 0, 15, 0, NULL),
	(2885, 165, 0, NULL, 95, '', 3, '0545', 0, 15, 0, NULL),
	(2886, 165, 0, NULL, 95, '', 4, '0545', 0, 15, 0, NULL),
	(2887, 165, 0, NULL, 95, '', 5, '0545', 0, 15, 0, NULL),
	(2888, 165, 0, NULL, 95, '', 6, '0545', 0, 15, 0, NULL),
	(2889, 165, 0, NULL, 95, '', 7, '0546', 0, 15, 0, NULL),
	(2890, 165, 0, NULL, 95, '', 8, '0546', 0, 15, 0, NULL),
	(2891, 165, 0, NULL, 95, '', 9, '0546', 0, 15, 0, NULL),
	(2892, 165, 0, NULL, 95, '', 10, '0546', 0, 15, 0, NULL),
	(2893, 165, 0, NULL, 95, '', 11, '0546', 0, 15, 0, NULL),
	(2894, 165, 0, NULL, 95, '', 12, '0546', 0, 15, 0, NULL),
	(2895, 165, 0, NULL, 95, '', 13, '0546', 0, 15, 0, NULL),
	(2896, 165, 0, NULL, 95, '', 14, '0546', 0, 15, 0, NULL),
	(2897, 165, 0, NULL, 95, '', 15, '0546', 0, 15, 0, NULL),
	(2898, 165, 0, NULL, 95, '', 16, '0546', 0, 15, 0, NULL),
	(2899, 165, 0, NULL, 95, '', 17, '0546', 0, 15, 0, NULL),
	(2900, 165, 0, NULL, 95, '', 18, '0546', 0, 15, 0, NULL),
	(2901, 165, 0, NULL, 95, '', 19, '0546', 0, 15, 0, NULL),
	(2902, 165, 0, NULL, 95, '', 20, '0546', 0, 15, 0, NULL),
	(2903, 165, 0, NULL, 95, '', 21, '0546', 0, 15, 0, NULL),
	(2904, 165, 0, NULL, 95, '', 22, '0546', 0, 15, 0, NULL),
	(2905, 165, 0, NULL, 95, '', 23, '0546', 0, 15, 0, NULL),
	(2906, 165, 0, NULL, 95, '', 24, '0546', 0, 15, 0, NULL),
	(2907, 165, 0, NULL, 95, '', 25, '0546', 0, 15, 0, NULL),
	(2908, 165, 0, NULL, 95, '', 26, '0546', 0, 15, 0, NULL),
	(2909, 165, 0, NULL, 95, '', 27, '0546', 0, 15, 0, NULL),
	(2910, 165, 0, NULL, 95, '', 28, '0546', 0, 10, 0, NULL),
	(2911, 165, 0, NULL, NULL, '', 29, '0546', 0, 15, 0, NULL),
	(2912, 165, 0, NULL, NULL, '', 30, '0546', 0, 15, 0, NULL),
	(2913, 161, 0, NULL, 71, '', 25, '0540', NULL, 9, 0, NULL),
	(2914, 167, 0, NULL, 88, '', 156, '0565', 10053, 1, 0, NULL),
	(2915, 167, 0, NULL, 88, '', 157, '0565', 5163, 1, 0, NULL),
	(2916, 167, 0, NULL, 88, '', 158, '0565', 1411, 1, 0, NULL),
	(2917, 167, 0, NULL, 88, '', 159, '0565', 7788, 1, 0, NULL),
	(2918, 167, 0, NULL, 88, '', 160, '0565', 5303, 1, 0, NULL),
	(2919, 167, 0, NULL, 88, '', 161, '0565', 4207, 1, 0, NULL),
	(2920, 167, 0, NULL, 88, '', 162, '0565', 3922, 1, 0, NULL),
	(2921, 167, 0, NULL, 88, '', 163, '0565', 2045, 1, 0, NULL),
	(2922, 167, 0, NULL, 88, '', 164, '0565', 7108, 1, 0, NULL),
	(2923, 167, 0, NULL, 88, '', 165, '0565', 8398, 1, 0, NULL),
	(2924, 167, 0, NULL, 92, '', 166, '0565', 471, 1, 0, NULL),
	(2925, 167, 0, NULL, 92, '', 167, '0565', 3188, 1, 0, NULL),
	(2926, 167, 0, NULL, 92, '', 168, '0565', 6040, 1, 0, NULL),
	(2927, 167, 0, NULL, 92, '', 169, '0565', 6085, 1, 0, NULL),
	(2928, 167, 0, NULL, 92, '', 170, '0565', 5211, 1, 0, NULL),
	(2929, 167, 0, NULL, 92, '', 171, '0565', 4460, 1, 0, NULL),
	(2930, 167, 0, NULL, 92, '', 172, '0565', 6582, 1, 0, NULL),
	(2931, 167, 0, NULL, 92, '', 173, '0565', 2197, 1, 0, NULL),
	(2932, 167, 0, NULL, 92, '', 174, '0565', 2246, 1, 0, NULL),
	(2933, 167, 0, NULL, 92, '', 175, '0565', 7112, 1, 0, NULL),
	(2934, 167, 0, NULL, 92, '', 176, '0565', 5926, 1, 0, NULL),
	(2935, 167, 0, NULL, 92, '', 177, '0565', 9148, 1, 0, NULL),
	(2936, 167, 0, NULL, 92, '', 178, '0565', 8023, 1, 0, NULL),
	(2937, 167, 0, NULL, 92, '', 179, '0565', 4166, 1, 0, NULL),
	(2938, 167, 0, NULL, 92, '', 180, '0566', 7238, 1, 0, NULL),
	(2939, 167, 0, NULL, 92, '', 181, '0566', 3104, 1, 0, NULL),
	(2940, 167, 0, NULL, 92, '', 182, '0566', 7268, 1, 0, NULL),
	(2941, 167, 0, NULL, 92, '', 183, '0566', 1817, 1, 0, NULL),
	(2942, 167, 0, NULL, 92, '', 184, '0566', 10673, 1, 0, NULL),
	(2943, 167, 0, NULL, 92, '', 185, '0566', 9967, 1, 0, NULL),
	(2944, 167, 0, NULL, 92, '', 186, '0566', 0, 1, 0, NULL),
	(2945, 167, 0, NULL, 92, '', 187, '0566', 5291, 1, 0, NULL),
	(2946, 167, 0, NULL, 92, '', 188, '0566', 12303, 1, 0, NULL),
	(2947, 167, 0, NULL, 92, '', 189, '0566', 5802, 1, 0, NULL),
	(2948, 167, 0, NULL, 92, '', 190, '0566', 9277, 1, 0, NULL),
	(2949, 167, 0, NULL, 92, '', 191, '0566', 311, 1, 0, NULL),
	(2950, 167, 0, NULL, 92, '', 192, '0566', 1022, 1, 0, NULL),
	(2951, 167, 0, NULL, 92, '', 193, '0566', 2947, 1, 0, NULL),
	(2952, 167, 0, NULL, 92, '', 194, '0566', 4040, 1, 0, NULL),
	(2953, 167, 0, NULL, 92, '', 195, '0566', 2288, 1, 0, NULL),
	(2954, 167, 0, NULL, 92, '', 196, '0566', 11570, 1, 0, NULL),
	(2955, 167, 0, NULL, 92, '', 197, '0566', 9936, 1, 0, NULL),
	(2956, 167, 0, NULL, 92, '', 198, '0566', 6065, 1, 0, NULL),
	(2957, 167, 0, NULL, 92, '', 199, '0566', 11779, 1, 0, NULL),
	(2958, 167, 0, NULL, 92, '', 200, '0566', 5892, 1, 0, NULL),
	(2959, 167, 0, NULL, 92, '', 201, '0566', 10918, 1, 0, NULL),
	(2960, 167, 0, NULL, 92, '', 202, '0566', 13678, 1, 0, NULL),
	(2961, 167, 0, NULL, 92, '', 203, '0567', 6516, 1, 0, NULL),
	(2962, 167, 0, NULL, 92, '', 204, '0567', 13414, 1, 0, NULL),
	(2963, 167, 0, NULL, 92, '', 205, '0567', 1170, 1, 0, NULL),
	(2964, 167, 0, NULL, 89, '', 206, '0567', 5327, 1, 0, NULL),
	(2965, 167, 0, NULL, 89, '', 207, '0567', 13756, 1, 0, NULL),
	(2966, 167, 0, NULL, 89, '', 208, '0567', 3795, 1, 0, NULL),
	(2967, 167, 0, NULL, 89, '', 209, '0567', 5514, 1, 0, NULL),
	(2968, 167, 0, NULL, 89, '', 210, '0567', 13768, 1, 0, NULL),
	(2969, 167, 0, NULL, 89, '', 211, '0567', 9268, 1, 0, NULL),
	(2970, 167, 0, NULL, 89, '', 212, '0567', 12636, 1, 0, NULL),
	(2971, 167, 0, NULL, 89, '', 213, '0567', 4606, 1, 0, NULL),
	(2972, 167, 0, NULL, 89, '', 214, '0567', 12948, 1, 0, NULL),
	(2973, 167, 0, NULL, 89, '', 215, '0567', 5550, 1, 0, NULL),
	(2974, 167, 0, NULL, 89, '', 216, '0567', 4327, 1, 0, NULL),
	(2975, 167, 0, NULL, 89, '', 217, '0567', 2614, 1, 0, NULL),
	(2976, 167, 0, NULL, 89, '', 218, '0567', 6338, 1, 0, NULL),
	(2977, 167, 0, NULL, 89, '', 219, '0567', 2273, 1, 0, NULL),
	(2978, 167, 0, NULL, 89, '', 220, '0567', 4859, 1, 0, NULL),
	(2979, 167, 0, NULL, 89, '', 221, '0567', 11668, 1, 0, NULL),
	(2980, 167, 0, NULL, 89, '', 222, '0567', 12260, 1, 0, NULL),
	(2981, 167, 0, NULL, 89, '', 223, '0567', 3812, 1, 0, NULL),
	(2982, 167, 0, NULL, 89, '', 224, '0567', 1848, 1, 0, NULL),
	(2983, 167, 0, NULL, 89, '', 225, '0567', 6729, 1, 0, NULL),
	(2984, 168, 0, NULL, NULL, '', 31, '0547', 0, 15, 0, NULL),
	(2985, 168, 0, NULL, NULL, '', 32, '0547', 0, 15, 0, NULL),
	(2986, 168, 0, NULL, NULL, '', 33, '0547', 0, 15, 0, NULL),
	(2987, 168, 0, NULL, NULL, '', 34, '0547', 0, 15, 0, NULL),
	(2988, 168, 0, NULL, NULL, '', 35, '0547', 0, 15, 0, NULL),
	(2989, 168, 0, NULL, NULL, '', 36, '0547', 0, 15, 0, NULL),
	(2990, 168, 0, NULL, NULL, '', 37, '0547', 0, 15, 0, NULL),
	(2991, 168, 0, NULL, NULL, '', 38, '0547', 0, 15, 0, NULL),
	(2992, 168, 0, NULL, NULL, '', 39, '0547', 0, 15, 0, NULL),
	(2993, 168, 0, NULL, NULL, '', 40, '0547', 0, 15, 0, NULL),
	(2994, 168, 0, NULL, NULL, '', 41, '0547', 0, 15, 0, NULL),
	(2995, 168, 0, NULL, NULL, '', 42, '0547', 0, 15, 0, NULL),
	(2996, 168, 0, NULL, NULL, '', 43, '0547', 0, 15, 0, NULL),
	(2997, 168, 0, NULL, NULL, '', 44, '0547', 0, 15, 0, NULL),
	(2998, 168, 0, NULL, NULL, '', 45, '0547', 0, 15, 0, NULL),
	(2999, 168, 0, NULL, NULL, '', 46, '0547', 0, 15, 0, NULL),
	(3000, 168, 0, NULL, NULL, '', 47, '0547', 0, 15, 0, NULL),
	(3001, 168, 0, NULL, NULL, '', 48, '0547', 0, 15, 0, NULL),
	(3002, 168, 0, NULL, NULL, '', 49, '0547', 0, 15, 0, NULL),
	(3003, 168, 0, NULL, NULL, '', 50, '0547', 0, 15, 0, NULL),
	(3004, 168, 0, NULL, NULL, '', 51, '0547', 0, 15, 0, NULL),
	(3005, 168, 0, NULL, NULL, '', 52, '0547', 0, 15, 0, NULL),
	(3006, 168, 0, NULL, NULL, '', 53, '0547', 0, 15, 0, NULL),
	(3007, 168, 0, NULL, NULL, '', 54, '0547', 0, 15, 0, NULL),
	(3008, 168, 0, NULL, NULL, '', 55, '0547', 0, 15, 0, NULL),
	(3009, 168, 0, NULL, NULL, '', 56, '0548', 0, 15, 0, NULL),
	(3010, 168, 0, NULL, NULL, '', 57, '0548', 0, 15, 0, NULL),
	(3011, 168, 0, NULL, NULL, '', 58, '0548', 0, 15, 0, NULL),
	(3012, 168, 0, NULL, NULL, '', 59, '0548', 0, 15, 0, NULL),
	(3013, 168, 0, NULL, NULL, '', 60, '0548', 0, 15, 0, NULL),
	(3014, 168, 0, NULL, NULL, '', 61, '0548', 0, 15, 0, NULL),
	(3015, 168, 0, NULL, NULL, '', 62, '0548', 0, 15, 0, NULL),
	(3016, 168, 0, NULL, NULL, '', 63, '0548', 0, 15, 0, NULL),
	(3017, 168, 0, NULL, NULL, '', 64, '0548', 0, 15, 0, NULL),
	(3018, 168, 0, NULL, NULL, '', 65, '0548', 0, 15, 0, NULL),
	(3019, 168, 0, NULL, NULL, '', 66, '0548', 0, 15, 0, NULL),
	(3020, 168, 0, NULL, NULL, '', 67, '0548', 0, 15, 0, NULL),
	(3021, 168, 0, NULL, NULL, '', 68, '0548', 0, 15, 0, NULL),
	(3022, 168, 0, NULL, NULL, '', 69, '0548', 0, 15, 0, NULL),
	(3023, 168, 0, NULL, NULL, '', 70, '0548', 0, 15, 0, NULL),
	(3024, 168, 0, NULL, NULL, '', 71, '0548', 0, 15, 0, NULL),
	(3025, 168, 0, NULL, NULL, '', 72, '0548', 0, 15, 0, NULL),
	(3026, 168, 0, NULL, NULL, '', 73, '0548', 0, 15, 0, NULL),
	(3027, 168, 0, NULL, NULL, '', 74, '0548', 0, 15, 0, NULL),
	(3028, 168, 0, NULL, NULL, '', 75, '0548', 0, 15, 0, NULL),
	(3029, 168, 0, NULL, NULL, '', 76, '0548', 0, 15, 0, NULL),
	(3030, 168, 0, NULL, NULL, '', 77, '0548', 0, 15, 0, NULL),
	(3031, 168, 0, NULL, NULL, '', 78, '0548', 0, 15, 0, NULL),
	(3032, 168, 0, NULL, NULL, '', 79, '0548', 0, 15, 0, NULL),
	(3033, 168, 0, NULL, NULL, '', 80, '0548', 0, 15, 0, NULL),
	(3034, 168, 0, NULL, NULL, '', 81, '0549', 0, 15, 0, NULL),
	(3035, 168, 0, NULL, NULL, '', 82, '0549', 0, 15, 0, NULL),
	(3036, 168, 0, NULL, NULL, '', 83, '0549', 0, 15, 0, NULL),
	(3037, 168, 0, NULL, NULL, '', 84, '0549', 0, 15, 0, NULL),
	(3038, 168, 0, NULL, NULL, '', 85, '0549', 0, 15, 0, NULL),
	(3039, 168, 0, NULL, NULL, '', 86, '0549', 0, 15, 0, NULL),
	(3040, 168, 0, NULL, NULL, '', 87, '0549', 0, 15, 0, NULL),
	(3041, 168, 0, NULL, NULL, '', 88, '0549', 0, 15, 0, NULL),
	(3042, 168, 0, NULL, NULL, '', 89, '0549', 0, 15, 0, NULL),
	(3043, 168, 0, NULL, NULL, '', 90, '0549', 0, 15, 0, NULL),
	(3044, 168, 0, NULL, NULL, '', 91, '0549', 0, 15, 0, NULL),
	(3045, 168, 0, NULL, NULL, '', 92, '0549', 0, 15, 0, NULL),
	(3046, 168, 0, NULL, NULL, '', 93, '0549', 0, 15, 0, NULL),
	(3047, 168, 0, NULL, NULL, '', 94, '0549', 0, 15, 0, NULL),
	(3048, 168, 0, NULL, NULL, '', 95, '0549', 0, 15, 0, NULL),
	(3049, 168, 0, NULL, NULL, '', 96, '0549', 0, 15, 0, NULL),
	(3119, 169, 0, NULL, 89, '', 226, '0568', 9934, 1, 0, NULL),
	(3120, 169, 0, NULL, 89, '', 227, '0568', 520, 1, 0, NULL),
	(3121, 169, 0, NULL, 89, '', 228, '0568', 1317, 1, 0, NULL),
	(3122, 169, 0, NULL, 89, '', 229, '0568', 13695, 1, 0, NULL),
	(3123, 169, 0, NULL, 89, '', 230, '0568', 13720, 1, 0, NULL),
	(3124, 169, 0, NULL, 89, '', 231, '0568', 9432, 1, 0, NULL),
	(3125, 169, 0, NULL, 89, '', 232, '0568', 10826, 1, 0, NULL),
	(3126, 169, 0, NULL, 89, '', 233, '0568', 6388, 1, 0, NULL),
	(3127, 169, 0, NULL, 89, '', 234, '0568', 3429, 1, 0, NULL),
	(3128, 169, 0, NULL, 89, '', 235, '0568', 8027, 1, 0, NULL),
	(3129, 169, 0, NULL, 89, '', 236, '0568', 11092, 1, 0, NULL),
	(3130, 169, 0, NULL, 89, '', 237, '0568', 285, 1, 0, NULL),
	(3131, 169, 0, NULL, 89, '', 238, '0568', 13458, 1, 0, NULL),
	(3132, 169, 0, NULL, 89, '', 239, '0568', 2236, 1, 0, NULL),
	(3133, 169, 0, NULL, 89, '', 240, '0568', 13779, 1, 0, NULL),
	(3134, 169, 0, NULL, 89, '', 241, '0568', 5918, 1, 0, NULL),
	(3135, 169, 0, NULL, 89, '', 242, '0568', 11780, 1, 0, NULL),
	(3136, 169, 0, NULL, 89, '', 243, '0568', 12850, 1, 0, NULL),
	(3137, 169, 0, NULL, 89, '', 244, '0568', 469, 1, 0, NULL),
	(3138, 169, 0, NULL, 89, '', 245, '0568', 10034, 1, 0, NULL),
	(3139, 169, 0, NULL, 96, '', 246, '0568', 12813, 1, 0, NULL),
	(3140, 169, 0, NULL, 96, '', 247, '0568', 5263, 1, 0, NULL),
	(3141, 169, 0, NULL, 96, '', 248, '0568', 11760, 1, 0, NULL),
	(3142, 169, 0, NULL, 96, '', 249, '0569', 4020, 1, 0, NULL),
	(3143, 169, 0, NULL, 96, '', 250, '0569', 10219, 1, 0, NULL),
	(3144, 169, 0, NULL, 96, '', 251, '0569', 9399, 1, 0, NULL),
	(3145, 169, 0, NULL, 96, '', 252, '0569', 6577, 1, 0, NULL),
	(3146, 169, 0, NULL, 96, '', 253, '0569', 5131, 1, 0, NULL),
	(3147, 169, 0, NULL, 96, '', 254, '0569', 11293, 1, 0, NULL),
	(3148, 169, 0, NULL, 96, '', 255, '0569', 5691, 1, 0, NULL),
	(3149, 169, 0, NULL, 96, '', 256, '0569', 4857, 1, 0, NULL),
	(3150, 169, 0, NULL, 96, '', 257, '0569', 10546, 1, 0, NULL),
	(3151, 169, 0, NULL, 96, '', 258, '0569', 960, 1, 0, NULL),
	(3152, 169, 0, NULL, 96, '', 259, '0569', 6039, 1, 0, NULL),
	(3153, 169, 0, NULL, 96, '', 260, '0569', 1141, 1, 0, NULL),
	(3154, 169, 0, NULL, 96, '', 261, '0569', 1291, 1, 0, NULL),
	(3155, 169, 0, NULL, 96, '', 262, '0569', 1059, 1, 0, NULL),
	(3156, 169, 0, NULL, 96, '', 263, '0569', 1665, 1, 0, NULL),
	(3157, 169, 0, NULL, 96, '', 264, '0569', 10656, 1, 0, NULL),
	(3158, 169, 0, NULL, 96, '', 265, '0569', 13749, 1, 0, NULL),
	(3159, 169, 0, NULL, 96, '', 266, '0569', 13323, 1, 0, NULL),
	(3160, 169, 0, NULL, 96, '', 267, '0569', 9007, 1, 0, NULL),
	(3161, 169, 0, NULL, 96, '', 268, '0569', 10010, 1, 0, NULL),
	(3162, 169, 0, NULL, 96, '', 269, '0569', 0, 1, 0, NULL),
	(3163, 169, 0, NULL, 96, '', 270, '0569', 13668, 1, 0, NULL),
	(3164, 169, 0, NULL, 96, '', 271, '0569', 1375, 1, 0, NULL),
	(3165, 169, 0, NULL, 96, '', 272, '0570', 1433, 1, 0, NULL),
	(3166, 169, 0, NULL, 96, '', 273, '0570', 7730, 1, 0, NULL),
	(3167, 169, 0, NULL, 96, '', 274, '0570', 13108, 1, 0, NULL),
	(3168, 169, 0, NULL, 96, '', 275, '0570', 6025, 1, 0, NULL),
	(3169, 169, 0, NULL, 96, '', 276, '0570', 2786, 1, 0, NULL),
	(3170, 169, 0, NULL, 96, '', 277, '0570', 3328, 1, 0, NULL),
	(3171, 169, 0, NULL, 96, '', 278, '0570', 13033, 1, 0, NULL),
	(3172, 169, 0, NULL, 96, '', 279, '0570', 10256, 1, 0, NULL),
	(3173, 169, 0, NULL, 96, '', 280, '0570', 9641, 1, 0, NULL),
	(3174, 169, 0, NULL, 96, '', 281, '0570', 10059, 1, 0, NULL),
	(3175, 169, 0, NULL, 96, '', 282, '0570', 382, 1, 0, NULL),
	(3176, 169, 0, NULL, 96, '', 283, '0570', 13359, 1, 0, NULL),
	(3177, 169, 0, NULL, 96, '', 284, '0570', 12733, 1, 0, NULL),
	(3178, 169, 0, NULL, 96, '', 285, '0570', 12624, 1, 0, NULL),
	(3179, 169, 0, NULL, 116, '', 286, '0570', 9459, 1, 0, NULL),
	(3180, 169, 0, NULL, 116, '', 287, '0570', 1631, 1, 0, NULL),
	(3181, 169, 0, NULL, 116, '', 288, '0570', 7360, 1, 0, NULL),
	(3182, 169, 0, NULL, 116, '', 289, '0570', 7689, 1, 0, NULL),
	(3183, 169, 0, NULL, 116, '', 290, '0570', 12073, 1, 0, NULL),
	(3184, 169, 0, NULL, 116, '', 291, '0570', 9602, 1, 0, NULL),
	(3185, 169, 0, NULL, 116, '', 292, '0570', 9777, 1, 0, NULL),
	(3186, 169, 0, NULL, 116, '', 293, '0570', 638, 1, 0, NULL),
	(3187, 169, 0, NULL, 116, '', 294, '0570', 12629, 1, 0, NULL),
	(3188, 169, 0, NULL, 116, '', 295, '0570', 13772, 1, 0, NULL),
	(3189, 170, 0, NULL, 111, '', 1, '0550', 10659, 1, 0, NULL),
	(3190, 170, 0, NULL, 111, '', 2, '0550', 6196, 1, 0, NULL),
	(3191, 170, 0, NULL, 111, '', 3, '0550', 4023, 1, 0, NULL),
	(3192, 170, 0, NULL, 111, '', 4, '0550', 12475, 1, 0, NULL),
	(3193, 170, 0, NULL, 111, '', 5, '0550', 10005, 1, 0, NULL),
	(3194, 170, 0, NULL, 111, '', 6, '0550', 7990, 1, 0, NULL),
	(3195, 170, 0, NULL, 111, '', 7, '0550', 9643, 1, 0, NULL),
	(3196, 170, 0, NULL, 111, '', 8, '0550', 11996, 1, 0, NULL),
	(3197, 170, 0, NULL, 111, '', 9, '0550', 9950, 1, 0, NULL),
	(3198, 170, 0, NULL, 111, '', 10, '0550', 6117, 1, 0, NULL),
	(3199, 170, 0, NULL, 111, '', 11, '0550', 10411, 1, 0, NULL),
	(3200, 170, 0, NULL, 111, '', 12, '0550', 4329, 1, 0, NULL),
	(3201, 170, 0, NULL, 111, '', 13, '0550', 8537, 1, 0, NULL),
	(3202, 170, 0, NULL, 111, '', 14, '0550', 3799, 1, 0, NULL),
	(3203, 170, 0, NULL, 112, '', 15, '0550', 12771, 1, 0, NULL),
	(3204, 170, 0, NULL, 112, '', 16, '0550', 4861, 1, 0, NULL),
	(3205, 170, 0, NULL, 112, '', 17, '0550', 10290, 1, 0, NULL),
	(3206, 170, 0, NULL, 112, '', 18, '0550', 2595, 1, 0, NULL),
	(3207, 170, 0, NULL, 112, '', 19, '0550', 10667, 1, 0, NULL),
	(3208, 170, 0, NULL, 112, '', 20, '0551', 5709, 1, 0, NULL),
	(3209, 170, 0, NULL, 112, '', 21, '0551', 2498, 1, 0, NULL),
	(3210, 170, 0, NULL, 112, '', 22, '0551', 7794, 1, 0, NULL),
	(3211, 170, 0, NULL, 112, '', 23, '0551', 6289, 1, 0, NULL),
	(3212, 170, 0, NULL, 112, '', 24, '0551', 2313, 1, 0, NULL),
	(3213, 170, 0, NULL, 112, '', 25, '0551', 7218, 1, 0, NULL),
	(3214, 170, 0, NULL, 112, '', 26, '0551', 7493, 1, 0, NULL),
	(3215, 170, 0, NULL, 112, '', 27, '0551', 2937, 1, 0, NULL),
	(3216, 170, 0, NULL, 112, '', 28, '0551', 8852, 1, 0, NULL),
	(3217, 170, 0, NULL, 112, '', 29, '0551', 6529, 1, 0, NULL),
	(3218, 170, 0, NULL, 112, '', 30, '0551', 5351, 1, 0, NULL),
	(3219, 170, 0, NULL, 112, '', 31, '0551', 6341, 1, 0, NULL),
	(3220, 170, 0, NULL, 112, '', 32, '0551', 10467, 1, 0, NULL),
	(3221, 170, 0, NULL, 112, '', 33, '0551', 13048, 1, 0, NULL),
	(3222, 170, 0, NULL, 112, '', 34, '0551', 9109, 1, 0, NULL),
	(3223, 170, 0, NULL, 112, '', 35, '0551', 7806, 1, 0, NULL),
	(3224, 170, 0, NULL, 112, '', 36, '0551', 6412, 1, 0, NULL),
	(3225, 170, 0, NULL, 112, '', 37, '0551', 8633, 1, 0, NULL),
	(3226, 170, 0, NULL, 112, '', 38, '0551', 13276, 1, 0, NULL),
	(3227, 170, 0, NULL, 112, '', 39, '0551', 2720, 1, 0, NULL),
	(3228, 170, 0, NULL, 112, '', 40, '0551', 3650, 1, 0, NULL),
	(3229, 170, 0, NULL, 112, '', 41, '0551', 13203, 1, 0, NULL),
	(3230, 170, 0, NULL, 112, '', 42, '0551', 8853, 1, 0, NULL),
	(3231, 170, 0, NULL, 112, '', 43, '0551', 8440, 1, 0, NULL),
	(3232, 170, 0, NULL, 112, '', 44, '0551', 11727, 1, 0, NULL),
	(3233, 170, 0, NULL, 112, '', 45, '0551', 11685, 1, 0, NULL),
	(3234, 170, 0, NULL, 112, '', 46, '0551', 8923, 1, 0, NULL),
	(3235, 170, 0, NULL, 112, '', 47, '0551', 8565, 1, 0, NULL),
	(3236, 170, 0, NULL, 112, '', 48, '0551', 10996, 1, 0, NULL),
	(3237, 170, 0, NULL, 112, '', 49, '0551', 8040, 1, 0, NULL),
	(3238, 170, 0, NULL, 112, '', 50, '0552', 5079, 1, 0, NULL),
	(3239, 170, 0, NULL, 112, '', 51, '0552', 5143, 1, 0, NULL),
	(3240, 170, 0, NULL, 112, '', 52, '0552', 2836, 1, 0, NULL),
	(3241, 170, 0, NULL, 112, '', 53, '0552', 3332, 1, 0, NULL),
	(3242, 170, 0, NULL, 112, '', 54, '0552', 2290, 1, 0, NULL),
	(3243, 170, 0, NULL, 112, '', 55, '0552', 2724, 1, 0, NULL),
	(3244, 170, 0, NULL, 112, '', 56, '0552', 8006, 1, 0, NULL),
	(3245, 170, 0, NULL, 113, '', 57, '0552', 3129, 1, 0, NULL),
	(3246, 170, 0, NULL, 113, '', 58, '0552', 3196, 1, 0, NULL),
	(3247, 170, 0, NULL, 113, '', 59, '0552', 4568, 1, 0, NULL),
	(3248, 170, 0, NULL, 113, '', 60, '0552', 5860, 1, 0, NULL),
	(3249, 170, 0, NULL, 113, '', 61, '0552', 3452, 1, 0, NULL),
	(3250, 170, 0, NULL, 113, '', 62, '0552', 4043, 1, 0, NULL),
	(3251, 170, 0, NULL, 113, '', 63, '0552', 3881, 1, 0, NULL),
	(3252, 170, 0, NULL, 113, '', 64, '0552', 4006, 1, 0, NULL),
	(3253, 170, 0, NULL, 113, '', 65, '0552', 3292, 1, 0, NULL),
	(3254, 170, 0, NULL, 113, '', 66, '0552', 5957, 1, 0, NULL),
	(3255, 170, 0, NULL, 113, '', 67, '0552', 5244, 1, 0, NULL),
	(3256, 170, 0, NULL, 113, '', 68, '0552', 7141, 1, 0, NULL),
	(3257, 170, 0, NULL, 113, '', 69, '0552', 5671, 1, 0, NULL),
	(3258, 170, 0, NULL, 113, '', 70, '0552', 2211, 1, 0, NULL),
	(3259, 170, 0, NULL, 113, '', 71, '0552', 2855, 1, 0, NULL),
	(3260, 170, 0, NULL, 113, '', 72, '0552', 2482, 1, 0, NULL),
	(3261, 170, 0, NULL, 113, '', 73, '0552', 7301, 1, 0, NULL),
	(3262, 170, 0, NULL, 113, '', 74, '0552', 5298, 1, 0, NULL),
	(3263, 170, 0, NULL, 113, '', 75, '0552', 3818, 1, 0, NULL),
	(3264, 170, 0, NULL, 113, '', 76, '0552', 5576, 1, 0, NULL),
	(3265, 170, 0, NULL, 113, '', 77, '0552', 2503, 1, 0, NULL),
	(3266, 170, 0, NULL, 113, '', 78, '0552', 4204, 1, 0, NULL),
	(3267, 170, 0, NULL, 113, '', 79, '0552', 3046, 1, 0, NULL),
	(3268, 170, 0, NULL, 113, '', 80, '0552', 7038, 1, 0, NULL),
	(3269, 170, 0, NULL, 113, '', 81, '0552', 9059, 1, 0, NULL),
	(3270, 170, 0, NULL, 113, '', 82, '0552', 5083, 1, 0, NULL),
	(3271, 170, 0, NULL, 113, '', 83, '0552', 0, 1, 0, NULL),
	(3272, 170, 0, NULL, 113, '', 84, '0552', 0, 1, 0, NULL),
	(3273, 160, 0, NULL, 60, '', 169, '0558', 3544, 1, 0, NULL),
	(3274, 160, 0, NULL, 60, '', 170, '0558', 4495, 1, 0, NULL),
	(3275, 160, 0, NULL, 60, '', 171, '0558', 3170, 1, 0, NULL),
	(3276, 171, 0, NULL, 116, '', 296, '0571', 11889, 1, 0, NULL),
	(3277, 171, 0, NULL, 116, '', 297, '0571', 13582, 1, 0, NULL),
	(3278, 171, 0, NULL, 116, '', 298, '0571', 10585, 1, 0, NULL),
	(3279, 171, 0, NULL, 116, '', 299, '0571', 11631, 1, 0, NULL),
	(3280, 171, 0, NULL, 116, '', 300, '0571', 9574, 1, 0, NULL),
	(3281, 171, 0, NULL, 116, '', 301, '0571', 12399, 1, 0, NULL),
	(3282, 171, 0, NULL, 116, '', 302, '0571', 13210, 1, 0, NULL),
	(3283, 171, 0, NULL, 116, '', 303, '0571', 9601, 1, 0, NULL),
	(3284, 171, 0, NULL, 116, '', 304, '0571', 10242, 1, 0, NULL),
	(3285, 171, 0, NULL, 116, '', 305, '0571', 1116, 1, 0, NULL),
	(3286, 171, 0, NULL, 116, '', 306, '0571', 8947, 1, 0, NULL),
	(3287, 171, 0, NULL, 116, '', 307, '0571', 13693, 1, 0, NULL),
	(3288, 171, 0, NULL, 116, '', 308, '0571', 430, 1, 0, NULL),
	(3289, 171, 0, NULL, 116, '', 309, '0571', 2170, 1, 0, NULL),
	(3290, 171, 0, NULL, 116, '', 310, '0571', 1552, 1, 0, NULL),
	(3291, 171, 0, NULL, 116, '', 311, '0571', 813, 1, 0, NULL),
	(3292, 171, 0, NULL, 116, '', 312, '0571', 0, 1, 0, NULL),
	(3293, 171, 0, NULL, 116, '', 313, '0571', 234, 1, 0, NULL),
	(3294, 171, 0, NULL, 116, '', 314, '0571', 777, 1, 0, NULL),
	(3295, 171, 0, NULL, 116, '', 315, '0571', 13371, 1, 0, NULL),
	(3296, 171, 0, NULL, 116, '', 316, '0571', 2386, 1, 0, NULL),
	(3297, 171, 0, NULL, 116, '', 317, '0571', 907, 1, 0, NULL),
	(3298, 171, 0, NULL, 116, '', 318, '0571', 858, 1, 0, NULL),
	(3299, 171, 0, NULL, 116, '', 319, '0572', 1307, 1, 0, NULL),
	(3300, 171, 0, NULL, 116, '', 320, '0572', 13745, 1, 0, NULL),
	(3301, 171, 0, NULL, 116, '', 321, '0572', 13682, 1, 0, NULL),
	(3302, 171, 0, NULL, 116, '', 322, '0572', 9627, 1, 0, NULL),
	(3303, 171, 0, NULL, 116, '', 323, '0572', 13689, 1, 0, NULL),
	(3304, 171, 0, NULL, 116, '', 324, '0572', 4088, 1, 0, NULL),
	(3305, 171, 0, NULL, 116, '', 325, '0572', 2333, 1, 0, NULL),
	(3306, 171, 0, NULL, 118, '', 326, '0572', 2760, 1, 0, NULL),
	(3307, 171, 0, NULL, 118, '', 327, '0572', 4935, 1, 0, NULL),
	(3308, 171, 0, NULL, 118, '', 328, '0572', 10871, 1, 0, NULL),
	(3309, 171, 0, NULL, 118, '', 329, '0572', 7315, 1, 0, NULL),
	(3310, 171, 0, NULL, 118, '', 330, '0572', 12895, 1, 0, NULL),
	(3311, 171, 0, NULL, 118, '', 331, '0572', 7269, 1, 0, NULL),
	(3312, 171, 0, NULL, 118, '', 332, '0572', 3440, 1, 0, NULL),
	(3313, 171, 0, NULL, 118, '', 333, '0572', 11759, 1, 0, NULL),
	(3314, 171, 0, NULL, 118, '', 334, '0572', 11971, 1, 0, NULL),
	(3315, 171, 0, NULL, 118, '', 335, '0572', 0, 1, 0, NULL),
	(3316, 171, 0, NULL, 118, '', 336, '0572', 11643, 1, 0, NULL),
	(3317, 171, 0, NULL, 118, '', 337, '0572', 4708, 1, 0, NULL),
	(3318, 171, 0, NULL, 118, '', 338, '0572', 7574, 1, 0, NULL),
	(3319, 171, 0, NULL, 118, '', 339, '0572', 8841, 1, 0, NULL),
	(3320, 171, 0, NULL, 118, '', 340, '0572', 10645, 1, 0, NULL),
	(3321, 171, 0, NULL, 118, '', 341, '0572', 9233, 1, 0, NULL),
	(3322, 171, 0, NULL, 118, '', 342, '0573', 11785, 1, 0, NULL),
	(3323, 171, 0, NULL, 118, '', 343, '0573', 12169, 1, 0, NULL),
	(3324, 171, 0, NULL, 118, '', 344, '0573', 13072, 1, 0, NULL),
	(3325, 171, 0, NULL, 118, '', 345, '0573', 12097, 1, 0, NULL),
	(3326, 171, 0, NULL, 118, '', 346, '0573', 11614, 1, 0, NULL),
	(3327, 171, 0, NULL, 118, '', 347, '0573', 9374, 1, 0, NULL),
	(3328, 171, 0, NULL, 118, '', 348, '0573', 6250, 1, 0, NULL),
	(3329, 171, 0, NULL, 118, '', 349, '0573', 9420, 1, 0, NULL),
	(3330, 171, 0, NULL, 118, '', 350, '0573', 9518, 1, 0, NULL),
	(3331, 171, 0, NULL, 118, '', 351, '0573', 13765, 1, 0, NULL),
	(3332, 171, 0, NULL, 118, '', 352, '0573', 862, 1, 0, NULL),
	(3333, 171, 0, NULL, 118, '', 353, '0573', 12591, 1, 0, NULL),
	(3334, 171, 0, NULL, 118, '', 354, '0573', 13628, 1, 0, NULL),
	(3335, 171, 0, NULL, 118, '', 355, '0573', 11328, 1, 0, NULL),
	(3336, 171, 0, NULL, 118, '', 356, '0573', 8879, 1, 0, NULL),
	(3337, 171, 0, NULL, 118, '', 357, '0573', 12722, 1, 0, NULL),
	(3338, 171, 0, NULL, 118, '', 358, '0573', 7460, 1, 0, NULL),
	(3339, 171, 0, NULL, 118, '', 359, '0573', 4183, 1, 0, NULL),
	(3340, 171, 0, NULL, 118, '', 360, '0573', 1586, 1, 0, NULL),
	(3341, 171, 0, NULL, 118, '', 361, '0573', 13680, 1, 0, NULL),
	(3342, 171, 0, NULL, 118, '', 362, '0573', 9065, 1, 0, NULL),
	(3343, 171, 0, NULL, 118, '', 363, '0573', 1389, 1, 0, NULL),
	(3344, 171, 0, NULL, 118, '', 364, '0573', 1624, 1, 0, NULL),
	(3345, 172, 0, NULL, 113, '', 85, '0553', 13242, 1, 0, NULL),
	(3346, 172, 0, NULL, 113, '', 86, '0553', 0, 1, 0, NULL),
	(3347, 172, 0, NULL, 113, '', 87, '0553', 5512, 1, 0, NULL),
	(3348, 172, 0, NULL, 113, '', 88, '0553', 904, 1, 0, NULL),
	(3349, 172, 0, NULL, 113, '', 89, '0553', 2998, 1, 0, NULL),
	(3350, 172, 0, NULL, 113, '', 90, '0553', 2761, 1, 0, NULL),
	(3351, 172, 0, NULL, 113, '', 91, '0553', 13716, 1, 0, NULL),
	(3352, 172, 0, NULL, 113, '', 92, '0553', 5147, 1, 0, NULL),
	(3353, 172, 0, NULL, 113, '', 93, '0553', 6337, 1, 0, NULL),
	(3354, 172, 0, NULL, 113, '', 94, '0553', 6471, 1, 0, NULL),
	(3355, 172, 0, NULL, 113, '', 95, '0553', 7159, 1, 0, NULL),
	(3356, 172, 0, NULL, 113, '', 96, '0553', 4827, 1, 0, NULL),
	(3357, 172, 0, NULL, 113, '', 97, '0553', 8220, 1, 0, NULL),
	(3358, 172, 0, NULL, 113, '', 98, '0553', 1411, 1, 0, NULL),
	(3359, 172, 0, NULL, NULL, '', 99, '0553', 5850, 1, 0, NULL),
	(3360, 172, 0, NULL, NULL, '', 100, '0553', 4220, 1, 0, NULL),
	(3361, 172, 0, NULL, NULL, '', 101, '0553', 11580, 1, 0, NULL),
	(3362, 172, 0, NULL, NULL, '', 102, '0553', 7459, 1, 0, NULL),
	(3363, 172, 0, NULL, NULL, '', 103, '0553', 9629, 1, 0, NULL),
	(3364, 172, 0, NULL, NULL, '', 104, '0553', 10793, 1, 0, NULL),
	(3365, 172, 0, NULL, NULL, '', 105, '0553', 3908, 1, 0, NULL),
	(3366, 172, 0, NULL, NULL, '', 106, '0553', 6849, 1, 0, NULL),
	(3367, 172, 0, NULL, NULL, '', 107, '0553', 7250, 1, 0, NULL),
	(3368, 172, 0, NULL, NULL, '', 108, '0553', 6421, 1, 0, NULL),
	(3369, 172, 0, NULL, NULL, '', 109, '0553', 4431, 1, 0, NULL),
	(3370, 172, 0, NULL, NULL, '', 110, '0553', 4420, 1, 0, NULL),
	(3371, 172, 0, NULL, NULL, '', 111, '0553', 6425, 1, 0, NULL),
	(3372, 172, 0, NULL, NULL, '', 112, '0553', 2043, 1, 0, NULL),
	(3373, 172, 0, NULL, NULL, '', 113, '0553', 2218, 1, 0, NULL),
	(3374, 172, 0, NULL, NULL, '', 114, '0553', 11891, 1, 0, NULL),
	(3375, 172, 0, NULL, NULL, '', 115, '0553', 3905, 1, 0, NULL),
	(3376, 172, 0, NULL, NULL, '', 116, '0553', 4296, 1, 0, NULL),
	(3377, 172, 0, NULL, NULL, '', 117, '0553', 12161, 1, 0, NULL),
	(3378, 172, 0, NULL, NULL, '', 118, '0553', 5341, 1, 0, NULL),
	(3379, 172, 0, NULL, NULL, '', 119, '0553', 13012, 1, 0, NULL),
	(3380, 172, 0, NULL, NULL, '', 120, '0554', 2068, 1, 0, NULL),
	(3381, 172, 0, NULL, NULL, '', 121, '0554', 5408, 1, 0, NULL),
	(3382, 172, 0, NULL, NULL, '', 122, '0554', 2563, 1, 0, NULL),
	(3383, 172, 0, NULL, NULL, '', 123, '0554', 4819, 1, 0, NULL),
	(3384, 172, 0, NULL, NULL, '', 124, '0554', 3121, 1, 0, NULL),
	(3385, 172, 0, NULL, NULL, '', 125, '0554', 2424, 1, 0, NULL),
	(3386, 172, 0, NULL, NULL, '', 126, '0554', 6948, 1, 0, NULL),
	(3387, 172, 0, NULL, NULL, '', 127, '0554', 6953, 1, 0, NULL),
	(3388, 172, 0, NULL, NULL, '', 128, '0554', 6583, 1, 0, NULL),
	(3389, 172, 0, NULL, NULL, '', 129, '0554', 5156, 1, 0, NULL),
	(3390, 172, 0, NULL, NULL, '', 130, '0554', 8079, 1, 0, NULL),
	(3391, 172, 0, NULL, NULL, '', 131, '0554', 2383, 1, 0, NULL),
	(3392, 172, 0, NULL, NULL, '', 132, '0554', 7400, 1, 0, NULL),
	(3393, 172, 0, NULL, NULL, '', 133, '0554', 3019, 1, 0, NULL),
	(3394, 172, 0, NULL, NULL, '', 134, '0554', 11968, 1, 0, NULL),
	(3395, 172, 0, NULL, NULL, '', 135, '0554', 4163, 1, 0, NULL),
	(3396, 172, 0, NULL, NULL, '', 136, '0554', 3962, 1, 0, NULL),
	(3397, 172, 0, NULL, NULL, '', 137, '0554', 3738, 1, 0, NULL),
	(3398, 172, 0, NULL, NULL, '', 138, '0554', 4587, 1, 0, NULL),
	(3399, 172, 0, NULL, NULL, '', 139, '0554', 6614, 1, 0, NULL),
	(3400, 172, 0, NULL, NULL, '', 140, '0554', 5679, 1, 0, NULL),
	(3401, 172, 0, NULL, NULL, '', 141, '0554', 2508, 1, 0, NULL),
	(3402, 172, 0, NULL, NULL, '', 142, '0554', 4124, 1, 0, NULL),
	(3403, 172, 0, NULL, NULL, '', 143, '0554', 7123, 1, 0, NULL),
	(3404, 172, 0, NULL, NULL, '', 144, '0554', 6751, 1, 0, NULL),
	(3405, 172, 0, NULL, NULL, '', 145, '0554', 2212, 1, 0, NULL),
	(3406, 172, 0, NULL, NULL, '', 146, '0554', 3734, 1, 0, NULL),
	(3407, 172, 0, NULL, NULL, '', 147, '0554', 9143, 1, 0, NULL),
	(3408, 172, 0, NULL, NULL, '', 148, '0554', 2528, 1, 0, NULL),
	(3409, 172, 0, NULL, NULL, '', 149, '0554', 5745, 1, 0, NULL),
	(3410, 172, 0, NULL, NULL, '', 150, '0554', 5297, 1, 0, NULL),
	(3411, 172, 0, NULL, NULL, '', 151, '0554', 5325, 1, 0, NULL),
	(3412, 172, 0, NULL, NULL, '', 152, '0554', 13803, 1, 0, NULL),
	(3413, 172, 0, NULL, NULL, '', 153, '0554', 3555, 1, 0, NULL),
	(3414, 172, 0, NULL, NULL, '', 154, '0554', 3809, 1, 0, NULL),
	(3415, 172, 0, NULL, NULL, '', 155, '0555', 4837, 1, 0, NULL),
	(3416, 172, 0, NULL, NULL, '', 156, '0555', 2872, 1, 0, NULL),
	(3417, 172, 0, NULL, NULL, '', 157, '0555', 9140, 1, 0, NULL),
	(3418, 172, 0, NULL, NULL, '', 158, '0555', 7021, 1, 0, NULL),
	(3419, 172, 0, NULL, NULL, '', 159, '0555', 5314, 1, 0, NULL),
	(3420, 172, 0, NULL, NULL, '', 160, '0555', 2805, 1, 0, NULL),
	(3421, 172, 0, NULL, NULL, '', 161, '0555', 4522, 1, 0, NULL),
	(3422, 172, 0, NULL, NULL, '', 162, '0555', 2116, 1, 0, NULL),
	(3423, 172, 0, NULL, NULL, '', 163, '0555', 3996, 1, 0, NULL),
	(3424, 172, 0, NULL, NULL, '', 164, '0555', 4773, 1, 0, NULL),
	(3425, 172, 0, NULL, NULL, '', 165, '0555', 4881, 1, 0, NULL),
	(3426, 172, 0, NULL, NULL, '', 166, '0555', 4136, 1, 0, NULL),
	(3427, 172, 0, NULL, NULL, '', 167, '0555', 4169, 1, 0, NULL),
	(3428, 172, 0, NULL, NULL, '', 168, '0555', 4781, 1, 0, NULL),
	(3429, 172, 0, NULL, NULL, '', 169, '0555', 4141, 1, 0, NULL),
	(3430, 172, 0, NULL, NULL, '', 170, '0555', 6826, 1, 0, NULL),
	(3431, 172, 0, NULL, NULL, '', 171, '0555', 7209, 1, 0, NULL),
	(3432, 172, 0, NULL, NULL, '', 172, '0555', 8425, 1, 0, NULL),
	(3433, 172, 0, NULL, NULL, '', 173, '0555', 3483, 1, 0, NULL),
	(3434, 172, 0, NULL, NULL, '', 174, '0555', 8799, 1, 0, NULL),
	(3435, 172, 0, NULL, NULL, '', 175, '0555', 7738, 1, 0, NULL),
	(3436, 172, 0, NULL, NULL, '', 176, '0555', 7752, 1, 0, NULL),
	(3437, 172, 0, NULL, NULL, '', 177, '0555', 7598, 1, 0, NULL),
	(3438, 172, 0, NULL, NULL, '', 178, '0555', 13523, 1, 0, NULL),
	(3439, 172, 0, NULL, NULL, '', 179, '0555', 9124, 1, 0, NULL),
	(3440, 172, 0, NULL, NULL, '', 180, '0555', 10948, 1, 0, NULL),
	(3441, 172, 0, NULL, NULL, '', 181, '0555', 9295, 1, 0, NULL),
	(3442, 172, 0, NULL, NULL, '', 182, '0555', 6910, 1, 0, NULL),
	(3443, 172, 0, NULL, NULL, '', 183, '0555', 4886, 1, 0, NULL),
	(3444, 172, 0, NULL, NULL, '', 184, '0555', 7690, 1, 0, NULL),
	(3445, 172, 0, NULL, NULL, '', 185, '0555', 1872, 1, 0, NULL),
	(3446, 173, 0, NULL, NULL, '', 1, '0555', 0, 15, 1, NULL),
	(3447, 173, 0, NULL, NULL, '', 2, '0555', 0, 15, 1, NULL),
	(3449, 162, 0, NULL, 81, '', 56, '0541', NULL, 14, 0, NULL),
	(3499, 174, 0, NULL, 93, '', 1, '0363', NULL, 1, 0, NULL),
	(3500, 174, 0, NULL, 93, '', 2, '0363', NULL, 1, 0, NULL),
	(3501, 174, 0, NULL, 93, '', 3, '0363', NULL, 1, 0, NULL),
	(3502, 174, 0, NULL, 93, '', 4, '0363', NULL, 1, 0, NULL),
	(3503, 174, 0, NULL, 93, '', 5, '0363', NULL, 1, 0, NULL),
	(3504, 174, 0, NULL, 93, '', 6, '0363', NULL, 1, 0, NULL),
	(3505, 174, 0, NULL, 93, '', 7, '0363', NULL, 1, 0, NULL),
	(3506, 174, 0, NULL, 93, '', 8, '0363', NULL, 1, 0, NULL),
	(3507, 174, 0, NULL, 93, '', 9, '0363', NULL, 1, 0, NULL),
	(3508, 174, 0, NULL, 93, '', 10, '0363', NULL, 1, 0, NULL),
	(3509, 174, 0, NULL, 93, '', 11, '0363', NULL, 1, 0, NULL),
	(3510, 174, 0, NULL, 93, '', 12, '0363', NULL, 1, 0, NULL),
	(3511, 174, 0, NULL, 93, '', 13, '0363', NULL, 1, 0, NULL),
	(3512, 174, 0, NULL, 93, '', 14, '0363', NULL, 1, 0, NULL),
	(3513, 174, 0, NULL, 93, '', 15, '0363', NULL, 1, 0, NULL),
	(3514, 174, 0, NULL, 93, '', 16, '0363', NULL, 1, 0, NULL),
	(3515, 174, 0, NULL, 94, '', 17, '0363', NULL, 1, 0, NULL),
	(3516, 174, 0, NULL, 94, '', 18, '0363', NULL, 1, 0, NULL),
	(3517, 174, 0, NULL, 94, '', 19, '0363', NULL, 1, 0, NULL),
	(3518, 174, 0, NULL, 94, '', 20, '0363', NULL, 1, 0, NULL),
	(3519, 174, 0, NULL, 94, '', 21, '0363', NULL, 1, 0, NULL),
	(3520, 174, 0, NULL, 94, '', 22, '0363', NULL, 1, 0, NULL),
	(3521, 174, 0, NULL, 94, '', 23, '0363', NULL, 1, 0, NULL),
	(3522, 174, 0, NULL, 94, '', 24, '0363', NULL, 1, 0, NULL),
	(3523, 174, 0, NULL, 94, '', 25, '0363', NULL, 1, 0, NULL),
	(3524, 174, 0, NULL, 94, '', 26, '0363', NULL, 1, 0, NULL),
	(3525, 175, 0, NULL, 118, '', 365, '0574', 10750, 1, 0, NULL),
	(3526, 175, 0, NULL, NULL, '', 366, '0574', 39, 1, 0, NULL),
	(3527, 175, 0, NULL, NULL, '', 367, '0574', 13666, 1, 0, NULL),
	(3528, 175, 0, NULL, NULL, '', 368, '0574', 12130, 1, 0, NULL),
	(3529, 175, 0, NULL, NULL, '', 369, '0574', 13721, 1, 0, NULL),
	(3530, 175, 0, NULL, NULL, '', 370, '0574', 10532, 1, 0, NULL),
	(3531, 175, 0, NULL, NULL, '', 371, '0574', 12613, 1, 0, NULL),
	(3532, 175, 0, NULL, NULL, '', 372, '0574', 1923, 1, 0, NULL),
	(3533, 175, 0, NULL, NULL, '', 373, '0574', 3143, 1, 0, NULL),
	(3534, 175, 0, NULL, NULL, '', 374, '0574', 10520, 1, 0, NULL),
	(3535, 175, 0, NULL, NULL, '', 375, '0574', 12544, 1, 0, NULL),
	(3536, 175, 0, NULL, NULL, '', 376, '0574', 5252, 1, 0, NULL),
	(3537, 175, 0, NULL, NULL, '', 377, '0574', 6057, 1, 0, NULL),
	(3538, 175, 0, NULL, NULL, '', 378, '0574', 303, 1, 0, NULL),
	(3539, 175, 0, NULL, NULL, '', 379, '0574', 2986, 1, 0, NULL),
	(3540, 175, 0, NULL, NULL, '', 380, '0574', 6543, 1, 0, NULL),
	(3541, 175, 0, NULL, NULL, '', 381, '0574', 6250, 1, 0, NULL),
	(3542, 175, 0, NULL, NULL, '', 382, '0574', 2966, 1, 0, NULL),
	(3543, 175, 0, NULL, NULL, '', 383, '0574', 7352, 1, 0, NULL),
	(3544, 175, 0, NULL, NULL, '', 384, '0574', 8768, 1, 0, NULL),
	(3545, 175, 0, NULL, NULL, '', 385, '0574', 7591, 1, 0, NULL),
	(3546, 175, 0, NULL, NULL, '', 386, '0574', 10616, 1, 0, NULL),
	(3547, 175, 0, NULL, NULL, '', 387, '0574', 11100, 1, 0, NULL),
	(3548, 175, 0, NULL, NULL, '', 388, '0574', 8195, 1, 0, NULL),
	(3549, 175, 0, NULL, NULL, '', 389, '0575', 1289, 1, 0, NULL),
	(3550, 175, 0, NULL, NULL, '', 390, '0575', 4509, 1, 0, NULL),
	(3551, 175, 0, NULL, NULL, '', 391, '0575', 13685, 1, 0, NULL),
	(3552, 175, 0, NULL, NULL, '', 392, '0575', 13776, 1, 0, NULL),
	(3553, 175, 0, NULL, NULL, '', 393, '0575', 1514, 1, 0, NULL),
	(3554, 175, 0, NULL, NULL, '', 394, '0575', 532, 1, 0, NULL),
	(3555, 175, 0, NULL, NULL, '', 395, '0575', 2322, 1, 0, NULL),
	(3556, 175, 0, NULL, NULL, '', 396, '0575', 6981, 1, 0, NULL),
	(3557, 175, 0, NULL, NULL, '', 397, '0575', 9016, 1, 0, NULL),
	(3558, 175, 0, NULL, NULL, '', 398, '0575', 12772, 1, 0, NULL),
	(3559, 175, 0, NULL, NULL, '', 399, '0575', 13720, 1, 0, NULL),
	(3560, 175, 0, NULL, NULL, '', 400, '0575', 5935, 1, 0, NULL),
	(3561, 175, 0, NULL, NULL, '', 401, '0575', 11798, 1, 0, NULL),
	(3562, 175, 0, NULL, NULL, '', 402, '0575', 7348, 1, 0, NULL),
	(3563, 175, 0, NULL, NULL, '', 403, '0575', 3806, 1, 0, NULL),
	(3564, 175, 0, NULL, NULL, '', 404, '0575', 1707, 1, 0, NULL),
	(3565, 175, 0, NULL, NULL, '', 405, '0575', 4252, 1, 0, NULL),
	(3566, 175, 0, NULL, NULL, '', 406, '0575', 0, 1, 0, NULL),
	(3567, 175, 0, NULL, NULL, '', 407, '0575', 0, 1, 0, NULL),
	(3568, 175, 0, NULL, NULL, '', 408, '0575', 0, 1, 0, NULL),
	(3569, 175, 0, NULL, NULL, '', 409, '0575', 0, 1, 0, NULL),
	(3570, 175, 0, NULL, NULL, '', 410, '0575', 0, 1, 0, NULL),
	(3571, 175, 0, NULL, NULL, '', 411, '0575', 0, 1, 0, NULL),
	(3572, 175, 0, NULL, NULL, '', 412, '0575', 0, 1, 0, NULL),
	(3573, 175, 0, NULL, NULL, '', 413, '0575', 0, 1, 0, NULL),
	(3574, 176, 0, NULL, 84, '', 1, '0576', 0, 15, 0, NULL),
	(3575, 176, 0, NULL, 84, '', 2, '0576', 0, 15, 0, NULL),
	(3576, 176, 0, NULL, 84, '', 3, '0576', 0, 1, 0, NULL),
	(3577, 176, 0, NULL, 83, '', 4, '0576', 0, 15, 0, NULL),
	(3578, 176, 0, NULL, 83, '', 5, '0576', 0, 15, 0, NULL),
	(3579, 176, 0, NULL, 83, '', 6, '0576', 0, 15, 0, NULL),
	(3580, 176, 0, NULL, 83, '', 7, '0576', 0, 15, 0, NULL),
	(3581, 176, 0, NULL, 83, '', 8, '0576', 0, 15, 0, NULL),
	(3582, 176, 0, NULL, 83, '', 9, '0576', 0, 15, 0, NULL),
	(3583, 176, 0, NULL, 83, '', 10, '0576', 0, 15, 0, NULL),
	(3584, 176, 0, NULL, 83, '', 11, '0576', 0, 15, 0, NULL),
	(3585, 176, 0, NULL, 83, '', 12, '0576', 0, 15, 0, NULL),
	(3586, 176, 0, NULL, 83, '', 13, '0576', 0, 15, 0, NULL),
	(3587, 176, 0, NULL, 83, '', 14, '0576', 0, 15, 0, NULL),
	(3588, 176, 0, NULL, 83, '', 15, '0576', 0, 15, 0, NULL),
	(3589, 177, 0, NULL, NULL, '', 3, '0556', 0, 15, 1, NULL),
	(3590, 177, 0, NULL, NULL, '', 4, '0556', 0, 15, 1, NULL),
	(3591, 177, 0, NULL, NULL, '', 5, '0556', 0, 15, 1, NULL),
	(3592, 177, 0, NULL, NULL, '', 6, '0556', 0, 15, 1, NULL),
	(3593, 177, 0, NULL, NULL, '', 7, '0556', 0, 15, 1, NULL),
	(3594, 177, 0, NULL, NULL, '', 8, '0556', 0, 15, 1, NULL),
	(3595, 177, 0, NULL, NULL, '', 9, '0556', 0, 15, 1, NULL),
	(3596, 177, 0, NULL, NULL, '', 10, '0556', 0, 15, 1, NULL),
	(3597, 177, 0, NULL, NULL, '', 11, '0556', 0, 15, 1, NULL),
	(3598, 177, 0, NULL, NULL, '', 12, '0556', 0, 15, 1, NULL),
	(3599, 177, 0, NULL, NULL, '', 13, '0556', 0, 15, 1, NULL),
	(3600, 177, 0, NULL, NULL, '', 14, '0556', 0, 15, 1, NULL),
	(3601, 177, 0, NULL, NULL, '', 15, '0556', 0, 15, 1, NULL),
	(3602, 177, 0, NULL, NULL, '', 16, '0556', 0, 15, 1, NULL),
	(3603, 177, 0, NULL, NULL, '', 17, '0556', 0, 15, 1, NULL),
	(3604, 177, 0, NULL, NULL, '', 18, '0556', 0, 15, 1, NULL),
	(3605, 177, 0, NULL, NULL, '', 19, '0556', 0, 15, 1, NULL),
	(3606, 177, 0, NULL, NULL, '', 20, '0556', 0, 15, 1, NULL),
	(3607, 177, 0, NULL, NULL, '', 21, '0556', 0, 15, 1, NULL),
	(3608, 177, 0, NULL, NULL, '', 22, '0556', 0, 15, 1, NULL),
	(3609, 177, 0, NULL, NULL, '', 23, '0556', 0, 15, 1, NULL),
	(3610, 177, 0, NULL, NULL, '', 24, '0556', 0, 15, 1, NULL),
	(3611, 177, 0, NULL, NULL, '', 25, '0556', 0, 15, 1, NULL),
	(3612, 177, 0, NULL, NULL, '', 26, '0556', 0, 15, 1, NULL),
	(3613, 177, 0, NULL, NULL, '', 27, '0557', 0, 15, 1, NULL),
	(3614, 177, 0, NULL, NULL, '', 28, '0557', 0, 15, 1, NULL),
	(3615, 177, 0, NULL, NULL, '', 29, '0557', 0, 15, 1, NULL),
	(3616, 177, 0, NULL, NULL, '', 30, '0557', 0, 15, 1, NULL),
	(3617, 177, 0, NULL, NULL, '', 31, '0557', 0, 15, 1, NULL),
	(3618, 177, 0, NULL, NULL, '', 32, '0557', 0, 15, 1, NULL),
	(3619, 177, 0, NULL, NULL, '', 33, '0557', 0, 15, 1, NULL),
	(3620, 177, 0, NULL, NULL, '', 34, '0557', 0, 15, 1, NULL),
	(3621, 177, 0, NULL, NULL, '', 35, '0557', 0, 15, 1, NULL),
	(3622, 177, 0, NULL, NULL, '', 36, '0557', 0, 15, 1, NULL),
	(3623, 177, 0, NULL, NULL, '', 37, '0557', 0, 15, 1, NULL),
	(3624, 177, 0, NULL, NULL, '', 38, '0557', 0, 15, 1, NULL),
	(3625, 177, 0, NULL, NULL, '', 39, '0557', 0, 15, 1, NULL),
	(3626, 177, 0, NULL, NULL, '', 40, '0557', 0, 15, 1, NULL),
	(3627, 177, 0, NULL, NULL, '', 41, '0557', 0, 15, 1, NULL),
	(3628, 177, 0, NULL, NULL, '', 42, '0557', 0, 15, 1, NULL),
	(3629, 177, 0, NULL, NULL, '', 43, '0557', 0, 15, 1, NULL),
	(3630, 177, 0, NULL, NULL, '', 44, '0557', 0, 15, 1, NULL),
	(3631, 177, 0, NULL, NULL, '', 45, '0557', 0, 15, 1, NULL),
	(3632, 177, 0, NULL, NULL, '', 46, '0557', 0, 15, 1, NULL),
	(3633, 177, 0, NULL, NULL, '', 47, '0557', 0, 15, 1, NULL),
	(3634, 177, 0, NULL, NULL, '', 48, '0557', 0, 15, 1, NULL),
	(3635, 177, 0, NULL, NULL, '', 49, '0557', 0, 15, 1, NULL),
	(3636, 177, 0, NULL, NULL, '', 50, '0557', 0, 15, 1, NULL),
	(3637, 177, 0, NULL, NULL, '', 51, '0557', 0, 15, 1, NULL),
	(3638, 177, 0, NULL, NULL, '', 52, '0558', 0, 15, 1, NULL),
	(3639, 177, 0, NULL, NULL, '', 53, '0558', 0, 15, 1, NULL),
	(3640, 177, 0, NULL, NULL, '', 54, '0558', 0, 15, 1, NULL),
	(3641, 177, 0, NULL, NULL, '', 55, '0558', 0, 15, 1, NULL),
	(3642, 177, 0, NULL, NULL, '', 56, '0558', 0, 15, 1, NULL),
	(3643, 177, 0, NULL, NULL, '', 57, '0558', 0, 15, 1, NULL),
	(3644, 177, 0, NULL, NULL, '', 58, '0558', 0, 15, 1, NULL),
	(3645, 177, 0, NULL, NULL, '', 59, '0558', 0, 15, 1, NULL),
	(3646, 177, 0, NULL, NULL, '', 60, '0558', 0, 15, 1, NULL),
	(3647, 177, 0, NULL, NULL, '', 61, '0558', 0, 15, 1, NULL),
	(3648, 177, 0, NULL, NULL, '', 62, '0558', 0, 15, 1, NULL),
	(3649, 177, 0, NULL, NULL, '', 63, '0558', 0, 15, 1, NULL),
	(3650, 177, 0, NULL, NULL, '', 64, '0558', 0, 15, 1, NULL),
	(3651, 177, 0, NULL, NULL, '', 65, '0558', 0, 15, 1, NULL),
	(3652, 177, 0, NULL, NULL, '', 66, '0558', 0, 15, 1, NULL),
	(3653, 177, 0, NULL, NULL, '', 67, '0558', 0, 15, 1, NULL),
	(3654, 177, 0, NULL, NULL, '', 68, '0558', 0, 15, 1, NULL),
	(3655, 177, 0, NULL, NULL, '', 69, '0558', 0, 15, 1, NULL),
	(3656, 177, 0, NULL, NULL, '', 70, '0558', 0, 15, 1, NULL),
	(3657, 177, 0, NULL, NULL, '', 71, '0558', 0, 15, 1, NULL),
	(3658, 178, 0, NULL, 94, '', 27, '0364', NULL, 1, 0, NULL),
	(3659, 178, 0, NULL, 94, '', 28, '0364', NULL, 1, 0, NULL),
	(3660, 178, 0, NULL, 94, '', 29, '0364', NULL, 1, 0, NULL),
	(3661, 178, 0, NULL, 94, '', 30, '0364', NULL, 1, 0, NULL),
	(3662, 178, 0, NULL, 94, '', 31, '0364', NULL, 1, 0, NULL),
	(3663, 178, 0, NULL, 94, '', 32, '0364', NULL, 1, 0, NULL),
	(3664, 178, 0, NULL, 103, '', 33, '0364', NULL, 1, 0, NULL),
	(3665, 178, 0, NULL, 103, '', 34, '0364', NULL, 1, 0, NULL),
	(3666, 178, 0, NULL, 103, '', 35, '0364', NULL, 1, 0, NULL),
	(3667, 178, 0, NULL, 103, '', 36, '0364', NULL, 1, 0, NULL),
	(3668, 178, 0, NULL, 103, '', 37, '0364', NULL, 1, 0, NULL),
	(3669, 178, 0, NULL, 103, '', 38, '0364', NULL, 1, 0, NULL),
	(3670, 178, 0, NULL, 103, '', 39, '0364', NULL, 1, 0, NULL),
	(3671, 178, 0, NULL, 103, '', 40, '0364', NULL, 1, 0, NULL),
	(3672, 178, 0, NULL, 103, '', 41, '0364', NULL, 1, 0, NULL),
	(3673, 178, 0, NULL, 103, '', 42, '0364', NULL, 1, 0, NULL),
	(3674, 178, 0, NULL, 103, '', 43, '0364', NULL, 1, 0, NULL),
	(3675, 178, 0, NULL, 103, '', 44, '0364', NULL, 1, 0, NULL),
	(3676, 178, 0, NULL, 103, '', 45, '0364', NULL, 1, 0, NULL),
	(3677, 178, 0, NULL, 103, '', 46, '0364', NULL, 1, 0, NULL),
	(3678, 178, 0, NULL, 103, '', 47, '0364', NULL, 1, 0, NULL),
	(3679, 178, 0, NULL, 103, '', 48, '0364', NULL, 1, 0, NULL),
	(3680, 178, 0, NULL, 104, '', 49, '0364', NULL, 1, 0, NULL),
	(3681, 178, 0, NULL, 104, '', 50, '0364', NULL, 1, 0, NULL),
	(3682, 178, 0, NULL, 104, '', 51, '0364', NULL, 1, 0, NULL),
	(3683, 178, 0, NULL, 104, '', 52, '0364', NULL, 1, 0, NULL),
	(3684, 179, 0, NULL, 83, '', 16, '0577', 0, 15, 0, NULL),
	(3685, 179, 0, NULL, 83, '', 17, '0577', 0, 15, 0, NULL),
	(3686, 179, 0, NULL, 83, '', 18, '0577', 0, 15, 0, NULL),
	(3687, 179, 0, NULL, 83, '', 19, '0577', 0, 15, 0, NULL),
	(3688, 179, 0, NULL, 83, '', 20, '0577', 0, 15, 0, NULL),
	(3689, 179, 0, NULL, 83, '', 21, '0577', 0, 15, 0, NULL),
	(3690, 179, 0, NULL, 83, '', 22, '0577', 0, 15, 0, NULL),
	(3691, 179, 0, NULL, 83, '', 23, '0577', 0, 1, 0, NULL),
	(3692, 179, 0, NULL, 85, '', 24, '0577', 0, 15, 0, NULL),
	(3693, 179, 0, NULL, 85, '', 25, '0577', 0, 15, 0, NULL),
	(3694, 179, 0, NULL, 85, '', 26, '0577', 0, 15, 0, NULL),
	(3695, 179, 0, NULL, 85, '', 27, '0577', 0, 15, 0, NULL),
	(3696, 179, 0, NULL, 85, '', 28, '0577', 0, 15, 0, NULL),
	(3697, 179, 0, NULL, 85, '', 29, '0577', 0, 15, 0, NULL),
	(3698, 179, 0, NULL, 85, '', 30, '0577', 0, 15, 0, NULL),
	(3699, 179, 0, NULL, 85, '', 31, '0577', 0, 15, 0, NULL),
	(3700, 179, 0, NULL, 85, '', 32, '0578', 0, 15, 0, NULL),
	(3701, 179, 0, NULL, 85, '', 33, '0578', 0, 15, 0, NULL),
	(3702, 179, 0, NULL, 85, '', 34, '0578', 0, 15, 0, NULL),
	(3703, 179, 0, NULL, 85, '', 35, '0578', 0, 15, 0, NULL),
	(3704, 179, 0, NULL, 85, '', 36, '0578', 0, 15, 0, NULL),
	(3705, 179, 0, NULL, 85, '', 37, '0578', 0, 15, 0, NULL),
	(3706, 179, 0, NULL, 85, '', 38, '0578', 0, 15, 0, NULL),
	(3707, 179, 0, NULL, 85, '', 39, '0578', 0, 15, 0, NULL),
	(3708, 179, 0, NULL, 85, '', 40, '0578', 0, 15, 0, NULL),
	(3709, 179, 0, NULL, 85, '', 41, '0578', 0, 15, 0, NULL),
	(3710, 179, 0, NULL, 85, '', 42, '0578', 0, 15, 0, NULL),
	(3711, 179, 0, NULL, 85, '', 43, '0578', 0, 1, 0, NULL),
	(3712, 179, 0, NULL, NULL, '', 44, '0578', 0, 15, 0, NULL),
	(3713, 179, 0, NULL, NULL, '', 45, '0578', 0, 15, 0, NULL),
	(3714, 179, 0, NULL, NULL, '', 46, '0578', 0, 15, 0, NULL),
	(3715, 179, 0, NULL, NULL, '', 47, '0578', 0, 15, 0, NULL),
	(3716, 179, 0, NULL, NULL, '', 48, '0579', 0, 15, 0, NULL),
	(3717, 179, 0, NULL, NULL, '', 49, '0579', 0, 15, 0, NULL),
	(3718, 179, 0, NULL, NULL, '', 50, '0579', 0, 15, 0, NULL),
	(3719, 179, 0, NULL, NULL, '', 51, '0579', 0, 15, 0, NULL),
	(3720, 179, 0, NULL, NULL, '', 52, '0579', 0, 15, 0, NULL),
	(3721, 179, 0, NULL, NULL, '', 53, '0579', 0, 15, 0, NULL),
	(3722, 179, 0, NULL, NULL, '', 54, '0579', 0, 15, 0, NULL),
	(3723, 179, 0, NULL, NULL, '', 55, '0579', 0, 15, 0, NULL),
	(3724, 179, 0, NULL, NULL, '', 56, '0579', 0, 15, 0, NULL),
	(3725, 179, 0, NULL, NULL, '', 57, '0579', 0, 15, 0, NULL),
	(3726, 179, 0, NULL, NULL, '', 58, '0579', 0, 15, 0, NULL),
	(3727, 179, 0, NULL, NULL, '', 59, '0579', 0, 15, 0, NULL),
	(3728, 179, 0, NULL, NULL, '', 60, '0579', 0, 15, 0, NULL),
	(3729, 179, 0, NULL, NULL, '', 61, '0579', 0, 15, 0, NULL),
	(3730, 179, 0, NULL, NULL, '', 62, '0579', 0, 15, 0, NULL),
	(3731, 162, 0, NULL, 82, '', 76, '0542', NULL, 14, 0, NULL),
	(3732, 162, 0, NULL, NULL, '', 96, '0543', NULL, 14, 1, NULL),
	(3733, 180, 0, NULL, 104, '', 53, '0365', NULL, 1, 0, NULL),
	(3734, 180, 0, NULL, 104, '', 54, '0365', NULL, 1, 0, NULL),
	(3735, 180, 0, NULL, 104, '', 55, '0365', NULL, 1, 0, NULL),
	(3736, 180, 0, NULL, 104, '', 56, '0365', NULL, 1, 0, NULL),
	(3737, 180, 0, NULL, 104, '', 57, '0365', NULL, 1, 0, NULL),
	(3738, 180, 0, NULL, 104, '', 58, '0365', NULL, 1, 0, NULL),
	(3739, 180, 0, NULL, 104, '', 59, '0365', NULL, 1, 0, NULL),
	(3740, 180, 0, NULL, 104, '', 60, '0365', NULL, 1, 0, NULL),
	(3741, 180, 0, NULL, 104, '', 61, '0365', NULL, 1, 0, NULL),
	(3742, 180, 0, NULL, 104, '', 62, '0365', NULL, 1, 0, NULL),
	(3743, 180, 0, NULL, 104, '', 63, '0365', NULL, 1, 0, NULL),
	(3744, 180, 0, NULL, 104, '', 64, '0365', NULL, 1, 0, NULL),
	(3745, 181, 0, NULL, 86, '', 1, '0580', 10296, 1, 0, NULL),
	(3746, 181, 0, NULL, 86, '', 2, '0580', 10206, 1, 0, NULL),
	(3747, 181, 0, NULL, 86, '', 3, '0580', 13452, 1, 0, NULL),
	(3748, 181, 0, NULL, 86, '', 4, '0580', 9895, 1, 0, NULL),
	(3749, 181, 0, NULL, 86, '', 5, '0580', 9749, 1, 0, NULL),
	(3750, 181, 0, NULL, 86, '', 6, '0580', 9590, 1, 0, NULL),
	(3751, 181, 0, NULL, 86, '', 7, '0580', 8477, 1, 0, NULL),
	(3752, 181, 0, NULL, 86, '', 8, '0580', 11552, 1, 0, NULL),
	(3753, 181, 0, NULL, 86, '', 9, '0580', 3912, 1, 0, NULL),
	(3754, 181, 0, NULL, 86, '', 10, '0580', 9869, 1, 0, NULL),
	(3755, 181, 0, NULL, 86, '', 11, '0580', 6518, 1, 0, NULL),
	(3756, 181, 0, NULL, 86, '', 12, '0580', 2207, 1, 0, NULL),
	(3757, 181, 0, NULL, 86, '', 13, '0580', 12724, 1, 0, NULL),
	(3758, 181, 0, NULL, 86, '', 14, '0580', 6440, 1, 0, NULL),
	(3759, 181, 0, NULL, 86, '', 15, '0580', 5973, 1, 0, NULL),
	(3760, 181, 0, NULL, 86, '', 16, '0580', 4713, 1, 0, NULL),
	(3761, 181, 0, NULL, 86, '', 17, '0580', 10484, 1, 0, NULL),
	(3762, 181, 0, NULL, 86, '', 18, '0580', 11420, 1, 0, NULL),
	(3763, 181, 0, NULL, 86, '', 19, '0580', 4817, 1, 0, NULL),
	(3764, 181, 0, NULL, 86, '', 20, '0580', 9285, 1, 0, NULL),
	(3765, 181, 0, NULL, 86, '', 21, '0581', 9254, 1, 0, NULL),
	(3766, 181, 0, NULL, 86, '', 22, '0581', 2356, 1, 0, NULL),
	(3767, 181, 0, NULL, 86, '', 23, '0581', 9745, 1, 0, NULL),
	(3768, 181, 0, NULL, 86, '', 24, '0581', 247, 1, 0, NULL),
	(3769, 181, 0, NULL, 86, '', 25, '0581', 6276, 1, 0, NULL),
	(3770, 181, 0, NULL, 86, '', 26, '0581', 9531, 1, 0, NULL),
	(3771, 181, 0, NULL, 86, '', 27, '0581', 7010, 1, 0, NULL),
	(3772, 181, 0, NULL, 86, '', 28, '0581', 10438, 1, 0, NULL),
	(3773, 181, 0, NULL, 86, '', 29, '0581', 3170, 1, 0, NULL),
	(3774, 181, 0, NULL, 86, '', 30, '0581', 11539, 1, 0, NULL),
	(3775, 181, 0, NULL, 86, '', 31, '0581', 6147, 1, 0, NULL),
	(3776, 181, 0, NULL, 86, '', 32, '0581', 6147, 1, 0, NULL),
	(3777, 181, 0, NULL, 86, '', 33, '0581', 7937, 1, 0, NULL),
	(3778, 181, 0, NULL, 86, '', 34, '0581', 1016, 1, 0, NULL),
	(3779, 181, 0, NULL, 86, '', 35, '0581', 13712, 1, 0, NULL),
	(3780, 181, 0, NULL, 86, '', 36, '0581', 9663, 1, 0, NULL),
	(3781, 181, 0, NULL, 86, '', 37, '0581', 5816, 1, 0, NULL),
	(3782, 181, 0, NULL, 86, '', 38, '0581', 10442, 1, 0, NULL),
	(3783, 181, 0, NULL, 86, '', 39, '0581', 11567, 1, 0, NULL),
	(3784, 181, 0, NULL, 86, '', 40, '0581', 12577, 1, 0, NULL),
	(3785, 181, 0, NULL, 86, '', 41, '0581', 11486, 1, 0, NULL),
	(3786, 181, 0, NULL, 86, '', 42, '0581', 9118, 1, 0, NULL),
	(3787, 181, 0, NULL, 87, '', 43, '0582', 4302, 1, 0, NULL),
	(3788, 181, 0, NULL, 87, '', 44, '0582', 10541, 1, 0, NULL),
	(3789, 181, 0, NULL, 87, '', 45, '0582', 7136, 1, 0, NULL),
	(3790, 181, 0, NULL, 87, '', 46, '0582', 7377, 1, 0, NULL),
	(3791, 181, 0, NULL, 87, '', 47, '0582', 13147, 1, 0, NULL),
	(3792, 181, 0, NULL, 87, '', 48, '0582', 12423, 1, 0, NULL),
	(3793, 181, 0, NULL, 87, '', 49, '0582', 811, 1, 0, NULL),
	(3794, 181, 0, NULL, 87, '', 50, '0582', 4049, 1, 0, NULL),
	(3795, 181, 0, NULL, 87, '', 51, '0582', 5155, 1, 0, NULL),
	(3796, 181, 0, NULL, 87, '', 52, '0582', 6140, 1, 0, NULL),
	(3797, 181, 0, NULL, 87, '', 53, '0582', 9662, 1, 0, NULL),
	(3798, 181, 0, NULL, 87, '', 54, '0582', 2584, 1, 0, NULL),
	(3799, 181, 0, NULL, 87, '', 55, '0582', 7488, 1, 0, NULL),
	(3800, 181, 0, NULL, 87, '', 56, '0582', 11777, 1, 0, NULL),
	(3801, 181, 0, NULL, 87, '', 57, '0582', 13733, 1, 0, NULL),
	(3802, 181, 0, NULL, 87, '', 58, '0582', 8481, 1, 0, NULL),
	(3803, 181, 0, NULL, 87, '', 59, '0582', 5569, 1, 0, NULL),
	(3804, 181, 0, NULL, 87, '', 60, '0582', 4352, 1, 0, NULL),
	(3805, 181, 0, NULL, 87, '', 61, '0582', 4914, 1, 0, NULL),
	(3806, 181, 0, NULL, 87, '', 62, '0582', 7232, 1, 0, NULL),
	(3807, 182, 0, NULL, NULL, '', 63, '0580', 0, 15, 0, NULL),
	(3808, 176, 0, NULL, 83, '', 3, '0576', NULL, 14, 0, NULL),
	(3809, 179, 0, NULL, 85, '', 23, '0577', NULL, 14, 0, NULL),
	(3810, 179, 0, NULL, NULL, '', 43, '0578', NULL, 14, 0, NULL),
	(3811, 165, 0, NULL, NULL, '', 28, '0546', NULL, 5, 0, NULL),
	(3812, 183, 0, NULL, 87, '', 63, '0583', 0, 1, 0, NULL),
	(3813, 183, 0, NULL, 87, '', 64, '0583', 9283, 1, 0, NULL),
	(3814, 183, 0, NULL, 87, '', 65, '0583', 2741, 1, 0, NULL),
	(3815, 183, 0, NULL, 87, '', 66, '0583', 13247, 1, 0, NULL),
	(3816, 183, 0, NULL, 87, '', 67, '0583', 8905, 1, 0, NULL),
	(3817, 183, 0, NULL, 87, '', 68, '0583', 11637, 1, 0, NULL),
	(3818, 183, 0, NULL, 87, '', 69, '0583', 7542, 1, 0, NULL),
	(3819, 183, 0, NULL, 87, '', 70, '0583', 10716, 1, 0, NULL),
	(3820, 183, 0, NULL, 87, '', 71, '0583', 8117, 1, 0, NULL),
	(3821, 183, 0, NULL, 87, '', 72, '0583', 7606, 1, 0, NULL),
	(3822, 183, 0, NULL, 87, '', 73, '0583', 12335, 1, 0, NULL),
	(3823, 183, 0, NULL, 87, '', 74, '0583', 1136, 1, 0, NULL),
	(3824, 183, 0, NULL, 87, '', 75, '0583', 11686, 1, 0, NULL),
	(3825, 183, 0, NULL, 87, '', 76, '0583', 10727, 1, 0, NULL),
	(3826, 183, 0, NULL, 87, '', 77, '0583', 13407, 1, 0, NULL),
	(3827, 183, 0, NULL, 87, '', 78, '0583', 6134, 1, 0, NULL),
	(3828, 183, 0, NULL, 87, '', 79, '0583', 6157, 1, 0, NULL),
	(3829, 183, 0, NULL, 87, '', 80, '0583', 2143, 1, 0, NULL),
	(3830, 183, 0, NULL, 87, '', 81, '0583', 753, 1, 0, NULL),
	(3831, 183, 0, NULL, 87, '', 82, '0583', 7624, 1, 0, NULL),
	(3832, 183, 0, NULL, 87, '', 83, '0583', 10455, 1, 0, NULL),
	(3833, 183, 0, NULL, 87, '', 84, '0583', 4598, 1, 0, NULL),
	(3834, 183, 0, NULL, 98, '', 85, '0584', 3502, 1, 0, NULL),
	(3835, 183, 0, NULL, 98, '', 86, '0584', 2873, 1, 0, NULL),
	(3836, 183, 0, NULL, 98, '', 87, '0584', 2575, 1, 0, NULL),
	(3837, 183, 0, NULL, 98, '', 88, '0584', 5799, 1, 0, NULL),
	(3838, 183, 0, NULL, 98, '', 89, '0584', 4633, 1, 0, NULL),
	(3839, 183, 0, NULL, 98, '', 90, '0584', 10022, 1, 0, NULL),
	(3840, 183, 0, NULL, 98, '', 91, '0584', 6862, 1, 0, NULL),
	(3841, 183, 0, NULL, 98, '', 92, '0584', 723, 1, 0, NULL),
	(3842, 183, 0, NULL, 98, '', 93, '0584', 11977, 1, 0, NULL),
	(3843, 183, 0, NULL, 98, '', 94, '0584', 7454, 1, 0, NULL),
	(3844, 183, 0, NULL, 98, '', 95, '0584', 10599, 1, 0, NULL),
	(3845, 183, 0, NULL, 98, '', 96, '0584', 12014, 1, 0, NULL),
	(3846, 183, 0, NULL, 98, '', 97, '0584', 9911, 1, 0, NULL),
	(3847, 183, 0, NULL, 98, '', 98, '0584', 11922, 1, 0, NULL),
	(3848, 183, 0, NULL, 98, '', 99, '0584', 12455, 1, 0, NULL),
	(3849, 183, 0, NULL, 98, '', 100, '0584', 7435, 1, 0, NULL),
	(3850, 183, 0, NULL, 98, '', 101, '0584', 10515, 1, 0, NULL),
	(3851, 183, 0, NULL, 98, '', 102, '0584', 10770, 1, 0, NULL),
	(3852, 183, 0, NULL, 98, '', 103, '0584', 2588, 1, 0, NULL),
	(3853, 183, 0, NULL, 98, '', 104, '0585', 4427, 1, 0, NULL),
	(3854, 183, 0, NULL, 98, '', 105, '0585', 1805, 1, 0, NULL),
	(3855, 183, 0, NULL, 98, '', 106, '0585', 8025, 1, 0, NULL),
	(3856, 183, 0, NULL, 98, '', 107, '0585', 6371, 1, 0, NULL),
	(3857, 183, 0, NULL, 98, '', 108, '0585', 9246, 1, 0, NULL),
	(3858, 183, 0, NULL, 98, '', 109, '0585', 3758, 1, 0, NULL),
	(3859, 183, 0, NULL, 98, '', 110, '0585', 8674, 1, 0, NULL),
	(3860, 183, 0, NULL, 98, '', 111, '0585', 2610, 1, 0, NULL),
	(3861, 183, 0, NULL, 98, '', 112, '0585', 615, 1, 0, NULL),
	(3862, 183, 0, NULL, 98, '', 113, '0585', 13228, 1, 0, NULL),
	(3863, 183, 0, NULL, 98, '', 114, '0585', 8987, 1, 0, NULL),
	(3864, 183, 0, NULL, 98, '', 115, '0585', 397, 1, 0, NULL),
	(3865, 183, 0, NULL, 98, '', 116, '0585', 3271, 1, 0, NULL),
	(3866, 183, 0, NULL, 98, '', 117, '0585', 1496, 1, 0, NULL),
	(3867, 183, 0, NULL, 98, '', 118, '0585', 5053, 1, 0, NULL),
	(3868, 183, 0, NULL, 98, '', 119, '0585', 5144, 1, 0, NULL),
	(3869, 183, 0, NULL, 98, '', 120, '0585', 1786, 1, 0, NULL),
	(3870, 183, 0, NULL, 98, '', 121, '0585', 8369, 1, 0, NULL),
	(3871, 183, 0, NULL, 98, '', 122, '0585', 10192, 1, 0, NULL),
	(3872, 183, 0, NULL, 98, '', 123, '0585', 10898, 1, 0, NULL),
	(3873, 183, 0, NULL, 98, '', 124, '0585', 8285, 1, 0, NULL),
	(3874, 185, 0, NULL, 105, '', 1, '0366', NULL, 1, 0, NULL),
	(3875, 185, 0, NULL, 105, '', 2, '0366', NULL, 1, 0, NULL),
	(3876, 185, 0, NULL, 105, '', 3, '0366', NULL, 1, 0, NULL),
	(3877, 185, 0, NULL, 105, '', 4, '0366', NULL, 1, 0, NULL),
	(3878, 185, 0, NULL, 105, '', 5, '0366', NULL, 1, 0, NULL),
	(3879, 185, 0, NULL, 105, '', 6, '0366', NULL, 1, 0, NULL),
	(3880, 185, 0, NULL, 105, '', 7, '0366', NULL, 1, 0, NULL),
	(3881, 185, 0, NULL, 105, '', 8, '0366', NULL, 1, 0, NULL),
	(3882, 185, 0, NULL, 105, '', 9, '0366', NULL, 1, 0, NULL),
	(3883, 185, 0, NULL, 105, '', 10, '0366', NULL, 1, 0, NULL),
	(3884, 185, 0, NULL, 105, '', 11, '0366', NULL, 1, 0, NULL),
	(3885, 185, 0, NULL, 105, '', 12, '0366', NULL, 1, 0, NULL),
	(3886, 185, 0, NULL, 105, '', 13, '0366', NULL, 1, 0, NULL),
	(3887, 185, 0, NULL, 105, '', 14, '0366', NULL, 1, 0, NULL),
	(3888, 185, 0, NULL, 105, '', 15, '0366', NULL, 1, 0, NULL),
	(3889, 185, 0, NULL, 105, '', 16, '0366', NULL, 1, 0, NULL),
	(3890, 185, 0, NULL, 106, '', 17, '0366', NULL, 1, 0, NULL),
	(3891, 185, 0, NULL, 106, '', 18, '0366', NULL, 1, 0, NULL),
	(3892, 185, 0, NULL, 106, '', 19, '0366', NULL, 1, 0, NULL),
	(3893, 185, 0, NULL, 106, '', 20, '0366', NULL, 1, 0, NULL),
	(3894, 185, 0, NULL, 106, '', 21, '0366', NULL, 1, 0, NULL),
	(3895, 185, 0, NULL, 106, '', 22, '0366', NULL, 1, 0, NULL),
	(3896, 185, 0, NULL, 106, '', 23, '0366', NULL, 1, 0, NULL),
	(3897, 185, 0, NULL, 106, '', 24, '0366', NULL, 1, 0, NULL),
	(3898, 185, 0, NULL, 106, '', 25, '0366', NULL, 1, 0, NULL),
	(3899, 185, 0, NULL, 106, '', 26, '0366', NULL, 1, 0, NULL),
	(3900, 186, 0, NULL, 98, '', 1, '0585', 2665, 1, 0, NULL),
	(3901, 186, 0, NULL, 98, '', 2, '0585', 8743, 1, 0, NULL),
	(3902, 186, 0, NULL, 97, '', 3, '0586', 13115, 1, 0, NULL),
	(3903, 186, 0, NULL, 97, '', 4, '0586', 7620, 1, 0, NULL),
	(3904, 186, 0, NULL, 97, '', 5, '0586', 11795, 1, 0, NULL),
	(3905, 186, 0, NULL, 97, '', 6, '0586', 6726, 1, 0, NULL),
	(3906, 186, 0, NULL, 97, '', 7, '0586', 3223, 1, 0, NULL),
	(3907, 186, 0, NULL, 97, '', 8, '0586', 7039, 1, 0, NULL),
	(3908, 186, 0, NULL, 97, '', 9, '0586', 7590, 1, 0, NULL),
	(3909, 186, 0, NULL, 97, '', 10, '0586', 3055, 1, 0, NULL),
	(3910, 186, 0, NULL, 97, '', 11, '0586', 8193, 1, 0, NULL),
	(3911, 186, 0, NULL, 97, '', 12, '0586', 3259, 1, 0, NULL),
	(3912, 186, 0, NULL, 97, '', 13, '0586', 6553, 1, 0, NULL),
	(3913, 186, 0, NULL, 97, '', 14, '0586', 4836, 1, 0, NULL),
	(3914, 186, 0, NULL, 97, '', 15, '0586', 744, 1, 0, NULL),
	(3915, 186, 0, NULL, 97, '', 16, '0586', 8609, 1, 0, NULL),
	(3916, 186, 0, NULL, 97, '', 17, '0586', 3914, 1, 0, NULL),
	(3917, 186, 0, NULL, 97, '', 18, '0586', 8640, 1, 0, NULL),
	(3918, 186, 0, NULL, 97, '', 19, '0586', 13266, 1, 0, NULL),
	(3919, 186, 0, NULL, 97, '', 20, '0586', 13153, 1, 0, NULL),
	(3920, 186, 0, NULL, 97, '', 21, '0587', 8054, 1, 0, NULL),
	(3921, 186, 0, NULL, 97, '', 22, '0587', 10759, 1, 0, NULL),
	(3922, 186, 0, NULL, 97, '', 23, '0587', 11849, 1, 0, NULL),
	(3923, 186, 0, NULL, 97, '', 24, '0587', 3708, 1, 0, NULL),
	(3924, 186, 0, NULL, 97, '', 25, '0587', 6846, 1, 0, NULL),
	(3925, 186, 0, NULL, 97, '', 26, '0587', 5042, 1, 0, NULL),
	(3926, 186, 0, NULL, 97, '', 27, '0587', 12356, 1, 0, NULL),
	(3927, 186, 0, NULL, 97, '', 28, '0587', 10602, 1, 0, NULL),
	(3928, 186, 0, NULL, 97, '', 29, '0587', 9804, 1, 0, NULL),
	(3929, 186, 0, NULL, 97, '', 30, '0587', 3476, 1, 0, NULL),
	(3930, 186, 0, NULL, 97, '', 31, '0587', 13672, 1, 0, NULL),
	(3931, 186, 0, NULL, 97, '', 32, '0587', 7294, 1, 0, NULL),
	(3932, 186, 0, NULL, 97, '', 33, '0587', 10119, 1, 0, NULL),
	(3933, 186, 0, NULL, 97, '', 34, '0587', 6695, 1, 0, NULL),
	(3934, 186, 0, NULL, 97, '', 35, '0587', 940, 1, 0, NULL),
	(3935, 186, 0, NULL, 97, '', 36, '0587', 10095, 1, 0, NULL),
	(3936, 186, 0, NULL, 97, '', 37, '0587', 8891, 1, 0, NULL),
	(3937, 186, 0, NULL, 97, '', 38, '0587', 2176, 1, 0, NULL),
	(3938, 186, 0, NULL, 97, '', 39, '0587', 5592, 1, 0, NULL),
	(3939, 186, 0, NULL, 97, '', 40, '0587', 7109, 1, 0, NULL),
	(3940, 186, 0, NULL, 97, '', 41, '0587', 8884, 1, 0, NULL),
	(3941, 187, 0, NULL, NULL, '', 1, '0109', 3037, 1, 0, NULL),
	(3942, 187, 0, NULL, NULL, '', 2, '0109', 3565, 1, 0, NULL),
	(3943, 187, 0, NULL, NULL, '', 3, '0109', 8649, 1, 0, NULL),
	(3944, 187, 0, NULL, NULL, '', 4, '0109', 3002, 1, 0, NULL),
	(3945, 187, 0, NULL, NULL, '', 5, '0109', 6843, 1, 0, NULL),
	(3946, 187, 0, NULL, NULL, '', 6, '0109', 6524, 1, 0, NULL),
	(3947, 187, 0, NULL, NULL, '', 7, '0109', 11549, 1, 0, NULL),
	(3948, 187, 0, NULL, NULL, '', 8, '0109', 6871, 1, 0, NULL),
	(3949, 187, 0, NULL, NULL, '', 9, '0109', 5245, 1, 0, NULL),
	(3950, 187, 0, NULL, NULL, '', 10, '0109', 5354, 1, 0, NULL),
	(3951, 187, 0, NULL, NULL, '', 11, '0109', 2206, 1, 0, NULL),
	(3952, 187, 0, NULL, NULL, '', 12, '0109', 10182, 1, 0, NULL),
	(3953, 187, 0, NULL, NULL, '', 13, '0109', 12664, 1, 0, NULL),
	(3954, 187, 0, NULL, NULL, '', 14, '0109', 7410, 1, 0, NULL),
	(3955, 187, 0, NULL, NULL, '', 15, '0109', 9044, 1, 0, NULL),
	(3956, 187, 0, NULL, NULL, '', 16, '0110', 2056, 1, 0, NULL),
	(3957, 187, 0, NULL, NULL, '', 17, '0110', 11165, 1, 0, NULL),
	(3958, 187, 0, NULL, NULL, '', 18, '0110', 4252, 1, 0, NULL),
	(3959, 187, 0, NULL, NULL, '', 19, '0110', 6387, 1, 0, NULL),
	(3960, 187, 0, NULL, NULL, '', 20, '0110', 4551, 1, 0, NULL),
	(3961, 187, 0, NULL, NULL, '', 21, '0110', 12611, 1, 0, NULL),
	(3962, 187, 0, NULL, NULL, '', 22, '0110', 7609, 1, 0, NULL),
	(3963, 187, 0, NULL, NULL, '', 23, '0110', 5346, 1, 0, NULL),
	(3964, 187, 0, NULL, NULL, '', 24, '0110', 8751, 1, 0, NULL),
	(3965, 187, 0, NULL, NULL, '', 25, '0110', 3103, 1, 0, NULL),
	(3966, 187, 0, NULL, NULL, '', 26, '0110', 8683, 1, 0, NULL),
	(3967, 187, 0, NULL, NULL, '', 27, '0110', 13392, 1, 0, NULL),
	(3968, 187, 0, NULL, NULL, '', 28, '0110', 4926, 1, 0, NULL),
	(3969, 187, 0, NULL, NULL, '', 29, '0110', 11191, 1, 0, NULL),
	(3970, 187, 0, NULL, NULL, '', 30, '0110', 2810, 1, 0, NULL),
	(3971, 187, 0, NULL, NULL, '', 31, '0110', 2084, 1, 0, NULL),
	(3972, 187, 0, NULL, NULL, '', 32, '0110', 4951, 1, 0, NULL),
	(3973, 189, 0, NULL, 106, '', 27, '0367', NULL, 1, 0, NULL),
	(3974, 189, 0, NULL, 106, '', 28, '0367', NULL, 1, 0, NULL),
	(3975, 189, 0, NULL, 106, '', 29, '0367', NULL, 1, 0, NULL),
	(3976, 189, 0, NULL, 106, '', 30, '0367', NULL, 1, 0, NULL),
	(3977, 189, 0, NULL, 106, '', 31, '0367', NULL, 1, 0, NULL),
	(3978, 189, 0, NULL, 106, '', 32, '0367', NULL, 1, 0, NULL),
	(3979, 189, 0, NULL, 107, '', 33, '0367', NULL, 1, 0, NULL),
	(3980, 189, 0, NULL, 107, '', 34, '0367', NULL, 1, 0, NULL),
	(3981, 189, 0, NULL, 107, '', 35, '0367', NULL, 1, 0, NULL),
	(3982, 189, 0, NULL, 107, '', 36, '0367', NULL, 1, 0, NULL),
	(3983, 189, 0, NULL, 107, '', 37, '0367', NULL, 1, 0, NULL),
	(3984, 189, 0, NULL, 107, '', 38, '0367', NULL, 1, 0, NULL),
	(3985, 189, 0, NULL, 107, '', 39, '0367', NULL, 1, 0, NULL),
	(3986, 189, 0, NULL, 107, '', 40, '0367', NULL, 1, 0, NULL),
	(3987, 189, 0, NULL, 107, '', 41, '0367', NULL, 1, 0, NULL),
	(3988, 189, 0, NULL, 107, '', 42, '0367', NULL, 1, 0, NULL),
	(3989, 189, 0, NULL, 107, '', 43, '0367', NULL, 1, 0, NULL),
	(3990, 189, 0, NULL, 107, '', 44, '0367', NULL, 1, 0, NULL),
	(3991, 189, 0, NULL, 107, '', 45, '0367', NULL, 1, 0, NULL),
	(3992, 189, 0, NULL, 107, '', 46, '0367', NULL, 1, 0, NULL),
	(3993, 189, 0, NULL, 107, '', 47, '0367', NULL, 1, 0, NULL),
	(3994, 189, 0, NULL, 107, '', 48, '0367', NULL, 1, 0, NULL),
	(3995, 189, 0, NULL, 114, '', 49, '0367', NULL, 1, 0, NULL),
	(3996, 189, 0, NULL, 114, '', 50, '0367', NULL, 1, 0, NULL),
	(3997, 189, 0, NULL, 114, '', 51, '0367', NULL, 1, 0, NULL),
	(3998, 189, 0, NULL, 114, '', 52, '0367', NULL, 1, 0, NULL),
	(4062, 191, 0, NULL, NULL, '', 1, '0111', 1882, 1, 0, NULL),
	(4063, 191, 0, NULL, NULL, '', 2, '0111', 11875, 1, 0, NULL),
	(4064, 191, 0, NULL, NULL, '', 3, '0111', 6903, 1, 0, NULL),
	(4065, 191, 0, NULL, NULL, '', 4, '0111', 6873, 1, 0, NULL),
	(4066, 191, 0, NULL, NULL, '', 5, '0111', 10605, 1, 0, NULL),
	(4067, 191, 0, NULL, NULL, '', 6, '0111', 11606, 1, 0, NULL),
	(4068, 191, 0, NULL, NULL, '', 7, '0111', 9454, 1, 0, NULL),
	(4069, 191, 0, NULL, NULL, '', 8, '0111', 13730, 1, 0, NULL),
	(4070, 191, 0, NULL, NULL, '', 9, '0111', 12650, 1, 0, NULL),
	(4071, 191, 0, NULL, NULL, '', 10, '0111', 8008, 1, 0, NULL),
	(4072, 191, 0, NULL, NULL, '', 11, '0111', 4605, 1, 0, NULL),
	(4073, 191, 0, NULL, NULL, '', 12, '0111', 6890, 1, 0, NULL),
	(4074, 191, 0, NULL, NULL, '', 13, '0111', 3802, 1, 0, NULL),
	(4075, 191, 0, NULL, NULL, '', 14, '0112', 3035, 1, 0, NULL),
	(4076, 191, 0, NULL, NULL, '', 15, '0112', 9572, 1, 0, NULL),
	(4077, 191, 0, NULL, NULL, '', 16, '0112', 13498, 1, 0, NULL),
	(4078, 191, 0, NULL, NULL, '', 17, '0112', 2340, 1, 0, NULL),
	(4079, 191, 0, NULL, NULL, '', 18, '0112', 4867, 1, 0, NULL),
	(4080, 191, 0, NULL, NULL, '', 19, '0112', 5331, 1, 0, NULL),
	(4081, 191, 0, NULL, NULL, '', 20, '0112', 4540, 1, 0, NULL),
	(4082, 191, 0, NULL, NULL, '', 21, '0112', 4763, 1, 0, NULL),
	(4083, 191, 0, NULL, NULL, '', 22, '0112', 5648, 1, 0, NULL),
	(4084, 191, 0, NULL, NULL, '', 23, '0112', 12562, 1, 0, NULL),
	(4085, 191, 0, NULL, NULL, '', 24, '0112', 6090, 1, 0, NULL),
	(4086, 191, 0, NULL, NULL, '', 25, '0112', 6558, 1, 0, NULL),
	(4087, 191, 0, NULL, NULL, '', 26, '0112', 8097, 1, 0, NULL),
	(4088, 191, 0, NULL, NULL, '', 27, '0112', 9677, 1, 0, NULL),
	(4089, 191, 0, NULL, NULL, '', 28, '0112', 4084, 1, 0, NULL),
	(4090, 191, 0, NULL, NULL, '', 29, '0112', 5024, 1, 0, NULL),
	(4091, 191, 0, NULL, NULL, '', 30, '0112', 6840, 1, 0, NULL),
	(4092, 191, 0, NULL, NULL, '', 31, '0113', 2812, 1, 0, NULL),
	(4093, 191, 0, NULL, NULL, '', 32, '0113', 2059, 1, 0, NULL),
	(4094, 191, 0, NULL, NULL, '', 33, '0113', 8719, 1, 0, NULL),
	(4095, 191, 0, NULL, NULL, '', 34, '0113', 4718, 1, 0, NULL),
	(4096, 191, 0, NULL, NULL, '', 35, '0113', 5603, 1, 0, NULL),
	(4097, 191, 0, NULL, NULL, '', 36, '0113', 7778, 1, 0, NULL),
	(4098, 191, 0, NULL, NULL, '', 37, '0113', 7057, 1, 0, NULL),
	(4099, 191, 0, NULL, NULL, '', 38, '0113', 4713, 1, 0, NULL),
	(4100, 191, 0, NULL, NULL, '', 39, '0113', 9649, 1, 0, NULL),
	(4101, 191, 0, NULL, NULL, '', 40, '0113', 2697, 1, 0, NULL),
	(4102, 191, 0, NULL, NULL, '', 41, '0113', 12272, 1, 0, NULL),
	(4103, 191, 0, NULL, NULL, '', 42, '0113', 8003, 1, 0, NULL),
	(4104, 191, 0, NULL, NULL, '', 43, '0113', 2336, 1, 0, NULL),
	(4105, 191, 0, NULL, NULL, '', 44, '0113', 11871, 1, 0, NULL),
	(4106, 191, 0, NULL, NULL, '', 45, '0113', 5119, 1, 0, NULL),
	(4107, 191, 0, NULL, NULL, '', 46, '0113', 11038, 1, 0, NULL),
	(4108, 191, 0, NULL, NULL, '', 47, '0113', 7988, 1, 0, NULL),
	(4109, 191, 0, NULL, NULL, '', 48, '0113', 8128, 1, 0, NULL),
	(4110, 192, 0, NULL, NULL, '', 33, '0111', 12343, 1, 0, NULL),
	(4111, 192, 0, NULL, NULL, '', 34, '0111', 7063, 1, 0, NULL),
	(4112, 192, 0, NULL, NULL, '', 35, '0111', 11019, 1, 0, NULL),
	(4113, 192, 0, NULL, NULL, '', 36, '0111', 10020, 1, 0, NULL),
	(4114, 192, 0, NULL, NULL, '', 37, '0111', 3866, 1, 0, NULL),
	(4115, 192, 0, NULL, NULL, '', 38, '0111', 4466, 1, 0, NULL),
	(4116, 190, 1, NULL, 97, 'DSR', 42, '0588', 123, 1, 0, NULL),
	(4117, 190, 1, NULL, 97, 'DSR', 43, '0588', 321, 1, 0, NULL),
	(4118, 190, 1, NULL, 97, 'DSR', 44, '0588', 295, 1, 0, NULL),
	(4119, 190, 1, NULL, 102, 'DSR', 45, '0588', 6562, 1, 0, NULL),
	(4120, 190, 1, NULL, 102, 'DSR', 46, '0588', 1496, 1, 0, NULL),
	(4121, 190, 1, NULL, 102, 'DSR', 47, '0588', NULL, 1, 0, NULL),
	(4122, 190, 1, NULL, 102, 'DSR', 48, '0588', NULL, 1, 0, NULL),
	(4123, 190, 1, NULL, 102, 'DSR', 49, '0588', NULL, 1, 0, NULL),
	(4124, 190, 1, NULL, 102, 'DSR', 50, '0588', NULL, 1, 0, NULL),
	(4125, 190, 1, NULL, 102, 'DSR', 51, '0588', NULL, 1, 0, NULL),
	(4126, 190, 1, NULL, 102, 'DSR', 52, '0588', NULL, 1, 0, NULL),
	(4127, 190, 1, NULL, 102, 'DSR', 53, '0588', NULL, 1, 0, NULL),
	(4128, 190, 1, NULL, 102, 'DSR', 54, '0588', NULL, 1, 0, NULL),
	(4129, 190, 1, NULL, 102, 'DSR', 55, '0588', NULL, 1, 0, NULL),
	(4130, 190, 1, NULL, 102, 'DSR', 56, '0588', NULL, 1, 0, NULL),
	(4131, 190, 1, NULL, 102, 'DSR', 57, '0588', NULL, 1, 0, NULL),
	(4132, 190, 1, NULL, 101, 'DSR', 58, '0588', NULL, 1, 0, NULL),
	(4133, 190, 1, NULL, 101, 'DSR', 59, '0588', NULL, 1, 0, NULL),
	(4134, 190, 1, NULL, 101, 'DSR', 60, '0588', NULL, 1, 0, NULL),
	(4135, 190, 1, NULL, 101, 'DSR', 61, '0588', NULL, 1, 0, NULL),
	(4136, 190, 1, NULL, 101, 'DSR', 62, '0588', NULL, 1, 0, NULL),
	(4137, 190, 2, NULL, 101, 'DSR', 63, '0589', NULL, 1, 0, NULL),
	(4138, 190, 2, NULL, 101, 'DSR', 64, '0589', NULL, 1, 0, NULL),
	(4139, 190, 2, NULL, 101, 'DSR', 65, '0589', NULL, 1, 0, NULL),
	(4140, 190, 2, NULL, 101, 'DSR', 66, '0589', NULL, 1, 0, NULL),
	(4141, 190, 2, NULL, 101, 'DSR', 67, '0589', NULL, 1, 0, NULL),
	(4142, 190, 2, NULL, 101, 'DSR', 68, '0589', NULL, 1, 0, NULL),
	(4143, 190, 2, NULL, 101, 'DSR', 69, '0589', NULL, 1, 0, NULL),
	(4144, 190, 2, NULL, 101, 'DSR', 70, '0589', NULL, 1, 0, NULL),
	(4145, 190, 2, NULL, 101, 'DSR', 71, '0589', NULL, 1, 0, NULL),
	(4146, 190, 2, NULL, 101, 'DSR', 72, '0589', NULL, 1, 0, NULL),
	(4147, 190, 2, NULL, 101, 'DSR', 73, '0589', NULL, 1, 0, NULL),
	(4148, 190, 2, NULL, 101, 'DSR', 74, '0589', NULL, 1, 0, NULL),
	(4149, 190, 2, NULL, 101, 'DSR', 75, '0589', NULL, 1, 0, NULL),
	(4150, 190, 2, NULL, 101, 'DSR', 76, '0589', NULL, 1, 0, NULL),
	(4151, 190, 2, NULL, 101, 'DSR', 77, '0589', NULL, 1, 0, NULL),
	(4152, 190, 2, NULL, 101, 'DSR', 78, '0589', NULL, 1, 0, NULL),
	(4153, 190, 2, NULL, 101, 'DSR', 79, '0589', NULL, 1, 0, NULL),
	(4154, 190, 2, NULL, 101, 'DSR', 80, '0589', NULL, 1, 0, NULL),
	(4155, 190, 2, NULL, 101, 'DSR', 81, '0589', NULL, 1, 0, NULL),
	(4156, 190, 2, NULL, 101, 'DSR', 82, '0589', NULL, 1, 0, NULL),
	(4157, 190, 2, NULL, 101, 'DSR', 83, '0589', NULL, 1, 0, NULL),
	(4158, 190, 3, NULL, 101, 'DSR', 84, '0590', NULL, 1, 0, NULL),
	(4159, 190, 3, NULL, 101, 'DSR', 85, '0590', NULL, 1, 0, NULL),
	(4160, 190, 3, NULL, 101, 'DSR', 86, '0590', NULL, 1, 0, NULL),
	(4161, 190, 3, NULL, 100, 'DSR', 87, '0590', NULL, 1, 0, NULL),
	(4162, 190, 3, NULL, 100, 'DSR', 88, '0590', NULL, 1, 0, NULL),
	(4163, 190, 3, NULL, 100, 'DSR', 89, '0590', NULL, 1, 0, NULL),
	(4164, 190, 3, NULL, 100, 'DSR', 90, '0590', NULL, 1, 0, NULL),
	(4165, 190, 3, NULL, 100, 'DSR', 91, '0590', NULL, 1, 0, NULL),
	(4166, 190, 3, NULL, 100, 'DSR', 92, '0590', NULL, 1, 0, NULL),
	(4167, 190, 3, NULL, 100, 'DSR', 93, '0590', NULL, 1, 0, NULL),
	(4168, 190, 3, NULL, 100, 'DSR', 94, '0590', NULL, 1, 0, NULL),
	(4169, 190, 3, NULL, 100, 'DSR', 95, '0590', NULL, 1, 0, NULL),
	(4170, 190, 3, NULL, 100, 'DSR', 96, '0590', NULL, 1, 0, NULL),
	(4171, 190, 3, NULL, 100, 'DSR', 97, '0590', NULL, 1, 0, NULL),
	(4172, 190, 3, NULL, 100, 'DSR', 98, '0590', NULL, 1, 0, NULL),
	(4173, 190, 3, NULL, 100, 'DSR', 99, '0590', NULL, 1, 0, NULL),
	(4174, 190, 3, NULL, 100, 'DSR', 100, '0590', NULL, 1, 0, NULL),
	(4175, 190, 3, NULL, 100, 'DSR', 101, '0590', NULL, 1, 0, NULL),
	(4176, 190, 3, NULL, 100, 'DSR', 102, '0590', NULL, 1, 0, NULL),
	(4177, 190, 3, NULL, 100, 'DSR', 103, '0590', NULL, 1, 0, NULL),
	(4178, 190, 3, NULL, 100, 'DSR', 104, '0590', NULL, 1, 0, NULL),
	(4179, 193, 0, NULL, 114, '', 53, '0368', NULL, 1, 0, NULL),
	(4180, 193, 0, NULL, 114, '', 54, '0368', NULL, 1, 0, NULL),
	(4181, 193, 0, NULL, 114, '', 55, '0368', NULL, 1, 0, NULL),
	(4182, 193, 0, NULL, 114, '', 56, '0368', NULL, 1, 0, NULL),
	(4183, 193, 0, NULL, 114, '', 57, '0368', NULL, 1, 0, NULL),
	(4184, 193, 0, NULL, 114, '', 58, '0368', NULL, 1, 0, NULL),
	(4185, 193, 0, NULL, 114, '', 59, '0368', NULL, 1, 0, NULL),
	(4186, 193, 0, NULL, 114, '', 60, '0368', NULL, 1, 0, NULL),
	(4187, 193, 0, NULL, 114, '', 61, '0368', NULL, 1, 0, NULL),
	(4188, 193, 0, NULL, 114, '', 62, '0368', NULL, 1, 0, NULL),
	(4189, 193, 0, NULL, 114, '', 63, '0368', NULL, 1, 0, NULL),
	(4190, 193, 0, NULL, 114, '', 64, '0368', NULL, 1, 0, NULL),
	(4191, 193, 0, NULL, 115, '', 65, '0368', NULL, 1, 0, NULL),
	(4192, 193, 0, NULL, 115, '', 66, '0368', NULL, 1, 0, NULL),
	(4193, 193, 0, NULL, 115, '', 67, '0368', NULL, 1, 0, NULL),
	(4194, 193, 0, NULL, 115, '', 68, '0368', NULL, 1, 0, NULL),
	(4195, 193, 0, NULL, 115, '', 69, '0368', NULL, 1, 0, NULL),
	(4196, 193, 0, NULL, 115, '', 70, '0368', NULL, 1, 0, NULL),
	(4197, 193, 0, NULL, 115, '', 71, '0368', NULL, 1, 0, NULL),
	(4198, 193, 0, NULL, 115, '', 72, '0368', NULL, 1, 0, NULL),
	(4199, 193, 0, NULL, 115, '', 73, '0368', NULL, 1, 0, NULL),
	(4200, 193, 0, NULL, 115, '', 74, '0368', NULL, 1, 0, NULL),
	(4201, 193, 0, NULL, 115, '', 75, '0368', NULL, 1, 0, NULL),
	(4202, 193, 0, NULL, 115, '', 76, '0368', NULL, 1, 0, NULL),
	(4203, 193, 0, NULL, 115, '', 77, '0368', NULL, 1, 0, NULL),
	(4204, 193, 0, NULL, 115, '', 78, '0368', NULL, 1, 0, NULL),
	(4205, 193, 0, NULL, 115, '', 79, '0369', NULL, 1, 0, NULL),
	(4206, 193, 0, NULL, 115, '', 80, '0369', NULL, 1, 0, NULL),
	(4207, 193, 0, NULL, 119, '', 81, '0369', NULL, 1, 0, NULL),
	(4208, 193, 0, NULL, 119, '', 82, '0369', NULL, 1, 0, NULL),
	(4209, 193, 0, NULL, 119, '', 83, '0369', NULL, 1, 0, NULL),
	(4210, 193, 0, NULL, 119, '', 84, '0369', NULL, 1, 0, NULL),
	(4211, 193, 0, NULL, 119, '', 85, '0369', NULL, 1, 0, NULL),
	(4212, 193, 0, NULL, 119, '', 86, '0369', NULL, 1, 0, NULL),
	(4213, 193, 0, NULL, 119, '', 87, '0369', NULL, 1, 0, NULL),
	(4214, 193, 0, NULL, 119, '', 88, '0369', NULL, 1, 0, NULL),
	(4215, 193, 0, NULL, 119, '', 89, '0369', NULL, 1, 0, NULL),
	(4216, 193, 0, NULL, 119, '', 90, '0369', NULL, 1, 0, NULL),
	(4217, 193, 0, NULL, 119, '', 91, '0369', NULL, 1, 0, NULL),
	(4218, 193, 0, NULL, 119, '', 92, '0369', NULL, 1, 0, NULL),
	(4219, 193, 0, NULL, 119, '', 93, '0369', NULL, 1, 0, NULL),
	(4220, 193, 0, NULL, 119, '', 94, '0369', NULL, 1, 0, NULL),
	(4221, 193, 0, NULL, 119, '', 95, '0369', NULL, 1, 0, NULL),
	(4222, 193, 0, NULL, 119, '', 96, '0369', NULL, 1, 0, NULL),
	(4223, 193, 0, NULL, 120, '', 97, '0369', NULL, 1, 0, NULL),
	(4224, 193, 0, NULL, 120, '', 98, '0369', NULL, 1, 0, NULL),
	(4225, 193, 0, NULL, 120, '', 99, '0369', NULL, 1, 0, NULL),
	(4226, 193, 0, NULL, 120, '', 100, '0369', NULL, 1, 0, NULL),
	(4227, 193, 0, NULL, 120, '', 101, '0369', NULL, 1, 0, NULL),
	(4228, 193, 0, NULL, 120, '', 102, '0369', NULL, 1, 0, NULL),
	(4229, 193, 0, NULL, 120, '', 103, '0369', NULL, 1, 0, NULL),
	(4230, 193, 0, NULL, 120, '', 104, '0369', NULL, 1, 0, NULL),
	(4293, 195, 0, NULL, NULL, '', 49, '0114', 3544, 1, 0, NULL),
	(4294, 195, 0, NULL, NULL, '', 50, '0114', 4495, 1, 0, NULL),
	(4295, 195, 0, NULL, NULL, '', 51, '0114', 5033, 1, 0, NULL),
	(4296, 195, 0, NULL, NULL, '', 52, '0114', 4856, 1, 0, NULL),
	(4297, 195, 0, NULL, NULL, '', 53, '0114', 2692, 1, 0, NULL),
	(4298, 195, 0, NULL, NULL, '', 54, '0114', 4196, 1, 0, NULL),
	(4299, 195, 0, NULL, NULL, '', 55, '0114', 2929, 1, 0, NULL),
	(4300, 195, 0, NULL, NULL, '', 56, '0114', 6866, 1, 0, NULL),
	(4301, 195, 0, NULL, NULL, '', 57, '0114', 10993, 1, 0, NULL),
	(4302, 195, 0, NULL, NULL, '', 58, '0114', 6669, 1, 0, NULL),
	(4303, 195, 0, NULL, NULL, '', 59, '0114', 6362, 1, 0, NULL),
	(4304, 195, 0, NULL, NULL, '', 60, '0114', 3095, 1, 0, NULL),
	(4305, 195, 0, NULL, NULL, '', 61, '0114', 9715, 1, 0, NULL),
	(4306, 195, 0, NULL, NULL, '', 62, '0114', 9816, 1, 0, NULL),
	(4307, 195, 0, NULL, NULL, '', 63, '0114', 500, 1, 0, NULL),
	(4308, 195, 0, NULL, NULL, '', 64, '0114', 8350, 1, 0, NULL),
	(4309, 195, 0, NULL, NULL, '', 65, '0114', 6806, 1, 0, NULL),
	(4310, 195, 0, NULL, NULL, '', 66, '0114', 10205, 1, 0, NULL),
	(4311, 195, 0, NULL, NULL, '', 67, '0115', 2902, 1, 0, NULL),
	(4312, 195, 0, NULL, NULL, '', 68, '0115', 4174, 1, 0, NULL),
	(4313, 195, 0, NULL, NULL, '', 69, '0115', 6987, 1, 0, NULL),
	(4314, 195, 0, NULL, NULL, '', 70, '0115', 5534, 1, 0, NULL),
	(4315, 195, 0, NULL, NULL, '', 71, '0115', 9506, 1, 0, NULL),
	(4316, 195, 0, NULL, NULL, '', 72, '0115', 5805, 1, 0, NULL),
	(4317, 195, 0, NULL, NULL, '', 73, '0115', 9408, 1, 0, NULL),
	(4318, 195, 0, NULL, NULL, '', 74, '0115', 9540, 1, 0, NULL),
	(4319, 195, 0, NULL, NULL, '', 75, '0115', 13494, 1, 0, NULL),
	(4320, 195, 0, NULL, NULL, '', 76, '0115', 9961, 1, 0, NULL),
	(4321, 195, 0, NULL, NULL, '', 77, '0115', 11985, 1, 0, NULL),
	(4322, 195, 0, NULL, NULL, '', 78, '0115', 9426, 1, 0, NULL),
	(4323, 195, 0, NULL, NULL, '', 79, '0115', 7095, 1, 0, NULL),
	(4324, 195, 0, NULL, NULL, '', 80, '0115', 11791, 1, 0, NULL),
	(4325, 195, 0, NULL, NULL, '', 81, '0115', 10548, 1, 0, NULL),
	(4326, 195, 0, NULL, NULL, '', 82, '0115', 6442, 1, 0, NULL),
	(4327, 195, 0, NULL, NULL, '', 83, '0115', 9858, 1, 0, NULL),
	(4328, 195, 0, NULL, NULL, '', 84, '0116', 9178, 1, 0, NULL),
	(4329, 195, 0, NULL, NULL, '', 85, '0116', 7686, 1, 0, NULL),
	(4330, 195, 0, NULL, NULL, '', 86, '0116', 6305, 1, 0, NULL),
	(4331, 195, 0, NULL, NULL, '', 87, '0116', 6189, 1, 0, NULL),
	(4332, 195, 0, NULL, NULL, '', 88, '0116', 6819, 1, 0, NULL),
	(4333, 195, 0, NULL, NULL, '', 89, '0116', 6356, 1, 0, NULL),
	(4334, 195, 0, NULL, NULL, '', 90, '0116', 3119, 1, 0, NULL),
	(4335, 195, 0, NULL, NULL, '', 91, '0116', 2651, 1, 0, NULL),
	(4336, 195, 0, NULL, NULL, '', 92, '0116', 7782, 1, 0, NULL),
	(4337, 195, 0, NULL, NULL, '', 93, '0116', 6346, 1, 0, NULL),
	(4338, 195, 0, NULL, NULL, '', 94, '0116', 2257, 1, 0, NULL),
	(4339, 195, 0, NULL, NULL, '', 95, '0116', 2919, 1, 0, NULL),
	(4340, 195, 0, NULL, NULL, '', 96, '0116', 6131, 1, 0, NULL),
	(4341, 195, 0, NULL, NULL, '', 97, '0116', 13249, 1, 0, NULL),
	(4342, 195, 0, NULL, NULL, '', 98, '0116', 11660, 1, 0, NULL),
	(4343, 195, 0, NULL, NULL, '', 99, '0116', 8613, 1, 0, NULL),
	(4430, 194, 1, '07:10:00', 100, 'DSR', 105, '0591', 12222, 1, 0, NULL),
	(4431, 194, 1, NULL, 100, 'DSR', 106, '0591', 534, 1, 0, NULL),
	(4432, 194, 1, NULL, 100, 'DSR', 107, '0591', 5367, 1, 0, NULL),
	(4433, 194, 1, NULL, 100, 'DSR', 108, '0591', NULL, 1, 0, NULL),
	(4434, 194, 1, NULL, 100, 'DSR', 109, '0591', NULL, 1, 0, NULL),
	(4435, 194, 1, NULL, 100, 'DSR', 110, '0591', NULL, 1, 0, NULL),
	(4436, 194, 1, NULL, 100, 'DSR', 111, '0591', NULL, 1, 0, NULL),
	(4437, 194, 1, NULL, 100, 'DSR', 112, '0591', NULL, 1, 0, NULL),
	(4438, 194, 1, NULL, 100, 'DSR', 113, '0591', NULL, 1, 0, NULL),
	(4439, 194, 1, NULL, 100, 'DSR', 114, '0591', NULL, 1, 0, NULL),
	(4440, 194, 1, NULL, 100, 'DSR', 115, '0591', NULL, 1, 0, NULL),
	(4441, 194, 1, NULL, 100, 'DSR', 116, '0591', NULL, 1, 0, NULL),
	(4442, 194, 1, NULL, 100, 'DSR', 117, '0591', NULL, 1, 0, NULL),
	(4443, 194, 1, NULL, 100, 'DSR', 118, '0591', NULL, 1, 0, NULL),
	(4444, 194, 1, NULL, 100, 'DSR', 119, '0591', NULL, 1, 0, NULL),
	(4445, 194, 1, NULL, 100, 'DSR', 120, '0591', NULL, 1, 0, NULL),
	(4446, 194, 1, NULL, 100, 'DSR', 121, '0591', NULL, 1, 0, NULL),
	(4447, 194, 1, NULL, 100, 'DSR', 122, '0591', NULL, 1, 0, NULL),
	(4448, 194, 1, NULL, 100, 'DSR', 123, '0591', NULL, 1, 0, NULL),
	(4449, 194, 1, NULL, 100, 'DSR', 124, '0591', NULL, 1, 0, NULL),
	(4451, 194, 2, NULL, 100, 'DSR', 126, '0592', NULL, 1, 0, NULL),
	(4452, 194, 2, NULL, 100, 'DSR', 127, '0592', NULL, 1, 0, NULL),
	(4453, 194, 2, NULL, 100, 'DSR', 128, '0592', NULL, 1, 0, NULL),
	(4454, 194, 2, NULL, 117, 'DSR', 129, '0592', NULL, 1, 0, NULL),
	(4455, 194, 2, NULL, 117, 'DSR', 130, '0592', NULL, 1, 0, NULL),
	(4456, 194, 2, NULL, 117, 'DSR', 131, '0592', NULL, 1, 0, NULL),
	(4457, 194, 2, NULL, 117, 'DSR', 132, '0592', NULL, 1, 0, NULL),
	(4458, 194, 2, NULL, 117, 'DSR', 133, '0592', NULL, 1, 0, NULL),
	(4459, 194, 2, NULL, 117, 'DSR', 134, '0592', NULL, 1, 0, NULL),
	(4460, 194, 2, NULL, 117, 'DSR', 135, '0592', NULL, 1, 0, NULL),
	(4461, 194, 2, NULL, 117, 'DSR', 136, '0592', NULL, 1, 0, NULL),
	(4462, 194, 2, NULL, 117, 'DSR', 137, '0592', NULL, 1, 0, NULL),
	(4463, 194, 2, NULL, 117, 'DSR', 138, '0592', NULL, 1, 0, NULL),
	(4464, 194, 2, NULL, 117, 'DSR', 139, '0592', NULL, 1, 0, NULL),
	(4465, 194, 2, NULL, 117, 'DSR', 140, '0592', NULL, 1, 0, NULL),
	(4466, 194, 2, NULL, 117, 'DSR', 141, '0592', NULL, 1, 0, NULL),
	(4467, 194, 2, NULL, 117, 'DSR', 142, '0592', NULL, 1, 0, NULL),
	(4468, 194, 2, NULL, 117, 'DSR', 143, '0592', NULL, 1, 0, NULL),
	(4469, 194, 2, NULL, 117, 'DSR', 144, '0592', NULL, 1, 0, NULL),
	(4470, 194, 2, NULL, 117, 'DSR', 145, '0592', NULL, 1, 0, NULL),
	(4471, 194, 3, NULL, 117, 'DSR', 146, '0593', NULL, 1, 0, NULL),
	(4472, 194, 3, NULL, 117, 'DSR', 147, '0593', NULL, 1, 0, NULL),
	(4473, 194, 3, NULL, 117, 'DSR', 148, '0593', NULL, 1, 0, NULL),
	(4474, 194, 3, NULL, 117, 'DSR', 149, '0593', NULL, 1, 0, NULL),
	(4475, 194, 3, NULL, 117, 'DSR', 150, '0593', NULL, 1, 0, NULL),
	(4476, 194, 3, NULL, 117, 'DSR', 151, '0593', NULL, 1, 0, NULL),
	(4477, 194, 3, NULL, 117, 'DSR', 152, '0593', NULL, 1, 0, NULL),
	(4478, 194, 3, NULL, 117, 'DSR', 153, '0593', NULL, 1, 0, NULL),
	(4479, 194, 3, NULL, 117, 'DSR', 154, '0593', NULL, 1, 0, NULL),
	(4480, 194, 3, NULL, 117, 'DSR', 155, '0593', NULL, 1, 0, NULL),
	(4481, 194, 3, NULL, 117, 'DSR', 156, '0593', NULL, 1, 0, NULL),
	(4482, 194, 3, NULL, 117, 'DSR', 157, '0593', NULL, 1, 0, NULL),
	(4483, 194, 3, NULL, 117, 'DSR', 158, '0593', NULL, 1, 0, NULL),
	(4484, 194, 3, NULL, 117, 'DSR', 159, '0593', NULL, 1, 0, NULL),
	(4485, 194, 3, NULL, 117, 'DSR', 160, '0593', NULL, 1, 0, NULL),
	(4486, 194, 3, NULL, 117, 'DSR', 161, '0593', NULL, 1, 0, NULL),
	(4487, 194, 3, NULL, 117, 'DSR', 162, '0593', NULL, 1, 0, NULL),
	(4488, 194, 3, NULL, 117, 'DSR', 163, '0593', NULL, 1, 0, NULL),
	(4489, 194, 3, NULL, 117, 'DSR', 164, '0593', NULL, 1, 0, NULL),
	(4490, 194, 3, NULL, 117, 'DSR', 165, '0593', NULL, 1, 0, NULL),
	(4491, 194, 3, NULL, 117, 'DSR', 166, '0593', NULL, 1, 0, NULL),
	(4493, 194, 1, '15:32:14', 100, 'DSR', 125, '0591', NULL, 1, 0, NULL),
	(4494, 196, 0, NULL, 120, '', 105, '0370', NULL, 1, 0, NULL),
	(4495, 196, 0, NULL, 120, '', 106, '0370', NULL, 1, 0, NULL),
	(4496, 196, 0, NULL, 120, '', 107, '0370', NULL, 1, 0, NULL),
	(4497, 196, 0, NULL, 120, '', 108, '0370', NULL, 1, 0, NULL),
	(4498, 196, 0, NULL, 120, '', 109, '0370', NULL, 1, 0, NULL),
	(4499, 196, 0, NULL, 120, '', 110, '0370', NULL, 1, 0, NULL),
	(4500, 196, 0, NULL, 120, '', 111, '0370', NULL, 1, 0, NULL),
	(4501, 196, 0, NULL, 120, '', 112, '0370', NULL, 1, 0, NULL),
	(4502, 196, 0, NULL, NULL, '', 113, '0370', NULL, 1, 0, NULL),
	(4503, 196, 0, NULL, NULL, '', 114, '0370', NULL, 1, 0, NULL),
	(4504, 196, 0, NULL, NULL, '', 115, '0370', NULL, 1, 0, NULL),
	(4505, 196, 0, NULL, NULL, '', 116, '0370', NULL, 1, 0, NULL),
	(4506, 196, 0, NULL, NULL, '', 117, '0370', NULL, 1, 0, NULL),
	(4507, 196, 0, NULL, NULL, '', 118, '0370', NULL, 1, 0, NULL),
	(4508, 196, 0, NULL, NULL, '', 119, '0370', NULL, 1, 0, NULL),
	(4509, 196, 0, NULL, NULL, '', 120, '0370', NULL, 1, 0, NULL),
	(4510, 196, 0, NULL, NULL, '', 121, '0370', NULL, 1, 0, NULL),
	(4511, 196, 0, NULL, NULL, '', 122, '0370', NULL, 1, 0, NULL),
	(4512, 196, 0, NULL, NULL, '', 123, '0370', NULL, 1, 0, NULL),
	(4513, 196, 0, NULL, NULL, '', 124, '0370', NULL, 1, 0, NULL),
	(4514, 196, 0, NULL, NULL, '', 125, '0370', NULL, 1, 0, NULL),
	(4515, 196, 0, NULL, NULL, '', 126, '0370', NULL, 1, 0, NULL),
	(4516, 196, 0, NULL, NULL, '', 127, '0370', NULL, 1, 0, NULL),
	(4517, 196, 0, NULL, NULL, '', 128, '0370', NULL, 1, 0, NULL),
	(4518, 196, 0, NULL, NULL, '', 129, '0370', NULL, 1, 0, NULL),
	(4519, 196, 0, NULL, NULL, '', 130, '0370', NULL, 1, 0, NULL),
	(4520, 196, 0, NULL, NULL, '', 131, '0371', NULL, 1, 0, NULL),
	(4521, 196, 0, NULL, NULL, '', 132, '0371', NULL, 1, 0, NULL),
	(4522, 196, 0, NULL, NULL, '', 133, '0371', NULL, 1, 0, NULL),
	(4523, 196, 0, NULL, NULL, '', 134, '0371', NULL, 1, 0, NULL),
	(4524, 196, 0, NULL, NULL, '', 135, '0371', NULL, 1, 0, NULL),
	(4525, 196, 0, NULL, NULL, '', 136, '0371', NULL, 1, 0, NULL),
	(4526, 196, 0, NULL, NULL, '', 137, '0371', NULL, 1, 0, NULL),
	(4527, 196, 0, NULL, NULL, '', 138, '0371', NULL, 1, 0, NULL),
	(4528, 196, 0, NULL, NULL, '', 139, '0371', NULL, 1, 0, NULL),
	(4529, 196, 0, NULL, NULL, '', 140, '0371', NULL, 1, 0, NULL),
	(4530, 196, 0, NULL, NULL, '', 141, '0371', NULL, 1, 0, NULL),
	(4531, 196, 0, NULL, NULL, '', 142, '0371', NULL, 1, 0, NULL),
	(4532, 196, 0, NULL, NULL, '', 143, '0371', NULL, 1, 0, NULL),
	(4533, 196, 0, NULL, NULL, '', 144, '0371', NULL, 1, 0, NULL),
	(4534, 196, 0, NULL, NULL, '', 145, '0371', NULL, 1, 0, NULL),
	(4535, 196, 0, NULL, NULL, '', 146, '0371', NULL, 1, 0, NULL),
	(4536, 196, 0, NULL, NULL, '', 147, '0371', NULL, 1, 0, NULL),
	(4537, 196, 0, NULL, NULL, '', 148, '0371', NULL, 1, 0, NULL),
	(4538, 196, 0, NULL, NULL, '', 149, '0371', NULL, 1, 0, NULL),
	(4539, 196, 0, NULL, NULL, '', 150, '0371', NULL, 1, 0, NULL),
	(4540, 196, 0, NULL, NULL, '', 151, '0371', NULL, 1, 0, NULL),
	(4541, 196, 0, NULL, NULL, '', 152, '0371', NULL, 1, 0, NULL),
	(4542, 196, 0, NULL, NULL, '', 153, '0371', NULL, 1, 0, NULL),
	(4543, 196, 0, NULL, NULL, '', 154, '0371', NULL, 1, 0, NULL),
	(4544, 196, 0, NULL, NULL, '', 155, '0371', NULL, 1, 0, NULL),
	(4545, 196, 0, NULL, NULL, '', 156, '0371', NULL, 1, 0, NULL),
	(4546, 197, 0, NULL, 117, '', 167, '0593', 0, 1, 0, NULL),
	(4547, 197, 0, NULL, 117, '', 168, '0593', 0, 1, 0, NULL),
	(4548, 197, 0, NULL, 117, '', 169, '0593', 0, 1, 0, NULL),
	(4549, 197, 0, NULL, 117, '', 170, '0593', 0, 1, 0, NULL),
	(4550, 197, 0, NULL, NULL, '', 171, '0594', 10974, 1, 0, NULL),
	(4551, 197, 0, NULL, NULL, '', 172, '0594', 11254, 1, 0, NULL),
	(4552, 197, 0, NULL, NULL, '', 173, '0594', 4055, 1, 0, NULL),
	(4553, 197, 0, NULL, NULL, '', 174, '0594', 5284, 1, 0, NULL),
	(4554, 197, 0, NULL, NULL, '', 175, '0594', 5210, 1, 0, NULL),
	(4555, 197, 0, NULL, NULL, '', 176, '0594', 152, 1, 0, NULL),
	(4556, 197, 0, NULL, NULL, '', 177, '0594', 12406, 1, 0, NULL),
	(4557, 197, 0, NULL, NULL, '', 178, '0594', 6634, 1, 0, NULL),
	(4558, 197, 0, NULL, NULL, '', 179, '0594', 11963, 1, 0, NULL),
	(4559, 197, 0, NULL, NULL, '', 180, '0594', 11400, 1, 0, NULL),
	(4560, 197, 0, NULL, NULL, '', 181, '0594', 10208, 1, 0, NULL),
	(4561, 197, 0, NULL, NULL, '', 182, '0594', 5291, 1, 0, NULL),
	(4562, 197, 0, NULL, NULL, '', 183, '0594', 2841, 1, 0, NULL),
	(4563, 197, 0, NULL, NULL, '', 184, '0594', 5352, 1, 0, NULL),
	(4564, 197, 0, NULL, NULL, '', 185, '0594', 8593, 1, 0, NULL),
	(4565, 197, 0, NULL, NULL, '', 186, '0594', 9382, 1, 0, NULL),
	(4566, 197, 0, NULL, NULL, '', 187, '0594', 10577, 1, 0, NULL),
	(4567, 197, 0, NULL, NULL, '', 188, '0595', 1022, 1, 0, NULL),
	(4568, 197, 0, NULL, NULL, '', 189, '0595', 11570, 1, 0, NULL),
	(4569, 197, 0, NULL, NULL, '', 190, '0595', 4178, 1, 0, NULL),
	(4570, 197, 0, NULL, NULL, '', 191, '0595', 3568, 1, 0, NULL),
	(4571, 197, 0, NULL, NULL, '', 192, '0595', 9277, 1, 0, NULL),
	(4572, 197, 0, NULL, NULL, '', 193, '0595', 5802, 1, 0, NULL),
	(4573, 197, 0, NULL, NULL, '', 194, '0595', 4040, 1, 0, NULL),
	(4574, 197, 0, NULL, NULL, '', 195, '0595', 12201, 1, 0, NULL),
	(4575, 197, 0, NULL, NULL, '', 196, '0595', 4247, 1, 0, NULL),
	(4576, 197, 0, NULL, NULL, '', 197, '0595', 13189, 1, 0, NULL),
	(4577, 197, 0, NULL, NULL, '', 198, '0595', 10118, 1, 0, NULL),
	(4578, 197, 0, NULL, NULL, '', 199, '0595', 4261, 1, 0, NULL),
	(4579, 197, 0, NULL, NULL, '', 200, '0595', 13414, 1, 0, NULL),
	(4580, 197, 0, NULL, NULL, '', 201, '0595', 1707, 1, 0, NULL),
	(4581, 197, 0, NULL, NULL, '', 202, '0595', 0, 1, 0, NULL),
	(4582, 197, 0, NULL, NULL, '', 203, '0595', 13678, 1, 0, NULL),
	(4583, 197, 0, NULL, NULL, '', 204, '0595', 8020, 1, 0, NULL),
	(4584, 197, 0, NULL, NULL, '', 205, '0595', 5108, 1, 0, NULL),
	(4585, 197, 0, NULL, NULL, '', 206, '0595', 9890, 1, 0, NULL),
	(4586, 197, 0, NULL, NULL, '', 207, '0595', 11422, 1, 0, NULL),
	(4587, 197, 0, NULL, NULL, '', 208, '0595', 9603, 1, 0, NULL),
	(4588, 197, 0, NULL, NULL, '', 209, '0595', 10286, 1, 0, NULL),
	(4589, 197, 0, NULL, NULL, '', 210, '0596', 790, 1, 0, NULL),
	(4590, 197, 0, NULL, NULL, '', 211, '0596', 11982, 1, 0, NULL),
	(4591, 197, 0, NULL, NULL, '', 212, '0596', 13780, 1, 0, NULL),
	(4592, 197, 0, NULL, NULL, '', 213, '0596', 1170, 1, 0, NULL),
	(4593, 197, 0, NULL, NULL, '', 214, '0596', 10594, 1, 0, NULL),
	(4594, 197, 0, NULL, NULL, '', 215, '0596', 6688, 1, 0, NULL),
	(4595, 197, 0, NULL, NULL, '', 216, '0596', 7437, 1, 0, NULL),
	(4596, 197, 0, NULL, NULL, '', 217, '0596', 3265, 1, 0, NULL),
	(4597, 197, 0, NULL, NULL, '', 218, '0596', 8437, 1, 0, NULL),
	(4598, 197, 0, NULL, NULL, '', 219, '0596', 7514, 1, 0, NULL),
	(4599, 197, 0, NULL, NULL, '', 220, '0596', 73040, 1, 0, NULL),
	(4600, 197, 0, NULL, NULL, '', 221, '0596', 10673, 1, 0, NULL),
	(4601, 197, 0, NULL, NULL, '', 222, '0596', 1219, 1, 0, NULL),
	(4602, 197, 0, NULL, NULL, '', 223, '0596', 2045, 1, 0, NULL),
	(4603, 197, 0, NULL, NULL, '', 224, '0596', 11855, 1, 0, NULL),
	(4604, 197, 0, NULL, NULL, '', 225, '0596', 2318, 1, 0, NULL),
	(4605, 197, 0, NULL, NULL, '', 226, '0596', 11976, 1, 0, NULL),
	(4606, 197, 0, NULL, NULL, '', 227, '0596', 5017, 1, 0, NULL),
	(4607, 197, 0, NULL, NULL, '', 228, '0596', 8444, 1, 0, NULL),
	(4608, 197, 0, NULL, NULL, '', 229, '0596', 4298, 1, 0, NULL),
	(4609, 197, 0, NULL, NULL, '', 230, '0596', 1152, 1, 0, NULL),
	(4610, 197, 0, NULL, NULL, '', 231, '0596', 9158, 1, 0, NULL),
	(4611, 198, 0, NULL, NULL, '', 100, '0117', 9286, 1, 0, NULL),
	(4612, 198, 0, NULL, NULL, '', 101, '0117', 10654, 1, 0, NULL),
	(4613, 198, 0, NULL, NULL, '', 102, '0117', 10457, 1, 0, NULL),
	(4614, 198, 0, NULL, NULL, '', 103, '0117', 788, 1, 0, NULL),
	(4615, 198, 0, NULL, NULL, '', 104, '0117', 13069, 1, 0, NULL),
	(4616, 198, 0, NULL, NULL, '', 105, '0117', 5714, 1, 0, NULL),
	(4617, 198, 0, NULL, NULL, '', 106, '0117', 9747, 1, 0, NULL),
	(4618, 198, 0, NULL, NULL, '', 107, '0117', 10758, 1, 0, NULL),
	(4619, 198, 0, NULL, NULL, '', 108, '0117', 4580, 1, 0, NULL),
	(4620, 198, 0, NULL, NULL, '', 109, '0117', 9317, 1, 0, NULL),
	(4621, 198, 0, NULL, NULL, '', 110, '0117', 5142, 1, 0, NULL),
	(4622, 198, 0, NULL, NULL, '', 111, '0117', 3598, 1, 0, NULL),
	(4623, 198, 0, NULL, NULL, '', 112, '0117', 10387, 1, 0, NULL),
	(4624, 198, 0, NULL, NULL, '', 113, '0117', 2369, 1, 0, NULL),
	(4625, 198, 0, NULL, NULL, '', 114, '0117', 9908, 1, 0, NULL),
	(4626, 198, 0, NULL, NULL, '', 115, '0117', 6065, 1, 0, NULL),
	(4627, 198, 0, NULL, NULL, '', 116, '0117', 2288, 1, 0, NULL),
	(4628, 198, 0, NULL, NULL, '', 117, '0117', 2734, 1, 0, NULL),
	(4629, 198, 0, NULL, NULL, '', 118, '0118', 9091, 1, 0, NULL),
	(4630, 198, 0, NULL, NULL, '', 119, '0118', 311, 1, 0, NULL),
	(4631, 198, 0, NULL, NULL, '', 120, '0118', 6346, 1, 0, NULL),
	(4632, 198, 0, NULL, NULL, '', 121, '0118', 10070, 1, 0, NULL),
	(4633, 198, 0, NULL, NULL, '', 122, '0118', 10979, 1, 0, NULL),
	(4634, 198, 0, NULL, NULL, '', 123, '0118', 6516, 1, 0, NULL),
	(4635, 198, 0, NULL, NULL, '', 124, '0118', 4460, 1, 0, NULL),
	(4636, 198, 0, NULL, NULL, '', 125, '0118', 516, 1, 0, NULL),
	(4637, 198, 0, NULL, NULL, '', 126, '0118', 3948, 1, 0, NULL),
	(4638, 198, 0, NULL, NULL, '', 127, '0118', 982, 1, 0, NULL),
	(4639, 198, 0, NULL, NULL, '', 128, '0118', 2947, 1, 0, NULL),
	(4640, 198, 0, NULL, NULL, '', 129, '0118', 10580, 1, 0, NULL),
	(4641, 198, 0, NULL, NULL, '', 130, '0118', 12553, 1, 0, NULL),
	(4642, 198, 0, NULL, NULL, '', 131, '0118', 4989, 1, 0, NULL),
	(4643, 198, 0, NULL, NULL, '', 132, '0118', 5211, 1, 0, NULL),
	(4644, 198, 0, NULL, NULL, '', 133, '0118', 12590, 1, 0, NULL),
	(4645, 198, 0, NULL, NULL, '', 134, '0118', 13486, 1, 0, NULL),
	(4646, 198, 0, NULL, NULL, '', 135, '0118', 2881, 1, 0, NULL),
	(4647, 198, 0, NULL, NULL, '', 136, '0119', 3330, 1, 0, NULL),
	(4648, 198, 0, NULL, NULL, '', 137, '0119', 3258, 1, 0, NULL),
	(4649, 198, 0, NULL, NULL, '', 138, '0119', 6183, 1, 0, NULL),
	(4650, 198, 0, NULL, NULL, '', 139, '0119', 2877, 1, 0, NULL),
	(4651, 198, 0, NULL, NULL, '', 140, '0119', 6220, 1, 0, NULL),
	(4652, 198, 0, NULL, NULL, '', 141, '0119', 11479, 1, 0, NULL),
	(4653, 198, 0, NULL, NULL, '', 142, '0119', 3838, 1, 0, NULL),
	(4654, 198, 0, NULL, NULL, '', 143, '0119', 6248, 1, 0, NULL),
	(4655, 198, 0, NULL, NULL, '', 144, '0119', 7820, 1, 0, NULL),
	(4656, 198, 0, NULL, NULL, '', 145, '0119', 6513, 1, 0, NULL),
	(4657, 198, 0, NULL, NULL, '', 146, '0119', 8427, 1, 0, NULL),
	(4658, 198, 0, NULL, NULL, '', 147, '0119', 1837, 1, 0, NULL),
	(4659, 198, 0, NULL, NULL, '', 148, '0119', 2034, 1, 0, NULL),
	(4660, 198, 0, NULL, NULL, '', 149, '0119', 3689, 1, 0, NULL),
	(4661, 198, 0, NULL, NULL, '', 150, '0119', 2799, 1, 0, NULL),
	(4662, 198, 0, NULL, NULL, '', 151, '0119', 2738, 1, 0, NULL),
	(4663, 198, 0, NULL, NULL, '', 152, '0119', 9404, 1, 0, NULL),
	(4664, 198, 0, NULL, NULL, '', 153, '0119', 0, 1, 0, NULL),
	(4672, 199, 0, NULL, NULL, '', 157, '0372', NULL, 1, 0, NULL),
	(4673, 199, 0, NULL, NULL, '', 158, '0372', NULL, 1, 0, NULL),
	(4674, 199, 0, NULL, NULL, '', 159, '0372', NULL, 1, 0, NULL),
	(4675, 199, 0, NULL, NULL, '', 160, '0372', NULL, 1, 0, NULL),
	(4676, 199, 0, NULL, NULL, '', 161, '0372', NULL, 1, 0, NULL),
	(4677, 199, 0, NULL, NULL, '', 162, '0372', NULL, 1, 0, NULL),
	(4678, 199, 0, NULL, NULL, '', 163, '0372', NULL, 1, 0, NULL),
	(4679, 199, 0, NULL, NULL, '', 164, '0372', NULL, 1, 0, NULL),
	(4680, 199, 0, NULL, NULL, '', 165, '0372', NULL, 1, 0, NULL),
	(4681, 199, 0, NULL, NULL, '', 166, '0372', NULL, 1, 0, NULL),
	(4682, 199, 0, NULL, NULL, '', 167, '0372', NULL, 1, 0, NULL),
	(4683, 199, 0, NULL, NULL, '', 168, '0372', NULL, 1, 0, NULL),
	(4684, 199, 0, NULL, NULL, '', 169, '0372', NULL, 1, 0, NULL),
	(4685, 199, 0, NULL, NULL, '', 170, '0372', NULL, 1, 0, NULL),
	(4686, 199, 0, NULL, NULL, '', 171, '0372', NULL, 1, 0, NULL),
	(4687, 199, 0, NULL, NULL, '', 172, '0372', NULL, 1, 0, NULL),
	(4688, 199, 0, NULL, NULL, '', 173, '0372', NULL, 1, 0, NULL),
	(4689, 199, 0, NULL, NULL, '', 174, '0372', NULL, 1, 0, NULL),
	(4690, 199, 0, NULL, NULL, '', 175, '0372', NULL, 1, 0, NULL),
	(4691, 199, 0, NULL, NULL, '', 176, '0372', NULL, 1, 0, NULL),
	(4692, 199, 0, NULL, NULL, '', 177, '0372', NULL, 1, 0, NULL),
	(4693, 199, 0, NULL, NULL, '', 178, '0372', NULL, 1, 0, NULL),
	(4694, 199, 0, NULL, NULL, '', 179, '0373', NULL, 1, 0, NULL),
	(4695, 199, 0, NULL, NULL, '', 180, '0373', NULL, 1, 0, NULL),
	(4696, 199, 0, NULL, NULL, '', 181, '0373', NULL, 1, 0, NULL),
	(4697, 199, 0, NULL, NULL, '', 182, '0373', NULL, 1, 0, NULL),
	(4698, 199, 0, NULL, NULL, '', 183, '0373', NULL, 1, 0, NULL),
	(4699, 199, 0, NULL, NULL, '', 184, '0373', NULL, 1, 0, NULL),
	(4700, 199, 0, NULL, NULL, '', 185, '0373', NULL, 1, 0, NULL),
	(4701, 199, 0, NULL, NULL, '', 186, '0373', NULL, 1, 0, NULL),
	(4702, 199, 0, NULL, NULL, '', 187, '0373', NULL, 1, 0, NULL),
	(4703, 199, 0, NULL, NULL, '', 188, '0373', NULL, 1, 0, NULL),
	(4704, 199, 0, NULL, NULL, '', 189, '0373', NULL, 1, 0, NULL),
	(4705, 199, 0, NULL, NULL, '', 190, '0373', NULL, 1, 0, NULL),
	(4706, 199, 0, NULL, NULL, '', 191, '0373', NULL, 1, 0, NULL),
	(4707, 199, 0, NULL, NULL, '', 192, '0373', NULL, 1, 0, NULL),
	(4708, 199, 0, NULL, NULL, '', 193, '0373', NULL, 1, 0, NULL),
	(4709, 199, 0, NULL, NULL, '', 194, '0373', NULL, 1, 0, NULL),
	(4710, 199, 0, NULL, NULL, '', 195, '0373', NULL, 1, 0, NULL),
	(4711, 199, 0, NULL, NULL, '', 196, '0373', NULL, 1, 0, NULL),
	(4712, 199, 0, NULL, NULL, '', 197, '0373', NULL, 1, 0, NULL),
	(4713, 199, 0, NULL, NULL, '', 198, '0373', NULL, 1, 0, NULL),
	(4714, 199, 0, NULL, NULL, '', 199, '0373', NULL, 1, 0, NULL),
	(4715, 199, 0, NULL, NULL, '', 200, '0373', NULL, 1, 0, NULL),
	(4716, 199, 0, NULL, NULL, '', 201, '0373', NULL, 1, 0, NULL),
	(4717, 199, 0, NULL, NULL, '', 202, '0373', NULL, 1, 0, NULL),
	(4718, 199, 0, NULL, NULL, '', 203, '0373', NULL, 1, 0, NULL),
	(4719, 199, 0, NULL, NULL, '', 204, '0373', NULL, 1, 0, NULL),
	(4782, 200, 0, NULL, NULL, '', 232, '0597', 11144, 1, 0, NULL),
	(4783, 200, 0, NULL, NULL, '', 233, '0597', 6940, 1, 0, NULL),
	(4784, 200, 0, NULL, NULL, '', 234, '0597', 9375, 1, 0, NULL),
	(4785, 200, 0, NULL, NULL, '', 235, '0597', 3922, 1, 0, NULL),
	(4786, 200, 0, NULL, NULL, '', 236, '0597', 13777, 1, 0, NULL),
	(4787, 200, 0, NULL, NULL, '', 237, '0597', 6142, 1, 0, NULL),
	(4788, 200, 0, NULL, NULL, '', 238, '0597', 1710, 1, 0, NULL),
	(4789, 200, 0, NULL, NULL, '', 239, '0597', 13130, 1, 0, NULL),
	(4790, 200, 0, NULL, NULL, '', 240, '0597', 11389, 1, 0, NULL),
	(4791, 200, 0, NULL, NULL, '', 241, '0597', 7584, 1, 0, NULL),
	(4792, 200, 0, NULL, NULL, '', 242, '0597', 6974, 1, 0, NULL),
	(4793, 200, 0, NULL, NULL, '', 243, '0597', 12818, 1, 0, NULL),
	(4794, 200, 0, NULL, NULL, '', 244, '0597', 7698, 1, 0, NULL),
	(4795, 200, 0, NULL, NULL, '', 245, '0597', 6148, 1, 0, NULL),
	(4796, 200, 0, NULL, NULL, '', 246, '0597', 1511, 1, 0, NULL),
	(4797, 200, 0, NULL, NULL, '', 247, '0597', 7604, 1, 0, NULL),
	(4798, 200, 0, NULL, NULL, '', 248, '0597', 4214, 1, 0, NULL),
	(4799, 200, 0, NULL, NULL, '', 249, '0597', 5436, 1, 0, NULL),
	(4800, 200, 0, NULL, NULL, '', 250, '0597', 1305, 1, 0, NULL),
	(4801, 200, 0, NULL, NULL, '', 251, '0597', 13294, 1, 0, NULL),
	(4802, 200, 0, NULL, NULL, '', 252, '0597', 8066, 1, 0, NULL),
	(4803, 200, 0, NULL, NULL, '', 253, '0597', 4790, 1, 0, NULL),
	(4804, 200, 0, NULL, NULL, '', 254, '0598', 1217, 1, 0, NULL),
	(4805, 200, 0, NULL, NULL, '', 255, '0598', 6716, 1, 0, NULL),
	(4806, 200, 0, NULL, NULL, '', 256, '0598', 1151, 1, 0, NULL),
	(4807, 200, 0, NULL, NULL, '', 257, '0598', 6848, 1, 0, NULL),
	(4808, 200, 0, NULL, NULL, '', 258, '0598', 2657, 1, 0, NULL),
	(4809, 200, 0, NULL, NULL, '', 259, '0598', 1324, 1, 0, NULL),
	(4810, 200, 0, NULL, NULL, '', 260, '0598', 8741, 1, 0, NULL),
	(4811, 200, 0, NULL, NULL, '', 261, '0598', 7998, 1, 0, NULL),
	(4812, 200, 0, NULL, NULL, '', 262, '0598', 9495, 1, 0, NULL),
	(4813, 200, 0, NULL, NULL, '', 263, '0598', 1571, 1, 0, NULL),
	(4814, 200, 0, NULL, NULL, '', 264, '0598', 12087, 1, 0, NULL),
	(4815, 200, 0, NULL, NULL, '', 265, '0598', 9327, 1, 0, NULL),
	(4816, 200, 0, NULL, NULL, '', 266, '0598', 3369, 1, 0, NULL),
	(4817, 200, 0, NULL, NULL, '', 267, '0598', 194, 1, 0, NULL),
	(4818, 200, 0, NULL, NULL, '', 268, '0598', 13669, 1, 0, NULL),
	(4819, 200, 0, NULL, NULL, '', 269, '0598', 8858, 1, 0, NULL),
	(4820, 200, 0, NULL, NULL, '', 270, '0598', 13396, 1, 0, NULL),
	(4821, 200, 0, NULL, NULL, '', 271, '0598', 4348, 1, 0, NULL),
	(4822, 200, 0, NULL, NULL, '', 272, '0598', 2352, 1, 0, NULL),
	(4823, 200, 0, NULL, NULL, '', 273, '0598', 11198, 1, 0, NULL),
	(4824, 200, 0, NULL, NULL, '', 274, '0598', 13667, 1, 0, NULL),
	(4825, 200, 0, NULL, NULL, '', 275, '0598', 5172, 1, 0, NULL),
	(4826, 200, 0, NULL, NULL, '', 276, '0599', 9170, 1, 0, NULL),
	(4827, 200, 0, NULL, NULL, '', 277, '0599', 2358, 1, 0, NULL),
	(4828, 200, 0, NULL, NULL, '', 278, '0599', 10925, 1, 0, NULL),
	(4829, 200, 0, NULL, NULL, '', 279, '0599', 3523, 1, 0, NULL),
	(4830, 200, 0, NULL, NULL, '', 280, '0599', 11716, 1, 0, NULL),
	(4831, 200, 0, NULL, NULL, '', 281, '0599', 1947, 1, 0, NULL),
	(4832, 200, 0, NULL, NULL, '', 282, '0599', 8502, 1, 0, NULL),
	(4833, 200, 0, NULL, NULL, '', 283, '0599', 7110, 1, 0, NULL),
	(4834, 200, 0, NULL, NULL, '', 284, '0599', 10587, 1, 0, NULL),
	(4835, 200, 0, NULL, NULL, '', 285, '0599', 7532, 1, 0, NULL),
	(4836, 200, 0, NULL, NULL, '', 286, '0599', 3968, 1, 0, NULL),
	(4837, 200, 0, NULL, NULL, '', 287, '0599', 6085, 1, 0, NULL),
	(4838, 200, 0, NULL, NULL, '', 288, '0599', 10538, 1, 0, NULL),
	(4839, 200, 0, NULL, NULL, '', 289, '0599', 5926, 1, 0, NULL),
	(4840, 200, 0, NULL, NULL, '', 290, '0599', 7818, 1, 0, NULL),
	(4841, 200, 0, NULL, NULL, '', 291, '0599', 2606, 1, 0, NULL),
	(4842, 200, 0, NULL, NULL, '', 292, '0599', 13323, 1, 0, NULL),
	(4843, 200, 0, NULL, NULL, '', 293, '0599', 8023, 1, 0, NULL),
	(4844, 200, 0, NULL, NULL, '', 294, '0599', 3104, 1, 0, NULL),
	(4845, 200, 0, NULL, NULL, '', 295, '0599', 1291, 1, 0, NULL),
	(4846, 200, 0, NULL, NULL, '', 296, '0599', 12733, 1, 0, NULL),
	(4847, 200, 0, NULL, NULL, '', 297, '0599', 13634, 1, 0, NULL),
	(4848, 201, 0, NULL, NULL, '', 154, '0120', 4537, 1, 0, NULL),
	(4849, 201, 0, NULL, NULL, '', 155, '0120', 8009, 1, 0, NULL),
	(4850, 201, 0, NULL, NULL, '', 156, '0120', 10601, 1, 0, NULL),
	(4851, 201, 0, NULL, NULL, '', 157, '0120', 11010, 1, 0, NULL),
	(4852, 201, 0, NULL, NULL, '', 158, '0120', 1036, 1, 0, NULL),
	(4853, 201, 0, NULL, NULL, '', 159, '0120', 2274, 1, 0, NULL),
	(4854, 201, 0, NULL, NULL, '', 160, '0120', 12177, 1, 0, NULL),
	(4855, 201, 0, NULL, NULL, '', 161, '0120', 6766, 1, 0, NULL),
	(4856, 201, 0, NULL, NULL, '', 162, '0120', 5363, 1, 0, NULL),
	(4857, 201, 0, NULL, NULL, '', 163, '0120', 7922, 1, 0, NULL),
	(4858, 201, 0, NULL, NULL, '', 164, '0120', 2286, 1, 0, NULL),
	(4859, 201, 0, NULL, NULL, '', 165, '0120', 7255, 1, 0, NULL),
	(4860, 201, 0, NULL, NULL, '', 166, '0120', 13355, 1, 0, NULL),
	(4861, 201, 0, NULL, NULL, '', 167, '0120', 6682, 1, 0, NULL),
	(4862, 201, 0, NULL, NULL, '', 168, '0120', 5440, 1, 0, NULL),
	(4863, 201, 0, NULL, NULL, '', 169, '0120', 3115, 1, 0, NULL),
	(4864, 201, 0, NULL, NULL, '', 170, '0120', 11393, 1, 0, NULL),
	(4865, 201, 0, NULL, NULL, '', 171, '0121', 6785, 1, 0, NULL),
	(4866, 201, 0, NULL, NULL, '', 172, '0121', 1912, 1, 0, NULL),
	(4867, 201, 0, NULL, NULL, '', 173, '0121', 4170, 1, 0, NULL),
	(4868, 201, 0, NULL, NULL, '', 174, '0121', 5175, 1, 0, NULL),
	(4869, 201, 0, NULL, NULL, '', 175, '0121', 4362, 1, 0, NULL),
	(4870, 201, 0, NULL, NULL, '', 176, '0121', 6898, 1, 0, NULL),
	(4871, 201, 0, NULL, NULL, '', 177, '0121', 2996, 1, 0, NULL),
	(4872, 201, 0, NULL, NULL, '', 178, '0121', 12502, 1, 0, NULL),
	(4873, 201, 0, NULL, NULL, '', 179, '0121', 2561, 1, 0, NULL),
	(4874, 201, 0, NULL, NULL, '', 180, '0121', 5647, 1, 0, NULL),
	(4875, 201, 0, NULL, NULL, '', 181, '0121', 2161, 1, 0, NULL),
	(4876, 201, 0, NULL, NULL, '', 182, '0121', 7917, 1, 0, NULL),
	(4877, 201, 0, NULL, NULL, '', 183, '0121', 8966, 1, 0, NULL),
	(4878, 201, 0, NULL, NULL, '', 184, '0121', 5131, 1, 0, NULL),
	(4879, 201, 0, NULL, NULL, '', 185, '0121', 6729, 1, 0, NULL),
	(4880, 201, 0, NULL, NULL, '', 186, '0121', 12988, 1, 0, NULL),
	(4881, 201, 0, NULL, NULL, '', 187, '0121', 4391, 1, 0, NULL),
	(4882, 201, 0, NULL, NULL, '', 188, '0121', 2283, 1, 0, NULL),
	(4883, 201, 0, NULL, NULL, '', 189, '0122', 13110, 1, 0, NULL),
	(4884, 201, 0, NULL, NULL, '', 190, '0122', 1884, 1, 0, NULL),
	(4885, 201, 0, NULL, NULL, '', 191, '0122', 3175, 1, 0, NULL),
	(4886, 201, 0, NULL, NULL, '', 192, '0122', 13752, 1, 0, NULL),
	(4887, 201, 0, NULL, NULL, '', 193, '0122', 3260, 1, 0, NULL),
	(4888, 201, 0, NULL, NULL, '', 194, '0122', 6344, 1, 0, NULL),
	(4889, 201, 0, NULL, NULL, '', 195, '0122', 8762, 1, 0, NULL),
	(4890, 201, 0, NULL, NULL, '', 196, '0122', 12925, 1, 0, NULL),
	(4891, 201, 0, NULL, NULL, '', 197, '0122', 7238, 1, 0, NULL),
	(4892, 201, 0, NULL, NULL, '', 198, '0122', 8027, 1, 0, NULL),
	(4893, 201, 0, NULL, NULL, '', 199, '0122', 7168, 1, 0, NULL),
	(4894, 201, 0, NULL, NULL, '', 200, '0122', 4041, 1, 0, NULL),
	(4895, 201, 0, NULL, NULL, '', 201, '0122', 2246, 1, 0, NULL),
	(4896, 201, 0, NULL, NULL, '', 202, '0122', 6478, 1, 0, NULL),
	(4897, 201, 0, NULL, NULL, '', 203, '0122', 6577, 1, 0, NULL),
	(4898, 201, 0, NULL, NULL, '', 204, '0122', 7268, 1, 0, NULL),
	(4899, 201, 0, NULL, NULL, '', 205, '0122', 12624, 1, 0, NULL),
	(4900, 201, 0, NULL, NULL, '', 206, '0122', 5959, 1, 0, NULL),
	(4989, 202, 0, NULL, NULL, '', 298, '0600', 8077, 1, 0, NULL),
	(4990, 202, 0, NULL, NULL, '', 299, '0600', 3737, 1, 0, NULL),
	(4991, 202, 0, NULL, NULL, '', 300, '0600', 6483, 1, 0, NULL),
	(4992, 202, 0, NULL, NULL, '', 301, '0600', 7174, 1, 0, NULL),
	(4993, 202, 0, NULL, NULL, '', 302, '0600', 6052, 1, 0, NULL),
	(4994, 202, 0, NULL, NULL, '', 303, '0600', 1994, 1, 0, NULL),
	(4995, 202, 0, NULL, NULL, '', 304, '0600', 4546, 1, 0, NULL),
	(4996, 202, 0, NULL, NULL, '', 305, '0600', 7657, 1, 0, NULL),
	(4997, 202, 0, NULL, NULL, '', 306, '0600', 1665, 1, 0, NULL),
	(4998, 202, 0, NULL, NULL, '', 307, '0600', 11801, 1, 0, NULL),
	(4999, 202, 0, NULL, NULL, '', 308, '0600', 10956, 1, 0, NULL),
	(5000, 202, 0, NULL, NULL, '', 309, '0600', 906, 1, 0, NULL),
	(5001, 202, 0, NULL, NULL, '', 310, '0600', 1017, 1, 0, NULL),
	(5002, 202, 0, NULL, NULL, '', 311, '0600', 13727, 1, 0, NULL),
	(5003, 202, 0, NULL, NULL, '', 312, '0600', 13781, 1, 0, NULL),
	(5004, 202, 0, NULL, NULL, '', 313, '0600', 13706, 1, 0, NULL),
	(5005, 202, 0, NULL, NULL, '', 314, '0600', 13695, 1, 0, NULL),
	(5006, 202, 0, NULL, NULL, '', 315, '0600', 13775, 1, 0, NULL),
	(5007, 202, 0, NULL, NULL, '', 316, '0600', 4937, 1, 0, NULL),
	(5008, 202, 0, NULL, NULL, '', 317, '0600', 8692, 1, 0, NULL),
	(5009, 202, 0, NULL, NULL, '', 318, '0600', 12853, 1, 0, NULL),
	(5010, 202, 0, NULL, NULL, '', 319, '0600', 2743, 1, 0, NULL),
	(5011, 202, 0, NULL, NULL, '', 320, '0601', 9934, 1, 0, NULL),
	(5012, 202, 0, NULL, NULL, '', 321, '0601', 3563, 1, 0, NULL),
	(5013, 202, 0, NULL, NULL, '', 322, '0601', 9967, 1, 0, NULL),
	(5014, 202, 0, NULL, NULL, '', 323, '0601', 7788, 1, 0, NULL),
	(5015, 202, 0, NULL, NULL, '', 324, '0601', 8398, 1, 0, NULL),
	(5016, 202, 0, NULL, NULL, '', 325, '0601', 4640, 1, 0, NULL),
	(5017, 202, 0, NULL, NULL, '', 326, '0601', 5562, 1, 0, NULL),
	(5018, 202, 0, NULL, NULL, '', 327, '0601', 7108, 1, 0, NULL),
	(5019, 202, 0, NULL, NULL, '', 328, '0601', 12303, 1, 0, NULL),
	(5020, 202, 0, NULL, NULL, '', 329, '0601', 9932, 1, 0, NULL),
	(5021, 202, 0, NULL, NULL, '', 330, '0601', 4207, 1, 0, NULL),
	(5022, 202, 0, NULL, NULL, '', 331, '0601', 5303, 1, 0, NULL),
	(5023, 202, 0, NULL, NULL, '', 332, '0601', 9148, 1, 0, NULL),
	(5024, 202, 0, NULL, NULL, '', 333, '0601', 471, 1, 0, NULL),
	(5025, 202, 0, NULL, NULL, '', 334, '0601', 10918, 1, 0, NULL),
	(5026, 202, 0, NULL, NULL, '', 335, '0601', 3860, 1, 0, NULL),
	(5027, 202, 0, NULL, NULL, '', 336, '0601', 7112, 1, 0, NULL),
	(5028, 202, 0, NULL, NULL, '', 337, '0601', 3188, 1, 0, NULL),
	(5029, 202, 0, NULL, NULL, '', 338, '0601', 6924, 1, 0, NULL),
	(5030, 203, 0, NULL, NULL, '', 207, '0123', 4327, 1, 0, NULL),
	(5031, 203, 0, NULL, NULL, '', 208, '0123', 1818, 1, 0, NULL),
	(5033, 203, 0, NULL, NULL, '', 209, '0123', 3421, 1, 0, NULL),
	(5034, 203, 0, NULL, NULL, '', 210, '0123', 8909, 1, 0, NULL),
	(5035, 204, 0, NULL, NULL, '', 1, '0001', 4166, 1, 0, NULL),
	(5036, 204, 0, NULL, NULL, '', 2, '0001', 11092, 1, 0, NULL),
	(5037, 204, 0, NULL, NULL, '', 3, '0001', 6388, 1, 0, NULL),
	(5038, 204, 0, NULL, NULL, '', 4, '0001', 11780, 1, 0, NULL),
	(5039, 204, 0, NULL, NULL, '', 5, '0001', 12850, 1, 0, NULL),
	(5040, 204, 0, NULL, NULL, '', 6, '0001', 6719, 1, 0, NULL),
	(5041, 204, 0, NULL, NULL, '', 7, '0001', 9126, 1, 0, NULL),
	(5042, 204, 0, NULL, NULL, '', 8, '0001', 10551, 1, 0, NULL),
	(5043, 204, 0, NULL, NULL, '', 9, '0001', 6433, 1, 0, NULL),
	(5044, 204, 0, NULL, NULL, '', 10, '0001', 10034, 1, 0, NULL),
	(5045, 204, 0, NULL, NULL, '', 11, '0001', 427, 1, 0, NULL),
	(5046, 204, 0, NULL, NULL, '', 12, '0002', 8545, 1, 0, NULL),
	(5047, 204, 0, NULL, NULL, '', 13, '0002', 3429, 1, 0, NULL),
	(5048, 204, 0, NULL, NULL, '', 14, '0002', 4521, 1, 0, NULL),
	(5049, 204, 0, NULL, NULL, '', 15, '0002', 3100, 1, 0, NULL),
	(5050, 204, 0, NULL, NULL, '', 16, '0002', 40571, 1, 0, NULL),
	(5051, 204, 0, NULL, NULL, '', 17, '0002', 12205, 1, 0, NULL),
	(5052, 204, 0, NULL, NULL, '', 18, '0002', 5563, 1, 0, NULL),
	(5053, 204, 0, NULL, NULL, '', 19, '0002', 2640, 1, 0, NULL),
	(5054, 204, 0, NULL, NULL, '', 20, '0002', 12790, 1, 0, NULL),
	(5055, 204, 0, NULL, NULL, '', 21, '0002', 4459, 1, 0, NULL),
	(5056, 204, 0, NULL, NULL, '', 22, '0002', 577, 1, 0, NULL),
	(5057, 204, 0, NULL, NULL, '', 23, '0002', 13779, 1, 0, NULL),
	(5058, 204, 0, NULL, NULL, '', 24, '0002', 2236, 1, 0, NULL),
	(5059, 204, 0, NULL, NULL, '', 25, '0002', 11125, 1, 0, NULL),
	(5060, 204, 0, NULL, NULL, '', 26, '0002', 5264, 1, 0, NULL),
	(5061, 204, 0, NULL, NULL, '', 27, '0002', 9539, 1, 0, NULL),
	(5062, 204, 0, NULL, NULL, '', 28, '0002', 9688, 1, 0, NULL),
	(5063, 204, 0, NULL, NULL, '', 29, '0002', 3072, 1, 0, NULL),
	(5064, 204, 0, NULL, NULL, '', 30, '0002', 9282, 1, 0, NULL),
	(5065, 204, 0, NULL, NULL, '', 31, '0002', 7868, 1, 0, NULL),
	(5066, 204, 0, NULL, NULL, '', 32, '0002', 11419, 1, 0, NULL),
	(5067, 204, 0, NULL, NULL, '', 33, '0002', 8912, 1, 0, NULL),
	(5068, 204, 0, NULL, NULL, '', 34, '0003', 7086, 1, 0, NULL),
	(5069, 204, 0, NULL, NULL, '', 35, '0003', 12164, 1, 0, NULL),
	(5070, 204, 0, NULL, NULL, '', 36, '0003', 13679, 1, 0, NULL),
	(5071, 204, 0, NULL, NULL, '', 37, '0003', 7316, 1, 0, NULL),
	(5072, 204, 0, NULL, NULL, '', 38, '0003', 3442, 1, 0, NULL),
	(5073, 204, 0, NULL, NULL, '', 39, '0003', 8098, 1, 0, NULL),
	(5074, 204, 0, NULL, NULL, '', 40, '0003', 3131, 1, 0, NULL),
	(5075, 204, 0, NULL, NULL, '', 41, '0003', 2164, 1, 0, NULL),
	(5076, 204, 0, NULL, NULL, '', 42, '0003', 4176, 1, 0, NULL),
	(5077, 204, 0, NULL, NULL, '', 43, '0003', 5280, 1, 0, NULL),
	(5078, 204, 0, NULL, NULL, '', 44, '0003', 8606, 1, 0, NULL),
	(5079, 204, 0, NULL, NULL, '', 45, '0003', 3165, 1, 0, NULL),
	(5080, 204, 0, NULL, NULL, '', 46, '0003', 12260, 1, 0, NULL),
	(5081, 204, 0, NULL, NULL, '', 47, '0003', 11668, 1, 0, NULL),
	(5082, 204, 0, NULL, NULL, '', 48, '0003', 3812, 1, 0, NULL),
	(5083, 204, 0, NULL, NULL, '', 49, '0003', 4859, 1, 0, NULL),
	(5084, 204, 0, NULL, NULL, '', 50, '0003', 2982, 1, 0, NULL),
	(5085, 204, 0, NULL, NULL, '', 51, '0003', 3888, 1, 0, NULL),
	(5086, 204, 0, NULL, NULL, '', 52, '0003', 4357, 1, 0, NULL),
	(5087, 204, 0, NULL, NULL, '', 53, '0003', 11949, 1, 0, NULL),
	(5088, 204, 0, NULL, NULL, '', 54, '0003', 5832, 1, 0, NULL),
	(5089, 204, 0, NULL, NULL, '', 55, '0003', 1411, 1, 0, NULL),
	(5090, 204, 0, NULL, NULL, '', 56, '0003', 10053, 1, 0, NULL),
	(5091, 205, 0, NULL, NULL, '', 1, '0001', 0, 15, 0, NULL),
	(5092, 205, 0, NULL, NULL, '', 2, '0001', 0, 15, 0, NULL),
	(5093, 205, 0, NULL, NULL, '', 3, '0001', 0, 15, 0, NULL),
	(5094, 205, 0, NULL, NULL, '', 4, '0001', 0, 15, 0, NULL),
	(5095, 205, 0, NULL, NULL, '', 5, '0001', 0, 15, 0, NULL),
	(5096, 205, 0, NULL, NULL, '', 6, '0001', 0, 15, 0, NULL),
	(5097, 205, 0, NULL, NULL, '', 7, '0001', 0, 15, 0, NULL),
	(5098, 205, 0, NULL, NULL, '', 8, '0001', 0, 15, 0, NULL),
	(5099, 205, 0, NULL, NULL, '', 9, '0001', 0, 15, 0, NULL),
	(5100, 205, 0, NULL, NULL, '', 10, '0001', 0, 15, 0, NULL),
	(5101, 205, 0, NULL, NULL, '', 11, '0001', 0, 15, 0, NULL),
	(5102, 205, 0, NULL, NULL, '', 12, '0002', 0, 15, 0, NULL),
	(5103, 205, 0, NULL, NULL, '', 13, '0002', 0, 15, 0, NULL),
	(5104, 205, 0, NULL, NULL, '', 14, '0002', 0, 15, 0, NULL),
	(5105, 205, 0, NULL, NULL, '', 15, '0002', 0, 15, 0, NULL),
	(5106, 205, 0, NULL, NULL, '', 16, '0002', 0, 15, 0, NULL),
	(5107, 205, 0, NULL, NULL, '', 17, '0002', 0, 15, 0, NULL),
	(5108, 205, 0, NULL, NULL, '', 18, '0002', 0, 15, 0, NULL),
	(5109, 206, 0, NULL, NULL, '', 1, '0002', 2473, 1, 0, NULL),
	(5110, 206, 0, NULL, NULL, '', 2, '0002', 13265, 1, 0, NULL),
	(5111, 206, 0, NULL, NULL, '', 3, '0002', 4335, 1, 0, NULL),
	(5112, 206, 0, NULL, NULL, '', 4, '0002', 2601, 1, 0, NULL),
	(5113, 206, 0, NULL, NULL, '', 5, '0002', 5616, 1, 0, NULL),
	(5114, 206, 0, NULL, NULL, '', 6, '0002', 13761, 1, 0, NULL),
	(5115, 206, 0, NULL, NULL, '', 7, '0002', 4685, 1, 0, NULL),
	(5116, 206, 0, NULL, NULL, '', 8, '0002', 8718, 1, 0, NULL),
	(5117, 206, 0, NULL, NULL, '', 9, '0002', 5375, 1, 0, NULL),
	(5118, 206, 0, NULL, NULL, '', 10, '0002', 5918, 1, 0, NULL),
	(5119, 206, 0, NULL, NULL, '', 11, '0002', 10147, 1, 0, NULL),
	(5120, 206, 0, NULL, NULL, '', 12, '0002', 2163, 1, 0, NULL),
	(5121, 206, 0, NULL, NULL, '', 13, '0002', 5543, 1, 0, NULL),
	(5122, 206, 0, NULL, NULL, '', 14, '0002', 4231, 1, 0, NULL),
	(5123, 206, 0, NULL, NULL, '', 15, '0002', 6935, 1, 0, NULL),
	(5124, 206, 0, NULL, NULL, '', 16, '0002', 2144, 1, 0, NULL),
	(5125, 206, 0, NULL, NULL, '', 17, '0002', 4814, 1, 0, NULL),
	(5126, 206, 0, NULL, NULL, '', 18, '0002', 5823, 1, 0, NULL),
	(5127, 206, 0, NULL, NULL, '', 19, '0002', 5091, 1, 0, NULL),
	(5128, 206, 0, NULL, NULL, '', 20, '0002', 4894, 1, 0, NULL),
	(5129, 206, 0, NULL, NULL, '', 21, '0002', 4663, 1, 0, NULL),
	(5130, 206, 0, NULL, NULL, '', 22, '0002', 13637, 1, 0, NULL),
	(5131, 206, 0, NULL, NULL, '', 23, '0002', 4724, 1, 0, NULL),
	(5132, 206, 0, NULL, NULL, '', 24, '0002', 2623, 1, 0, NULL),
	(5133, 206, 0, NULL, NULL, '', 25, '0002', 9364, 1, 0, NULL),
	(5134, 206, 0, NULL, NULL, '', 26, '0002', 12623, 1, 0, NULL),
	(5135, 206, 0, NULL, NULL, '', 27, '0003', 4880, 1, 0, NULL),
	(5136, 206, 0, NULL, NULL, '', 28, '0003', 2227, 1, 0, NULL),
	(5137, 206, 0, NULL, NULL, '', 29, '0003', 2082, 1, 0, NULL),
	(5138, 206, 0, NULL, NULL, '', 30, '0003', 5135, 1, 0, NULL),
	(5139, 206, 0, NULL, NULL, '', 31, '0003', 3872, 1, 0, NULL),
	(5140, 206, 0, NULL, NULL, '', 32, '0003', 6889, 1, 0, NULL),
	(5141, 206, 0, NULL, NULL, '', 33, '0003', 6020, 1, 0, NULL),
	(5142, 206, 0, NULL, NULL, '', 34, '0003', 7114, 1, 0, NULL),
	(5143, 206, 0, NULL, NULL, '', 35, '0003', 4021, 1, 0, NULL),
	(5144, 206, 0, NULL, NULL, '', 36, '0003', 6249, 1, 0, NULL),
	(5145, 206, 0, NULL, NULL, '', 37, '0003', 2643, 1, 0, NULL),
	(5146, 206, 0, NULL, NULL, '', 38, '0003', 6035, 1, 0, NULL),
	(5147, 206, 0, NULL, NULL, '', 39, '0003', 2427, 1, 0, NULL),
	(5148, 206, 0, NULL, NULL, '', 40, '0003', 3775, 1, 0, NULL),
	(5149, 206, 0, NULL, NULL, '', 41, '0003', 6195, 1, 0, NULL),
	(5150, 206, 0, NULL, NULL, '', 42, '0003', 1854, 1, 0, NULL),
	(5151, 206, 0, NULL, NULL, '', 43, '0003', 2921, 1, 0, NULL),
	(5152, 206, 0, NULL, NULL, '', 44, '0003', 8094, 1, 0, NULL),
	(5153, 206, 0, NULL, NULL, '', 45, '0003', 6226, 1, 0, NULL),
	(5154, 206, 0, NULL, NULL, '', 46, '0003', 3389, 1, 0, NULL),
	(5155, 206, 0, NULL, NULL, '', 47, '0003', 3795, 1, 0, NULL),
	(5156, 206, 0, NULL, NULL, '', 48, '0003', 5550, 1, 0, NULL),
	(5157, 206, 0, NULL, NULL, '', 49, '0003', 5514, 1, 0, NULL),
	(5158, 206, 0, NULL, NULL, '', 50, '0003', 6332, 1, 0, NULL),
	(5159, 206, 0, NULL, NULL, '', 51, '0003', 5275, 1, 0, NULL),
	(5160, 206, 0, NULL, NULL, '', 52, '0003', 6413, 1, 0, NULL),
	(5161, 206, 0, NULL, NULL, '', 53, '0003', 4835, 1, 0, NULL),
	(5162, 206, 0, NULL, NULL, '', 54, '0003', 3595, 1, 0, NULL),
	(5163, 206, 0, NULL, NULL, '', 55, '0003', 5057, 1, 0, NULL),
	(5164, 206, 0, NULL, NULL, '', 56, '0003', 6803, 1, 0, NULL),
	(5165, 206, 0, NULL, NULL, '', 57, '0003', 4954, 1, 0, NULL),
	(5166, 206, 0, NULL, NULL, '', 58, '0003', 5703, 1, 0, NULL),
	(5167, 206, 0, NULL, NULL, '', 59, '0003', 4328, 1, 0, NULL),
	(5168, 206, 0, NULL, NULL, '', 60, '0003', 2781, 1, 0, NULL),
	(5169, 206, 0, NULL, NULL, '', 61, '0003', 2960, 1, 0, NULL),
	(5172, 204, 1, '07:20:00', NULL, 'DSR', 1, '0001', 0, 1, 0, NULL),
	(5173, 204, 1, '07:57:00', NULL, 'DSR', 2, '0001', 0, 1, 0, NULL),
	(5175, 202, 1, '11:02:52', NULL, 'DSR', 1, '0001', NULL, 1, 0, NULL),
	(5177, 204, 1, '08:35:00', NULL, 'DSR', 3, '0001', 0, 1, 0, NULL),
	(5178, 204, 1, '15:33:17', NULL, 'DSR', 4, '0001', NULL, 1, 0, NULL),
	(5179, 204, 1, '15:33:18', NULL, 'DSR', 5, '0001', NULL, 1, 0, NULL),
	(5180, 204, 1, '15:33:18', NULL, 'DSR', 6, '0001', NULL, 1, 0, NULL),
	(5182, 204, 2, NULL, NULL, 'DSR', 8, '0002', NULL, 1, 0, NULL),
	(5183, 204, 2, NULL, NULL, 'DSR', 9, '0002', NULL, 1, 0, NULL),
	(5184, 204, 2, NULL, NULL, 'DSR', 10, '0002', NULL, 1, 0, NULL),
	(5185, 204, 2, NULL, NULL, 'DSR', 11, '0002', NULL, 1, 0, NULL),
	(5186, 204, 2, NULL, NULL, 'DSR', 12, '0002', NULL, 1, 0, NULL),
	(5187, 204, 2, NULL, NULL, 'DSR', 13, '0002', NULL, 1, 0, NULL),
	(5188, 204, 2, NULL, NULL, 'DSR', 14, '0002', NULL, 1, 0, NULL),
	(5189, 204, 2, NULL, NULL, 'DSR', 15, '0002', NULL, 1, 0, NULL),
	(5191, 204, 3, NULL, NULL, 'DSR', 17, '0003', NULL, 1, 0, NULL),
	(5192, 204, 3, NULL, NULL, 'DSR', 18, '0003', NULL, 1, 0, NULL),
	(5193, 204, 3, NULL, NULL, 'DSR', 19, '0003', NULL, 1, 0, NULL),
	(5194, 204, 3, NULL, NULL, 'DSR', 20, '0003', NULL, 1, 0, NULL),
	(5195, 204, 3, NULL, NULL, 'DSR', 21, '0003', NULL, 1, 0, NULL),
	(5196, 204, 3, NULL, NULL, 'DSR', 22, '0003', NULL, 1, 0, NULL),
	(5197, 207, 1, NULL, NULL, 'RAMAPET', 100, '0009', NULL, 1, 0, NULL),
	(5198, 207, 1, NULL, NULL, 'RAMAPET', 101, '0009', NULL, 1, 0, NULL),
	(5199, 207, 1, NULL, NULL, 'RAMAPET', 102, '0009', NULL, 1, 0, NULL),
	(5200, 207, 1, NULL, NULL, 'RAMAPET', 103, '0009', NULL, 1, 0, NULL),
	(5201, 207, 1, NULL, NULL, 'RAMAPET', 104, '0009', NULL, 1, 0, NULL),
	(5202, 207, 1, NULL, NULL, 'RAMAPET', 105, '0009', NULL, 1, 0, NULL),
	(5203, 207, 1, NULL, NULL, 'RAMAPET', 106, '0009', NULL, 1, 0, NULL),
	(5204, 207, 1, NULL, NULL, 'RAMAPET', 107, '0009', NULL, 1, 0, NULL),
	(5205, 207, 1, NULL, NULL, 'RAMAPET', 108, '0009', NULL, 1, 0, NULL),
	(5206, 207, 1, NULL, NULL, 'RAMAPET', 109, '0009', NULL, 1, 0, NULL),
	(5207, 207, 1, NULL, NULL, 'RAMAPET', 110, '0009', NULL, 1, 0, NULL),
	(5208, 207, 1, NULL, NULL, 'RAMAPET', 111, '0009', NULL, 1, 0, NULL),
	(5209, 207, 1, NULL, NULL, 'RAMAPET', 112, '0009', NULL, 1, 0, NULL),
	(5210, 207, 1, NULL, NULL, 'RAMAPET', 113, '0009', NULL, 1, 0, NULL),
	(5211, 207, 1, NULL, NULL, 'RAMAPET', 114, '0009', NULL, 1, 0, NULL),
	(5212, 207, 1, NULL, NULL, 'RAMAPET', 115, '0009', NULL, 1, 0, NULL),
	(5213, 207, 2, NULL, NULL, 'RAMAPET', 116, '0010', NULL, 1, 0, NULL),
	(5214, 207, 2, NULL, NULL, 'RAMAPET', 117, '0010', NULL, 1, 0, NULL),
	(5215, 207, 2, NULL, NULL, 'RAMAPET', 118, '0010', NULL, 1, 0, NULL),
	(5216, 207, 2, NULL, NULL, 'RAMAPET', 119, '0010', NULL, 1, 0, NULL),
	(5217, 207, 2, NULL, NULL, 'RAMAPET', 120, '0010', NULL, 1, 0, NULL),
	(5218, 207, 2, NULL, NULL, 'RAMAPET', 121, '0010', NULL, 1, 0, NULL),
	(5219, 207, 2, NULL, NULL, 'RAMAPET', 122, '0010', NULL, 1, 0, NULL),
	(5220, 207, 2, NULL, NULL, 'RAMAPET', 123, '0010', NULL, 1, 0, NULL),
	(5221, 207, 2, NULL, NULL, 'RAMAPET', 124, '0010', NULL, 1, 0, NULL),
	(5222, 207, 2, NULL, NULL, 'RAMAPET', 125, '0010', NULL, 1, 0, NULL),
	(5223, 207, 2, NULL, NULL, 'RAMAPET', 126, '0010', NULL, 1, 0, NULL),
	(5224, 207, 2, NULL, NULL, 'RAMAPET', 127, '0010', NULL, 1, 0, NULL),
	(5225, 207, 2, NULL, NULL, 'RAMAPET', 128, '0010', NULL, 1, 0, NULL),
	(5226, 207, 2, NULL, NULL, 'RAMAPET', 129, '0010', NULL, 1, 0, NULL),
	(5227, 207, 2, NULL, NULL, 'RAMAPET', 130, '0010', NULL, 1, 0, NULL),
	(5228, 207, 2, NULL, NULL, 'RAMAPET', 131, '0010', NULL, 1, 0, NULL),
	(5229, 205, 1, NULL, NULL, 'EASTLON', 5, '0009', NULL, 15, 0, NULL),
	(5230, 205, 1, NULL, NULL, 'EASTLON', 6, '0009', NULL, 15, 0, NULL),
	(5231, 205, 1, NULL, NULL, 'EASTLON', 7, '0009', NULL, 15, 0, NULL),
	(5232, 205, 1, NULL, NULL, 'EASTLON', 8, '0009', NULL, 15, 0, NULL),
	(5233, 205, 1, NULL, NULL, 'EASTLON', 9, '0009', NULL, 15, 0, NULL),
	(5234, 205, 1, NULL, NULL, 'EASTLON', 10, '0009', NULL, 15, 0, NULL),
	(5235, 205, 1, NULL, NULL, 'EASTLON', 11, '0009', NULL, 15, 0, NULL),
	(5236, 205, 2, NULL, NULL, 'EASTLON', 12, '0010', NULL, 15, 0, NULL),
	(5237, 205, 2, NULL, NULL, 'EASTLON', 13, '0010', NULL, 15, 0, NULL),
	(5238, 205, 2, NULL, NULL, 'EASTLON', 14, '0010', NULL, 15, 0, NULL),
	(5239, 205, 2, NULL, NULL, 'EASTLON', 15, '0010', NULL, 15, 0, NULL),
	(5240, 205, 2, NULL, NULL, 'EASTLON', 16, '0010', NULL, 15, 0, NULL),
	(5241, 205, 2, NULL, NULL, 'EASTLON', 17, '0010', NULL, 15, 0, NULL),
	(5242, 205, 2, NULL, NULL, 'EASTLON', 18, '0010', NULL, 15, 0, NULL),
	(5243, 204, 2, NULL, NULL, 'DSR', 16, '0002', NULL, 1, 0, NULL),
	(5244, 204, 1, '13:32:37', NULL, 'DSR', 7, '0001', NULL, 1, 0, NULL),
	(5245, 204, 3, NULL, NULL, 'DSR', 23, '0003', NULL, 1, 0, NULL);
/*!40000 ALTER TABLE `stpj` ENABLE KEYS */;

-- membuang struktur untuk table warehouse.user
CREATE TABLE IF NOT EXISTS `user` (
  `User_ID` int(20) NOT NULL AUTO_INCREMENT,
  `User_Name` varchar(30) NOT NULL,
  `Nik` int(10) NOT NULL,
  `Password` varchar(8) NOT NULL,
  `Dept` int(1) NOT NULL,
  `Kasta` int(1) NOT NULL,
  `Foto` text,
  `Paraf` text,
  `Start_Activity` datetime NOT NULL,
  `End_Activity` datetime NOT NULL,
  PRIMARY KEY (`User_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

-- Membuang data untuk tabel warehouse.user: ~16 rows (lebih kurang)
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
REPLACE INTO `user` (`User_ID`, `User_Name`, `Nik`, `Password`, `Dept`, `Kasta`, `Foto`, `Paraf`, `Start_Activity`, `End_Activity`) VALUES
	(1, 'ABASUKI', 36, 'ita', 1, 1, 'profile.jpg', NULL, '2024-08-22 07:03:35', '2023-02-19 06:13:50'),
	(2, 'Harun S.', 1017, 'ita', 1, 0, 'harun.jpg', '5.jpg', '2023-01-02 14:28:41', '2023-01-02 14:45:00'),
	(3, 'Sukardi', 1056, 'ita', 2, 0, 'sukardi.jpg', NULL, '2023-02-17 14:35:54', '2023-02-17 14:41:41'),
	(4, 'Ahmad', 3333, 'ita', 3, 0, NULL, NULL, '2022-12-30 11:19:14', '2022-11-08 15:41:03'),
	(5, 'Wahid', 1028, 'ita', 4, 0, 'MWD1.jpg', '5.jpg', '2022-12-31 08:38:49', '2022-12-31 09:11:48'),
	(6, 'Darmin', 4442, 'ita', 4, 5, NULL, '6.jpg', '2022-11-04 10:41:30', '2022-11-04 10:41:34'),
	(7, 'Edi Purnomo', 4440, 'ita', 4, 1, NULL, NULL, '2023-03-17 06:43:16', '2023-01-02 09:04:30'),
	(8, 'Nanang', 4443, 'ita', 4, 0, 'nanang.jpg', 'parafnanang.png', '2022-11-15 14:30:05', '2022-11-15 15:22:13'),
	(9, 'Faiz', 1532, 'ita', 4, 0, NULL, 'paraffaiz.png', '2023-01-02 09:05:30', '2023-01-02 09:07:06'),
	(10, 'Wuryanto', 2220, 'ita', 2, 1, NULL, NULL, '2023-08-22 19:02:04', '2023-02-17 14:35:47'),
	(11, 'Alen', 918, 'ita', 2, 0, NULL, NULL, '2022-12-28 10:41:14', '2022-12-28 10:40:44'),
	(12, 'Sumarno', 3330, 'ita', 3, 1, NULL, NULL, '2023-01-30 13:49:07', '2022-11-08 15:44:05'),
	(13, 'Herman', 1070, 'ita', 2, 0, NULL, NULL, '2023-01-03 14:01:35', '2023-01-03 14:01:28'),
	(16, 'Wildan', 1394, 'ita', 1, 0, NULL, NULL, '2023-08-22 06:38:45', '2023-08-22 06:38:55'),
	(17, 'Seftian', 916, 'ita', 2, 0, NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
	(18, 'Intan', 1553, 'ita', 4, 0, NULL, NULL, '2023-01-02 09:07:13', '0000-00-00 00:00:00');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
